{*******************************************************************************
   Unit
      smemo.pas
   Description:
      sMemo control - flat TMemo child with TsLabel support
   Versions:
      1.0
   History:
      1.0*	- 	10/12/1998
               .Initial release
   Autor(s):
      Dimitry Statilko - dstatus@iname.com, dima@mobitel.com
   Comments:
      Whell, instead of flat borders this is nothing new. I made it to keep the
      same feel of interface for my applications  
*******************************************************************************}
unit sMemo;

interface

uses Windows, StdCtrls, Controls, Messages, Classes,
     Graphics, Forms, ExtCtrls, SysUtils, sEdits, sFlat;

type

   TsMemo = class(TMemo)
   private
      FFlat: Boolean;
      FSolidBorder: Boolean;
      procedure SetSolidBorder;
      procedure SetFlat(const Value: Boolean);
      procedure WMPaint(var Message: TWMPaint); message WM_PAINT;
      procedure WMNCPaint(var Message: TMessage); message WM_NCPAINT;
      procedure WMSetFocus(var Message: TMessage); message WM_SETFOCUS;
      procedure WMKillFocus(var Message: TMessage); message WM_KILLFOCUS;
      procedure CMMouseEnter(var Message: TMessage); message CM_MOUSEENTER;
      procedure CMMouseLeave(var Message: TMessage); message CM_MOUSELEAVE;
      procedure CMEnabledChanged(var Msg: TMessage); message CM_ENABLEDCHANGED;
   protected
      FEditState: TsEditState;
      procedure CreateWnd; override;
      procedure RedrawBorders; virtual;
      function GetSolidBorder: Boolean; virtual;
      property SolidBorder: Boolean read FSolidBorder;
      procedure SetEditRect; virtual;
   public
      constructor Create(AOwner: TComponent); override;
   published
      property Flat: Boolean read FFlat write SetFlat default FALSE;
   end;


procedure Register;

implementation

uses sTdUtils, sConsts;

constructor TsMemo.Create(AOwner: TComponent);
begin
   inherited;
   ControlStyle := ControlStyle - [csSetCaption, csFramed];
end;

procedure TsMemo.CreateWnd;
begin
   inherited;
   SetEditRect;
end;

procedure TsMemo.WMPaint(var Message: TWMPaint);
var
   DC: HDC;
   PS: TPaintStruct;
begin
   try
      DC := BeginPaint(Handle, PS);
      PaintWindow(DC);
      RedrawBorders;
   finally
      EndPaint(Handle, PS);
   end;
end;

procedure TsMemo.WMNCPaint(var Message: TMessage);
begin
   inherited;
   RedrawBorders;
end;

procedure TsMemo.WMSetFocus(var Message: TMessage);
begin
   inherited;
   SetSolidBorder;
end;

procedure TsMemo.WMKillFocus(var Message: TMessage);
begin
   SetSolidBorder;
   inherited;
end;

procedure TsMemo.CMMouseEnter(var Message: TMessage);
begin
   inherited;
   if not (msMouseInControl in FEditState) and Enabled then begin
      Include(FEditState, msMouseInControl);
      SetSolidBorder;
      Notify( self, STM_MOUSEENTERNOTIFY, 0);
   end;
end;

procedure TsMemo.CMMouseLeave(var Message: TMessage);
begin
   inherited;
   if (msMouseInControl in FEditState) and Enabled then begin
      Exclude(FEditState, msMouseInControl);
      SetSolidBorder;
      Notify( self, STM_MOUSELEAVENOTIFY, 0);
   end;
end;

procedure TsMemo.CMEnabledChanged(var Msg: TMessage);
begin
   inherited;
   Notify( self, STM_ENABLEDCHANGENOTIFY, Ord(ENABLED));
end;

function TsMemo.GetSolidBorder: Boolean;
begin
   Result := ((csDesigning in ComponentState) and Enabled) or
      (not(csDesigning in ComponentState) and
      (Focused or ((msMouseInControl in FEditState) and IsFlatApplied)));
end;

procedure TsMemo.SetSolidBorder;
var
   sb: Boolean;
begin
   sb := GetSolidBorder;
   if sb <> FSolidBorder then begin
      FSolidBorder := sb;
      RedrawBorders;
   end;
end;

procedure TsMemo.RedrawBorders;
begin
   if FFlat then
      InternalRedrawBorder( Handle, SolidBorder);
end;


procedure TsMemo.SetFlat(const Value: Boolean);
begin
   if Value <> FFlat then begin
      FFlat := Value;
      RecreateWnd;
   end;
end;

procedure TsMemo.SetEditRect;
var
  	R: TRect;
begin
   if HandleAllocated then begin
      R := GetClientRect;
      InflateRect(R, -4, -4);
      SendMessage(Handle, EM_SETRECTNP, 0, LongInt(@R));
   end;
end;


procedure Register;
begin
   RegisterComponents('sEditTools', [TsMemo]);
end;

end.
