{*******************************************************************************
   Unit
      sConsts.pas
   Description:
      Common constants for sEditTools
   Versions:
   History:
   Autor(s):
      Dimitry Statilko - dstatus@iname.com, dima@mobitel.com**
   Comments:
*******************************************************************************}
unit sConsts;

interface

uses Messages;

resourcestring
   RegistryDelphiPath = 'Software\borland\Delphi\';

   RegEntryFormState = 'FormState';
   RegEntryFormLeft = 'FormLeft';
   RegEntryFormTop = 'FormTop';
   RegEntryFormWidth = 'FormWidth';
   RegEntryFormHeight = 'FormHeight';

   EmptyStr = '';


resourcestring
{sBrowseFolder}
   STestMessage = 'Item selected:'#13#13'%s';

{sEdits}
   SNoDateCaption = 'No date';
   SBrowseCaption = 'Browse';
   SDefaultFilesFilter = 'All files (*.*)|*.*';
{sPickDate}
   STodayCaption = 'Today';

{sGlyphList}
   SChangeGlyphIdTitles = 'Edit glyph Id';
   SChangeGlyphIdCaption = 'Please type the glyph id here:';
   SGlyphListEditorRegistryEntry = 'GlyphsListForm';

{stdUtils}
   SDefaultLogFilename = 'noname.log';
   SDefaultErrorMessage = 'Error ocured:' + #10 + #13 +  '%s';
   SSaveChangesQuery = 'Save changes ?';

{ Error messages}
	SErrorNeedsBmp = 'Can not specify glyph other then bitmap';
   SErrorGlyphNotFound = 'Glyph with Id %d was not found in the list';
	SErrorDuplicateId = 'Glyph with Id %s already exists in the glyphs list';
   SErrorInvalidGlyphId = 'Glyph Id mast be a positive number';
   SErrorResourceNotFound = 'Resource %s not found';
   SErrorInvalidUpDownGlyph = 'Invalid glyph for UpDown control';
   SErrorNoFileInformation = 'No file information';



{Registration}
   SEditToolsPageCaption = 'sEditTools';
   SDBEditToolsPageCaption = 'sDBEditTools';
{editors}
   SGlyphEditorCaption = 'Glyphs Editor';
   STestDialogEditorCaption = 'Test Dialog';
   STransRefreshEditor = 'Refresh';

{ *******************************
   MESSAGES used by sEditTools.
********************************}

const
   STM_FIRST = WM_USER + 100;

	STM_GLYPHIDCHANGED      = STM_FIRST + 1;
   STM_ENABLEDCHANGENOTIFY = STM_FIRST + 2;
   STM_MOUSEENTERNOTIFY    = STM_FIRST + 3;
   STM_MOUSELEAVENOTIFY    = STM_FIRST + 4;

implementation





end.
