{*******************************************************************************
   Unit
      sFlat.pas
   Description:
      utils common for flat controls of sEditTools pack
   Versions:
      2.0
   Autor(s):
      Dimitry Statilko - dstatus@iname.com, dima@mobitel.com.
   Comments:
   History:
		2.0*  - 	End of Sep. 1998
      			Initial release
*     I did not track the versions before, so let's consider it as 1.0
*******************************************************************************}
unit sFlat;

interface

uses Windows, Graphics, Controls;

procedure InternalDrawTransBmpRect(DC: HDC; Rect: TRect; Bitmap: TBitmap; Stretch: Boolean);
procedure InternalRedrawBorder( Handle: HWND; const SolidBorder: Boolean);
function IsFlatApplied: Boolean;

type
   TWinControlClass = class of TWinControl;

procedure RegisterFlatControl(control: TWinControlClass);

var
   FloatingOnFocusOnly: Boolean;

implementation

uses Classes, Forms, sGraphics, stdCtrls, StdUtils;


procedure InternalRedrawBorder( Handle: HWND; const SolidBorder: Boolean);
var
   BtnFaceBrush, WindowBrush: HBRUSH;
   DC: HDC;
   R: TRect;
begin
   DC := GetWindowDC(Handle);
   try
      BtnFaceBrush := CreateSolidBrush(GetSysColor(COLOR_BTNFACE));
      WindowBrush := CreateSolidBrush(GetSysColor(COLOR_WINDOW));
      try
         GetWindowRect(Handle, R);
         OffsetRect (R, -R.Left, -R.Top);
         if SolidBorder then begin
            DrawEdge (DC, R, BDR_SUNKENOUTER, BF_RECT or BF_ADJUST);
            FrameRect (DC, R, BtnFaceBrush);
            InflateRect (R, -1, -1);
            FrameRect (DC, R, WindowBrush);
         end else begin
            FrameRect (DC, R, BtnFaceBrush);
            InflateRect (R, -1, -1);
            FrameRect (DC, R, BtnFaceBrush);
            InflateRect (R, -1, -1);
            FrameRect (DC, R, WindowBrush);
         end;
      finally
         DeleteObject (WindowBrush);
         DeleteObject (BtnFaceBrush);
      end;
   finally
      ReleaseDC(DC, Handle);
   end;
end;

procedure InternalDrawTransBmpRect(DC: HDC; Rect: TRect; Bitmap: TBitmap; Stretch: Boolean);
var
  MemImage: TBitmap;
  R: TRect;
  w, h, x: Integer;
begin
   MemImage := TBitmap.Create;
   try
      R := Bounds(0, 0, Bitmap.Width, Bitmap.Height);
      MemImage.Width := Bitmap.Width;
      MemImage.Height := Bitmap.Height;
      MemImage.Canvas.CopyRect(R, Bitmap.Canvas, R);
      if Stretch then begin
         w := WidthOf(Rect);
         h := HeightOf(Rect);
      end else begin // centering bitmap
         w := Bitmap.Width;
         h := Bitmap.Height;
         if h > HeightOf(Rect) then
            h := HeightOf(Rect);
         x := (WidthOf(Rect) - w) div 2;
         if x > 0 then
            InflateRect( Rect, -x, 0);
         x := (heightOf(Rect) - h) div 2;
         if x > 0 then
            InflateRect( Rect, 0, -x);
      end;
      DrawTransparentBitmapRect(DC, MemImage.Handle, Rect.Left, Rect.Top, w, h,
         R, ColorToRGB(Bitmap.TransparentColor and not TransparentMask))
   finally
      MemImage.Free;
   end;
end;


var
   flatControls: TList;

function IsFlatApplied: Boolean;
var
   Cntrl: TWinControl;
   ii: Integer;
begin
   Result := TRUE;
   if FloatingOnFocusOnly then begin
      if flatControls = nil then
         Exit;
      Cntrl := Screen.ActiveControl;
      for ii := 0 to flatControls.Count - 1 do
         if Cntrl.InheritsFrom( TWinControlClass(flatControls[ii])) then begin
            Result := FALSE;
            Exit;
         end;
   end;
end;

procedure RegisterFlatControl(control: TWinControlClass);
var
   ii: Integer;
begin
   if flatControls = nil then
      flatControls := TList.Create;
   for ii := 0 to flatControls.Count - 1 do
      if TControlClass(flatControls[ii]) = control then
         Exit;
   flatControls.Add(control);
end;


initialization
   FloatingOnFocusOnly := FALSE;
finalization
   flatControls.Free;
   flatControls := nil;

end.
