{*******************************************************************************
   Unit
      sDialogs.pas
   Description:
      Declares the TsCustomDialog, the base calss for the dialogs, who want to
         have the ability to be previewed at design time.
      Implements the "property editor" to preview the dialog.
   Versions:
      1.0
	History:
      1.0	- 	somewhere 1997
      			Initial (and, I think, final) release
   Autor(s):
      Dimitry Statilko - dstatus@iname.com, dima@mobitel.com
   Comments:
*******************************************************************************}
unit sDialogs;

interface

uses Classes;

type
   TsCustomDialog = class(TComponent)
   public
      function Execute: Boolean; virtual; abstract;
   end;

procedure Register;

implementation

uses SysUtils, Dialogs, Forms, DsgnIntf, sConsts;

type
   TDialogEditor = class(TDefaultEditor)
   public
      procedure ExecuteVerb(Index : Integer); override;
      function GetVerb(Index : Integer): string; override;
      function GetVerbCount : Integer; override;
      procedure Edit; override;
   end;


procedure TDialogEditor.ExecuteVerb(Index: Integer);
begin
   if Index <> 0 then Exit;
   Edit;
end;

function TDialogEditor.GetVerb(Index: Integer): AnsiString;
begin
   Result := STestDialogEditorCaption;
end;

function TDialogEditor.GetVerbCount: Integer;
begin
   Result := 1;
end;

procedure TDialogEditor.Edit;
begin
   TsCustomDialog(Component).Execute;
end;

procedure Register;
begin
   RegisterComponentEditor(TsCustomDialog, TDialogEditor);
end;





end.
