{*******************************************************************************
   Unit
      sDBUtils.pas
   Description:
      Misc. DB utilities
   Versions:
      2.0
	History:
      2.0*	- 	End of October
      			Initial release
   Autor(s):
      Dimitry Statilko - dstatus@iname.com, dima@mobitel.com
   Comments:
*     I did not track the versions before, so let's consider it as 2.0
*******************************************************************************}
unit sDBUtils;

{$W-,R-,B-,N+,P+}
{$I S.INC}

interface


uses Windows, Classes, SysUtils, Bde, DB, DBTables, Registry, IniFiles;

{ Utility routines }
function GrabMemoAsString( TheField: TMemoField; MaxLen: Integer; const SupressCR: Boolean): String;
procedure StrToMemo( TheField: TMemoField; const Str: String);

function GetAliasPath(const AliasName: string): string;

{ transaction support}
function PostTables( Tables: array of TDBDataSet): Boolean;
procedure CancelTables( Tables: array of TDBDataSet);
procedure CommitTransaction( database: TDataBase; const retr: Integer);
procedure RollBackTransaction( database: TDataBase);

implementation

//uses Controls, Dialogs, Consts, DBConsts, VCLUtils,
//   StrUtils, BDEConst, DBCommon;

var
   PArray: array [0..255] of Char;

function GrabMemoAsString( TheField: TMemoField; MaxLen: Integer; const SupressCR: Boolean): String;
var
   stream: TBlobStream;
   theSize: Integer;
   Ptr: PChar;
begin
   if TheField.IsNull then
      Result := ''
   else begin
      stream := TBlobStream.Create(TheField, bmRead);
      with stream do try
         theSize := Size;
         if theSize > MaxLen then theSize := MaxLen;
         Ptr := PArray;
         Read( Ptr^, theSize);
         Ptr[theSize] := #0;
         Result := StrPas(Ptr);
      finally
         Free;
      end;
      if SupressCR then begin
         while Pos(#10, Result) > 0 do
            Result[Pos(#10, Result)] := ' ';
         while Pos(#13, Result) > 0 do
            Result[Pos(#13, Result)] := ' ';
      end;
   end;
end;

procedure StrToMemo( TheField: TMemoField; const Str: String);
var
   stream: TBlobStream;
begin
   stream := TBlobStream.Create(TheField, bmWrite);
   try
      stream.Write( Str, Length(Str));
   finally
      stream.Free;
   end;
end;


function IsDirectory(const DatabaseName: string): Boolean;
begin
   Result := (DatabaseName = '') or (Pos(':', DatabaseName) <> 0) or
            (Pos('\', DatabaseName) <> 0);
end;

function GetAliasPath(const AliasName: string): string;
var
   SAlias: DBINAME;
   Desc: DBDesc;
   Params: TStrings;
begin
   Result := '';
   StrPLCopy(SAlias, AliasName, SizeOf(SAlias) - 1);
   AnsiToOem(SAlias, SAlias);
   Check(DbiGetDatabaseDesc(SAlias, @Desc));
   if StrIComp(Desc.szDbType, szCFGDBSTANDARD) = 0 then begin
      OemToAnsi(Desc.szPhyName, Desc.szPhyName);
      Result := StrPas(Desc.szPhyName);
   end else begin
      Params := TStringList.Create;
      try
         Session.Active := True;
         Session.GetAliasParams(AliasName, Params);
         Result := Params.Values['SERVER NAME'];
      finally
         Params.Free;
      end;
   end;
end;

function PostTables( Tables: array of TDBDataSet): Boolean;
var
   ii: Integer;
begin
   try
      for ii := 0 to High(Tables) do if Tables[ii] <> nil then
         with Tables[ii] do if State in dsEditModes then Post;
      Result := TRUE;
   except
      Result := FALSE;
   end;
end;

procedure CancelTables( Tables: array of TDBDataSet);
var
   ii: Integer;
begin
   try
      for ii := 0 to High(Tables) do if Tables[ii] <> nil then
         with Tables[ii] do if State in dsEditModes then Cancel;
   except
   end;
end;

procedure CommitTransaction( database: TDataBase; const retr: Integer);
var
   count: Integer;
   done: Boolean;
begin
   Done := FALSE;
   count := 0;
   while (not done) and (count < retr) do try
      database.Commit;
      done := TRUE;
   except
      inc(count);
   end;
   if not done then RollBackTransaction(database);
end;

procedure RollBackTransaction( database: TDataBase);
begin
   try
      database.RollBack;
   except
   end;
end;


end.