unit MainUnit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, sCtrls, ExtCtrls, StdCtrls, sCombos, sTrans, sEdits, TiledBmp,
  sGlyphsList, Buttons, sPickDate;

type
  TForm1 = class(TForm)
    PageControl1: TPageControl;
    SStatusBar1: TsStatusBar;
    Animate1: TAnimate;
    sGlyphList1: TsGlyphList;
    TabSheet1: TTabSheet;
    x: TTiledBmp;
    sDirectoryEdit1: TsDirectoryEdit;
    sCheckBox1: TsCheckBox;
    sPathComboBox1: TsPathComboBox;
    sLabel1: TsLabel;
    Bevel1: TBevel;
    sLabel2: TsLabel;
    sLabel3: TsLabel;
    sLabel4: TsLabel;
    Image1: TImage;
    Bevel2: TBevel;
    sCheckBox2: TsCheckBox;
    sCheckBox3: TsCheckBox;
    sCheckBox4: TsCheckBox;
    sColorComboBox1: TsColorComboBox;
    sLabel5: TsLabel;
    Bevel3: TBevel;
    sRadioButton1: TsRadioButton;
    sRadioButton2: TsRadioButton;
    sLabel6: TsLabel;
    sLabel7: TsLabel;
    TabSheet2: TTabSheet;
    sSpeedButton1: TsSpeedButton;
    sSpeedButton2: TsSpeedButton;
    sSpeedButton3: TsSpeedButton;
    sSpeedButton4: TsSpeedButton;
    sSpeedButton5: TsSpeedButton;
    sSpeedButton6: TsSpeedButton;
    sSpeedButton7: TsSpeedButton;
    sSpeedButton8: TsSpeedButton;
    sFontComboBox1: TsFontComboBox;
    sLabel8: TsLabel;
    sLabel9: TsLabel;
    sFilenameEdit1: TsFilenameEdit;
    sEdit1: TsEdit;
    sLinkEdit1: TsLinkEdit;
    sDateEdit1: TsDateEdit;
    sNumberEdit1: TsNumberEdit;
    sLabel10: TsLabel;
    sLabel11: TsLabel;
    sLabel12: TsLabel;
    sLabel13: TsLabel;
    TsFilenameEdit: TsLabel;
    Bevel4: TBevel;
    sLabel14: TsLabel;
    sColorComboBox2: TsColorComboBox;
    sPathComboBox2: TsPathComboBox;
    sLabel16: TsLabel;
    sLabel17: TsLabel;
    sComboBox1: TsComboBox;
    sLabel18: TsLabel;
    Bevel5: TBevel;
    sLabel19: TsLabel;
    TabSheet3: TTabSheet;
    sCalendar1: TsCalendar;
    TiledBmp1: TTiledBmp;
    sCheckBox5: TsCheckBox;
    sCheckBox6: TsCheckBox;
    sCheckBox7: TsCheckBox;
    sRadioButton3: TsRadioButton;
    sRadioButton4: TsRadioButton;
    Bevel6: TBevel;
    sLabel15: TsLabel;
    sLabel20: TsLabel;
    Bevel7: TBevel;
    Bevel8: TBevel;
    sLabel21: TsLabel;
    sCheckBox8: TsCheckBox;
    Bevel9: TBevel;
    sLabel22: TsLabel;
    sComboBox2: TsComboBox;
    TiledBmp2: TTiledBmp;
    sLabel23: TsLabel;
    procedure sDirectoryEdit1Exit(Sender: TObject);
    procedure sCheckBox1Click(Sender: TObject);
    procedure sDirectoryEdit1PathChange(Sender: TObject);
    procedure sPathComboBox1Change(Sender: TObject);
    procedure sCheckBox2Click(Sender: TObject);
    procedure sCheckBox3Click(Sender: TObject);
    procedure sCheckBox4Click(Sender: TObject);
    procedure sRadioButton1Click(Sender: TObject);
    procedure sRadioButton2Click(Sender: TObject);
    procedure sColorComboBox1Change(Sender: TObject);
    procedure sSpeedButton1Click(Sender: TObject);
    procedure sFilenameEdit1Button2Click(Sender: TObject);
    procedure sCheckBox5Click(Sender: TObject);
    procedure sCheckBox6Click(Sender: TObject);
    procedure sCheckBox7Click(Sender: TObject);
    procedure sCheckBox8Click(Sender: TObject);
    procedure sRadioButton3Click(Sender: TObject);
    procedure sRadioButton4Click(Sender: TObject);
    procedure sComboBox2Change(Sender: TObject);
  end;

var
  Form1: TForm1;

implementation
{$R *.DFM}

uses sFileUtils, sFlat, sGraphics;


procedure TForm1.sDirectoryEdit1Exit(Sender: TObject);
begin
   sPathComboBox1.Path := sDirectoryEdit1.Path;
end;

procedure TForm1.sCheckBox1Click(Sender: TObject);
var
   S: String;
begin
   if sCheckBox1.Checked then begin
      S := GetShellFolder(sfPersonal);
      sDirectoryEdit1.Path := S;
      sPathComboBox1.Path := S;
   end;
   sDirectoryEdit1.Enabled := not sCheckBox1.Checked;
end;

procedure TForm1.sDirectoryEdit1PathChange(Sender: TObject);
begin
   sPathComboBox1.ItemIndex := -1;
end;

procedure TForm1.sPathComboBox1Change(Sender: TObject);
var
   S: String;
begin
   S := '';
   with sPathComboBox1 do if ItemIndex > - 1 then
      S := Items[ItemIndex];
   Image1.Picture.LoadFromFile(sDirectoryEdit1.Path + S);
end;

procedure TForm1.sCheckBox2Click(Sender: TObject);
begin
   Image1.Center := sCheckBox2.Checked;
end;

procedure TForm1.sCheckBox3Click(Sender: TObject);
begin
   Image1.Stretch := sCheckBox3.Checked;
end;

procedure TForm1.sCheckBox4Click(Sender: TObject);
begin
   Image1.Transparent := sCheckBox4.Checked;
end;

procedure TForm1.sRadioButton1Click(Sender: TObject);
begin
   Image1.Picture.Bitmap.TransparentMode := tmAuto;
   sColorComboBox1.Enabled := FALSE;
end;

procedure TForm1.sRadioButton2Click(Sender: TObject);
begin
   sColorComboBox1.Enabled := TRUE;
   Image1.Picture.Bitmap.TransparentColor := sColorComboBox1.ColorValue;
end;

procedure TForm1.sColorComboBox1Change(Sender: TObject);
begin
   Image1.Picture.Bitmap.TransparentColor := sColorComboBox1.ColorValue;
end;

procedure TForm1.sSpeedButton1Click(Sender: TObject);
begin
   MessageDlg('The TsSpeedButton is a TsSppedButton child,'+#13+#10+
      'wich implements some of the TBitBtn methods '+#13+#10+
      'and properties, including Kind, ModalResult, and '+#13+#10+
      'Cancel and Default properties.'+#13+#10+
      '(Note that the glyphs of buttons are not stored in .dfm)',mtInformation,[mbOk],0);
end;

procedure TForm1.sFilenameEdit1Button2Click(Sender: TObject);
begin
   MessageDlg('Button 2 clicked.'+#13+#10+
      'By the way, the glyphs used by the edit controls are stored in TsGlyphList object',
      mtInformation,[mbOk],0);
end;

procedure TForm1.sCheckBox5Click(Sender: TObject);
begin
   sCalendar1.Transparent := sCheckBox5.Checked;
end;

procedure TForm1.sCheckBox6Click(Sender: TObject);
const
   todayOption = [coShowToday, coShowTodayBtn];
begin
   if sCheckBox6.Checked then
      sCalendar1.Options := sCalendar1.Options + todayOption
   else
      sCalendar1.Options := sCalendar1.Options - todayOption;
end;

procedure TForm1.sCheckBox7Click(Sender: TObject);
begin
   if sCheckBox7.Checked then
      sCalendar1.Options := sCalendar1.Options + [coShowWeeks]
   else
      sCalendar1.Options := sCalendar1.Options - [coShowWeeks];
end;

procedure TForm1.sCheckBox8Click(Sender: TObject);
begin
   if sCheckBox8.Checked then
      sCalendar1.Options := sCalendar1.Options - [coFullDisplay]
   else
      sCalendar1.Options := sCalendar1.Options + [coFullDisplay];
end;

procedure TForm1.sRadioButton3Click(Sender: TObject);
begin
   sCalendar1.SelectStyle := ssFrame;
end;

procedure TForm1.sRadioButton4Click(Sender: TObject);
begin
   sCalendar1.SelectStyle := ssOval;
end;

procedure TForm1.sComboBox2Change(Sender: TObject);
begin
   sCalendar1.HilightStyle := THilightStyle(sComboBox2.ItemIndex + 1);
   if sComboBox2.ItemIndex = 1 then
      sCalendar1.Hilight3d.Spacing := 2
   else
      sCalendar1.Hilight3d.Spacing := 1;
   if sComboBox2.ItemIndex = 4 then
      sCalendar1.Hilight3d.Color := clBlue
   else
      sCalendar1.Hilight3d.Color := clWindow;
end;

initialization
//   FloatingOnFocusOnly := TRUE;

end.
