unit sDialogs;

interface

uses Classes;

type
   TsCustomDialog = class(TComponent)
   public
      function Execute: Boolean; virtual; abstract;
   end;

procedure Register;

implementation

uses SysUtils, Dialogs, Forms, DsgnIntf;

type
   TDialogEditor = class(TDefaultEditor)
   public
      procedure ExecuteVerb(Index : Integer); override;
      function GetVerb(Index : Integer): string; override;
      function GetVerbCount : Integer; override;
      procedure Edit; override;
   end;


procedure TDialogEditor.ExecuteVerb(Index: Integer);
begin
   if Index <> 0 then Exit;
   Edit;
end;

function TDialogEditor.GetVerb(Index: Integer): AnsiString;
begin
   Result := 'Test Dialog';
end;

function TDialogEditor.GetVerbCount: Integer;
begin
   Result := 1;
end;

procedure TDialogEditor.Edit;
begin
   TsCustomDialog(Component).Execute;
end;

procedure Register;
begin
   RegisterComponentEditor(TsCustomDialog, TDialogEditor);
end;





end.
