unit TiledBmp;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;

type
	TWallpaperMode = (wpTile, wpCenter, wpTopLeft);

  	TTiledBmp = class(TGraphicControl)
  	private
    	FImage: TBitmap;
    	FMode: TWallpaperMode;
    	procedure PictureChanged(Sender: TObject);
      procedure SetImage(Value: TBitMap);
      procedure SetMode(value: TWallpaperMode);
	protected
    	procedure Paint; override;
  	public
   	constructor Create(AOwner: TComponent); override;
    	destructor Destroy; override;
   published
    	property Align;
    	property Picture: TBitMap read FImage write SetImage;
    	property Mode: TWallpaperMode read FMode write SetMode;
  	end;

procedure Register;

implementation


constructor TTiledBmp.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  ControlStyle := ControlStyle + [csReplicatable];
  FImage := TBitmap.Create;
  FImage.OnChange := PictureChanged;
  Height := 105;
  Width := 105;
end;

destructor TTiledBmp.Destroy;
begin
  	FImage.Free;
  	inherited;
end;

procedure TileBitmap(Bitmap: TBitmap; Canvas: TCanvas; Width, Height: Integer);
var
	i, j: Integer;
begin
  	for i := 0 to (Width-1) div Bitmap.Width do
  		for j := 0 to (Height-1) div Bitmap.Height do
    		Canvas.Draw(i*Bitmap.Width, j*Bitmap.Height, Bitmap);
end;

procedure TTiledBmp.Paint;
var
	Dest: TRect;
begin
   if not FImage.Empty then begin
 	  if FMode = wpTile then
   		TileBitmap( FImage, inherited Canvas, Width, Height)
   	else begin
   		if FMode = wpCenter then
   			Dest := Bounds((Width - FImage.Width) div 2, (Height - FImage.Height) div 2,
      			FImage.Width, FImage.Height)
      	else
				Dest := Rect(0, 0, FImage.Width, FImage.Height);
      	with inherited Canvas do
    			StretchDraw(Dest, FImage);
   	end;
   end;
   if csDesigning in ComponentState then with inherited Canvas do begin
   	Pen.Style := psDash;
      Brush.Style := bsClear;
      Rectangle(0, 0, Width, Height);
   end;
end;

procedure TTiledBmp.SetImage(Value: TBitmap);
begin
  	FImage.Assign(Value);
  	Invalidate;
end;

procedure TTiledBmp.PictureChanged( Sender: TObject);
begin
  	if (FImage.width >= Width) and (FImage.Height >= Height) then
  		ControlStyle := ControlStyle + [csOpaque]
  	else
   	ControlStyle := ControlStyle - [csOpaque];
  	Invalidate;
end;

procedure TTiledBmp.SetMode(value: TWallpaperMode);
begin
	if Value <> FMode then begin
   	FMode := Value;
      Invalidate;
   end;
end;


procedure Register;
begin
   RegisterComponents('sEditTools', [TTiledBmp]);
end;

end.
