unit SEDReg;

interface

procedure Register;

implementation
uses
   SysUtils, Classes, DsgnIntf, Dialogs, Forms, FiltEdit,
   sFileUtils, sCtrls, sPickDate, sEdits, sCombos, sBrowseFolder, sDBCtrls;

{$R sCtrls.dcr}
{$R sEdits.dcr}
{$R sCombos.dcr}
{$R sPickDate.dcr}
{$R sDBCtrls.dcr}

type
   TFilenameProperty = class(TStringProperty)
   protected
      function GetFilter: string; virtual;
   public
      procedure Edit; override;
      function GetAttributes: TPropertyAttributes; override;
   end;

   TDirnameProperty = class(TStringProperty)
   public
      procedure Edit; override;
      function GetAttributes: TPropertyAttributes; override;
   end;

function TFilenameProperty.GetFilter: string;
begin
   Result := 'All files|*.*';
end;

procedure TFilenameProperty.Edit;
var
   FileOpen: TOpenDialog;
begin
   FileOpen := TOpenDialog.Create(Application);
   try
      FileOpen.Filename := GetValue;
      FileOpen.InitialDir := ExtractFilePath(FileOpen.Filename);
      if (ExtractFileName(FileOpen.Filename) = '') or not
         ValidFileName(ExtractFileName(FileOpen.Filename)) then
         FileOpen.Filename := '';
      FileOpen.Filter := GetFilter;
      FileOpen.Options := FileOpen.Options + [ofHideReadOnly];
      if FileOpen.Execute then
         SetValue(FileOpen.Filename);
   finally
      FileOpen.Free;
   end;
end;

function TFilenameProperty.GetAttributes: TPropertyAttributes;
begin
   Result := [paDialog, paRevertable];
end;

{ TDirnameProperty }

procedure TDirnameProperty.Edit;
var
   FolderName: string;
begin
   FolderName := GetValue;
   if BrowseDirectory(FolderName, 'Select directiory') then
      SetValue(FolderName);
end;

function TDirnameProperty.GetAttributes: TPropertyAttributes;
begin
   Result := [paDialog, paRevertable];
end;


const
   sEditToolsPage = 'sEditTools';
   sDBEditToolsPage = 'sDBEditTools';

procedure Register;
begin
   RegisterComponents(sEditToolsPage, [TsEdit, TsLinkEdit, TsDateEdit,
         TsNumberEdit, TsFilenameEdit, TsDirectoryEdit]);
   RegisterComponents(sEditToolsPage, [TsComboBox, TsColorComboBox,
         TsFontComboBox, TsPathComboBox]);
   RegisterComponents(sEditToolsPage, [TsCheckBox, TsRadioButton]);
   RegisterComponents(sEditToolsPage, [TsCalendar]);

   {Database components}
   RegisterComponents(sDBEditToolsPage, [TsDBEdit, TsDBLinkEdit, TsDBDateEdit, TsDBNumberEdit, TsDBCheckBox{, TsDBComboBox}]);

   RegisterPropertyEditor( TypeInfo(string), TsFileNameEdit, 'Filter', TFilterProperty);
   RegisterPropertyEditor( TypeInfo(string), TsFileNameEdit, 'Path', TFilenameProperty);
   RegisterPropertyEditor( TypeInfo(string), TsDirectoryEdit, 'Path', TDirnameProperty);
   RegisterPropertyEditor( TypeInfo(string), TsFileDirEdit, 'InitialDir', TDirnameProperty);
   RegisterPropertyEditor( TypeInfo(string), TsPathComboBox, 'Path', TDirnameProperty);
end;

end.
