unit u_main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  SecHash, StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    SecHash1: TSecHash;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
const IV : array[0..2] of Char = ('a','b','c');
var IntDigest : TIntDigest;
begin
   IntDigest:=SecHash1.ComputeString('abc');
   ShowMessage( 'Vector 1: "abc" results in the message digest :'+#13#10#13#10+
                intToHex(IntDigest[0],8)+' '+
                intToHex(IntDigest[1],8)+' '+
                intToHex(IntDigest[2],8)+' '+
                intToHex(IntDigest[3],8)+' '+
                intToHex(IntDigest[4],8));
end;

procedure TForm1.Button2Click(Sender: TObject);
var IntDigest : TIntDigest;
begin
   IntDigest:=SecHash1.ComputeString('abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq');
   ShowMessage( 'Vector 2: "abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq"'+#13#10+
                '                  results in the message digest :'+#13#10#13#10+
                intToHex(IntDigest[0],8)+' '+
                intToHex(IntDigest[1],8)+' '+
                intToHex(IntDigest[2],8)+' '+
                intToHex(IntDigest[3],8)+' '+
                intToHex(IntDigest[4],8));
end;

procedure TForm1.Button3Click(Sender: TObject);
var IntDigest : TIntDigest;
begin
   Screen.Cursor:=crHourGlass;
   Try
      IntDigest:=SecHash1.ComputeFile('aaaa.aaa');
   finally
      Screen.Cursor:=crDefault;
   end;
   ShowMessage( 'Vector 3: "a million repetitions of a" results in the message digest :'+#13#10#13#10+
                intToHex(IntDigest[0],8)+' '+
                intToHex(IntDigest[1],8)+' '+
                intToHex(IntDigest[2],8)+' '+
                intToHex(IntDigest[3],8)+' '+
                intToHex(IntDigest[4],8));
end;

end.
