unit ScriptDemoWin;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Buttons, StdCtrls, ScriptTypes, ScriptExceptions, ScriptTokenizer, ComCtrls, ExtCtrls,
  Db, DBTables, Menus;

type
  TfrmScriptDemo = class(TForm)
	 script: TScript;
	 fncsGraphix: TFuncs;
	 fncDot: TFunc;
	 fncSin: TFunc;
	 fncCos: TFunc;
	 fncPrint: TFunc;
	 Panel2: TPanel;
	 imPix: TImage;
	 lbLog: TListBox;
	 MainMenu1: TMainMenu;
	 FileMenu: TMenuItem;
	 NewItem: TMenuItem;
	 OpenItem: TMenuItem;
	 SaveItem: TMenuItem;
	 ExitItem: TMenuItem;
	 N1: TMenuItem;
	 ScriptMenu: TMenuItem;
	 CompileItem: TMenuItem;
	 ExecuteItem: TMenuItem;
	 N2: TMenuItem;
	 ShowTreeItem: TMenuItem;
	 Memo1: TMemo;
	 DemosMenu: TMenuItem;
	 CircleItem: TMenuItem;
	 OpenDialog1: TOpenDialog;
	 SaveDialog1: TSaveDialog;
	 fncClearPix: TFunc;
	 N3: TMenuItem;
	 VariablesItem: TMenuItem;
	 fncLine: TFunc;
	 LinesItem: TMenuItem;
	 N4: TMenuItem;
	 MacroStartItem: TMenuItem;
	 MacroStopItem: TMenuItem;
	 ProceduresItem: TMenuItem;
	 ParamresItem: TMenuItem;
	 ArrayItem: TMenuItem;
	 HelpMenu: TMenuItem;
	 SyntaxItem: TMenuItem;
	 ClassItem: TMenuItem;
	 FuncItem: TMenuItem;
	 N5: TMenuItem;
	 HomeItem: TMenuItem;
	 AboutItem: TMenuItem;
	 ReadmeItem: TMenuItem;
	 StopItem: TMenuItem;
	 ColorsItem: TMenuItem;
	 GraphicsItem: TMenuItem;
	 OverloadingItem: TMenuItem;
	 fncOverload: TFunc;
	 fncGetPixel: TFunc;
	 ScreenCopyItem: TMenuItem;
	 ExitBreakContinue1: TMenuItem;
    fncGetCapitals: TFunc;
    htmlItem: TMenuItem;
    N6: TMenuItem;
    BlockItem: TMenuItem;
    DelphiProcedures1: TMenuItem;
    SaveAsItem: TMenuItem;
    ScriptArraysItem: TMenuItem;
    DelphiArraysItem: TMenuItem;
    MultiArraysItem: TMenuItem;
	 procedure fncSinEval(Sender: TObject; args: TArgList; var Result: Variant);
	 procedure fncPrintEval(Sender: TObject; args: TArgList; var Result: Variant);
	 procedure fncCosEval(Sender: TObject; args: TArgList; var Result: Variant);
	 procedure fncClearPixEval(Sender: TObject; args: TArgList; var Result: Variant);
	 procedure NewItemClick(Sender: TObject);
	 procedure CompileItemClick(Sender: TObject);
	 procedure ExecuteItemClick(Sender: TObject);
	 procedure ExitItemClick(Sender: TObject);
	 procedure ShowTreeItemClick(Sender: TObject);
	 procedure FormCreate(Sender: TObject);
	 procedure CircleItemClick(Sender: TObject);
	 procedure VariablesItemClick(Sender: TObject);
	 procedure MacroStartItemClick(Sender: TObject);
	 procedure LinesItemClick(Sender: TObject);
	 procedure MacroStopItemClick(Sender: TObject);
	 procedure imPixMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
	 procedure imPixMouseUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
	 procedure ProceduresItemClick(Sender: TObject);
	 procedure ParamresItemClick(Sender: TObject);
	 procedure ArrayItemClick(Sender: TObject);
	 procedure SyntaxItemClick(Sender: TObject);
	 procedure FuncItemClick(Sender: TObject);
	 procedure ClassItemClick(Sender: TObject);
	 procedure HomeItemClick(Sender: TObject);
	 procedure AboutItemClick(Sender: TObject);
	 procedure ReadmeItemClick(Sender: TObject);
	 procedure StopItemClick(Sender: TObject);
	 procedure ColorsItemClick(Sender: TObject);
	 procedure fncOverloadExEval(Sender: TObject; pat: Integer; args: TArgList; var Result: Variant);
	 procedure OverloadingItemClick(Sender: TObject);
	 procedure fncLineExEval(Sender: TObject; pat: Integer; args: TArgList; var Result: Variant);
	 procedure fncGetPixelEval(Sender: TObject; args: TArgList; var Result: Variant);
	 procedure fncDotExEval(Sender: TObject; pat: Integer; args: TArgList; var Result: Variant);
	 procedure ScreenCopyItemClick(Sender: TObject);
	 procedure FormDestroy(Sender: TObject);
	 procedure ExitBreakContinue1Click(Sender: TObject);
	 procedure fncGetCapitalsEval(Sender: TObject; args: TArgList;
	 var Result: Variant);
	 procedure SaveItemClick(Sender: TObject);
	 procedure OpenItemClick(Sender: TObject);
    procedure Memo1Change(Sender: TObject);
	 procedure htmlItemClick(Sender: TObject);
    procedure BlockItemClick(Sender: TObject);
    procedure SaveAsItemClick(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure DelphiArraysItemClick(Sender: TObject);
    procedure MultiArraysItemClick(Sender: TObject);
  private
	 orgx, orgy : Integer;
	 macro : boolean;
	 winDC : THandle;

	 ScriptChanged : boolean;

	 scrfile : string;
	 procedure OpenScript (sname : string);
  public
	 progpath : string;
	 docupath : string;
	 scriptpath : string;
  end;

var
  frmScriptDemo: TfrmScriptDemo;

implementation

uses ScriptDemoTree, ScriptDemoVar, ShellApi;

{$R *.DFM}

procedure TfrmScriptDemo.FormCreate(Sender: TObject);
begin
	progpath := ExtractFilePath (Application.Exename);
	docupath := progpath + '..\help\';
	scriptpath := progpath + '..\scripts\';
	ScriptChanged := false;
	Macro := false;

	winDC := GetWindowDC (Handle);
end;

procedure TfrmScriptDemo.FormDestroy(Sender: TObject);
begin
	ReleaseDC (Handle, winDC);
end;

procedure TfrmScriptDemo.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
	NewItemClick (Sender);
	CanClose := not Memo1.Modified;
end;

procedure TfrmScriptDemo.NewItemClick(Sender: TObject);
var
	res : Integer;
begin
	if Memo1.Modified then begin
		res := MessageDlg ('There are unsaved changes! Do you want to save now?',
		mtInformation, [mbYes, mbNo, mbCancel], 0);
		if res = mrCancel then exit;
		if res = mrYes then SaveItemClick (self);
	end;
	Memo1.Clear;
	Memo1.Modified := false;
	scrfile := '';
	Caption := 'TScript Demo';
end;

procedure TfrmScriptDemo.OpenItemClick(Sender: TObject);
begin
	OpenDialog1.InitialDir := scriptpath;
	if OpenDialog1.Execute then begin
		NewItemClick (sender);
		if Memo1.Modified then exit;
		scrfile := OpenDialog1.FileName;
		Caption := 'TScript Demo - ' + scrfile;
		Memo1.Lines.LoadFromFile (OpenDialog1.FileName);

		ScriptChanged := true;
	end;
end;

procedure TfrmScriptDemo.SaveItemClick(Sender: TObject);
begin
	if scrfile = '' then
		SaveAsItemClick (Sender)
	else begin
		Memo1.Lines.SaveToFile (scrfile);
		Memo1.Modified := false;
	end;
end;

procedure TfrmScriptDemo.SaveAsItemClick(Sender: TObject);
begin
	SaveDialog1.InitialDir := scriptpath;
	if SaveDialog1.Execute then begin
		scrfile := SaveDialog1.FileName;
		Caption := 'TScript Demo - ' + scrfile;
		Memo1.Lines.SaveToFile (scrfile);
	end;
end;

procedure TfrmScriptDemo.ExitItemClick(Sender: TObject);
begin
	Close
end;

procedure TfrmScriptDemo.Memo1Change(Sender: TObject);
begin
	// The script code was modified in the memo
	ScriptChanged := true;
end;

procedure TfrmScriptDemo.CompileItemClick(Sender: TObject);
begin
	try
		// Assigns the script code in the memo to the script component
		script.Text := Memo1.Lines.Text;
		ScriptChanged := false;

		// Compiles the script
		if script.Compile then begin
			lbLog.Clear;
			lbLog.Items.Add ('*** Compiled.')
		end
		else
			lbLog.Items.Add ('*** Not compiled (Script is running)');
	except
		// Errors in the script syntax will raise an EScriptError-exception
		on e : EScriptError do begin
			// The position of the token causing the error is stored in e.ePos
			memo1.SelStart := e.ePos - 1;
			memo1.SelLength := 1;
			ShowMessage (e.Message);
		end;
		on e : Exception do
			ShowMessage (e.Message);
	end;
end;

procedure TfrmScriptDemo.ExecuteItemClick(Sender: TObject);
var
	t : LongInt;
begin
	try
		if ScriptChanged then script.Text := Memo1.Lines.Text;
		ScriptChanged := false;
		if not script.Compiled then lbLog.Clear;
		lbLog.Items.Add ('==========================================');
		lbLog.Items.Add ('*** Executing...  press [Ctrl+Del] to stop');
		t := GetTickCount;

		// If the script is not yet compiled Execute will do this now.
		if script.Execute then begin
			// Execution successful!
			lbLog.Items.Add (Format ('*** Executed. [%.2f s]', [(LongInt (GetTickCount) - t) / 1000]));
			// Shows the value of the script variable "result"
			lbLog.Items.Add ('*** Result: ' + VarToStr (script.Result));
		end
		else
			lbLog.Items.Add ('*** Execution failed');
	except
		// Runtime errors in the script will raise an EScriptError-exception
		on e : EScriptError do begin
			// Highlight the position of the runtime error
			Memo1.SelStart := e.ePos - 1;
			Memo1.SelLength := 1;
			ShowMessage (e.Message);
		end;
		on e : Exception do
			ShowMessage (e.Message);
	end;
end;

procedure TfrmScriptDemo.StopItemClick(Sender: TObject);
begin
	// If a script is executing it will be stopped now.
	script.Stop;
end;

procedure TfrmScriptDemo.BlockItemClick(Sender: TObject);
begin
	// Toggel blocking mode
	script.Blocking := not script.Blocking;
	BlockItem.Checked := script.Blocking;	
end;

procedure TfrmScriptDemo.VariablesItemClick(Sender: TObject);
begin
	frmScriptDemoVar.ShowModal;
end;

procedure TfrmScriptDemo.ShowTreeItemClick(Sender: TObject);
begin
	// Shows the code tree, generated by the script parser in a TTreeView component
	script.ShowTree (frmScriptTree.TV);
	frmScriptTree.ShowModal;
end;

procedure TfrmScriptDemo.OpenScript;
begin
	NewItemClick (nil);
	Memo1.Lines.LoadFromFile (scriptpath + sname);
	scrfile := scriptpath + sname;
	Caption := 'TScript Demo - ' + scrfile;
end;

procedure TfrmScriptDemo.LinesItemClick(Sender: TObject);
begin
	OpenScript ('lines.sct');
end;

procedure TfrmScriptDemo.ColorsItemClick(Sender: TObject);
begin
	OpenScript ('colors.sct');
end;

procedure TfrmScriptDemo.CircleItemClick(Sender: TObject);
begin
	OpenScript ('circle.sct');
end;

procedure TfrmScriptDemo.ScreenCopyItemClick(Sender: TObject);
begin
	OpenScript ('scrcopy.sct');
end;

procedure TfrmScriptDemo.ArrayItemClick(Sender: TObject);
begin
	OpenScript ('array.sct');
end;

procedure TfrmScriptDemo.DelphiArraysItemClick(Sender: TObject);
begin
	OpenScript ('delphiarrays.sct');
end;

procedure TfrmScriptDemo.MultiArraysItemClick(Sender: TObject);
begin
	OpenScript ('multiarrays.sct');
end;

procedure TfrmScriptDemo.ProceduresItemClick(Sender: TObject);
begin
	OpenScript ('dprocs.sct');
end;

procedure TfrmScriptDemo.ExitBreakContinue1Click(Sender: TObject);
begin
	OpenScript ('exitbreak.sct');
end;

procedure TfrmScriptDemo.OverloadingItemClick(Sender: TObject);
begin
	OpenScript ('overload.sct');
end;

procedure TfrmScriptDemo.ParamresItemClick(Sender: TObject);
begin
	// Creates two global variables.
	script.SetGlobal ('opentime', Double(now)); // Without a typecast (double) the compiler would create a varDateTime variant (not supported by TScript)
	script.SetGlobal ('exectime', Double(now));
	OpenScript ('globalvar.sct');
end;

procedure TfrmScriptDemo.MacroStartItemClick(Sender: TObject);
begin
	// Initialization
	imPix.Canvas.FillRect (imPix.ClientRect);
	OpenScript ('macro.sct');

	Macro := True;
end;

procedure TfrmScriptDemo.MacroStopItemClick(Sender: TObject);
begin
	Macro := False;
end;

procedure OpenFile(const FileName : string);
begin
	if FileExists (FileName) then
		ShellExecute(Application.MainForm.Handle, 'open', PChar (FileName), nil, nil, SW_SHOW)
	else
		ShowMessage (Filename + ' not found');
end;

procedure TfrmScriptDemo.htmlItemClick(Sender: TObject);
begin
	OpenFile (docupath + 'scrip_en.html');
end;

procedure TfrmScriptDemo.SyntaxItemClick(Sender: TObject);
begin
	OpenFile (docupath + 'scsyn_en.html');
end;

procedure TfrmScriptDemo.FuncItemClick(Sender: TObject);
begin
	OpenFile (docupath + 'scbif_en.html');
end;

procedure TfrmScriptDemo.ClassItemClick(Sender: TObject);
begin
	OpenFile (docupath + 'sccmp_en.html');
end;

procedure TfrmScriptDemo.ReadmeItemClick(Sender: TObject);
begin
	OpenFile ('..\readme.txt');
end;

procedure TfrmScriptDemo.HomeItemClick(Sender: TObject);
begin
	OpenFile ('http://n.ethz.ch/student/ackermma/index_en.html')
end;

procedure TfrmScriptDemo.AboutItemClick(Sender: TObject);
begin
	ShowMessage ('Demonstration program for TScript Component'#10#13'(c) 1999 by Matthias Ackermann, Switzerland');
end;

procedure TfrmScriptDemo.imPixMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
	if not Macro then exit;
	// Remember mouse position.
	orgx := x; orgy := y;
end;

procedure TfrmScriptDemo.imPixMouseUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
	// Mousebutton released in the image surface
	if not Macro then exit;

	imPix.Canvas.MoveTo (orgx, orgy);
	imPix.Canvas.LineTo (x, y);

	Memo1.Lines.Add (Format ('Line (%d, %d, %d, %d);', [orgx, orgy, x, y]));
end;

procedure TfrmScriptDemo.fncDotExEval(Sender: TObject; pat: Integer; args: TArgList; var Result: Variant);
begin
	{
	fncDot.Declaration: Dot (integer, integer), (integer, integer, integer)
	-> Dot has two diffrent definitions
	-> variable 'pat' indicates which definition was selected
	}

	if pat = 1 then imPix.Canvas.Pen.Color := args[2].Eval;
	imPix.Canvas.Pixels[Round(args[0].Eval), Round(args[1].Eval)] := imPix.Canvas.Pen.Color;
end;

procedure TfrmScriptDemo.fncLineExEval(Sender: TObject; pat: Integer; args: TArgList; var Result: Variant);
begin
	{
	fncLine.Declaration: Line (integer, integer, integer, integer, integer), (integer, integer, integer, integer)
	-> Two diffrent definitions
	-> pat indicates which definition was selected
	}
	if pat = 0 then	imPix.Canvas.Pen.Color := args[4].Eval;
	imPix.Canvas.MoveTo (args[0].Eval, args[1].Eval);
	imPix.Canvas.LineTo (args[2].Eval, args[3].Eval);
end;

procedure TfrmScriptDemo.fncClearPixEval (Sender: TObject; args: TArgList; var Result: Variant);
begin
	{
	fncClearPix.Declaration: ClearPix ()
	-> args is empty
	}
	imPix.Canvas.FillRect (imPix.ClientRect);
end;

procedure TfrmScriptDemo.fncGetPixelEval(Sender: TObject; args: TArgList; var Result: Variant);
begin
	{
	fncGetPixel.Declaration: getpixel (integer, integer)
	-> Returns the color of the pixel indicated by x and y (args[0].Eval and args[1].Eval)
	}
	result := GetPixel (winDC, args[0].Eval, args[1].Eval);
end;

procedure TfrmScriptDemo.fncSinEval (Sender: TObject; args: TArgList; var Result: Variant);
begin
	{
	fncSin.Declaration: Sin (float) : float
	-> if result is not a floating point value, a runtime error occurs
	}
	result := System.Sin (args[0].Eval);
end;

procedure TfrmScriptDemo.fncCosEval (Sender: TObject; args: TArgList; var Result: Variant);
begin
	{
	fncCos.Declaration: Cos (float) : float
	-> if result is not a floating point value, a runtime error will occur
	}
	result := System.Cos (args[0].Eval);
end;

procedure TfrmScriptDemo.fncPrintEval (Sender: TObject; args: TArgList; var Result: Variant);
var
	x : Integer;
begin
	{
	fncPrint.Declaration: Print (all open)
	-> The number and type of the arguments varies
	}
	for x := 0 to args.count - 1 do
		lbLog.Items.Add (VarToStr (args[x].Eval));
end;

procedure TfrmScriptDemo.fncOverloadExEval(Sender: TObject; pat: Integer; args: TArgList; var Result: Variant);
begin
	{
	fncOverload.Definition: overload (integer), (string), (integer, string), (string, integer) : string;
	-> Four diffrent definitions.
	-> Shows how to use the variable 'pat' of the OnExEval event!
	}
	case pat of
		0 : result := 'INTEGER: ' + IntToStr (args[0].Eval);
		1 : result := 'STRING: ' + args[0].Eval;
		2 : result := IntToStr (args[0].Eval) + args[1].Eval;
		3 : result := args[0].Eval + IntToStr (args[1].Eval);
	end;
	result := Format ('pat: %d %s', [pat, result]);
end;

procedure TfrmScriptDemo.fncGetCapitalsEval(Sender: TObject; args: TArgList; var Result: Variant);
var
	v : Variant;
begin
	v := VarArrayCreate ([0, 4, 0, 1], varOleStr);

	v[0,0] := 'SWITZERLAND';
	v[1,0] := 'GERMANY';
	v[2,0] := 'AUSTRIA';
	v[3,0] := 'ITALIA';
	v[4,0] := 'FRANCE';

	v[0,1] := 'BERN';
	v[1,1] := 'BERLIN';
	v[2,1] := 'WIEN';
	v[3,1] := 'ROM';
	v[4,1] := 'PARIS';

	result := v;
end;

end.
