unit ScriptDemoVar;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Buttons, StdCtrls, ExtCtrls;

type
  TfrmScriptDemoVar = class(TForm)
    lbName: TLabel;
	edName: TEdit;
    cbType: TComboBox;
    lbType: TLabel;
    lbValue: TLabel;
    edValue: TEdit;
    bnRead: TButton;
    bnSet: TButton;
    bnCancel: TBitBtn;
    rgKind: TRadioGroup;
    Label1: TLabel;
	procedure bnSetClick(Sender: TObject);
	procedure bnReadClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure rgKindClick(Sender: TObject);
  private
	{ Private-Deklarationen}
  public
	{ Public-Deklarationen}
  end;

var
  frmScriptDemoVar: TfrmScriptDemoVar;

implementation

uses
	ScriptDemoWin, ScriptTypes;

{$R *.DFM}

procedure TfrmScriptDemoVar.FormCreate(Sender: TObject);
begin
	cbType.ItemIndex := 0;
end;

procedure TfrmScriptDemoVar.bnSetClick(Sender: TObject);
var
	v : Variant;
	size : Integer;
begin
	if rgKind.ItemIndex = 1 then begin
		size := StrToInt (edValue.Text);
		case cbType.ItemIndex of
			0 : v := VarArrayCreate ([0, size - 1], varOleStr);
			1 : v := VarArrayCreate ([0, size - 1], varInteger);
			2 : v := VarArrayCreate ([0, size - 1], varDouble);
			3 : v := VarArrayCreate ([0, size - 1], varBoolean);
		end;
		frmScriptDemo.script.SetGlobal (edName.Text, v);
	end
	else begin
		case cbType.ItemIndex of
			0 : v := edValue.Text;
			1 : v := StrToInt (edValue.Text);
			2 : v := StrToFloat (edValue.Text);
			3 : v := (AnsiCompareText (edValue.Text, 'True') = 0);
		end;
		case rgKind.ItemIndex of
			0 :	frmScriptDemo.script.SetGlobal (edName.Text, v);
			2 : frmScriptDemo.script.SetGlobalConst (edName.Text, v);
		end;
	end;
end;

procedure TfrmScriptDemoVar.bnReadClick(Sender: TObject);
var
	di : TDataItem;
begin
	di := frmScriptDemo.Script.GetGlobal (edName.Text);
	if Assigned (di) then begin
		// Determine type of Dataitem
		if (di is TConstant) then
			rgKind.ItemIndex := 2
		else begin
			if (di.ResType and apArray) <> 0 then
				rgKind.ItemIndex := 1
			else
				rgKind.ItemIndex := 0;
		end;

		// Read value of DataItem
		if (di.ResType and apArray) <> 0 then
			edValue.Text := IntToStr (VarArrayHighBound (di.Value, 1))
		else
			edValue.Text := VarToStr (di.Value);

		// Determine type of DataItem
		if (di.ResType and atString) <> 0 then
			cbType.ItemIndex := 0
		else if (di.ResType and atInteger) <> 0 then
			cbType.ItemIndex := 1
		else if (di.ResType and atFloat) <> 0 then
			cbType.ItemIndex := 2
		else if (di.ResType and atBoolean) <> 0 then
			cbType.ItemIndex := 3;
	end
	else
		edValue.Text := '[undefined]';
end;

procedure TfrmScriptDemoVar.rgKindClick(Sender: TObject);
begin
	if rgKind.ItemIndex = 1 then
		lbValue.Caption := 'Array Size:'
	else
		lbValue.Caption := 'Value:';
end;

end.
