//Well, here it is, my first Delphi Component. Have fun.

{You can use, modify, destroy, change, this code as much as you jolly well like,
but if you imporve it please send be a copy of the imporved source code. Remember
it's jon.baker@virgin.net}

{If you use this code in a commercial product, ie are making small dough from it
then have a pint on me. If you are making really large sums of money then I
would be most upset if you did not to share your welth with me.}

{ps. Leave my name in the code somewere - based on JB etc.}

{

Version 2.
          Thanks to Jim McKeeth, Ken Knight & Josaverhn F Jarrett for their bug fixes. I owe you one guys.

Version 3.
          Well at least you can delete a TScreenSaver!! Ooops.
	  The form now fits correctly in config panel mode.
	  Problems with the preview paine (should) be fixed - let me know if not!
	  Display Properties bugs should be sorted.
          Finally, the baine of my life has been fixed. Yes, I have hooked the WM_SYSCOMMAND message queue. Now only 1 screensaver will activate at a time!!
		(Although the form with TScreenSaver on must be the foreground window.)
          Respect to Dima, without whom I probably would not have bothered with V3.

Thoughts for V4:
	  Hooking the WM_Close queue to automate the screensaver password check.
		This could be done but Form1.Close does not actually WM_CLOSE it Application.Terminates - Arse.
	  Hooking the Keyboard and Mouse queue to automatically send close command.
		This is possible.
}


unit ScreenSaver;


interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, StdCtrls, ExtCtrls, Registry;


type
  TConfigBoxStyle = (cbsMessageDlg, cbsPanel); //Choose between standard Dialog Box and Panel View
  TDuplicateComponent = class(Exception);
  TFormNotOwner = class(Exception);
  TOnPreviewEvent = procedure(Sender :TObject) of object;
  TOnMainSaverEvent = procedure(Sender :TObject) of object;
  TOnConfigBoxEvent = procedure(Sender :TObject) of object;
  TOnPasswordSetEvent = procedure(Sender :TObject) of object;
  TOnBeforePreviewEvent = procedure(Sender :TObject) of object;
  TOnBeforeMainSaverEvent = procedure(Sender :TObject) of object;
  TOnBeforeConfigBoxEvent = procedure(Sender :TObject) of object;
  TOnBeforePasswordSetEvent = procedure(Sender :TObject) of object;
  TScreenSaver = class(TComponent)

  private
    fAutoEnable: Boolean;
    fAutoMaximize: Boolean;
    fAutoBorderLess: Boolean;
    fAutoOnTop: Boolean;
    fPreview: Boolean;
    fMainSaver: Boolean;
    fConfigBox: Boolean;
    fConfigBoxStyle: TConfigBoxStyle;
    fConfigBoxPanel: TPanel;
    fConfigBoxMessage: String;
    fSystemKeysOff: Boolean;
    fPasswordSetting: Boolean;
    fAutoMouseHide: Boolean;
    fAutoPanelHide: Boolean;
    fToLoad:Boolean;

    OldWndProc: TFarProc;
    NewWndProc: Pointer;

    fOnPreviewEvent:TOnPreviewEvent;
    fOnMainSaverEvent:TOnMainSaverEvent;
    fOnConfigBoxEvent:TOnConfigBoxEvent;
    fOnPasswordSetEvent:TOnPasswordSetEvent;
    fOnBeforePreviewEvent:TOnBeforePreviewEvent;
    fOnBeforeMainSaverEvent:TOnBeforeMainSaverEvent;
    fOnBeforeConfigBoxEvent:TOnBeforeConfigBoxEvent;
    fOnBeforePasswordSetEvent:TOnBeforePasswordSetEvent;

    Function IsAutoEnable:boolean;
    Procedure SetAutoEnable (value:boolean);

    Function IsAutoMaximize:boolean;
    Procedure SetAutoMaximize (value:boolean);

    Function IsAutoBorderLess:boolean;
    Procedure SetAutoBorderLess (value:boolean);

    Function IsAutoOnTop:boolean;
    Procedure SetAutoOnTop (value:boolean);

    Function IsPreview:boolean;
    Procedure SetPreview (value:boolean);

    Function IsMainSaver:boolean;
    Procedure SetMainSaver (value:boolean);

    Function IsConfigBox:boolean;
    Procedure SetConfigBox (value:boolean);

    Function IsConfigBoxStyle:TConfigBoxStyle;
    Procedure SetConfigBoxStyle (value:TConfigBoxStyle);

    Function IsConfigBoxPanel:TPanel;
    Procedure SetConfigBoxPanel (value:TPanel);

    Function IsConfigBoxMessage:String;
    Procedure SetConfigBoxMessage (value:String);

    Function IsSystemKeysOff:boolean;
    Procedure SetSystemKeysOff (value:boolean);

    Function IsPasswordSetting:boolean;
    Procedure SetPasswordSetting (value:boolean);

    Function IsAutoMouseHide:boolean;
    Procedure SetAutoMouseHide (value:boolean);

    Function IsAutoPanelHide:boolean;
    Procedure SetAutoPanelHide (value:boolean);

    procedure HookParent;
    procedure UnhookParent;
    procedure ParentMessageProcedure(var Message: TMessage);

     { Private declarations }
  protected
    { Protected declarations }
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure Enable;
    Function DoPasswordCheck:Boolean;
    procedure DoPreview;
    procedure DoMainSaver;
    procedure DoConfigBox;
    procedure DoPasswordSet;
    procedure Loaded; override;

  published
    { Published declarations }
    property AutoEnable: boolean read IsAutoEnable write SetAutoEnable stored true default true;
    property AutoMaximize: boolean read IsAutoMaximize write SetAutoMaximize stored true default true;
    property AutoBorderLess: boolean read IsAutoBorderLess write SetAutoBorderLess stored true default true;
    property AutoOnTop: boolean read IsAutoOnTop write SetAutoOnTop stored true default true;
    property AutoMouseHide: boolean read IsAutoMouseHide write SetAutoMouseHide stored true default true;
    property AutoPanelHide: boolean read IsAutoPanelHide write SetAutoPanelHide stored true default true;
    property PreviewWindow: boolean read IsPreview write SetPreview stored true default true;
    property MainScreenSaver: boolean read IsMainSaver write SetMainSaver stored true default true;
    property ConfigurationBox: boolean read IsConfigBox write SetConfigBox stored true default true;
    property ConfigurationBoxStyle: TConfigBoxStyle read IsConfigBoxStyle write SetConfigBoxStyle stored true default cbsMessageDlg;
    property ConfigurationBoxPanel: TPanel read IsConfigBoxPanel write SetConfigBoxPanel;
    property ConfigurationBoxMessage: String read IsConfigBoxMessage write SetConfigBoxMessage stored true;
    property SystemKeysDisabled: Boolean read IsSystemKeysOff write SetSystemKeysOff stored true default true;
    property PasswordSetting: Boolean read IsPasswordSetting write SetPasswordSetting stored true default true;
    //Events
    property OnPreviewActive: TOnPreviewEvent read FOnPreviewEvent write FOnPreviewEvent;
    property OnMainSaverActive: TOnMainSaverEvent read FOnMainSaverEvent write FOnMainSaverEvent;
    property OnConfigBoxActive: TOnConfigBoxEvent read FOnConfigBoxEvent write FOnConfigBoxEvent;
    property OnPasswordSet: TOnPasswordSetEvent read FOnPasswordSetEvent write FOnPasswordSetEvent;
    property OnBeforePreviewActive: TOnBeforePreviewEvent read FOnBeforePreviewEvent write FOnBeforePreviewEvent;
    property OnBeforeMainSaverActive: TOnBeforeMainSaverEvent read FOnBeforeMainSaverEvent write FOnBeforeMainSaverEvent;
    property OnBeforeConfigBoxActive: TOnBeforeConfigBoxEvent read FOnBeforeConfigBoxEvent write FOnBeforeConfigBoxEvent;
    property OnBeforePasswordSet: TOnBeforePasswordSetEvent read FOnBeforePasswordSetEvent write FOnBeforePasswordSetEvent;
  end;

procedure Register;

var
SaverForm : TForm;


implementation

constructor TScreenSaver.Create(AOwner: TComponent);
var  i: word;				//General Loop Counter
CompCount: byte;                        //Component count
begin
  inherited Create(AOwner);             //Call TComponent Constructor
  CompCount := 0;                       //Initialise Component Count to zero
  SaverForm := TForm(AOwner);            //Where are we comming from? Which Form to Use.
  fPreview := True;
  fMainSaver := True;
  fConfigBox := True;
  fAutoEnable := True;
  fAutoMaximize := True;
  fAutoBorderLess := True;
  fAutoOnTop := True;
  fAutoMouseHide := True;
  fAutoPanelHide := True;
  fConfigBoxStyle:= cbsMessageDlg;
  fConfigBoxMessage:= 'Easy Screensaver Component for Delphi 1999 Jon Baker.';     //Touch this and I will not be pleased.
  fSystemKeysOff := True;
  fPasswordSetting := True;
  fToLoad := False;
  if (csDesigning in ComponentState) then
    if (AOwner is TForm) then
      with (AOwner as TForm) do
      begin
        for i := 0 to ComponentCount - 1 do              //I can't see any reason for having more than one TScreenSaver. Can you?
          if Components[i] is TScreenSaver then inc(CompCount);

if CompCount > 1 then raise TDuplicateComponent.Create ('Why would you want more than 1 TScreenSaver component on a Form?');
     end
      else
        raise TFormNotOwner.Create('The TScreenSaver Component does not appear to be on a TForm. What are you trying to do?');

end;

destructor TScreenSaver.Destroy;
var PassedParam : String;
Output: Integer;
begin
if not (csDesigning in ComponentState) then
begin
  	UnhookParent;
        PassedParam := UpperCase(ParamStr(1));
        Delete(PassedParam, 1, 1);
        Delete(PassedParam, 2, Length(PassedParam));
        If UpperCase(PassedParam) = 'C' then
           begin
           EnableWindow(FindWindow(nil, 'Display Properties'), True);     //Enable Display Properites.
           //EnableWindow(GetParent(StrToIntDef(PassedParam, 0)), True);
           end;
        if fSystemKeysOff = True then SystemParametersInfo(SPI_SCREENSAVERRUNNING, Word(False), @Output, 0);   //SystemKeysOn
        if fAutoMouseHide = True then ShowCursor(True);       //Mouse Visible
//        inherited destroy;
end;
inherited destroy;
end;

//Preview-----------------------------------------------------------------------------------------------------
procedure TScreenSaver.DoPreview;
var ThisWindow : hWnd;
SaverWindow: hWnd;
begin
if assigned(FOnBeforePreviewEvent) then FOnBeforePreviewEvent(Self);
If fPreview = True then
   begin
   //Kill taskbar Option.
   ShowWindow(FindWindow(nil,@Application.Title[1]), SW_HIDE);
   SetWindowLong(Application.Handle, GWL_EXSTYLE, WS_EX_TOOLWINDOW and not WS_EX_APPWINDOW or WS_EX_TOPMOST);

   ThisWindow := SaverForm.Handle; //That is better!

   SaverWindow := StrToIntDef(ParamStr(2), 0);                   //Set to 0 if no Param2String;

   If StrToIntDef(ParamStr(2), -1) <> -1 then                    // And obviously don't bother with the preview.
      begin

      //SetForegroundWindow(FindWindow(nil, 'Display Properties'));         //Where else would you run the preview from? If you can think of somewhere I will modify this.

      //Get and Set the attributes of the preview window.
      SetWindowLong(ThisWindow, GWL_STYLE, GetWindowLong((SaverWindow), GWL_STYLE) or WS_DISABLED or WS_CHILD);
      SetWindowLong(ThisWindow, GWL_EXSTYLE, GetWindowLong((SaverWindow), GWL_EXSTYLE));

      Windows.SetParent(ThisWindow, SaverWindow);       //Put preview window in the box.

      //Create the right Size of form.
      SaverForm.Position := poDesigned;

      If fAutoMaximize = True then
         begin
         SaverForm.Width := Screen.Width;
         SaverForm.Height := Screen.Height;
         end;

      with SaverForm do ScaleBy(152, Width);

      SaverForm.Width := 152;                       //Here I have a problem, what ever I try I can't create a frame border of have a box wich doesn't fill the preview window
      SaverForm.Height := 112;                      //Without reeking havoc with the SetParent command. So you will have to put up with no border and a window which fills the preview box.
      SaverForm.Top := 0;                           //If you have any ideas on how to improve this please let me know.
      SaverForm.Left := 0;

      end;

   end;
   if assigned(FOnPreviewEvent) then FOnPreviewEvent(Self);
end;

Function TScreenSaver.IsPreview:boolean;
begin
result:=fPreview;
end;

Procedure TScreenSaver.SetPreview(value:boolean);
begin
fPreview:=value;
end;

//MainSaver---------------------------------------------------------------------------------------------------
procedure TScreenSaver.DoMainSaver;
var Output: Integer;
begin
if assigned(FOnBeforeMainSaverEvent) then FOnBeforeMainSaverEvent(Self);
If fMainSaver = True then
   begin
   //Kill taskbar Option.
   ShowWindow(FindWindow(nil,@Application.Title[1]), SW_HIDE);
   //Kill System Keys
   if fSystemKeysOff then SystemParametersInfo(SPI_SCREENSAVERRUNNING, Word(True), @Output, 0);
   if fAutoMouseHide then ShowCursor(False);
   if fAutoMaximize then SaverForm.WindowState := wsMaximized;
   if fAutoBorderLess then SaverForm.BorderStyle := bsNone;
   if fAutoOnTop then SaverForm.FormStyle := fsStayOnTop;
   end;
   HookParent;
   if assigned(FOnMainSaverEvent) then FOnMainSaverEvent(Self);
end;

Function TScreenSaver.IsMainSaver:boolean;
begin
result:=fMainSaver;
end;

Procedure TScreenSaver.SetMainSaver(value:boolean);
begin
fMainSaver:=value;
end;

//ConfigBox---------------------------------------------------------------------------------------------------
procedure TScreenSaver.DoConfigBox;
var i:Integer;
PassedParam: String;
begin
if assigned(FOnBeforeConfigBoxEvent) then FOnBeforeConfigBoxEvent(Self);
PassedParam := UpperCase(ParamStr(1));
Delete(PassedParam, 1, 1);
Delete(PassedParam, 2, Length(PassedParam));
If fConfigBox = True then
   If fConfigBoxStyle = cbsPanel then
      begin
            with SaverForm do
                begin
                     //EnableWindow(GetParent(StrToIntDef(PassedParam, 0)), False); //This it want you could use if you only want to work under NT, however, you will need to strip passedparam 1,3.
                     //Ok, this is quite novel. I wanted to be able to use another form for the config box if I chose. I could not find a way to do that, but I could count panels.
                     //So this bit runs through all components, hides all the panels, except the one chosen. I thought about destroying them, but thought somebody may what them for something.
                     for i := 0 to ComponentCount - 1 do
                         if Components[i] is TPanel then if Components[i].Name <> fConfigBoxPanel.Name then TPanel(Components[i]).Visible := False;
                     fConfigBoxPanel.Visible := True;
                     fConfigBoxPanel.Left := 0;
                     fConfigBoxPanel.Top := 0;
                     fConfigBoxPanel.BringToFront;
                     WindowState := wsNormal;
                     BorderStyle := bsDialog;
                     ClientWidth := fConfigBoxPanel.Width;
                     ClientHeight := fConfigBoxPanel.Height;
                     Position := poScreenCenter;
                     //Show;
                     //NT, praise it, passes /c:12345 where the number identifies a child of the Display Properites window, so you would disable the parent of 12345.
                     //95 on the otherhand, over looked this, so we will have to too. Damn 95 and all who use her.
                     //The down side of this is that if Disp Prop is open, and you run the SS /c outside of this it will disable display properites. Tough. ps. Sorry for the Abrev. I'm getting lazy.
                     If PassedParam = 'C' then
                        begin
                        EnableWindow(FindWindow(nil, 'Display Properties'), False);
                        SetForegroundWindow(FindWindow(nil, 'Display Properties'));  //If I don't do this, all sorts of windows end up in front of DispProp, weird.
                        end;
                end;
      end
      else
      begin
      //This bit does the MessageDlg if required.
      If PassedParam = 'C' then
         begin
         EnableWindow(FindWindow(nil, 'Display Properties'), False);
         end;
      If SaverForm.WindowState <> wsNormal then SaverForm.WindowState := wsNormal;
      SaverForm.Left := -SaverForm.Width - 100;
      MessageDlg(fConfigBoxMessage, mtInformation, [mbOK], 0);
      if assigned(FOnConfigBoxEvent) then FOnConfigBoxEvent(Self);
      If PassedParam = 'C' then
         begin
         EnableWindow(FindWindow(nil, 'Display Properties'), True);
         SetForegroundWindow(FindWindow(nil, 'Display Properties'));
         end;
      Application.Terminate;
      end;

  if assigned(FOnConfigBoxEvent) then FOnConfigBoxEvent(Self);

end;

Function TScreenSaver.IsConfigBox:boolean;
begin
result:=fConfigBox;
end;

Procedure TScreenSaver.SetConfigBox(value:boolean);
begin
fConfigBox:=value;
end;

//PasswordSetFor95-------------------This-Section-Was-Sort-of-Stolen.-Sorry-Meik-Weber---Who-Ever-You-Are!----
//Note this function will not be called under NT.
Procedure TScreenSaver.DoPasswordSet;
var  hLib : THandle;
  P : function (a : PChar; ParentHandle : THandle; b, c : Integer) : Integer; stdcall;
  SysDir : String;
  NewLength : Integer;
  PassedParam: String;
begin
if assigned(FOnBeforePasswordSetEvent) then FOnBeforePasswordSetEvent(Self);
if fPasswordSetting = True then
   begin
   //Kill taskbar Option.
   ShowWindow(FindWindow(nil,@Application.Title[1]), SW_HIDE);
   SaverForm.WindowState := wsMinimized;
   SetWindowLong(Application.Handle, GWL_EXSTYLE, WS_EX_TOOLWINDOW and not WS_EX_APPWINDOW or WS_EX_TOPMOST);

   PassedParam := UpperCase(ParamStr(2));
   SetLength (SysDir, MAX_PATH);
   NewLength := GetSystemDirectory (PChar (SysDir), MAX_PATH);
   SetLength (SysDir, NewLength);
   if (length (SysDir) > 0) and (SysDir [length (SysDir)] <> '\') then SysDir := SysDir + '\';
   hLib := LoadLibrary (PChar (SysDir + 'MPR.DLL'));
   if hLib <> 0 then
      begin
      P := GetProcAddress(hLib, 'PwdChangePasswordA');
      if assigned(P) then P('SCRSAVE', StrToIntDef(PassedParam, 0), 0, 0);  //The code I lifted this from (sorry chief)
      FreeLibrary (hLib);
      end;
   end;
   if assigned(FOnPasswordSetEvent) then FOnPasswordSetEvent(Self);
   if fPasswordSetting = True then Application.Terminate;
end;

//PasswordCheckFor95---------------------Yep,-this-section too.-Although-I-did-tidy-this-code-up-a-bit--------
//Note this function will fail under NT.
Function TScreenSaver.DoPasswordCheck:boolean;
var
  hLib : THandle;
  P : function (Parent : THandle) : Boolean; stdcall;
  SysDir : String;
  NewLength : Integer;
  Registry : TRegistry;
  PassedParam: String;
  SaverWind: hWnd;
begin
   SaverWind := GetForegroundWindow;
   if fAutoMouseHide = True then ShowCursor(True);
  //Check if Use Password ticked
  PassedParam := UpperCase(ParamStr(1));
  Delete(PassedParam, 1, 1);                       //Remove any / or -
  Delete(PassedParam, 2, Length(PassedParam));     // some times winows passes /c:312321
  If PassedParam <> 'S' then Result := True else
  begin
  Registry := TRegistry.Create;
  Registry.RootKey := HKEY_CURRENT_USER;
  if Registry.OpenKey('Control Panel\Desktop', false) = False then Result := True else
  begin
    if Registry.ValueExists('ScreenSaveUsePassword') = False then Result := True else
    begin
      if Registry.ReadInteger('ScreenSaveUsePassword') = 0 then Result := True else
         begin
         //ShowCursor (True);
         //load library PASSWORD.CPL from system-directory
         SetLength (SysDir, MAX_PATH);
         NewLength := GetSystemDirectory (PChar (SysDir), MAX_PATH);
         SetLength (SysDir, NewLength);
         if (length (SysDir) > 0) and (SysDir [length (SysDir)] <> '\') then SysDir := SysDir + '\';
         hLib := LoadLibrary (PChar (SysDir + 'PASSWORD.CPL'));
         if hLib = 0 then Result := True else //if dll not found
            begin
              //show the password verification dialog
              P := GetProcAddress (hLib, 'VerifyScreenSavePwd');
              if P(SaverWind) then Result := True else
                 begin
                 Result := False;
                 if fAutoMouseHide = True then ShowCursor(False);
                 end;
              FreeLibrary (hLib); //unload PASSWORD.CPL
            end;
         end;
    end;
  end;
  Registry.Free;
  end;
end;

//All these set and recieve settings.
//AutoEnable--------------------------------------------------------------------------------------------------
Function TScreenSaver.IsAutoEnable:boolean;
begin
result:=fAutoEnable;
end;

Procedure TScreenSaver.SetAutoEnable(value:boolean);
begin
fAutoEnable:=value;
end;

//AutoMaximize--------------------------------------------------------------------------------------------------
Function TScreenSaver.IsAutoMaximize:boolean;
begin
result:=fAutoMaximize;
end;

Procedure TScreenSaver.SetAutoMaximize(value:boolean);
begin
fAutoMaximize:=value;
end;

//AutoBorderLess--------------------------------------------------------------------------------------------------
Function TScreenSaver.IsAutoBorderLess:boolean;
begin
result:=fAutoBorderLess;
end;

Procedure TScreenSaver.SetAutoBorderLess(value:boolean);
begin
fAutoBorderLess:=value;
end;

//AutoOnTop--------------------------------------------------------------------------------------------------
Function TScreenSaver.IsAutoOnTop:boolean;
begin
result:=fAutoOnTop;
end;

Procedure TScreenSaver.SetAutoOnTop(value:boolean);
begin
fAutoOnTop:=value;
end;

//ConfigBoxStyle---------------------------------------------------------------------------------------------
Function TScreenSaver.IsConfigBoxStyle:TConfigBoxStyle;
begin
result:=fConfigBoxStyle;
end;

Procedure TScreenSaver.SetConfigBoxStyle(value:TConfigBoxStyle);
begin
fConfigBoxStyle:=value;
end;

//ConfigBoxPanel---------------------------------------------------------------------------------------------
Function TScreenSaver.IsConfigBoxPanel:TPanel;
begin
Result := fConfigBoxPanel;
end;

Procedure TScreenSaver.SetConfigBoxPanel(value:TPanel);
begin
fConfigBoxPanel := Value;
end;

//ConfigBoxStyle---------------------------------------------------------------------------------------------
Function TScreenSaver.IsConfigBoxMessage:String;
begin
result:=fConfigBoxMessage;
end;

Procedure TScreenSaver.SetConfigBoxMessage(value:String);
begin
fConfigBoxMessage:=value;
end;

//SystemKeysOff----------------------------------------------------------------------------------------------
Function TScreenSaver.IsSystemKeysOff:boolean;
begin
result:=fSystemKeysOff;
end;

Procedure TScreenSaver.SetSystemKeysOff(value:boolean);
begin
fSystemKeysOff:=value;
end;

//PasswordCheckingWin95--------------------------------------------------------------------------------------
Function TScreenSaver.IsPasswordSetting:boolean;
begin
result:=fPasswordSetting;
end;

Procedure TScreenSaver.SetPasswordSetting(value:boolean);
begin
fPasswordSetting:=value;
end;

//AutoMouseCursorHide----------------------------------------------------------------------------------------
Function TScreenSaver.IsAutoMouseHide:boolean;
begin
result:=fAutoMouseHide;
end;

Procedure TScreenSaver.SetAutoMouseHide(value:boolean);
begin
fAutoMouseHide:=value;
end;

//AutoPanelHide----------------------------------------------------------------------------------------------
Function TScreenSaver.IsAutoPanelHide:boolean;
begin
result:=fAutoPanelHide;
end;

Procedure TScreenSaver.SetAutoPanelHide(value:boolean);
begin
fAutoPanelHide:=value;
end;

//OtherOperations---------------------------------------------------------------------------------------------
procedure TScreenSaver.Loaded;
var i: Integer;
PanCount: Byte;
begin
  inherited Loaded;                     // Always call inherited Loaded method

  //Test To See if Panel Exists if it doesn't then set to use MessageDlg. Stops nasty exception errors.
  PanCount := 0;
    //if not (csDesigning in ComponentState) then if fConfigBoxStyle = cbsPanel then //I had this in but realised that realy we want to test this when created as well.
    with SaverForm do
      begin
        for i := 0 to ComponentCount - 1 do
          if Components[i] is TPanel then if TPanel(Components[i]) = TPanel(fConfigBoxPanel) then inc(PanCount);
        if PanCount = 0 then
        begin
        fConfigBoxStyle := cbsMessageDlg;
        fConfigBoxPanel := nil;
        end
	else
	begin
	if fAutoPanelHide = True then TPanel(fConfigBoxPanel).Hide;
	end
      end;
  if not (csDesigning in ComponentState) then
     begin
        if fAutoEnable = True then Enable;
     end;
end;

Procedure TScreenSaver.Enable;
var PassedParam : String;
begin
  PassedParam := UpperCase(ParamStr(1));
  Delete(PassedParam, 1, 1);                       //Remove any / or -
  Delete(PassedParam, 2, Length(PassedParam));     //NT passes /c:312321 - Get NT it's much better.
  If PassedParam = 'P' then DoPreview else
     If PassedParam = 'S' then DoMainSaver else
        If PassedParam = 'A' then DoPasswordSet else
        DoConfigBox;                               //Else display the config box.
end;

//MessageHandling-------------------------------------------------------------------------------------------

procedure TScreenSaver.HookParent;
begin
if owner=nil then exit;
  OldWndProc := TFarProc(GetWindowLong(SaverForm.Handle, GWL_WNDPROC));
  NewWndProc := MakeObjectInstance(ParentMessageProcedure);
  SetWindowLong(SaverForm.Handle, GWL_WNDPROC, LongInt(NewWndProc));

end;

procedure TScreenSaver.UnhookParent;
begin
  if (owner <> NIL) and assigned(OldWndProc) then
    SetWindowLong(SaverForm.Handle, GWL_WNDPROC, LongInt(OldWndProc));
  if assigned(NewWndProc) then
    FreeObjectInstance(NewWndProc);
  NewWndProc := NIL;
  OldWndProc := NIL;
end;

procedure TScreenSaver.ParentMessageProcedure(var Message: TMessage);
begin
  if owner = NIL then exit;
  	if (message.msg = WM_SYSCOMMAND) and (message.WParam=SC_SCREENSAVE) then message.Result := 0 else message.Result := CallWindowProc(OldWndProc, SaverForm.Handle, message.Msg, message.wParam, message.lParam);
end;

//RegisterOperation-------------------------------------------------------------------------------------------
//Well, it is for Win32
procedure Register;
begin
  RegisterComponents('Win32', [TScreenSaver]);
end;

end.







