(**********************************************)
(*                                            *)
(*    Delphi TRulerPanel component v. 1.1     *)
(*             = freeware =                   *)
(*                                            *)
(*   (C) Copyright 1999, Dmitry H. Bubniewski *)
(*                                            *)
(*  e-mail: sb3@id.ru, super_bubba@mail.ru    *)
(*            ICQ # 37115452                  *)
(*                                            *)
(**********************************************)

unit SbRuler;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls;

type
  TRulerOrientation = (roLeft, roTop, roRight, roBottom);

  TRulerPanel = class(TPanel)
  private
    FOrientation: TRulerOrientation;
    FRulerLength: Integer;
    FStartOffset: Integer;
    FMouseView: Integer;
    FShape:TShape;
    FRiskVisible: Boolean;
    procedure SetOrientation(const Value: TRulerOrientation);
    procedure SetRulerLength(const Value: Integer);
    procedure SetStartOffset(const Value: Integer);
    procedure SetMouseView(const Value: Integer);
    procedure SetRiskVisible(const Value: Boolean);
  protected
    procedure Paint;override;
  public
    constructor Create(AOwner:TComponent);override;
    destructor Destroy;override;
  published
    property StartOffset:Integer read FStartOffset write SetStartOffset;
    property RulerLength:Integer read FRulerLength write SetRulerLength;
    property Orientation:TRulerOrientation read FOrientation write SetOrientation;
    property MouseView:Integer read FMouseView write SetMouseView;
    property RiskVisible:Boolean read FRiskVisible write SetRiskVisible;
  end;

procedure Register;

implementation

{$R *.RES}

procedure Register;
begin
  RegisterComponents('Additional', [TRulerPanel]);
end;

{ TRulerPanel }

constructor TRulerPanel.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  Font.Size:=6;
  Caption:=' ';
  FRulerLength:=100;
  FStartOffSet:=10;
  FOrientation:=roBottom;
  FRiskVisible:=True;
end;

destructor TRulerPanel.Destroy;
begin
  if FShape<>nil then
    FShape.Free;
  inherited Destroy;
end;

procedure TRulerPanel.Paint;
var Col, i, ConstSnap, FWidth, OffY,
    Paralax, SideParalax, Sign:Integer;
    ConstMM:Real;
    Rect:TRect;
begin
  inherited Paint;
  ConstMM:=(Screen.PixelsPerInch/25.4);
  FWidth:=Round(FRulerLength*ConstMM);
  ConstSnap:=Round(ConstMM);
  Col:=Round(FWidth/(ConstMM));
  Paralax:=0;
  FStartOffSet:=FStartOffSet+3;
  SideParalax:=0;
  if FOrientation=roTop then SideParalax:=Height;
  if FOrientation=roLeft then SideParalax:=Width;
  if SideParalax=0 then Sign:=-1 else Sign:=1;
  with Canvas do
    begin
      Rect := GetClientRect;
      Brush.Color := Color;
      FillRect(Rect);
      Brush.Style := bsClear;
      Font.Size:=6;
      Font.Color:=Pen.Color;
      Pen.Style:=psInsideFrame;
      for i:=1 to Col-1 do
        begin
          if ((i mod 10)=0) or (((i-1) mod 10)=0) then
            Inc(Paralax);
          if (i mod 5)=0 then OffY:=14 else OffY:=7;
          if (FOrientation=roBottom) or (FOrientation=roTop) then
            begin
              MoveTo(FStartOffSet+ConstSnap*i-Paralax, Height-SideParalax+Sign*OffY);
              LineTo(FStartOffSet+ConstSnap*i-Paralax, Height-SideParalax);
              if (i mod 10)=0 then
                TextOut(FStartOffSet+ConstSnap*i+2-Paralax,Height-SideParalax+Sign*21,
                        IntToStr(i div 10));
            end
          else
            begin
              MoveTo(Width-SideParalax+Sign*OffY, FStartOffSet+ConstSnap*i-Paralax);
              LineTo(Width-SideParalax, FStartOffSet+ConstSnap*i-Paralax);
              if (i mod 10)=0 then
                TextOut(Width-SideParalax+Sign*21, FStartOffSet+ConstSnap*i+2-Paralax,
                        IntToStr(i div 10));
            end;
        end;
    end;
  FStartOffSet:=FStartOffSet-3;
end;

procedure TRulerPanel.SetMouseView(const Value: Integer);
begin
  FMouseView := Value;
  if FShape=nil then
    begin
      FShape:=TShape.Create(Self);
      with FShape do
        begin
          Parent:=Self;
          Top:=0;
          Left:=FStartOffSet;
          Height:=Self.Height;
          Width:=1;
          Pen.Style:=psDot;
        end;
    end;
  if (FOrientation=roBottom) or (FOrientation=roTop) then
    begin
      FShape.Height:=Height;
      FShape.Width:=1;
      FShape.Top:=0;
      FShape.Left:=FStartOffSet+FMouseView;
    end
  else
    begin
      FShape.Height:=1;
      FShape.Width:=Width;
      FShape.Top:=FStartOffSet+FMouseView;
      FShape.Left:=0;
    end;
  if not FRiskVisible then
    begin
      FShape.Left:=-47;
      FShape.Top:=-47;
    end;
end;

procedure TRulerPanel.SetOrientation(const Value: TRulerOrientation);
begin
  FOrientation := Value;
  Paint;
  SetMouseView(FStartOffSet);
end;

procedure TRulerPanel.SetRiskVisible(const Value: Boolean);
begin
  FRiskVisible := Value;
  SetMouseView(FStartOffSet);
end;

procedure TRulerPanel.SetRulerLength(const Value: Integer);
begin
  FRulerLength := Value;
  Paint;
end;

procedure TRulerPanel.SetStartOffset(const Value: Integer);
begin
  FStartOffset := Value;
  Paint;
end;

end.
