unit _tst;

interface

uses
  Windows,Classes, Controls, Forms, StdCtrls, ComCtrls, ExtCtrls, DropWrap;

type
  TForm1 = class(TForm)
    ListView1: TListView;
    ImageList1: TImageList;
    Panel1: TPanel;
    Panel2: TPanel;
    GroupBox1: TGroupBox;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    GroupBox2: TGroupBox;
    CheckBox4: TCheckBox;
    CheckBox5: TCheckBox;
    CheckBox6: TCheckBox;
    procedure ListView1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure CheckBox2Click(Sender: TObject);
    procedure CheckBox3Click(Sender: TObject);
    procedure CheckBox4Click(Sender: TObject);
    procedure CheckBox5Click(Sender: TObject);
    procedure CheckBox6Click(Sender: TObject);
  private
    { Private declarations }
    MyWrapper  : TMyOLEDragDropInterface;
    DragedItem : TListItem;
    procedure ProcessAllowDrag(EF : TMyAllowedDropEffects; CB : TCheckBox);
    procedure ProcessAllowDrop(EF : TMyAllowedDropEffects; CB : TCheckBox);
    procedure OnDrop(DropString : string; Point : TPoint);
    procedure OnDragFinished(DropEffect : TMyDropEffect);
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.OnDrop(DropString : string; Point : TPoint);
var AListItem : TListItem;
begin
  AListItem := ListView1.Items.Add;
  AListItem.Caption := DropString;
  AListItem.SetPosition(Point);
end;

procedure TForm1.OnDragFinished(DropEffect : TMyDropEffect);
begin
  case DropEffect of
    deNone : Panel1.Caption := '  Drag cancelled';
    deCopy : Panel1.Caption := '  Item copied';
    deMove : begin
               Panel1.Caption := '  Item moved';
               DragedItem.Delete;
             end;
    deLink : Panel1.Caption := '  Item linked';
  end;
end;

procedure TForm1.ListView1MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
  if (ssLeft in Shift) and (not MyWrapper.IsInDragging) then
   begin
     Panel1.Caption := '';
     if ListView1.SelCount <> 0 then
      begin
        DragedItem := ListView1.Selected;
        MyWrapper.StartDrag(DragedItem.Caption);
      end;
   end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  MyWrapper := TMyOLEDragDropInterface.Create(Self);
end;

procedure TForm1.FormShow(Sender: TObject);
begin
  MyWrapper.DragDropControl := ListView1;
  MyWrapper.OnDrop := OnDrop;
  MyWrapper.OnDragFinished := OnDragFinished;
end;

procedure TForm1.ProcessAllowDrag(EF : TMyAllowedDropEffects; CB : TCheckBox);
begin
  if CB.Checked
   then MyWrapper.AllowedDragEffects := MyWrapper.AllowedDragEffects + EF
   else MyWrapper.AllowedDragEffects := MyWrapper.AllowedDragEffects - EF;
end;

procedure TForm1.ProcessAllowDrop(EF : TMyAllowedDropEffects; CB : TCheckBox);
begin
  if CB.Checked
   then MyWrapper.AllowedDropEffects := MyWrapper.AllowedDropEffects + EF
   else MyWrapper.AllowedDropEffects := MyWrapper.AllowedDropEffects - EF;
end;

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
  ProcessAllowDrag([deCopy], CheckBox1);
end;

procedure TForm1.CheckBox2Click(Sender: TObject);
begin
  ProcessAllowDrag([deMove], CheckBox2);
end;

procedure TForm1.CheckBox3Click(Sender: TObject);
begin
  ProcessAllowDrag([deLink], CheckBox3);
end;

procedure TForm1.CheckBox4Click(Sender: TObject);
begin
  ProcessAllowDrop([deCopy], CheckBox4);
end;

procedure TForm1.CheckBox5Click(Sender: TObject);
begin
  ProcessAllowDrop([deMove], CheckBox5);
end;

procedure TForm1.CheckBox6Click(Sender: TObject);
begin
  ProcessAllowDrop([deLink], CheckBox6);
end;

end.
