unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, RotImg, ComCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    Label4: TLabel;
    TrackBar1: TTrackBar;
    Panel2: TPanel;
    RotateImage1: TRotateImage;
    procedure TrackBar1Change(Sender: TObject);
    procedure RotateImage1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure RotateImage1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure RotateImage1MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    Dragging: Boolean;
    StartTheta: Extended;
    StartAngle: Extended;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

uses Math;

procedure TForm1.TrackBar1Change(Sender: TObject);
begin
  RotateImage1.Angle := TrackBar1.Position / 10;
  Label4.Caption := Format('Angle = %.1f', [RotateImage1.Angle]);
  Update;
end;

procedure TForm1.RotateImage1MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  Dragging := (Button = mbLeft);
  if Dragging then
  begin
    StartAngle := RotateImage1.Angle;
    if X = RotateImage1.Width / 2 then
      if Y < RotateImage1.Height / 2 then
        StartTheta := Pi / 2
      else
        StartTheta := -Pi / 2
    else
      StartTheta := ArcTan2(Y - RotateImage1.Height / 2, X - RotateImage1.Width / 2);
  end;
end;

procedure TForm1.RotateImage1MouseMove(Sender: TObject; Shift: TShiftState;
  X, Y: Integer);
var
  Theta, Angle: Extended;
begin
  if Dragging then
  begin
    if X = RotateImage1.Width / 2 then
      if Y < RotateImage1.Height / 2 then
        Theta := Pi / 2
      else
        Theta := -Pi / 2
    else
      Theta := ArcTan2(Y - RotateImage1.Height / 2, X - RotateImage1.Width / 2);
    Angle := StartAngle + 180 * (StartTheta - Theta) / Pi;
    // Use the following line to rotate the image directly
    // RotateImage1.Angle := Angle;
    // or use this one to rotate the image in TrackBar's OnChange event
    TrackBar1.Position := Trunc(Angle * 10) mod 3600;
  end;
end;

procedure TForm1.RotateImage1MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  Dragging := False;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  {$IFNDEF VER100} { Delphi 4.0 or higher }
  Panel2.DoubleBuffered := True;  // To prevent flickering
  {$ENDIF}
end;

end.
