{******************************************************************************

 ------------------- CASablanca library for MS Windows ------------------------
                            File:  main.pas
                           IMPLEMENTATIONFILE
 ==============================================================================
 first release:
 System:          Win32
 Autor:           Christian Abeln
 Copyright:       Christian Abeln, Technik & Software, abeln@compuserve.com
 Contents:        implementation
 file name:       Main.pas
 last revision:   25.09.1997
 ==============================================================================
 This unit contains the classes:

 ******************************************************************************}
unit Main;
{ $I Compiler_Settings}

{********************************* INTERFACE **********************************}
interface

uses{** standard windows units **}
     Windows,
     {** standard DELPHI units **}
     SysUtils,
     ComObj;

{********************************* INCLUDES ***********************************}

{******************************** DECLARATIONS ********************************}
procedure Run;



{********************************* IMPLEMENTATIONS ****************************}
implementation
uses
  Registry,
  ActiveX,
  ShellAPI;

type
  TRegisterMode = (regRegister, regUnregister);

const
  EOL = #13#10;

{-------------------------------------------------------------------------------
 -  MsgBox
 -------------------------------------------------------------------------------
                               PRIVATE TOOL
   Initial Release:
     24.09.1997, Christian Abeln
 -------------------------------------------------------------------------------}
procedure MsgBox (strMessage : STRING);
begin
  MessageBox (0,
              PCHAR(strMessage),
              'Warning',
              MB_ICONEXCLAMATION or MB_OK);
end;              

{-------------------------------------------------------------------------------
 -  OLERegisterDLLFile
 -------------------------------------------------------------------------------
                               PRIVATE TOOL
   Initial Release:
     29.08.1997, Christian Abeln
 -------------------------------------------------------------------------------}
function OLERegisterDLLFile (strFileName : STRING; mode : TRegisterMode) : BOOLEAN;
type
  TOleRegister = function : HResult;
var
  hLib : THandle;
  fnAdr: TFarProc;
begin
  Result := FALSE;
  hLib := LoadLibrary(PCHAR(strFileName));
  if (hLib > 0) then
  begin
    try
      if (mode = regRegister) then
        fnAdr := GetProcAddress(hLib, pchar('DllRegisterServer'))
      else
        fnAdr := GetProcAddress(hLib, pchar('DllUnregisterServer'));
      if (fnAdr <> nil) then
        Result := (TOleRegister(fnAdr) >= 0);
    finally
      FreeLibrary(hLib);
    end;
  end;
end; { RegisterDLLFile }

{-------------------------------------------------------------------------------
 -  OLERegisterTLBFile
 -------------------------------------------------------------------------------
                               PRIVATE TOOL
   Initial Release:
     29.08.1997, Christian Abeln
 -------------------------------------------------------------------------------}
function OLERegisterTLBFile (strFileName : STRING; mode : TRegisterMode) : BOOLEAN;
type
  TUnRegTlbProc = function (const libID: TGUID; wVerMajor, wVerMinor: Word;
    lcid: TLCID; syskind: TSysKind): HResult; stdcall;
var
  wstrFileName: WideString;
  wstrDocName: WideString;
  iTypeLibrary: ITypeLib;
  pLibAttr: PTLibAttr;
  hOleAutLib: THandle;
  fnUnRegTlbProc: TUnRegTlbProc;
begin
  Result := TRUE;
  try
    wstrFileName := strFileName;
    OLECheck(LoadTypeLib(PWideChar(wstrFileName), iTypeLibrary));
    OLECheck(iTypeLibrary.GetLibAttr(pLibAttr));
    try
      if (mode = regRegister) then
      begin
        OleCheck(iTypeLibrary.GetDocumentation(-1, nil, nil, nil, @wstrDocName));
        wstrDocName := ExtractFilePath(wstrDocName);
        OleCheck(RegisterTypeLib(iTypeLibrary, PWideChar(wstrFileName ),
                                               PWideChar(wstrDocName)));
      end
      else
      begin
        hOleAutLib := GetModuleHandle( 'OLEAUT32.DLL' );
        if (hOleAutLib <> 0) then
        begin
          @fnUnRegTlbProc := GetProcAddress(hOleAutLib, 'UnRegisterTypeLib');
          OleCheck(fnUnRegTlbProc(pLibAttr^.Guid,
                                  pLibAttr^.wMajorVerNum,
                                  pLibAttr^.wMinorVerNum,
                                  pLibAttr^.LCID,
                                  pLibAttr^.SysKind ));
        end;
      end;
    finally
      iTypeLibrary.ReleaseTLibAttr(pLibAttr);
    end;
  except
    Result := FALSE;
  end;
end; { OLERegisterTLBFile }

{-------------------------------------------------------------------------------
 -  OLERegisterEXEFile
 -------------------------------------------------------------------------------
                               PRIVATE TOOL
   Initial Release:
     29.08.1997, Christian Abeln
 -------------------------------------------------------------------------------}
function OLERegisterEXEFile (strFileName : STRING; mode : TRegisterMode) : BOOLEAN;
begin
  if (mode = regRegister) then
    Result := (ShellExecute(0, 'open',
                            PCHAR(strFileName),
                            '/RegServer',
                            nil, SW_SHOWNORMAL) > 32)
  else
    Result := (ShellExecute(0, 'open',
                            PCHAR(strFileName),
                            '/UnregServer',
                            nil, SW_SHOWNORMAL) > 32);
end;                            

{-------------------------------------------------------------------------------
 -  RegisterOLEFile
 -------------------------------------------------------------------------------
                               PUBLIC TOOL
   Comment:
     Registers or UnRegisters any type library (*.tlb),
     any OCX (*.ocx) or any OLE server exe.
   Parametes:
     strFileName: The file name of the executable to be registered.
     mode:        regRegister if the ole intrfaces in the file should
                  be registerd
                  regUregister if the ole intrfaces in the file should
                  be unregisterd
   Return value:
     TRUE if the registration suceeded, else FALSE.
   Initial Release:
     29.08.1997 Christian Abeln
 -------------------------------------------------------------------------------}
function RegisterOLEFile (const strFileName : STRING; mode : TRegisterMode) : BOOLEAN;
var
  strExt : STRING;
begin
  Result := FALSE;
  if (FileExists(strFileName)) then
  begin
    strExt := ExtractFileExt(strFileName);
    if (strExt <> '') then
    begin
      strExt := Copy (strExt, 2, Length(strExt));
      if (CompareText (strExt, 'OCX') = 0) or
         (CompareText (strExt, 'DLL') = 0) then
        Result := OLERegisterDLLFile (strFileName, mode)
      else
      if (CompareText (strExt, 'TLB') = 0) then
        Result := OLERegisterTLBFile (strFileName, mode)
      else
      if (CompareText (strExt, 'EXE') = 0) then
        Result := OLERegisterEXEFile (strFileName, mode)
    end;
  end;
end; { RegisterOLEFile }

{-------------------------------------------------------------------------------
 -  DoRegisterFile
 -------------------------------------------------------------------------------
                               PRIVATE TOOL
 -------------------------------------------------------------------------------}
procedure DoRegisterFile (strFileName:STRING);
var
 fSuccess : BOOLEAN;
begin
  try
    fSuccess := RegisterOLEFile (ParamStr(2), regRegister);
  except
    fSuccess := FALSE;
  end;
  if (fSuccess) then
    MsgBox (ParamStr(2) + EOL + 'successfully registered.')
  else
    MsgBox (ParamStr(2) + EOL + 'could NOT be registered.');
end;

{-------------------------------------------------------------------------------
 -  DoUnRegisterFile
 -------------------------------------------------------------------------------
                               PRIVATE TOOL
 -------------------------------------------------------------------------------}
procedure DoUnRegisterFile (strFileName:STRING);
var
 fSuccess : BOOLEAN;
begin
  try
    fSuccess := RegisterOLEFile (ParamStr(2), regUnRegister);
  except
    fSuccess := FALSE;
  end;
  if (fSuccess) then
    MsgBox (ParamStr(2) + EOL + 'successfully unregistered.')
  else
    MsgBox (ParamStr(2) + EOL + 'could NOT be unregistered.');
end;

{-------------------------------------------------------------------------------
 -  RegisterAssociation
 -------------------------------------------------------------------------------
                               PRIVATE TOOL
 -------------------------------------------------------------------------------}
procedure RegisterAssociation (strExt, strType : STRING);
var
  reg : TRegistry;
  szFileName : array[0..500] of CHAR;
begin
  reg := TRegistry.Create;
  try
    with reg do
    begin
      RootKey := HKEY_CLASSES_ROOT;
      if (OpenKey (strExt, TRUE)) then
        WriteString ('', strType);
      CloseKey;

      GetModuleFileName (0, szFileName, sizeof(szFileName));
      RootKey := HKEY_CLASSES_ROOT;
      if (OpenKey (strType, TRUE)) and
         (OpenKey ('shell', TRUE)) and
         (OpenKey ('Register',TRUE)) and
         (OpenKey ('command', TRUE)) then
        WriteString ('', '"' + STRING(szFileName) + '" /reg "%1"');
      CloseKey;
      RootKey := HKEY_CLASSES_ROOT;
      if (OpenKey (strType, TRUE)) and
         (OpenKey ('shell', TRUE)) and
         (OpenKey ('Unregister',TRUE)) and
         (OpenKey ('command', TRUE)) then
        WriteString ('', '"' + STRING(szFileName) + '" /unreg "%1"');
      CloseKey;
    end; { with reg do }
  finally
    reg.Free;
  end;
end; { RegisterAssociation }

{-------------------------------------------------------------------------------
 -  UnRegisterAssociation
 -------------------------------------------------------------------------------
                               PRIVATE TOOL
 -------------------------------------------------------------------------------}
procedure UnRegisterAssociation (strExt, strType : STRING);
var
  reg : TRegistry;
  szFileName : array[0..500] of CHAR;
begin
  reg := TRegistry.Create;
  try
    with reg do
    begin
      GetModuleFileName (0, szFileName, sizeof(szFileName));
      RootKey := HKEY_CLASSES_ROOT;
      if (OpenKey (strType, FALSE)) and
         (OpenKey ('shell', FALSE)) then
        DeleteKey ('Register');
      CloseKey;
      RootKey := HKEY_CLASSES_ROOT;
      if (OpenKey (strType, FALSE)) and
         (OpenKey ('shell', FALSE)) then
        DeleteKey ('Unregister');
      CloseKey;
    end; { with reg do }
  finally
    reg.Free;
  end;
end; { UnRegisterAssociation }

{-------------------------------------------------------------------------------
 -  RegisterKeys
 -------------------------------------------------------------------------------
                               PRIVATE TOOL
 -------------------------------------------------------------------------------}
procedure RegisterKeys;
begin
  //************************
  //* EXE file accociation *
  //* this will succeed in *
  //* admin mode only      *
  //************************
  RegisterAssociation ('.exe', 'exefile');
  RegisterAssociation ('.dll', 'dllfile');
  //************************
  //* OCX file accociation *
  //************************
  RegisterAssociation ('.ocx', 'ocxfile');
  //************************
  //* TLB file accociation *
  //************************
  RegisterAssociation ('.tlb', 'tlbfile');
end;

{-------------------------------------------------------------------------------
 -  UnRegisterKeys
 -------------------------------------------------------------------------------
                               PRIVATE TOOL
 -------------------------------------------------------------------------------}
procedure UnRegisterKeys;
begin
  //************************
  //* EXE file accociation *
  //* this will succeed in *
  //* admin mode only      *
  //************************
  UnRegisterAssociation ('.exe', 'exefile');
  UnRegisterAssociation ('.dll', 'dllfile');  
  //************************
  //* OCX file accociation *
  //************************
  UnRegisterAssociation ('.ocx', 'ocxfile');
  //************************
  //* TLB file accociation *
  //************************
  UnRegisterAssociation ('.tlb', 'tlbfile');
end;

{-------------------------------------------------------------------------------
 -  Run
 -------------------------------------------------------------------------------
                               PUBLIC TOOL
 -------------------------------------------------------------------------------}
procedure Run;
var
  fRegister : BOOLEAN;
begin
  fRegister := (ParamCount <> 1) or
               (CompareText(ParamStr(1), 'remove') <> 0);
  if (fRegister) then
    RegisterKeys
  else
    UnRegisterKeys;
    
  if (ParamCount = 2) then
  begin
    if (FileExists(ParamStr(2))) then
    begin
      if (CompareText(ParamStr(1), '/reg') = 0) then
        DoRegisterFile (ParamStr(2))
      else
      if (CompareText(ParamStr(1), '/unreg') = 0) then
        DoUnRegisterFile (ParamStr(2));
    end;
  end
  else
  begin
    if (fRegister) then
      MsgBox ('"OLE Registration Wizard"' + ' has been registered and added' + EOL +
              'items to the explorer''s context menu for the file types' + EOL +
              'ocx, tlb, dll and exe (if you have administrator privileges).')
    else
      MsgBox ('"OLE Registration Wizard"' + ' removed it''s menu items' + EOL +
              'from the explorer''s context menu.');
  end;
end; { Run }

{-------------------------------------------------------------------------------
 -   MODULE INITIALISATION
 -------------------------------------------------------------------------------}


end.
{*******************************************************************************
 ************************** end fo file MAIN.PAS *******************************
 *******************************************************************************}
