unit Unit2;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, ExtCtrls, PgSetup, Printers;

type
  TForm2 = class(TForm)
    RichEdit1: TRichEdit;
    PageSetupDialog: TPageSetupDialog;
    Panel1: TPanel;
    Button1: TButton;
    Button2: TButton;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form2: TForm2;

implementation

{$R *.DFM}

procedure TForm2.FormCreate(Sender: TObject);
begin
  RichEdit1.Lines.LoadFromFile('c:\autoexec.bat');
end;

procedure TForm2.Button1Click(Sender: TObject);
begin
  RichEdit1.Print('testing');
end;

procedure TForm2.Button2Click(Sender: TObject);

 function ThousandthsToPixels(const ARect: TRect): TRect;
 // Conversion function to convert 1/1000" to pixels
 var
   LogX, LogY: integer;
 begin
   LogX := GetDeviceCaps(Printer.Handle, LOGPIXELSX);
   LogY := GetDeviceCaps(Printer.Handle, LOGPIXELSY);
   Result.Left   := (ARect.Left * LogX div 1000) -
      GetDeviceCaps(Printer.Handle, PHYSICALOFFSETX);
   Result.Top    := ARect.Top * LogY div 1000 -
      GetDeviceCaps(Printer.Handle, PHYSICALOFFSETY);
   Result.Right  := Printer.PageWidth - (ARect.Right * LogX div 1000) +
      GetDeviceCaps(Printer.Handle, PHYSICALOFFSETX);
   Result.Bottom := Printer.PageHeight - (ARect.Bottom * LogY div 1000) +
      GetDeviceCaps(Printer.Handle, PHYSICALOFFSETY);
 end;

 function HundredthsToPixels(ARect: TRect): TRect;
 // Conversion function to convert 1/100 mm to pixels
 begin
   ARect.Left   := Round(ARect.Left / 2.54);
   ARect.Top    := Round(ARect.Top / 2.54);
   ARect.Right  := Round(ARect.Right / 2.54);
   ARect.Bottom := Round(ARect.Bottom / 2.54);
   // No system api call to get the logical pixels in a metric unit.  Have to
   // get it per inch and then convert to metric.
   Result := ThousandthsToPixels(ARect);
 end;

begin
  if PageSetupDialog.Execute then
  begin
    { Margins is the 1000ths of an inch from each edge of the paper. PageRect }
    { is the size of the printable area in pixels.  The docs say twips, but   }
    { the source code for TRichEdit.Print converts pixels...  So, we still    }
    { have to convert the Right and Bottom values since they are the distance }
    { from the edge of their respective sides of the paper, not the distance  }
    { from the other margin which gives a size }
    if PageSetupDialog.CurrentMeasurements = pmInches then
      RichEdit1.PageRect := ThousandthsToPixels(PageSetupDialog.Margins.Rect)
    else
      RichEdit1.PageRect := HundredthsToPixels(PageSetupDialog.Margins.Rect);
  end;
end;

end.
