{ Marco Cantu' (author of Master Delphi x and Delphi Developers Handbook has   }
{ released an excellent run-time object inspector tool as freeware.  It can be }
{ found in the Delphi Developers Handbook (highly recommended) and on his web  }
{ site at http://www.marcocantu.com.  If you have this installed, you can      }
{ enable the following define (remove the period) to use it in the demo.       }
{ It is for Delphi 3 only, but I think he has a beta for Delphi 2.             }
{.$DEFINE DFS_RUN_TIME_DEBUGGER}

unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  {$IFDEF DFS_RUN_TIME_DEBUGGER}
  DdhObjDb,
  {$ENDIF}
  StdCtrls, ExtCtrls, Menus, PgSetup, Printers;

type
  TForm1 = class(TForm)
    PageSetupDialog: TPageSetupDialog;
    Button1: TButton;
    Button2: TButton;
    Label1: TLabel;
    Label2: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Bevel1: TBevel;
    lblPaperSize: TLabel;
    lblOrientation: TLabel;
    lblMinMargins: TLabel;
    lblMargins: TLabel;
    Button3: TButton;
    procedure Button2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    function PageSetupDialogInitPaintPage(Sender: TObject;
      PaperSize: Smallint; PaperType: TPSPaperType;
      PaperOrientation: TPSPaperOrientation; PrinterType: TPSPrinterType;
      pSetupData: PPSDlgData): Boolean;
    function PageSetupDialogPaintPage(Sender: TObject;
      PaintWhat: TPSPaintWhat; Canvas: TCanvas; Rect: TRect): Boolean;
    procedure Button3Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

uses Unit2;


procedure TForm1.Button2Click(Sender: TObject);
begin
  Close;
end;

procedure TForm1.Button1Click(Sender: TObject);
var
  MC: string;
begin
  if PageSetupDialog.Execute then
  begin
    if PageSetupDialog.CurrentMeasurements = pmInches then
      MC := '"'
    else
      MC := 'mm';

    with PageSetupDialog do
    begin
      lblPaperSize.Caption := Format('Width = %-2.2f'+MC+'   Height = %-2.2f'+MC,
           [FromMeasurementVal(PaperSize.X), FromMeasurementVal(PaperSize.Y)]);

      lblMinMargins.Caption := Format('Left = %-2.2f'+MC+'  Right = %-2.2f' +
           MC + #13 + 'Top = %-2.2f'+MC+'  Bottom = %-2.2f'+MC,
           [FromMeasurementVal(MinimumMargins.Left),
           FromMeasurementVal(MinimumMargins.Right),
           FromMeasurementVal(MinimumMargins.Top),
           FromMeasurementVal(MinimumMargins.Bottom)]);

      lblMargins.Caption := Format('Left = %-2.2f'+MC+'  Right = %-2.2f'+MC+#13+
         'Top = %-2.2f'+MC+'  Bottom = %-2.2f'+MC,
         [FromMeasurementVal(Margins.Left), FromMeasurementVal(Margins.Right),
         FromMeasurementVal(Margins.Top), FromMeasurementVal(Margins.Bottom)]);
    end;

    // Stuff that comes from the current printer
    if Printer.Orientation = poPortrait then
      lblOrientation.Caption := 'Portrait'
    else
      lblOrientation.Caption := 'Landscape'
  end;
end;

function TForm1.PageSetupDialogInitPaintPage(Sender: TObject;
  PaperSize: Smallint; PaperType: TPSPaperType;
  PaperOrientation: TPSPaperOrientation; PrinterType: TPSPrinterType;
  pSetupData: PPSDlgData): Boolean;
begin
  // All parameters contain data describing the paper.
  // Return true to tell the dialog that we want don't want to do any drawing, i.e.
  // the OnPaintPage event will not be called and you will only get a blank paper.
  // Return false to allow OnPaintPage to be called so you can draw it.
  Result := FALSE;
end;

function TForm1.PageSetupDialogPaintPage(Sender: TObject;
  PaintWhat: TPSPaintWhat; Canvas: TCanvas; Rect: TRect): Boolean;
begin
  Result := FALSE;
  case PaintWhat of
    // The entire paper.
    pwFullPage:
      begin

        Canvas.Brush.Color := clYellow;
        with Rect do
          Canvas.Rectangle(Left, Top, Right, Bottom);
      end;

    // Thre frame of the paper
    pwMinimumMargins:
      begin
        Canvas.Pen.Color := clGreen;
        Canvas.Brush.Color := clYellow;
        with Rect do
          Canvas.Rectangle(Left, Top, Right, Bottom);
      end;

    // The margin rectangle
    pwMargins:
      begin
        Canvas.Pen.Color := clRed;
        Canvas.Pen.Style := psDot;
        Canvas.Brush.Color := clWhite;
        with Rect do
          Canvas.Rectangle(Left, Top, Right, Bottom);
      end;

    // The rectangle where sample text is drawn.
    pwGreekText:
      begin
        Canvas.Pen.Color := clRed;
        Canvas.Pen.Style := psDot;
        Canvas.Brush.Color := clWhite;
        with Rect do
          Canvas.Rectangle(Left, Top, Right, Bottom);
      end;

    // Stamp rect for envelopes.
    pwEnvStamp:
      begin
        Canvas.Pen.Color := clBlue;
        Canvas.Pen.Style := psDot;
        Canvas.Brush.Style := bsSolid;
        Canvas.Brush.Color := clRed;
        with Rect do
          Canvas.Rectangle(Left, Top, Right, Bottom);
      end;
  end;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  with TForm2.Create(Self) do
  begin
    ShowModal;
    Free;
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  {$IFDEF DFS_RUN_TIME_DEBUGGER}
  TDdhObjectDebugger.Create(Self);
  {$ENDIF}
end;


end.


