{$I DFS.INC}

unit PgSetupReg;

interface

uses
  DsgnIntf, Classes;

{$IFDEF DFS_COMPILER_3_UP}
type
  TPageSetupDialogEditor = class(TDefaultEditor)
  public
    procedure ExecuteVerb(Index : Integer); override;
    function GetVerb(Index : Integer): string; override;
    function GetVerbCount : Integer; override;
    procedure Edit; override;
  end;
{$ENDIF}

procedure Register;

implementation

uses
  PgSetup, DFSAbout;

  
{$IFDEF DFS_COMPILER_3_UP}

procedure TPageSetupDialogEditor.ExecuteVerb(Index: Integer);
begin
  if Index <> 0 then Exit; { We only have one verb, so exit if this ain't it }
  Edit;  { Invoke the Edit function the same as if double click had happened }
end;

function TPageSetupDialogEditor.GetVerb(Index: Integer): String;
begin
  Result := 'Test Dialog';  { Menu item caption for context menu }
end;

function TPageSetupDialogEditor.GetVerbCount: Integer;
begin
  Result := 1;
end;

procedure TPageSetupDialogEditor.Edit;
begin
  if Component is TPageSetupDialog then
    TPageSetupDialog(Component).Execute;
end;

{$ENDIF}


procedure Register;
begin
  RegisterComponents('DFS', [TPageSetupDialog]);
{$IFDEF DFS_COMPILER_3_UP}
  RegisterComponentEditor(TPageSetupDialog, TPageSetupDialogEditor);
{$ENDIF}
  RegisterPropertyEditor(TypeInfo(TDFSVersion), TPageSetupDialog, 'Version',
     TDFSVersionProperty);
end;

end.
