unit Main;

interface

uses
  Windows, SysUtils, Classes, Graphics, Forms, Controls, Menus,
  StdCtrls, Dialogs, Buttons, Messages, ExtCtrls, ComCtrls,
  Registry, ToolWin, PgSetup, Printers;

type
	TFindOrReplaceOption=(opNothing, opFind, opReplace);
  TMainForm = class(TForm)
    MainMenu: TMainMenu;
    File1: TMenuItem;
    FileNewItem: TMenuItem;
    FileOpenItem: TMenuItem;
    Help: TMenuItem;
    N1: TMenuItem;
    FileExitItem: TMenuItem;
    HelpAboutItem: TMenuItem;
    OpenDialog: TOpenDialog;
    FileSaveAsItem: TMenuItem;
    Edit1: TMenuItem;
    CutItem: TMenuItem;
    CopyItem: TMenuItem;
    PasteItem: TMenuItem;
    StatusBar: TStatusBar;
    SaveDialog: TSaveDialog;
    SelectAll: TMenuItem;
    Clear: TMenuItem;
    Suchen1: TMenuItem;
    Find: TMenuItem;
    Replace: TMenuItem;
    Again: TMenuItem;
    Optionen1: TMenuItem;
    Font: TMenuItem;
    Tabulator: TMenuItem;
    Color: TMenuItem;
    ColorDialog: TColorDialog;
    FontDialog: TFontDialog;
    Tools: TMenuItem;
    Grossbuchstaben: TMenuItem;
    Kleinbuchstaben: TMenuItem;
    N3: TMenuItem;
    Undo: TMenuItem;
    N4: TMenuItem;
    Konvertieren: TMenuItem;
    ANSI: TMenuItem;
    OEM: TMenuItem;
    N5: TMenuItem;
    Drucken: TMenuItem;
    N7: TMenuItem;
    Backup: TMenuItem;
    Umbruch: TMenuItem;
    N2: TMenuItem;
    N6: TMenuItem;
    Dateierweiterungen: TMenuItem;
    Tab2: TMenuItem;
    Tab4: TMenuItem;
    Tab6: TMenuItem;
    Tab8: TMenuItem;
    RichEdit: TRichEdit;
    Tab3: TMenuItem;
    ToolBar: TToolBar;
    SpeedButton11: TSpeedButton;
    SpeedButton12: TSpeedButton;
    SpeedButton13: TSpeedButton;
    Werkzeugleiste: TMenuItem;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    SpeedButton3: TSpeedButton;
    SpeedButton4: TSpeedButton;
    SpeedButton5: TSpeedButton;
    SpeedButton6: TSpeedButton;
    SpeedButton7: TSpeedButton;
    SpeedButton8: TSpeedButton;
    SpeedButton9: TSpeedButton;
    SpeedButton10: TSpeedButton;
    PageSetupDialog: TPageSetupDialog;
    procedure FormCreate(Sender: TObject);
    procedure FileNewItemClick(Sender: TObject);
    procedure FileOpenItemClick(Sender: TObject);
    procedure FileExitItemClick(Sender: TObject);
    procedure FileSaveAsItemClick(Sender: TObject);
    procedure CutItemClick(Sender: TObject);
    procedure CopyItemClick(Sender: TObject);
    procedure PasteItemClick(Sender: TObject);
    procedure HelpAboutItemClick(Sender: TObject);
    procedure SelectAllClick(Sender: TObject);
    procedure ClearClick(Sender: TObject);
    procedure FindClick(Sender: TObject);
    procedure ReplaceClick(Sender: TObject);
    procedure AgainClick(Sender: TObject);
    procedure FontClick(Sender: TObject);
    procedure ColorClick(Sender: TObject);
    procedure TabulatorClick(Sender: TObject);
    procedure GrossbuchstabenClick(Sender: TObject);
    procedure KleinbuchstabenClick(Sender: TObject);
    procedure UndoClick(Sender: TObject);
    procedure OEMClick(Sender: TObject);
    procedure ANSIClick(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure RichEditChange(Sender: TObject);
    procedure RichEditKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure RichEditMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure DruckenClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure UmbruchClick(Sender: TObject);
    procedure BackupClick(Sender: TObject);
    procedure TimerTimer(Sender: TObject);
    procedure Tab2Click(Sender: TObject);
    procedure Tab4Click(Sender: TObject);
    procedure Tab6Click(Sender: TObject);
    procedure Tab8Click(Sender: TObject);
    procedure DateierweiterungenClick(Sender: TObject);
    procedure Tab3Click(Sender: TObject);
    procedure WerkzeugleisteClick(Sender: TObject);
  private
    { Private declarations }
  	FindOrReplace: TFindOrReplaceOption;
    BackupFlag: Boolean;
    extensions: String;
    procedure ShowHint(Sender: TObject);
    procedure DoFind;
    procedure DoReplace;
    procedure Rewrite;
    function GetRow(R: TRichEdit): LongInt;
    function GetCol(R: TRichEdit): LongInt;
    procedure ShowInfo;
    function Changed: Boolean;
    function Empty: Boolean;
    procedure SaveIfChanged;
   public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

const
  IniFileName='redit';

implementation

{$R *.DFM}

uses About, Suchen, Ersetzen;

procedure TMainForm.FormCreate(Sender: TObject);
var
  IniFile: TRegIniFile;
begin
  IniFile:=TRegIniFile.Create(IniFileName);
  Application.OnHint:=ShowHint;
  FindOrReplace:=opNothing;
  Caption:='noname.txt';
  BackupFlag:=False;
  extensions:='*.txt;*.c;*.cpp;*.h;*.pas;*.bat';
  Toolbar.Hide;
  MainForm.Width:=IniFile.ReadInteger('Position', 'Width', 600);
  MainForm.Height:=IniFile.ReadInteger('Position', 'Height', 400);
  MainForm.Top:=IniFile.ReadInteger('Position', 'Top', 0);
  MainForm.Left:=IniFile.ReadInteger('Position', 'Left', 0);
  IniFile.Free;
end;

procedure TMainForm.ShowHint(Sender: TObject);
begin
  StatusBar.Panels[3].Text:=Application.Hint;
end;

procedure TMainForm.FileNewItemClick(Sender: TObject);
begin
  SaveIfChanged;
  with RichEdit do
  begin
    SelectAll;
    ClearSelection;
    Modified:=False;
    Caption:='noname.txt';
  end;
  RichEdit.SetFocus;
end;

procedure TMainForm.FileOpenItemClick(Sender: TObject);
begin
  SaveIfChanged;
  OpenDialog.Filter:='Vorgabe ('+extensions+')|'+extensions+'|Alle Dateien (*.*)|*.*';
  if OpenDialog.Execute then
  begin
    if FileExists(OpenDialog.FileName) then
    begin
      Caption:=OpenDialog.FileName;
      RichEdit.Lines.LoadFromFile(OpenDialog.FileName);
      RichEdit.Modified:=False;
    end
    else ShowMessage('Datei "'+OpenDialog.FileName+'" nicht gefunden!');
  end;
  RichEdit.SetFocus;
end;

procedure TMainForm.FileSaveAsItemClick(Sender: TObject);
var
  name: String;
  punkt: Integer;
begin
	SaveDialog.Filename:=Caption;
  SaveDialog.Filter:='Vorgabe ('+extensions+')|'+extensions+'|Alle Dateien (*.*)|*.*';
  if SaveDialog.Execute then
  begin
    if (FileExists(SaveDialog.FileName)) and (BackupFlag=True) then
    begin
      name:=SaveDialog.FileName;
      punkt:=Pos('.', name);
      if punkt>0 then name[punkt+1]:='~' else name:=name+'.~';
      CopyFile(PChar(SaveDialog.FileName), PChar(name), False);
    end;
    RichEdit.Lines.SaveToFile(SaveDialog.FileName);
    RichEdit.Modified:=False;
    Caption:=SaveDialog.FileName;
  end;
  RichEdit.SetFocus;
end;

procedure TMainForm.FileExitItemClick(Sender: TObject);
begin
  Close;
  RichEdit.SetFocus;
end;

procedure TMainForm.CutItemClick(Sender: TObject);
begin
	RichEdit.CutToClipboard;
end;

procedure TMainForm.CopyItemClick(Sender: TObject);
begin
	RichEdit.CopyToClipboard;
end;

procedure TMainForm.PasteItemClick(Sender: TObject);
begin
	RichEdit.PasteFromClipboard;
end;

procedure TMainForm.HelpAboutItemClick(Sender: TObject);
begin
  AboutBox.ShowModal;
  RichEdit.SetFocus;
end;

procedure TMainForm.SelectAllClick(Sender: TObject);
begin
	RichEdit.SelectAll;
end;

procedure TMainForm.ClearClick(Sender: TObject);
begin
	RichEdit.ClearSelection;
end;

procedure TMainForm.FindClick(Sender: TObject);
begin
  if Empty then exit;
	SuchDialog.ShowModal;
  if SuchDialog.ModalResult=mrOk then DoFind;
  RichEdit.SetFocus;
end;

procedure TMainForm.ReplaceClick(Sender: TObject);
begin
  if Empty then exit;
	ErsatzDialog.ShowModal;
  if ErsatzDialog.ModalResult=mrOK then DoReplace;
  RichEdit.SetFocus;
end;

procedure TMainForm.DoFind;
var
	FoundAt: LongInt;
  StartPos, ToEnd: Integer;
  FindOptions: TSearchTypes;
begin
	FindOrReplace:=opFind;
	with RichEdit do
  begin
  	if SelLength<>0 then StartPos:=SelStart+SelLength
    else StartPos:=0;
    ToEnd:=Length(Text)-StartPos;
		with SuchDialog do
    begin
			FindOptions:=[];
    	if Wort.Checked then FindOptions:=[stWholeWord];
    	if GrossKlein.Checked then FindOptions:=FindOptions+[stMatchCase];
		end;
    FoundAt:=FindText(SuchDialog.SuchEdit.Text, StartPos, ToEnd, FindOptions);
		if FoundAt<>-1 then
    begin
    	SetFocus;
      SelStart:=FoundAt;
      SelLength:=Length(SuchDialog.SuchEdit.Text);
    end
    else ShowMessage('"'+SuchDialog.SuchEdit.Text+'" nicht gefunden!');
  end;
end;

procedure TMainForm.DoReplace;
var
	FoundAt: LongInt;
  StartPos, ToEnd: Integer;
  FindOptions: TSearchTypes;
begin
	FindOrReplace:=opReplace;
	with RichEdit do
  begin
  	if SelLength<>0 then StartPos:=SelStart+SelLength
    else StartPos:=0;
    ToEnd:=Length(Text)-StartPos;
		with ErsatzDialog do
    begin
			FindOptions:=[];
    	if Wort.Checked then FindOptions:=[stWholeWord];
    	if GrossKlein.Checked then FindOptions:=FindOptions+[stMatchCase];
		end;
    FoundAt:=FindText(ErsatzDialog.SuchEdit.Text, StartPos, ToEnd, FindOptions);
		if FoundAt<>-1 then
    begin
    	SetFocus;
      SelStart:=FoundAt;
      SelLength:=Length(ErsatzDialog.SuchEdit.Text);
      if MessageDlg('"'+ErsatzDialog.Suchedit.Text+'" durch "'+ErsatzDialog.ErsatzEdit.Text+'" ersetzen?', mtConfirmation, [mbYes, mbNo], 0)=mrYes then SelText:=ErsatzDialog.ErsatzEdit.Text;
    end
    else ShowMessage('"'+ErsatzDialog.SuchEdit.Text+'" nicht gefunden!');
  end;
end;

procedure TMainForm.AgainClick(Sender: TObject);
begin
  if Empty then exit;
	if FindOrReplace=opFind then DoFind;
  if FindOrReplace=opReplace then DoReplace;
  RichEdit.SetFocus;
end;

procedure TMainForm.FontClick(Sender: TObject);
var
  IniFile: TRegIniFile;
  fs: TFontStyles;
begin
  IniFile:=TRegIniFile.Create(IniFileName);
  with FontDialog.Font do
  begin
    fs:=[];
    Name:=IniFile.ReadString('Font', 'Name', 'Fixedsys');
    Size:=IniFile.ReadInteger('Font', 'Size', 10);
    if IniFile.ReadBool('Font', 'Bold', False) then fs:=fs+[fsBold];
    if IniFile.ReadBool('Font', 'Italic', False) then fs:=fs+[fsItalic];
    if IniFile.ReadBool('Font', 'Underline', False) then fs:=fs+[fsUnderline];
    if IniFile.ReadBool('Font', 'StrikeOut', False) then fs:=fs+[fsStrikeOut];
    Style:=fs;
    Color:=iniFile.ReadInteger('Font', 'Color', clBlack);
  end;
  if FontDialog.Execute then
  begin
    IniFile.WriteString('Font', 'Name', FontDialog.Font.Name);
    IniFile.WriteInteger('Font', 'Size', FontDialog.Font.Size);
    if (fsBold in FontDialog.Font.Style) then IniFile.WriteBool('Font', 'Bold', True)
      else IniFile.WriteBool('Font', 'Bold', False);
    if (fsItalic in FontDialog.Font.Style) then IniFile.WriteBool('Font', 'Italic', True)
      else IniFile.WriteBool('Font', 'Italic', False);
    if (fsUnderline in FontDialog.Font.Style) then IniFile.WriteBool('Font', 'Underline', True)
      else IniFile.WriteBool('Font', 'Underline', False);
    if (fsStrikeOut in FontDialog.Font.Style) then IniFile.WriteBool('Font', 'StrikeOut', True)
      else IniFile.WriteBool('Font', 'StrikeOut', False);
    IniFile.WriteInteger('Font', 'Color', FontDialog.Font.Color);
    Rewrite;
  end;
  IniFile.Free;
  RichEdit.SetFocus;
end;

procedure TMainForm.ColorClick(Sender: TObject);
var
  IniFile: TRegIniFile;
begin
  IniFile:=TRegIniFile.Create(IniFileName);
  ColorDialog.Color:=IniFile.ReadInteger('Background Color', '', clWindow);
  if ColorDialog.Execute then
  begin
    IniFile.WriteInteger('Background Color', '', ColorDialog.Color);
    Rewrite;
  end;
  IniFile.Free;
  Richedit.SetFocus;
end;

procedure TMainForm.TabulatorClick(Sender: TObject);
var
  IniFile: TRegIniFile;
  Tabulator: Integer;
begin
  IniFile:=TRegIniFile.Create(IniFileName);
  Tabulator:=IniFile.ReadInteger('TabWidth', '', 2);
  case Tabulator of
    2: Tab2.Checked:=True;
    4: Tab4.Checked:=True;
    6: Tab6.Checked:=True;
    8: Tab8.Checked:=True;
  end;
  IniFile.Free;
  RichEdit.SetFocus;
end;

procedure TMainForm.Rewrite;
var
  IniFile: TRegIniFile;
  fs: TFontStyles;
  i, tw, Tabulator: Integer;
  flag: Boolean;
begin
  IniFile:=TRegIniFile.Create(IniFileName);
  with RichEdit do
  begin
    Visible:=False;
    SelectAll;
    fs:=[];
    with SelAttributes do
    begin
      Name:=IniFile.ReadString('Font', 'Name', 'Fixedsys');
      Size:=IniFile.ReadInteger('Font', 'Size', 10);
      if IniFile.ReadBool('Font', 'Bold', False) then fs:=fs+[fsBold];
      if IniFile.ReadBool('Font', 'Italic', False) then fs:=fs+[fsItalic];
      if IniFile.ReadBool('Font', 'Underline', False) then fs:=fs+[fsUnderline];
      if IniFile.ReadBool('Font', 'StrikeOut', False) then fs:=fs+[fsStrikeOut];
      Style:=fs;
      Color:=IniFile.ReadInteger('Font', 'Color', clBlack);
    end;
    Color:=IniFile.ReadInteger('Background Color', '', clWindow);
    Tabulator:=IniFile.ReadInteger('TabWidth', '', 2);
    BackupFlag:=IniFile.ReadBool('Backup', '', False);
    WordWrap:=IniFile.ReadBool('WordWrap', '', False);
    extensions:=IniFile.ReadString('Extensions', '', extensions);
    flag:=IniFile.ReadBool('ToolBar', '', False);
    if flag then
    begin
      ToolBar.Show;
      Werkzeugleiste.Checked:=True;
    end
    else
    begin
      ToolBar.Hide;
      Werkzeugleiste.Checked:=False;
    end;
    if BackupFlag then Backup.Checked:=True else Backup.Checked:=False;
    if WordWrap then Umbruch.Checked:=True else Umbruch.Checked:=False;
    tw:=Canvas.TextWidth('                    ');
    tw:=(tw div 10)*Tabulator;
    Paragraph.TabCount:=1000;
    for i:=1 to Paragraph.TabCount do Paragraph.Tab[i-1]:=i*tw;
    SelLength:=0;
    SelStart:=0;
    Visible:=True;
    SetFocus;
  end;
  IniFile.Free;
end;

procedure TMainForm.GrossbuchstabenClick(Sender: TObject);
var
  s: String;
begin
  with RichEdit do
  begin
    if (SelLength>0) and (MessageDlg('Markierten Text in Grobuchstaben umwandeln?', mtConfirmation, [mbYes, mbNo], 0)=mrYes) then
    begin
      s:=SelText;
      s:=AnsiUpperCase(s);
      SelText:=s;
    end;
    SetFocus;
  end;
end;

procedure TMainForm.KleinbuchstabenClick(Sender: TObject);
var
  s: String;
begin
  with RichEdit do
  begin
    if (SelLength>0) and (MessageDlg('Markierten Text in Kleinbuchstaben umwandeln?', mtConfirmation, [mbYes, mbNo], 0)=mrYes) then
    begin
     s:=SelText;
     s:=AnsiLowerCase(s);
     SelText:=s;
    end;
    SetFocus;
  end;
end;

procedure TMainForm.UndoClick(Sender: TObject);
begin
  RichEdit.Perform(EM_UNDO, 0, 0);
end;

procedure TMainForm.OEMClick(Sender: TObject);
var
  s: String;
begin
  if Empty then exit;
  with RichEdit do
  begin
    if MessageDlg('Den Text von OEM- nach ANSI-Font konvertieren?', mtConfirmation, [mbYes, mbNo], 0)=mrYes then
    begin
      s:=Text;
      OemToChar(PChar(s), PChar(s));
      Text:=s;
    end;
    SetFocus;
  end;
end;

procedure TMainForm.ANSIClick(Sender: TObject);
var
  s: String;
begin
  if Empty then exit;
  with RichEdit do
  begin
    if MessageDlg('Den Text von ANSI- nach OEM-Font konvertieren?', mtConfirmation, [mbYes, mbNo], 0)=mrYes then
    begin
      s:=Text;
      CharToOem(PChar(s), PChar(s));
      Text:=s;
    end;
    SetFocus;
  end;
end;

procedure TMainForm.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
var
  IniFile: TRegIniFile;
begin
  IniFile:=TRegIniFile.Create(IniFileName);
  CanClose:=False;
  SaveIfChanged;
  IniFile.WriteInteger('Position', 'Width', MainForm.Width);
  IniFile.WriteInteger('Position', 'Height', MainForm.Height);
  IniFile.WriteInteger('Position', 'Top', MainForm.Top);
  IniFile.WriteInteger('Position', 'Left', MainForm.Left);
  IniFile.Free;
  CanClose:=True;
end;

function TMainForm.GetRow(R: TRichEdit): LongInt;
begin
  Result:=SendMessage(R.Handle, EM_LINEFROMCHAR, R.SelStart, 0);
end;

function TMainForm.GetCol(R: TRichEdit): LongInt;
begin
  Result:=R.SelStart-SendMessage(R.Handle, EM_LINEINDEX, SendMessage(R.Handle, EM_LINEFROMCHAR, R.SelStart, 0), 0);
end;

procedure TMainForm.ShowInfo;
var
  s: String;
begin
  s:='';
  StatusBar.Panels[0].Text:=format('%d : %d', [GetRow(RichEdit)+1, GetCol(RichEdit)+1]);
  StatusBar.Panels[1].Text:=format('%d [%x]', [RichEdit.SelStart+1, RichEdit.SelStart+1]);
  if GetKeyState(VK_INSERT)=1 then s:='Insert' else s:='Overwrite';
  if GetKeyState(VK_NUMLOCK)=1 then s:=s+' Num';
  if GetKeyState(VK_CAPITAL)=1 then s:=s+' Caps';
  if RichEdit.Modified then s:=s+' Modified';
  StatusBar.Panels[3].Text:=s;
end;

procedure TMainForm.RichEditChange(Sender: TObject);
begin
  ShowInfo;
end;

procedure TMainForm.RichEditKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if (Shift=[ssCtrl, ssAlt]) then MainForm.SetFocus;
  ShowInfo;
end;

procedure TMainForm.RichEditMouseMove(Sender: TObject; Shift: TShiftState;
  X, Y: Integer);
begin
  ShowInfo;
end;

function TMainForm.Changed: Boolean;
begin
  Changed:=False;
  with RichEdit do if (Modified) and (Length(Text)>0) then Changed:=True;
end;

procedure TMainForm.SaveIfChanged;
var
  name: String;
  punkt: Integer;
begin
  if Changed then
  begin
    if MessageDlg('Der Text wurde gendert, jetzt speichern?', mtConfirmation, [mbYes, mbNo], 0)=mrYes then
    begin
    	SaveDialog.Filename:=Caption;
      if SaveDialog.Execute then
      begin
        if (FileExists(SaveDialog.FileName)) and (BackupFlag=True) then
        begin
          name:=SaveDialog.FileName;
          punkt:=Pos('.', name);
          if punkt>0 then name[punkt+1]:='~' else name:=name+'.~';
          CopyFile(PChar(SaveDialog.FileName), PChar(name), False);
        end;
        RichEdit.Lines.SaveToFile(SaveDialog.FileName);
        RichEdit.Modified:=False;
        RichEdit.SetFocus;
      end;
    end;
  end;
end;

function TMainForm.Empty: Boolean;
begin
  Empty:=True;
  if Length(RichEdit.Text)>0 then Empty:=False;
end;

procedure TMainForm.DruckenClick(Sender: TObject);

  function ThousandthsToPixels(const ARect: TRect): TRect;
  var
    LogX, LogY: Integer;
  begin
    LogX:=GetDeviceCaps(Printer.Handle, LOGPIXELSX);
    LogY:=GetDeviceCaps(Printer.Handle, LOGPIXELSY);
    Result.Left:=(ARect.Left*LogX div 1000)-GetDeviceCaps(Printer.Handle, PHYSICALOFFSETX);
    Result.Top:=(ARect.Top*LogY div 1000)-GetDeviceCaps(Printer.Handle, PHYSICALOFFSETY);
    Result.Right:=Printer.PageWidth-(ARect.Right*LogX div 1000)+GetDeviceCaps(Printer.Handle, PHYSICALOFFSETX);
    Result.Bottom:=Printer.PageHeight-(ARect.Bottom*LogY div 1000)+GetDeviceCaps(Printer.Handle, PHYSICALOFFSETY);
  end;

  function HundredthsToPixels(ARect: TRect):TRect;
  begin
    ARect.Left:=Round(ARect.Left/2.54);
    ARect.Top:=Round(ARect.Top/2.54);
    ARect.Right:=Round(ARect.Right/2.54);
    ARect.Bottom:=Round(ARect.Bottom/2.54);
    Result:=ThousandthsToPixels(ARect);
  end;

begin
  if Empty then exit;
  if PageSetupDialog.Execute then
  begin
    if PageSetupDialog.CurrentMeasurements=pmInches then
      RichEdit.PageRect:=ThousandthsToPixels(PageSetupDialog.Margins.Rect)
    else
      RichEdit.PageRect:=HundredthsToPixels(PageSetupDialog.Margins.Rect);
    RichEdit.Print(Caption);
  end;
  RichEdit.SetFocus;
end;

procedure TMainForm.FormActivate(Sender: TObject);
begin
  Rewrite;
  RichEdit.Modified:=False;
  ShowInfo;
  TimerTimer(Sender);
  if (ParamCount>0) then
    if FileExists(ParamStr(1)) then
    begin
      Caption:=ParamStr(1);
      RichEdit.Lines.LoadFromFile(ParamStr(1));
      RichEdit.Modified:=False;
    end
    else ShowMessage('Datei "'+ParamStr(1)+'" nicht gefunden!');
end;

procedure TMainForm.UmbruchClick(Sender: TObject);
var
   IniFile: TRegIniFile;
begin
  IniFile:=TRegIniFile.Create(IniFileName);
  Umbruch.Checked:= not Umbruch.Checked;
  if Umbruch.Checked then Richedit.Wordwrap:=True else RichEdit.WordWrap:=False;
  IniFile.WriteBool('WordWrap', '', RichEdit.Wordwrap);
  IniFile.Free;
end;

procedure TMainForm.BackupClick(Sender: TObject);
var
   IniFile: TRegIniFile;
begin
  IniFile:=TRegIniFile.Create(IniFileName);
  Backup.Checked:= not Backup.Checked;
  if Backup.Checked then BackupFlag:=True else BackupFlag:=False;
  IniFile.WriteBool('Backup', '', BackupFlag);
  IniFile.Free;
end;

procedure TMainForm.TimerTimer(Sender: TObject);
begin
  StatusBar.Panels[2].Text:=FormatDateTime('ddd, dd.mm.yyyy, hh:mm', Now);
end;

procedure TMainForm.Tab2Click(Sender: TObject);
var
  IniFile: TRegIniFile;
  Tabulator: Integer;
begin
  IniFile:=TRegIniFile.Create(IniFileName);
  Tab2.Checked:=True;
  Tabulator:=2;
  IniFile.WriteInteger('TabWidth', '', Tabulator);
  IniFile.Free;
  Rewrite;
end;

procedure TMainForm.Tab3Click(Sender: TObject);
var
  IniFile: TRegIniFile;
  Tabulator: Integer;
begin
  IniFile:=TRegIniFile.Create(IniFileName);
  Tab3.Checked:=True;
  Tabulator:=3;
  IniFile.WriteInteger('TabWidth', '', Tabulator);
  IniFile.Free;
  Rewrite;
end;

procedure TMainForm.Tab4Click(Sender: TObject);
var
  IniFile: TRegIniFile;
  Tabulator: Integer;
begin
  IniFile:=TRegIniFile.Create(IniFileName);
  Tab4.Checked:=True;
  Tabulator:=4;
  IniFile.WriteInteger('TabWidth', '', Tabulator);
  IniFile.Free;
  Rewrite;
end;

procedure TMainForm.Tab6Click(Sender: TObject);
var
  IniFile: TRegIniFile;
  Tabulator: Integer;
begin
  IniFile:=TRegIniFile.Create(IniFileName);
  Tab6.Checked:=True;
  Tabulator:=6;
  IniFile.WriteInteger('TabWidth', '', Tabulator);
  IniFile.Free;
  Rewrite;
end;

procedure TMainForm.Tab8Click(Sender: TObject);
var
  IniFile: TRegIniFile;
  Tabulator: Integer;
begin
  IniFile:=TRegIniFile.Create(IniFileName);
  Tab8.Checked:=True;
  Tabulator:=8;
  IniFile.WriteInteger('TabWidth', '', Tabulator);
  IniFile.Free;
  Rewrite;
end;

procedure TMainForm.DateierweiterungenClick(Sender: TObject);
var
  IniFile: TRegIniFile;
begin
  IniFile:=TRegIniFile.Create(IniFileName);
  extensions:=IniFile.ReadString('Extensions', '', extensions);
  extensions:=InputBox('Standarderweiterungen eingeben', 'Durch Semikolon trennen, z.B.: *.txt;*.c;*.h', extensions);
  IniFile.WriteString('Extensions', '', extensions);
  IniFile.Free;
end;

procedure TMainForm.WerkzeugleisteClick(Sender: TObject);
var
  IniFile: TRegIniFile;
  flag: Boolean;
begin
  IniFile:=TRegIniFile.Create(IniFileName);
  flag:=IniFile.ReadBool('ToolBar', '', False);
  if flag then
  begin
    ToolBar.Hide;
    Werkzeugleiste.Checked:=False;
  end
  else
  begin
    ToolBar.Show;
    Werkzeugleiste.Checked:=True;
  end;
  IniFile.WriteBool('ToolBar', '', not flag);
  IniFile.Free;
end;

end.

