Unit magrasapi;

Interface

Uses SysUtils, Windows ;

{ Copyright (c) 1992, Microsoft Corporation, all rights reserved
  Note: The 'dwSize' member of a structure X must be set to sizeof(X)
  before calling the associated API, otherwise ERROR_INVALID_SIZE is
  returned.  The APIs determine the size using 2-byte packing (the
  default for Microsoft compilers when no /Zp<n> option is supplied).
  Users requiring non-default packing can use the 'dwSize' values
  listed next to each 'dwSize' member in place of sizeof(X). }

{
DELPHI RAS COMPONENT - API
23rd Jan 2000, Release 4.3
(C) 1996 Daniel Polistchuck and 2000 Magenta Systems Ltd

Updated by Angus Robertson, Magenta Systems Ltd, England
in early 1998, angus@magsys.co.uk, http://www.magsys.co.uk
Copyright Magenta Systems Ltd, 2000

Compatible with Delphi 2, 3, 4 and 5 tested with Win95, 98 and NT4
Tested with Windows 95, 98, NT4 and Windows 2000/NT5

Added RasMonitorDlg (NT only)
Added .DLL since needed for NT4
Added phone book stuff
Removed explicit DLL calls so application will run without RAS installed
Added extra literals

Changes in 2.8
Changed WINVER41 to NT_EXTNS so code can be compiled under NT4 but using only
   Win9x functions and structures  (removed in 3.2)
Added RASSUBENTRY, RasGetSubEntryProperties for multi-link connections, NT only
Added various AUTODIAL things, NT only

Changes in 3.1
Added RASEntryNT, similar to RASEntry but with NT extensions non-conditionally added

Changes in 3.2
Added RasGetConnectionStatisitcs, Ras_Stats, RasClearConnectionStatistics (W2K only)

Changes in 4.0
All DLL functions loaded here, to avoid duplication in three RAS modules
Duplicates of many structures so the same calls work on 9x/NT4/W2K
Using DWORD not Longint to ease compiler range checking problems
Added Windows 2000 versions of structures, and literals from latest ras.h

Changes in 4.2
Corrected TRasPppLcpW2K from new RAS.H
Changed some VAR arguments to PCHAR to allow nil to be used
Moved TAPI device stuff to magtapiapi

Changes in 4.3
Make sure library variables cleared at start

Note - some NT functions are not yet supported
}


Const
  UNLEN = 256;
  PWLEN = 256;
  DNLEN = 15;
  NETBIOS_NAME_LEN  	= 16; // Angus
  RAS_MaxEntryName	  	=  256;
  RAS_MaxDeviceName	 	=  128;
  RAS_MaxDeviceType 	=  16;
//RAS_MaxParamKey 		=  32;
//RAS_MaxParamValue 	= 128;
  RAS_MaxPhoneNumber 	= 128;
  RAS_MaxCallbackNumber =  RAS_MaxPhoneNumber;
  RAS_MaxIpAddress 		= 15;  // ANGUS
  RAS_MaxIpxAddress 	= 21;  // ANGUS
  RAS_MaxAreaCode 		= 10;
  RAS_MaxPadType 		= 32;
  RAS_MaxX25Address 	= 200;
  RAS_MaxFacilities 	= 200;
  RAS_MaxUserData 		= 200;
  RAS_MaxReplyMessage   = 1024;

Type
//UINT = Word;
  PHRasConn = ^HRasConn;
  HRasConn = DWORD;

{ Pass this string to the RegisterWindowMessage() API to get the message
** number that will be used for notifications on the hwnd you pass to the
** RasDial() API.  WM_RASDIALEVENT is used only if a unique message cannot be
** registered. }

const
//  RASDialEvent 		= 'RASDialEvent';    // no longer used in 3.1
//  WM_RASDialEvent 	= $0CCCD;

  { Enumerates intermediate states to a Connection.  (See RasDial) }
  RASCS_Paused 		= $1000;     // =4096
  RASCS_Done		= $2000;	 // =8192

  RASBase = 600;
  Success = 0;
{ Error Codes }
  PENDING								= (RASBase+0);
  ERROR_INVALID_PORT_HANDLE				= (RASBase+1);
  ERROR_PORT_ALREADY_OPEN				= (RASBase+2);
  ERROR_BUFFER_TOO_SMALL				= (RASBase+3);
  ERROR_WRONG_INFO_SPECIFIED			= (RASBase+4);
  ERROR_CANNOT_SET_PORT_INFO			= (RASBase+5);
  ERROR_PORT_NOT_CONNECTED				= (RASBase+6);
  ERROR_EVENT_INVALID					= (RASBase+7);
  ERROR_DEVICE_DOES_NOT_EXIST			= (RASBase+8);
  ERROR_DEVICETYPE_DOES_NOT_EXIST		= (RASBase+9);
  ERROR_INVALID_BUFFER					= (RASBase+10);
  ERROR_ROUTE_NOT_AVAILABLE				= (RASBase+11);
  ERROR_ROUTE_NOT_ALLOCATED				= (RASBase+12);
  ERROR_INVALID_COMPRESSION_SPECIFIED	= (RASBase+13);
  ERROR_OUT_OF_BUFFERS					= (RASBase+14);
  ERROR_PORT_NOT_FOUND					= (RASBase+15);
  ERROR_ASYNC_REQUEST_PENDING			= (RASBase+16);
  ERROR_ALREADY_DISCONNECTING			= (RASBase+17);
  ERROR_PORT_NOT_OPEN					= (RASBase+18);
  ERROR_PORT_DISCONNECTED				= (RASBase+19);
  ERROR_NO_ENDPOINTS					= (RASBase+20);
  ERROR_CANNOT_OPEN_PHONEBOOK			= (RASBase+21);
  ERROR_CANNOT_LOAD_PHONEBOOK			= (RASBase+22);
  ERROR_CANNOT_FIND_PHONEBOOK_ENTRY		= (RASBase+23);
  ERROR_CANNOT_WRITE_PHONEBOOK			= (RASBase+24);
  ERROR_CORRUPT_PHONEBOOK				= (RASBase+25);
  ERROR_CANNOT_LOAD_STRING				= (RASBase+26);
  ERROR_KEY_NOT_FOUND					= (RASBase+27);
  ERROR_DISCONNECTION					= (RASBase+28);
  ERROR_REMOTE_DISCONNECTION			= (RASBase+29);
  ERROR_HARDWARE_FAILURE				= (RASBase+30);
  ERROR_USER_DISCONNECTION				= (RASBase+31);
  ERROR_INVALID_SIZE					= (RASBase+32);
  ERROR_PORT_NOT_AVAILABLE				= (RASBase+33);
  ERROR_CANNOT_PROJECT_CLIENT			= (RASBase+34);
  ERROR_UNKNOWN							= (RASBase+35);
  ERROR_WRONG_DEVICE_ATTACHED			= (RASBase+36);
  ERROR_BAD_STRING						= (RASBase+37);
  ERROR_REQUEST_TIMEOUT					= (RASBase+38);
  ERROR_CANNOT_GET_LANA					= (RASBase+39);
  ERROR_NETBIOS_ERROR					= (RASBase+40);
  ERROR_SERVER_OUT_OF_RESOURCES			= (RASBase+41);
  ERROR_NAME_EXISTS_ON_NET				= (RASBase+42);
  ERROR_SERVER_GENERAL_NET_FAILURE		= (RASBase+43);
  WARNING_MSG_ALIAS_NOT_ADDED			= (RASBase+44);
  ERROR_AUTH_INTERNAL					= (RASBase+45);
  ERROR_RESTRICTED_LOGON_HOURS			= (RASBase+46);
  ERROR_ACCT_DISABLED					= (RASBase+47);
  ERROR_PASSWD_EXPIRED					= (RASBase+48);
  ERROR_NO_DIALIN_PERMISSION			= (RASBase+49);
  ERROR_SERVER_NOT_RESPONDING			= (RASBase+50);
  ERROR_FROM_DEVICE						= (RASBase+51);
  ERROR_UNRECOGNIZED_RESPONSE			= (RASBase+52);
  ERROR_MACRO_NOT_FOUND					= (RASBase+53);
  ERROR_MACRO_NOT_DEFINED				= (RASBase+54);
  ERROR_MESSAGE_MACRO_NOT_FOUND			= (RASBase+55);
  ERROR_DEFAULTOFF_MACRO_NOT_FOUND		= (RASBase+56);
  ERROR_FILE_COULD_NOT_BE_OPENED		= (RASBase+57);
  ERROR_DEVICENAME_TOO_LONG				= (RASBase+58);
  ERROR_DEVICENAME_NOT_FOUND			= (RASBase+59);
  ERROR_NO_RESPONSES					= (RASBase+60);
  ERROR_NO_COMMAND_FOUND				= (RASBase+61);
  ERROR_WRONG_KEY_SPECIFIED				= (RASBase+62);
  ERROR_UNKNOWN_DEVICE_TYPE				= (RASBase+63);
  ERROR_ALLOCATING_MEMORY				= (RASBase+64);
  ERROR_PORT_NOT_CONFIGURED				= (RASBase+65);
  ERROR_DEVICE_NOT_READY				= (RASBase+66);
  ERROR_READING_INI_FILE				= (RASBase+67);
  ERROR_NO_ConnECTION					= (RASBase+68);
  ERROR_BAD_USAGE_IN_INI_FILE			= (RASBase+69);
  ERROR_READING_SECTIONNAME				= (RASBase+70);
  ERROR_READING_DEVICETYPE				= (RASBase+71);
  ERROR_READING_DEVICENAME				= (RASBase+72);
  ERROR_READING_USAGE					= (RASBase+73);
  ERROR_READING_MAXCONNECTBPS			= (RASBase+74);
  ERROR_READING_MAXCARRIERBPS			= (RASBase+75);
  ERROR_LINE_BUSY						= (RASBase+76);
  ERROR_VOICE_ANSWER					= (RASBase+77);
  ERROR_NO_ANSWER						= (RASBase+78);
  ERROR_NO_CARRIER						= (RASBase+79);
  ERROR_NO_DIALTONE						= (RASBase+80);
  ERROR_IN_COMMAND						= (RASBase+81);
  ERROR_WRITING_SECTIONNAME				= (RASBase+82);
  ERROR_WRITING_DEVICETYPE				= (RASBase+83);
  ERROR_WRITING_DEVICENAME				= (RASBase+84);
  ERROR_WRITING_MAXConnECTBPS			= (RASBase+85);
  ERROR_WRITING_MAXCARRIERBPS			= (RASBase+86);
  ERROR_WRITING_USAGE					= (RASBase+87);
  ERROR_WRITING_DEFAULTOFF				= (RASBase+88);
  ERROR_READING_DEFAULTOFF				= (RASBase+89);
  ERROR_EMPTY_INI_FILE					= (RASBase+90);
  ERROR_AUTHENTICATION_FAILURE			= (RASBase+91);
  ERROR_PORT_OR_DEVICE					= (RASBase+92);
  ERROR_NOT_BINARY_MACRO				= (RASBase+93);
  ERROR_DCB_NOT_FOUND					= (RASBase+94);
  ERROR_STATE_MACHINES_NOT_STARTED		= (RASBase+95);
  ERROR_STATE_MACHINES_ALREADY_STARTED	= (RASBase+96);
  ERROR_PARTIAL_RESPONSE_LOOPING		= (RASBase+97);
  ERROR_UNKNOWN_RESPONSE_KEY			= (RASBase+98);
  ERROR_RECV_BUF_FULL					= (RASBase+99);
  ERROR_CMD_TOO_LONG					= (RASBase+100);
  ERROR_UNSUPPORTED_BPS                 = (RASBase+101);
  ERROR_UNEXPECTED_RESPONSE             = (RASBase+102);
  ERROR_INTERACTIVE_MODE                = (RASBase+103);
  ERROR_BAD_CALLBACK_NUMBER             = (RASBase+104);
  ERROR_INVALID_AUTH_STATE              = (RASBase+105);
  ERROR_WRITING_INITBPS                 = (RASBase+106);
  ERROR_X25_DIAGNOSTIC                  = (RASBase+107);
  ERROR_ACCT_EXPIRED                    = (RASBase+108);
  ERROR_CHANGING_PASSWORD               = (RASBase+109);
  ERROR_OVERRUN                         = (RASBase+110);
  ERROR_RASMAN_CANNOT_INITIALIZE        = (RASBase+111);
  ERROR_BIPLEX_PORT_NOT_AVAILABLE       = (RASBase+112);
  ERROR_NO_ACTIVE_ISDN_LINES            = (RASBase+113);
  ERROR_NO_ISDN_CHANNELS_AVAILABLE      = (RASBase+114);
  ERROR_TOO_MANY_LINE_ERRORS            = (RASBase+115);
  ERROR_IP_CONFIGURATION                = (RASBase+116);
  ERROR_NO_IP_ADDRESSES                 = (RASBase+117);
  ERROR_PPP_TIMEOUT                     = (RASBase+118);
  ERROR_PPP_REMOTE_TERMINATED           = (RASBase+119);
  ERROR_PPP_NO_PROTOCOLS_CONFIGURED     = (RASBase+120);
  ERROR_PPP_NO_RESPONSE                 = (RASBase+121);
  ERROR_PPP_INVALID_PACKET              = (RASBase+122);
  ERROR_PHONE_NUMBER_TOO_LONG           = (RASBase+123);
  ERROR_IPXCP_NO_DIALOUT_CONFIGURED     = (RASBase+124);
  ERROR_IPXCP_NO_DIALIN_CONFIGURED      = (RASBase+125);
  ERROR_IPXCP_DIALOUT_ALREADY_ACTIVE    = (RASBase+126);
  ERROR_ACCESSING_TCPCFGDLL             = (RASBase+127);
  ERROR_NO_IP_RAS_ADAPTER               = (RASBase+128);
  ERROR_SLIP_REQUIRES_IP                = (RASBase+129);
  ERROR_PROJECTION_NOT_COMPLETE         = (RASBase+130);
  ERROR_PROTOCOL_NOT_CONFIGURED         = (RASBase+131);
  ERROR_PPP_NOT_CONVERGING              = (RASBase+132);
  ERROR_PPP_CP_REJECTED                 = (RASBase+133);
  ERROR_PPP_LCP_TERMINATED              = (RASBase+134);
  ERROR_PPP_REQUIRED_ADDRESS_REJECTED   = (RASBase+135);
  ERROR_PPP_NCP_TERMINATED              = (RASBase+136);
  ERROR_PPP_LOOPBACK_DETECTED           = (RASBase+137);
  ERROR_PPP_NO_ADDRESS_ASSIGNED         = (RASBase+138);
  ERROR_CANNOT_USE_LOGON_CREDENTIALS    = (RASBase+139);
  ERROR_TAPI_CONFIGURATION              = (RASBase+140);
  ERROR_NO_LOCAL_ENCRYPTION             = (RASBase+141);
  ERROR_NO_REMOTE_ENCRYPTION            = (RASBase+142);
  ERROR_REMOTE_REQUIRES_ENCRYPTION      = (RASBase+143);
  ERROR_IPXCP_NET_NUMBER_CONFLICT       = (RASBase+144);
  ERROR_INVALID_SMM                     = (RASBase+145);
  ERROR_SMM_UNINITIALIZED               = (RASBase+146);
  ERROR_NO_MAC_FOR_PORT                 = (RASBase+147);
  ERROR_SMM_TIMEOUT                     = (RASBase+148);
  ERROR_BAD_PHONE_NUMBER                = (RASBase+149);
  ERROR_WRONG_MODULE                    = (RASBase+150);
  ERROR_INVALID_CALLBACK_NUMBER         = (RASBase+151);
  ERROR_SCRIPT_SYNTAX                   = (RASBase+152);
  ERROR_HANGUP_FAILED                   = (RASBase+153);
  ERROR_BUNDLE_NOT_FOUND                = (RASBASE+154);  // following probably W2K
  ERROR_CANNOT_DO_CUSTOMDIAL            = (RASBASE+155);
  ERROR_DIAL_ALREADY_IN_PROGRESS        = (RASBASE+156);
  ERROR_RASAUTO_CANNOT_INITIALIZE	    = (RASBASE+157);
  ERROR_CONNECTION_ALREADY_SHARED       = (RASBASE+158);
  ERROR_SHARING_CHANGE_FAILED           = (RASBASE+159);
  ERROR_SHARING_ROUTER_INSTALL          = (RASBASE+160);
  ERROR_SHARE_CONNECTION_FAILED         = (RASBASE+161);
  ERROR_SHARING_PRIVATE_INSTALL         = (RASBASE+162);
  ERROR_CANNOT_SHARE_CONNECTION         = (RASBASE+163);
  ERROR_NO_SMART_CARD_READER            = (RASBASE+164);
  ERROR_SHARING_ADDRESS_EXISTS          = (RASBASE+165);
  ERROR_NO_CERTIFICATE                  = (RASBASE+166);
  ERROR_SHARING_MULTIPLE_ADDRESSES      = (RASBASE+167);
  ERROR_FAILED_TO_ENCRYPT               = (RASBASE+168);
  ERROR_BAD_ADDRESS_SPECIFIED           = (RASBASE+169);
  ERROR_CONNECTION_REJECT               = (RASBASE+170);
  ERROR_CONGESTION                      = (RASBASE+171);
  ERROR_INCOMPATIBLE                    = (RASBASE+172);
  ERROR_NUMBERCHANGED                   = (RASBASE+173);
  ERROR_TEMPFAILURE                     = (RASBASE+174);
  ERROR_BLOCKED                         = (RASBASE+175);
  ERROR_DONOTDISTURB                    = (RASBASE+176);
  ERROR_OUTOFORDER                      = (RASBASE+177);
  ERROR_UNABLE_TO_AUTHENTICATE_SERVER   = (RASBASE+178);
  ERROR_SMART_CARD_REQUIRED             = (RASBASE+179);
  ERROR_INVALID_FUNCTION_FOR_ENTRY      = (RASBASE+180);
  ERROR_CERT_FOR_ENCRYPTION_NOT_FOUND   = (RASBASE+181);
  RASBaseEnd                            = (RASBase+182);

Const
  	RASCS_OpenPort = 0;
  	RASCS_PortOpened = 1;
  	RASCS_ConnectDevice = 2;
  	RASCS_DeviceConnected = 3;
  	RASCS_AllDevicesConnected = 4;
  	RASCS_Authenticate = 5;
  	RASCS_AuthNotify = 6;
  	RASCS_AuthRetry = 7;
  	RASCS_AuthCallback = 8;
  	RASCS_AuthChangePassword = 9;
  	RASCS_AuthProject = 10;
  	RASCS_AuthLinkSpeed = 11;
  	RASCS_AuthAck = 12;
  	RASCS_ReAuthenticate = 13;
  	RASCS_Authenticated = 14;
  	RASCS_PrepareForCallback = 15;
  	RASCS_WaitForModemReset = 16;
  	RASCS_WaitForCallback = 17;
  	RASCS_Projected = 18;
  	RASCS_StartAuthentication = 19;   // following three are Win95 only
  	RASCS_CallbackComplete = 20;
  	RASCS_LogonNetwork = 21;
    RASCS_SubEntryConnected = 22 ;    // following are Windows NT
    RASCS_SubEntryDisconnected = 23 ;
  	RASCS_Interactive		 	= RASCS_Paused;         // $1000=4096
  	RASCS_RetryAuthentication 	= RASCS_Paused + 1;
  	RASCS_CallbackSetByCaller 	= RASCS_Paused + 2;
  	RASCS_PasswordExpired	 	= RASCS_Paused + 3;
    RASCS_InvokeEapUI 			= RASCS_Paused + 4 ;    // Windows 2000
  	RASCS_Connected	 			= RASCS_Done;           // $2000=8192
  	RASCS_DisConnected 			= RASCS_Done + 1;       // $2001=8193

Type

// Identifies an active RAS Connection, RasConnectEnum
  PRasConn = ^TRasConn;             // Windows 9x only
  TRasConn = record
	dwSize: DWORD;
	rasConn: HRasConn;
	szEntryName: Array[0..RAS_MaxEntryName] Of Char;
	szDeviceType: Array[0..RAS_MaxDeviceType] Of Char;
	szDeviceName: Array [0..RAS_MaxDeviceName] Of char;
  end;

  PRasConnNT4 = ^TRasConnNT4;       // Windows NT4
  TRasConnNT4 = record
	dwSize: DWORD;
	rasConn: HRasConn;
	szEntryName: Array[0..RAS_MaxEntryName] Of Char;
	szDeviceType: Array[0..RAS_MaxDeviceType] Of Char;
	szDeviceName: Array [0..RAS_MaxDeviceName] Of char;
    szPhonebook: Array[0..MAX_PATH - 1] Of Char;
    dwSubEntry: dword;
  end;

  PRasConnW2K = ^TRasConnW2K;        // Windows 2000
  TRasConnW2K = record
	dwSize: DWORD;
	rasConn: HRasConn;
	szEntryName: Array[0..RAS_MaxEntryName] Of Char;
	szDeviceType: Array[0..RAS_MaxDeviceType] Of Char;
	szDeviceName: Array [0..RAS_MaxDeviceName] Of char;
    szPhonebook: Array[0..MAX_PATH - 1] Of Char;
    dwSubEntry: dword;
    guidEntry: TGUID ;        // guid that represents the phone-book entry
   end;

// status of a specific RAS connection, RasGetConnectStatus
  PRasConnStatus = ^TRasConnStatus;      // Windows 9x
  TRasConnStatus = Record
	dwSize: DWORD;
	rasConnstate: Word;
	dwError: DWORD;
	szDeviceType: Array[0..RAS_MaxDeviceType] Of Char;
	szDeviceName: Array[0..RAS_MaxDeviceName] Of Char;
  End;

  PRasConnStatusNT4 = ^TRasConnStatusNT4;      // Windows NT4 and 2000
  TRasConnStatusNT4 = Record
	dwSize: DWORD;
	rasConnstate: Word;
	dwError: DWORD;
	szDeviceType: Array[0..RAS_MaxDeviceType] Of Char;
	szDeviceName: Array[0..RAS_MaxDeviceName] Of Char;
    szPhoneNumber: Array[0..RAS_MaxPhoneNumber] Of Char;
  End;

// dial params, used for both RasDial and RasGetEntryDialParams
  PRasDialParams = ^TRasDialParams;       // Windows 9x
  TRasDialParams = Record
	dwSize: DWORD;
	szEntryName: Array[0..RAS_MaxEntryName] Of Char;
	szPhoneNumber: Array[0..RAS_MaxPhoneNumber] Of Char;
	szCallbackNumber: Array[0..RAS_MaxCallbackNumber] Of Char;
	szUserName: Array[0..UNLEN] Of Char;
	szPassword: Array[0..PWLEN] Of Char;
	szDomain: Array[0..DNLEN] Of Char;
  end;

  PRasDialParamsNT4 = ^TRasDialParamsNT4;       // Windows NT4 and 2000
  TRasDialParamsNT4 = Record
	dwSize: DWORD;
	szEntryName: Array[0..RAS_MaxEntryName] Of Char;
	szPhoneNumber: Array[0..RAS_MaxPhoneNumber] Of Char;
	szCallbackNumber: Array[0..RAS_MaxCallbackNumber] Of Char;
	szUserName: Array[0..UNLEN] Of Char;
	szPassword: Array[0..PWLEN] Of Char;
	szDomain: Array[0..DNLEN] Of Char;
    dwSubEntry: DWORD;                  // index
    dwCallbackId: DWORD;                // for RasDialFunc2
  end;

// Ras{Get,Set}Credentials structure.
// These calls supercede Ras{Get,Set}EntryDialParams in NT4
  PRasCredentials = ^TRasCredentials ;      // Windows NT4 and 2000
  TRasCredentials = Record
    dwSize,
    dwMask: DWORD;
	szUserName: Array[0..UNLEN] Of Char;
	szPassword: Array[0..PWLEN] Of Char;
	szDomain: Array[0..DNLEN] Of Char;
  end ;

const
// RASCREDENTIALS 'dwMask' values.

	RASCM_UserName    = $00000001 ;
	RASCM_Password    = $00000002 ;
	RASCM_Domain      = $00000004 ;

type
// Authentification
  TRasEapInfo = Record            	              // Windows 2000
    dwSizeofEapInfo: DWORD;
    pbEapInfo: Pointer;
  	end ;

// dial extensions for RasDial
  PRasDialExtensions = ^TRasDialExtensions;     // Windows NT4
  TRasDialExtensions = Record
	dwSize: DWORD;
	dwfOptions: DWORD;
	hwndParent: HWnd;
	reserved: DWORD;
	end;

  PRasDialExtensionsW2K = ^TRasDialExtensionsW2K;     // Windows 2000
  TRasDialExtensionsW2K = Record
	dwSize: DWORD;
	dwfOptions: DWORD;
	hwndParent: HWnd;
	reserved: DWORD;
    reserved1: DWORD;
    RasEapInfo: TRasEapInfo;
	end;

const
// 'dwfOptions' bit flags in TRasDialExtensions

	RDEOPT_UsePrefixSuffix           = $00000001 ;
	RDEOPT_PausedStates              = $00000002 ;
	RDEOPT_IgnoreModemSpeaker        = $00000004 ;
	RDEOPT_SetModemSpeaker           = $00000008 ;
	RDEOPT_IgnoreSoftwareCompression = $00000010 ;
	RDEOPT_SetSoftwareCompression    = $00000020 ;
	RDEOPT_DisableConnectedUI        = $00000040 ;
	RDEOPT_DisableReconnectUI        = $00000080 ;
	RDEOPT_DisableReconnect          = $00000100 ;
	RDEOPT_NoUser                    = $00000200 ;
	RDEOPT_PauseOnScript             = $00000400 ;
	RDEOPT_Router                    = $00000800 ;
	RDEOPT_CustomDial                = $00001000 ;

// Phonebooks, aka connection entry list, for RasEnumEntries
type
  PRasEntryName = ^TRasEntryName;   // Windows 9x and NT
  TRasEntryName = Record
	dwSize: DWORD;
	szEntryName: Array[0..RAS_MaxEntryName] Of Char;
  End;

  PRasEntryNameW2K = ^TRasEntryNameW2K;   // Windows W2K only
  TRasEntryNameW2K = Record
	dwSize: DWORD;
	szEntryName: Array[0..RAS_MaxEntryName] Of Char;
    dwFlags: DWORD ; 				     // REN_Allusers or REN_User
    szPhonebookPath: Array[0..MAX_PATH - 1] Of Char;
  End;

// This flag when set in the RASENTRYNAME structure
// indicates that the phonebook to which this entry
// belongs is a system phonebook.
const
  	REN_User       = 0 ;
	REN_AllUsers   = 1 ;

// NT dialog box
type
  PRasRasMonitorDlg= ^TRasRasMonitorDlg;	// ANGUS 5Feb98
  TRasRasMonitorDlg= Record
	dwSize: DWORD ;
	hwndOwner: HWnd;
	dwFlags: DWORD ;
	dwStartPage: DWORD ;
	xDlg: DWORD ;
	yDlg: DWORD ;
	dwError: DWORD ;
	reserved: DWORD ;
	reserved2: DWORD ;
	End;

// Describes the result of a PPP NBF (NetBEUI) projection

  PRasPppNbf = ^TRasPppNbf;
  TRasPppNbf = record
	dwSize: DWORD;
	dwError: DWORD;
	dwNetBiosError: DWORD;
	szNetBiosError: Array[0..NETBIOS_NAME_LEN] of Char;
	szWorkstationName: Array[0..NETBIOS_NAME_LEN] of Char;
	bLana: Byte;
  end;


// Describes the results of a PPP IPX (Internetwork Packet Exchange)
// projection.

  PRasPppIpx = ^TRasPppIpx;
  TRasPppIpx = record
	dwSize: DWORD;
	dwError: DWORD;
	szIpxAddress: Array[0..RAS_MaxIpxAddress] of Char;
  end;

// Describes the results of a PPP IP (Internet) projection.

  PRasPppIp = ^TRasPppIp;
  TRasPppIp = record
	dwSize: DWORD;
	dwError: DWORD;
	szIpAddress: Array[0..RAS_MaxIpAddress] of Char;
	szServerIpAddress: Array[0..RAS_MaxIpAddress] of Char;
  end ;

// Describes the results of a PPP LCP/multi-link negotiation - Angus 4.0
// Note this structure is undocumented, info from ras.h file

  PRasPppLcp = ^TRasPppLcp;       // Windows 9x and NT4, probably
  TRasPppLcp = record
	dwSize: DWORD;
	fBundled: LongBool;
  end;

  PRasPppLcpW2K = ^TRasPppLcpW2K; // Windows 2000, probably
  TRasPppLcpW2K = record
	dwSize: DWORD;
	fBundled: LongBool;
    dwError,
    dwAuthenticationProtocol,
    dwAuthenticationData,
    dwEapTypeId,
    dwServerAuthenticationProtocol,
    dwServerAuthenticationData,
    dwServerEapTypeId: DWORD;
    fMultilink: LongBool;
    dwTerminateReason,
    dwServerTerminateReason: DWORD;
    szReplyMessage: array[0..RAS_MaxReplyMessage-1] of Char;
    dwOptions,
    dwServerOptions: DWORD ;
  end;

// Describes the results of a PPP CCP (Compression Control Protocol) projection.

  PTRasPppCcp = ^TRasPppCcp;
  TRasPppCcp = record
   	dwSize,
    dwError: DWORD;
    dwCompressionAlgorithm,
    dwOptions,
    dwServerCompressionAlgorithm,
    dwServerOptions: DWORD ;
  end;

// Describes the results of a SLIP (Serial Line IP) projection.

  PRasSlip = ^TRasSlip;
  TRasSlip = record
	dwSize: DWORD;
	dwError: DWORD;
	szIpAddress: Array[0..RAS_MaxIpAddress] of Char;
  end;

// Protocol code to projection data structure mapping.
const
// TRasProjection literals for RasGetProjectionInfo
  	RASP_Amb 		= $10000 ;
  	RASP_PppNbf 	= $803F ;
  	RASP_PppIpx 	= $802B ;
  	RASP_PppIp 		= $8021 ;
    RASP_PppCcp 	= $80FD ;
  	RASP_PppLcp 	= $C021 ;
  	RASP_Slip 		= $20000 ;

// RASPPPLCP 'dwAuthenticatonProtocol' values.
	RASLCPAP_PAP    = $C023 ;
	RASLCPAP_SPAP   = $C123 ;
	RASLCPAP_CHAP   = $C223 ;
	RASLCPAP_EAP    = $C227 ;

// RASPPPLCP 'dwAuthenticatonData' values.
	RASLCPAD_CHAP_MD5   = $05 ;
	RASLCPAD_CHAP_MS    = $80 ;
	RASLCPAD_CHAP_MSV2  = $81 ;

// RASPPPLCP 'dwOptions' values and 'dwServerOptions' flags.
	RASLCPO_PFC        = $00000001 ;
	RASLCPO_ACFC       = $00000002 ;
	RASLCPO_SSHF       = $00000004 ;
	RASLCPO_DES_56     = $00000008 ;
	RASLCPO_3_DES      = $00000010 ;

// RASPPPCCP 'dwCompressionAlgorithm' values.
	RASCCPCA_MPPC      = $00000006 ;
	RASCCPCA_STAC      = $00000005 ;

// RASPPPCCP 'dwOptions' values.
	RASCCPO_Compression      = $00000001 ;
	RASCCPO_HistoryLess      = $00000002 ;
	RASCCPO_Encryption56bit  = $00000010 ;
	RASCCPO_Encryption40bit  = $00000020 ;
	RASCCPO_Encryption128bit = $00000040 ;
	RAS_IPSEC_ESP_DES        = $00000080 ;
	RAS_IPSEC_ESP_DES_40     = $00000100 ;
	RAS_IPSEC_ESP_3_DES      = $00000200 ;

//Flags for RasConnectionNotification()
  	RASCN_Connection       = $00000001;
  	RASCN_Disconnection    = $00000002;
  	RASCN_BandwidthAdded   = $00000004;
  	RASCN_BandwidthRemoved = $00000008;

type
//  Information describing a RAS-capable device - ie modems or ISDN cards

  PRasDevInfo = ^TRasDevInfo;
  TRasDevInfo = record
	dwSize: DWORD;
	szDeviceType: Array[0..RAS_MaxDeviceType] of Char;
	szDeviceName: Array[0..RAS_MaxDeviceName] of Char;
  end;


// RAS Country Information (currently retreieved from TAPI).

  PRasCtryInfo = ^TRasCtryInfo;
  TRasCtryInfo = record
	dwSize,
	dwCountryID,
	dwNextCountryID,
	dwCountryCode,
	dwCountryNameOffset: DWORD;
  end;

  TRasExtCtryInfo = record             // version for RasGetCountryInfo 
   	RasCtryInfo: TRasCtryInfo ;
    buffer: array [0..255] of char ;   // returns the country name
  end ;

// A RAS IP Address.

  PRasIPAddr = ^TRasIPAddr;
  TRasIPAddr = record
	a, b, c, d: Byte;
  end;


// A RAS phonebook entry, three versions, minimum Win9x, NT4 and W2K

  PRasEntry = ^TRasEntry;
  TRasEntry = record
   	dwSize,
	dwfOptions,
	//
	// Location/phone number.
	//
	dwCountryID,
	dwCountryCode: DWORD;
	szAreaCode: array[0.. RAS_MaxAreaCode] of Char;
	szLocalPhoneNumber: array[0..RAS_MaxPhoneNumber] of Char;
	dwAlternateOffset: DWORD;
	//
// PPP/Ip
	//
	ipaddr,
	ipaddrDns,
	ipaddrDnsAlt,
	ipaddrWins,
	ipaddrWinsAlt: TRasIPAddr;
	//
	// Framing
	//
	dwFrameSize,
	dwfNetProtocols,
	dwFramingProtocol: DWORD;
	//
	// Scripting
	//
	szScript: Array[0..MAX_PATH - 1] of Char;
	//
	// AutoDial
	//
	szAutodialDll: Array [0..MAX_PATH - 1] of Char;
	szAutodialFunc: Array [0..MAX_PATH - 1] of Char;
	//
	// Device
	//
	szDeviceType: Array [0..RAS_MaxDeviceType] of Char;
	szDeviceName: Array [0..RAS_MaxDeviceName] of Char;
	//
	// X.25
	//
	szX25PadType: Array [0..RAS_MaxPadType] of Char;
	szX25Address: Array [0..RAS_MaxX25Address] of Char;
	szX25Facilities: Array [0..RAS_MaxFacilities] of Char;
	szX25UserData: Array [0..RAS_MaxUserData] of Char;
    //
    // ISDN number of B channels, only if DeviceType=isdn
    //
	dwChannels: DWORD;
	//
	// Reserved
	//
	dwReserved1,
	dwReserved2: DWORD;
	//
    end;   // followed by alternate numbers

  PRasEntryNT4 = ^TRasEntryNT4 ;    // this version fails under Win9x
  TRasEntryNT4 = record
   	dwSize,
	dwfOptions,
	//
	// Location/phone number.
	//
	dwCountryID,
	dwCountryCode: DWORD;
	szAreaCode: array[0.. RAS_MaxAreaCode] of Char;
	szLocalPhoneNumber: array[0..RAS_MaxPhoneNumber] of Char;
	dwAlternateOffset: DWORD;
	//
// PPP/Ip
	//
	ipaddr,
	ipaddrDns,
	ipaddrDnsAlt,
	ipaddrWins,
	ipaddrWinsAlt: TRasIPAddr;
	//
	// Framing
	//
	dwFrameSize,
	dwfNetProtocols,
	dwFramingProtocol: DWORD;
	//
	// Scripting
	//
	szScript: Array[0..MAX_PATH - 1] of Char;
	//
	// AutoDial
	//
	szAutodialDll: Array [0..MAX_PATH - 1] of Char;
	szAutodialFunc: Array [0..MAX_PATH - 1] of Char;
	//
	// Device
	//
	szDeviceType: Array [0..RAS_MaxDeviceType] of Char;
	szDeviceName: Array [0..RAS_MaxDeviceName] of Char;
	//
	// X.25
	//
	szX25PadType: Array [0..RAS_MaxPadType] of Char;
	szX25Address: Array [0..RAS_MaxX25Address] of Char;
	szX25Facilities: Array [0..RAS_MaxFacilities] of Char;
	szX25UserData: Array [0..RAS_MaxUserData] of Char;
    //
    // ISDN number of B channels, only if DeviceType=isdn
    //
	dwChannels: DWORD;
	//
	// Reserved
	//
	dwReserved1,
	dwReserved2: DWORD;
	//
	// Multilink
	//
	dwSubEntries,
	dwDialMode,
	dwDialExtraPercent,
	dwDialExtraSampleSeconds,
	dwHangUpExtraPercent,
	dwHangUpExtraSampleSeconds: DWORD;
	//
	// Idle timeout
	//
	dwIdleDisconnectSeconds: DWORD;
    end;    // followed by alternate numbers

  PRasEntryW2K = ^TRasEntryW2K ;    // this version fails under Win9x and NT4
  TRasEntryW2K = record
   	dwSize,
	dwfOptions,
	//
	// Location/phone number.
	//
	dwCountryID,
	dwCountryCode: DWORD;
	szAreaCode: array[0.. RAS_MaxAreaCode] of Char;
	szLocalPhoneNumber: array[0..RAS_MaxPhoneNumber] of Char;
	dwAlternateOffset: DWORD;
	//
// PPP/Ip
	//
	ipaddr,
	ipaddrDns,
	ipaddrDnsAlt,
	ipaddrWins,
	ipaddrWinsAlt: TRasIPAddr;
	//
	// Framing
	//
	dwFrameSize,
	dwfNetProtocols,
	dwFramingProtocol: DWORD;
	//
	// Scripting
	//
	szScript: Array[0..MAX_PATH - 1] of Char;
	//
	// AutoDial
	//
	szAutodialDll: Array [0..MAX_PATH - 1] of Char;
	szAutodialFunc: Array [0..MAX_PATH - 1] of Char;
	//
	// Device
	//
	szDeviceType: Array [0..RAS_MaxDeviceType] of Char;
	szDeviceName: Array [0..RAS_MaxDeviceName] of Char;
	//
	// X.25
	//
	szX25PadType: Array [0..RAS_MaxPadType] of Char;
	szX25Address: Array [0..RAS_MaxX25Address] of Char;
	szX25Facilities: Array [0..RAS_MaxFacilities] of Char;
	szX25UserData: Array [0..RAS_MaxUserData] of Char;
    //
    // ISDN number of B channels, only if DeviceType=isdn
    //
	dwChannels: DWORD;
	//
	// Reserved
	//
	dwReserved1,
	dwReserved2: DWORD;
	//
	// Multilink - NT4 and W2K
	//
	dwSubEntries,
	dwDialMode,
	dwDialExtraPercent,          // note - percent stuff only supported by W2K
	dwDialExtraSampleSeconds,
	dwHangUpExtraPercent,
	dwHangUpExtraSampleSeconds: DWORD;
	//
	// Idle timeout
	//
	dwIdleDisconnectSeconds: DWORD;
	//
    // Windows 2000 extensions
    //
    dwType,               	 	// entry type
    dwEncryptionType,      		// type of encryption to use
    dwCustomAuthKey: DWORD ;    // authentication key for EAP
    guidId: TGUID ;              // guid that represents the phone-book entry
    szCustomDialDll: Array [0..MAX_PATH - 1] of Char;  // DLL for custom dialing
    dwVpnStrategy: DWORD ;      // specifies type of VPN protocol
    end;  // followed by alternate numbers

// A RAS phone book multilinked sub-entry - NT4 and W2K

type

  LpRasSubEntryNT4 = ^TRasSubEntryNT4;
  TRasSubEntryNT4 = record
    dwSize,
    dwfFlags: DWORD;
    //
    // Device
    //
    szDeviceType: Array[0..RAS_MaxDeviceType] Of Char;
    szDeviceName: Array[0..RAS_MaxDeviceName] Of Char;
    //
    // Phone numbers
    //
    szLocalPhoneNumber: Array[0..RAS_MaxPhoneNumber] Of Char;
    dwAlternateOffset: DWORD;
  end;    // followed by alternate numbers

  PRasProjection = ^TRasProjection;
  TRasProjection = Integer;

const

// TRasEntry 'dwfOptions' bit flags.

  	RASEO_UseCountryAndAreaCodes 	= $00000001;
	RASEO_SpecificIpAddr		 	= $00000002;
  	RASEO_SpecificNameServers		= $00000004;
  	RASEO_IpHeaderCompression		= $00000008;
  	RASEO_RemoteDefaultGateway		= $00000010;
  	RASEO_DisableLcpExtensions		= $00000020;
  	RASEO_TerminalBeforeDial	 	= $00000040;
  	RASEO_TerminalAfterDial	  		= $00000080;
  	RASEO_ModemLights				= $00000100;
  	RASEO_SwCompression		  		= $00000200;
  	RASEO_RequireEncryptedPw	 	= $00000400;
  	RASEO_RequireMsEncryptedPw		= $00000800;
  	RASEO_RequireDataEncryption  	= $00001000;
  	RASEO_NetworkLogon				= $00002000;
  	RASEO_UseLogonCredentials		= $00004000;
  	RASEO_PromoteAlternates	  		= $00008000;
  	RASEO_SecureLocalFiles			= $00010000;    // NT4 and W2K
	RASEO_RequireEAP                = $00020000; 	// following W2K only
	RASEO_RequirePAP                = $00040000;
	RASEO_RequireSPAP               = $00080000;
	RASEO_Custom                    = $00100000;
	RASEO_PreviewPhoneNumber        = $00200000;
	RASEO_SharedPhoneNumbers        = $00800000;
	RASEO_PreviewUserPw             = $01000000;
	RASEO_PreviewDomain             = $02000000;
	RASEO_ShowDialingProgress       = $04000000;
	RASEO_RequireCHAP               = $08000000;
	RASEO_RequireMsCHAP             = $10000000;
	RASEO_RequireMsCHAP2            = $20000000;
	RASEO_RequireW95MSCHAP          = $40000000;

// TRasEntry 'dwfNetProtocols' bit flags. (session negotiated protocols)

  	RASNP_Netbeui 	= $00000001;  // Negotiate NetBEUI
  	RASNP_Ipx	 	= $00000002;  // Negotiate IPX
  	RASNP_Ip	  	= $00000004;  // Negotiate TCP/IP

// TRasEntry 'dwFramingProtocols' (framing protocols used by the server)

  	RASFP_Ppp  = $00000001;  // Point-to-Point Protocol (PPP)
  	RASFP_Slip = $00000002;  // Serial Line Internet Protocol (SLIP)
  	RASFP_Ras  = $00000004;  // Microsoft proprietary protocol

// TRasEntry 'szDeviceType' strings

  	RASDT_Modem		= 'modem';
  	RASDT_Isdn  	= 'isdn';
  	RASDT_X25		= 'x25';
  	RASDT_Vpn     	= 'vpn';
  	RASDT_Pad     	= 'pad';
	RASDT_Generic   = 'generic';  // following are Windows 2000 only
	RASDT_Serial    = 'serial';
	RASDT_FrameRelay= 'framerelay';
	RASDT_Atm       = 'atm';
	RASDT_Sonet     = 'sonet';
	RASDT_SW56      = 'sw56';
	RASDT_Irda      = 'irda';
    RASDT_Parallel  = 'parallel';

// TRasEntry 'dwDialMode' values.
  	RASEDM_DialAll      = 1;
  	RASEDM_DialAsNeeded = 2;

// TRasEntry 'dwIdleDisconnectSeconds' constants
  	RASIDS_Disabled       = $ffffffff;
  	RASIDS_UseGlobalValue = 0;

// The entry type used to determine which UI properties
// are to be presented to user.
	RASET_Phone    = 1 ; 	 // Phone lines: modem, ISDN, X.25, etc
	RASET_Vpn      = 2 ;  	 // Virtual private network
	RASET_Direct   = 3 ;  	 // Direct connect: serial, parallel
	RASET_Internet = 4 ;     // BaseCamp internet

// TRasEntry 'dwEncryptionType'
	ET_40Bit        = 1 ;
	ET_128Bit       = 2 ;

// ??, alternative to the above?
	ET_None         = 0 ;  // No encryption
	ET_Require      = 1 ;  // Require Encryption
	ET_RequireMax   = 2 ;  // Require max encryption
	ET_Optional     = 3 ;  // Do encryption if possible. None Ok.

// TRasEntry 'dwVnpStrategy'
	VS_Default		= 0 ;  // default (PPTP for now)
	VS_PptpOnly	    = 1	;  // Only PPTP is attempted.
	VS_PptpFirst	= 2 ;  // PPTP is tried first.
	VS_L2tpOnly 	= 3 ;  // Only L2TP is attempted.
	VS_L2tpFirst	= 4	;  // L2TP is tried first.

type

// AutoDial DLL function parameter block

  LpRasADParams = ^TRasADParams;
  TRasADParams = record
    dwSize: DWORD;
    hwndOwner: THandle;
    dwFlags: DWORD;
    xDlg,
    yDlg: DWORD;
  end;

const

// AutoDial DLL function parameter block 'dwFlags.'

  RASADFLG_PositionDlg = $00000001;

type

// AutoDial address properties

  LPRasAutoDialEntry = ^TRasAutoDialEntry;
  TRasAutoDialEntry = record
    dwSize,
    dwFlags,
    dwDialingLocation: DWORD;
    szEntry: Array[0..RAS_MaxEntryName] Of Char;
  end;


const

//  AutoDial control parameter values for
//  Ras(Get,Set)AutodialParam.

  RASADP_DisableConnectionQuery  = 0;
  RASADP_LoginSessionDisable     = 1;
  RASADP_SavedAddressesLimit     = 2;
  RASADP_FailedConnectionTimeout = 3;
  RASADP_ConnectionQueryTimeout  = 4;


// RAS statistics structure, Windows 2000/NT 5 only

type
    PTRas_Stats = ^TRas_Stats ;
	TRas_Stats = Record
    	dwSize,
    	dwBytesXmited,
    	dwBytesRcved,
    	dwFramesXmited,
    	dwFramesRcved,
    	dwCrcErr,
    	dwTimeoutErr,
    	dwAlignmentErr,
    	dwHardwareOverrunErr,
    	dwFramingErr,
    	dwBufferOverrunErr,
    	dwCompressionRatioIn,
    	dwCompressionRatioOut,
    	dwBps,
    	dwConnectDuration: DWORD ;
	end ;

// RAS functions, all loaded dynamically since some only available in certain OSs

var

RasDial: Function (
	lpRasDialExtensions : PRasDialExtensionsW2K;	// pointer to function extensions data
	lpszPhonebook: PChar;	// pointer to full path and filename of phonebook file
	lpRasDialParams : PRasDialParamsNT4;	// pointer to calling parameters data
	dwNotifierType : DWORD;	// specifies type of RasDial event handler
	lpvNotifier: Pointer;	// specifies a handler for RasDial events
	var rasConn: HRASConn 	// pointer to variable to receive connection handle
	): DWORD; stdcall;

RasEnumConnections: Function (
	RASConn: PrasConn;		{ buffer to receive Connections data }
	var BufSize: DWord;		{ size in bytes of buffer }
	var Connections: DWord	{ number of Connections written to buffer }
	): DWORD; stdcall;

RasEnumEntries: Function (
	reserved: PChar;	// reserved, must be NULL
	lpszPhonebook: PChar  ;	// pointer to full path and filename of phonebook file
	lprasentryname: PRasEntryNameW2K ;	// buffer to receive phonebook entries
	var lpcb : 	DWORD;// size in bytes of buffer
	var lpcEntries : DWORD// number of entries written to buffer
	) : DWORD; stdcall;

RasGetConnectStatus: Function (
	RASConn: hrasConn;	{ handle to Remote Access Connection of interest }
	RASConnStatus: PRASConnStatusNT4	{ buffer to receive status data }
	): DWORD; stdcall;

RasGetErrorString: Function (
	ErrorCode: DWord;	{ error code to get string for }
	szErrorString: PChar;	{ buffer to hold error string }
	BufSize: DWord	{ sizeof buffer }
	): DWORD; stdcall;

RasHangUp: Function (
	RASConn: hrasConn	{ handle to the Remote Access Connection to hang up }
	): DWORD; stdcall;

RasGetEntryDialParams: Function (		  // ANGUS
	lpszPhonebook:PChar;	// pointer to the full path and filename of the phonebook file
	var lprasdialparams: TRasDialParamsNT4;	// pointer to a structure that receives the connection parameters
	var lpfPassword : BOOL	// indicates whether the user's password was retrieved
	): DWORD; stdcall;

RasSetEntryDialParams: Function (		  // ANGUS
	lpszPhonebook:PChar;	// pointer to the full path and filename of the phonebook file
	var lprasdialparams: TRasDialParamsNT4;	// pointer to a structure that contains the connection parameters
	fRemovePassword: BOOL	// // indicates whether to remove password from entry's parameters
	): DWORD; stdcall;

RasMonitorDlg: Function (
	lpszDeviceName:PChar;	// pointer to the name of the device to display initially
	var lprasmonitordlg:TRasRasMonitorDlg	// pointer to a structure with I/O parms
	): DWORD; stdcall;

RasEditPhonebookEntry: Function (	 // ANGUS
	hWndParent : HWND;	 // handle to the parent window of the dialog box
	lpszPhonebook : PChar; // pointer to the full path and filename of the phonebook file
	lpszEntryName : PChar  // pointer to the phonebook entry name
	) : DWORD; stdcall;

RasCreatePhonebookEntry: Function (	// ANGUS
	hWndParent : HWND;	// handle to the parent window of the dialog box
	lpszPhonebook : PChar // pointer to the full path and filename of the phonebook file
	) : DWORD; stdcall;

RasGetProjectionInfo: Function (	// ANGUS
	hConn: HRasConn;
	rasproj: TRasProjection;
	lpProjection: Pointer;
	var lpcb: DWORD
	): DWORD; stdcall;

RasGetCountryInfo: Function (	// ANGUS  -  from RNAPH.DLL
	lpCtryInfo: PChar;
	var lpdwSize: DWORD
	): DWORD; stdcall;

RasGetEntryProperties: Function (	// ANGUS	 -  from RNAPH.DLL
	lpszPhonebook,
	szEntry: PChar;
	lpbEntry: PChar;              // Angus 4.11
	lpdwEntrySize: PChar;         // Angus 4.11
	lpbDeviceInfo: PChar;         // Angus 4.11
	lpdwDeviceInfoSize: PChar     // Angus 4.11
	): DWORD; stdcall;

RasSetEntryProperties: Function (	// ANGUS	-  from RNAPH.DLL
	lpszPhonebook,
	szEntry: PChar;
	lpbEntry: PChar;               // Angus 4.11
	dwEntrySize: DWORD;
	lpbDeviceInfo: PChar;          // Angus 4.11
	dwDeviceInfoSize: DWORD
	): DWORD; stdcall;

RasRenameEntry: Function (	// ANGUS		 -  from RNAPH.DLL
	lpszPhonebook,
	szEntryOld,
	szEntryNew: PChar
	): DWORD; stdcall;

RasDeleteEntry: Function (	// ANGUS		  -  from RNAPH.DLL
	lpszPhonebook,
	szEntry: PChar
	): DWORD; stdcall;

RasValidateEntryName: Function (	// ANGUS	 -  from RNAPH.DLL
	lpszPhonebook,
	szEntry: PChar
	): DWORD; stdcall;

RasEnumDevices: Function (	// ANGUS	  -  from RNAPH.DLL
	lpBuff: PRasDevInfo;
	var lpcbSize: DWORD;
	var lpcDevices: DWORD
	): DWORD; stdcall;


// following functions are NT4 only


RasGetSubEntryHandle: Function (  	// ANGUS     - NT4 only
    hrasconn: HRasConn;
    dwSubEntry: DWORD;
    var lphrasconn: HRasConn
    ): DWORD; stdcall;

RasGetCredentials: Function (  	// ANGUS     - NT4 only
    lpszPhoneBook,
    lpszEntry: PChar;
    var lpCredentials: TRasCredentials
    ): DWORD; stdcall;

RasSetCredentials: Function (  	// ANGUS     - NT4 only
    lpszPhoneBook,
    lpszEntry: PChar;
    var lpCredentials: TRasCredentials;
    fRemovePassword: LongBool
    ): DWORD; stdcall;

RasConnectionNotification: Function (  	// ANGUS     - NT4 only
  hrasconn: HRasConn;
  hEvent: THandle;
  dwFlags: DWORD
  ): DWORD; stdcall;

RasGetSubEntryProperties: Function (  	// ANGUS     - NT4 only
    lpszPhoneBook,
    lpszEntry: PChar;
    dwSubEntry: DWORD;
    lpRasSubEntry: PChar;            // Angus 4.11
    lpdwcb: PChar;                   // Angus 4.11
	lpbDeviceInfo: PChar;    		 // Angus 4.11  unused
	lpdwDeviceInfoSize: PChar        // Angus 4.11  unused
    ): DWORD; stdcall;

RasSetSubEntryProperties: Function (  	// ANGUS     - NT4 only
    lpszPhoneBook,
    lpszEntry: PChar;
    dwSubEntry: DWORD;
    lpRasSubEntry: PChar;             // Angus 4.11
    dwcb: DWORD;
	lpbDeviceInfo: PChar;             // Angus 4.11
	dwDeviceInfoSize: DWORD
    ): DWORD; stdcall;

RasGetAutodialAddress: Function (  	// ANGUS     - NT4 only
    lpszAddress: PChar;
    lpdwReserved: Pointer;
    lpAutoDialEntries: LPRasAutoDialEntry;
    var lpdwcbAutoDialEntries: DWORD;
    var lpdwcAutoDialEntries: DWORD
    ): DWORD; stdcall;

RasSetAutodialAddress: Function (  	// ANGUS     - NT4 only
    lpszAddress: PChar;
    dwReserved: DWORD;
    lpAutoDialEntries: LPRasAutoDialEntry;
    dwcbAutoDialEntries: DWORD;
    dwcAutoDialEntries: DWORD
    ): DWORD; stdcall;

RasEnumAutodialAddresses: Function (  	// ANGUS     - NT4 only
    lppAddresses: Pointer;
    var lpdwcbAddresses: DWORD;
    var lpdwAddresses: DWORD
    ): DWORD; stdcall;

RasGetAutodialEnable: Function (  	// ANGUS     - NT4 only
    dwDialingLocation: DWORD;
    var lpfEnabled: LongBool
    ): DWORD; stdcall;

RasSetAutodialEnable: Function (  	// ANGUS     - NT4 only
    dwDialingLocation: DWORD;
    fEnabled: LongBool
    ): DWORD; stdcall;

RasGetAutodialParam: Function (  	// ANGUS     - NT4 only
    dwKey: DWORD;
    lpvValue: Pointer;
    var lpdwcbValue: DWORD
    ): DWORD; stdcall;

RasSetAutodialParam: Function (  	// ANGUS     - NT4 only
    dwKey: DWORD;
    lpvValue: Pointer;
    dwcbValue: DWORD
    ): DWORD; stdcall;

// following functions are Windows 2000/NT5 only

RasGetConnectionStatistics: Function (   	// ANGUS    - W2K only
 	hrasconn: HRasConn;
  	lpStatistics: PTRas_Stats  // buffer to receive statistics
    ): DWORD; stdcall;

RasGetLinkStatistics: Function (  		 	// ANGUS    - W2K only
 	hrasconn: HRasConn;
    dwSubEntry: DWORD ;
  	lpStatistics: PTRas_Stats  // buffer to receive statistics
    ): DWORD; stdcall;

RasClearConnectionStatistics: Function (   	// ANGUS    - W2K only
  	hrasconn: HRasConn
    ): DWORD; stdcall;

RasClearLinkStatistics: Function (   	   	// ANGUS    - W2K only
  	hrasconn: HRasConn;
    dwSubEntry: DWORD 
    ): DWORD; stdcall;


const
  RASAPI_DLL = 'RASAPI32.DLL';	// Angus - WinNT needs file extension
  RNAPH_DLL  = 'RNAPH.DLL';		// Angus - functions may be in rasapi32

type
  TOSVersion = (OSW9x, OSNT4, OSW2K) ;    // Angus 4.0, getting messy to check

const
  MaxConnections = 8 ;         // number of connections monitored
  MaxPhonebooks = 100 ;        // number of phonebooks in list
  MaxDevices = 30 ;            // number of modems
  MaxCountries = 260 ;		   // number of countries
  MaxSubEntries = 4 ;          // number of subentries
  MaxWin9xDUA = 4 ;			   // number of Win9x dial-up adaptors (probably 2)
var
  MagRasLib: THandle = 0 ;
  MagRasxLib: THandle = 0 ;
  MagRasAPI_Loaded: Boolean = false ; 	// See if DLL functions are loaded
  MagRasExtn_Flag: Boolean = false ; 	// See if extensions are available
  MagRasOSVersion: TOSVersion ;    // simplified OS version - Angus 3.2

  function MagLoadRasApi: boolean ;

implementation

// Try and load various RAS DLL functions. Returns false if failed

function MagLoadRasApi: boolean ;
begin
	if MagRasAPI_Loaded then
	begin
		result := Assigned (RasDial) ;
		exit ;
	end ;

// keep OS version
	MagRasOSVersion := OSW9x ;
	if Win32Platform = VER_PLATFORM_WIN32_NT then
    begin
       	if Win32MajorVersion >= 5 then
        	MagRasOSVersion := OSW2K
		else
            MagRasOSVersion := OSNT4 ;
	end ;

// open libraries - only come here once
	result := false ;
	RasDial := Nil;
	MagRasAPI_Loaded := True ;
	MagRasExtn_Flag := false ;
	MagRasLib := LoadLibrary (RASAPI_DLL) ;
	If MagRasLib = 0 then exit ;

// set function addresses to ASCII versions in DLL
	RasDial := GetProcAddress(MagRasLib, 'RasDialA') ;
	RasEnumConnections := GetProcAddress(MagRasLib, 'RasEnumConnectionsA');
	RasEnumEntries := GetProcAddress(MagRasLib, 'RasEnumEntriesA');
	RasGetConnectStatus := GetProcAddress(MagRasLib, 'RasGetConnectStatusA');
	RasGetErrorString := GetProcAddress(MagRasLib, 'RasGetErrorStringA');
	RasHangUp := GetProcAddress(MagRasLib, 'RasHangUpA');
	RasGetEntryDialParams := GetProcAddress(MagRasLib, 'RasGetEntryDialParamsA');
	RasSetEntryDialParams := GetProcAddress(MagRasLib, 'RasSetEntryDialParamsA');
	RasMonitorDlg := GetProcAddress(MagRasLib, 'RasMonitorDlgA');
	RasEditPhonebookEntry := GetProcAddress(MagRasLib, 'RasEditPhonebookEntryA');
	RasCreatePhonebookEntry := GetProcAddress(MagRasLib, 'RasCreatePhonebookEntryA');
	RasGetProjectionInfo := GetProcAddress(MagRasLib, 'RasGetProjectionInfoA');

// Windows 98 stuff
	if (MagRasOSVersion >= OSNT4) or
			   ((MagRasOSVersion = OSW9x) and (Win32MinorVersion >= 10)) then
    begin
		RasConnectionNotification := GetProcAddress(MagRasLib, 'RasConnectionNotificationA');
	end ;

// Windows NT4 stuff (and W2K)
	if MagRasOSVersion >= OSNT4 then
    begin
		RasGetSubEntryHandle := GetProcAddress(MagRasLib, 'RasGetSubEntryHandleA');
		RasGetSubEntryProperties := GetProcAddress(MagRasLib, 'RasGetSubEntryPropertiesA');
		RasSetSubEntryProperties := GetProcAddress(MagRasLib, 'RasSetSubEntryPropertiesA');

// Windows 2000/NT5 stuff
		if MagRasOSVersion = OSW2K then
		begin
			RasGetConnectionStatistics := GetProcAddress(MagRasLib, 'RasGetConnectionStatistics');
			RasClearConnectionStatistics := GetProcAddress(MagRasLib, 'RasClearConnectionStatistics');
			RasGetLinkStatistics := GetProcAddress(MagRasLib, 'RasGetLinkStatistics');
			RasClearLinkStatistics := GetProcAddress(MagRasLib, 'RasClearLinkStatistics');
		end ;
	end ;

// now get API extensions that may be in rasapi32.dll or rnaph.dll
	MagRasxLib := MagRasLib ;
	RasGetCountryInfo := GetProcAddress(MagRasxLib, 'RasGetCountryInfoA');
	if Assigned (RasGetCountryInfo) then
		MagRasExtn_Flag := true
	else
	begin
		MagRasxLib := LoadLibrary (RNAPH_DLL) ;
		If MagRasxLib <> 0 then MagRasExtn_Flag := true ;
	end ;
	if MagRasExtn_Flag then
	begin
		RasGetCountryInfo := GetProcAddress(MagRasxLib, 'RasGetCountryInfoA');
		RasGetEntryProperties := GetProcAddress(MagRasxLib, 'RasGetEntryPropertiesA');
		RasSetEntryProperties := GetProcAddress(MagRasxLib, 'RasSetEntryPropertiesA');
		RasRenameEntry := GetProcAddress(MagRasxLib, 'RasRenameEntryA');
		RasDeleteEntry := GetProcAddress(MagRasxLib, 'RasDeleteEntryA');
		RasValidateEntryName := GetProcAddress(MagRasxLib, 'RasValidateEntryNameA');
		RasEnumDevices := GetProcAddress(MagRasxLib, 'RasEnumDevicesA');
	end ;
	result := Assigned (RasDial) ;
end ;

Initialization
	MagRasxLib := 0 ;
    MagRasLib := 0 ;
    MagRasAPI_Loaded := false ;
finalization
	if (MagRasxLib <> MagRasLib) and (MagRasxLib <> 0) then
    												FreeLibrary (MagRasxLib) ;
	if MagRasAPI_Loaded then FreeLibrary (MagRasLib) ;
end.


