unit PUtils;

interface
Uses Windows, Messages, SysUtils, Classes, Controls, Forms,
     Dialogs,stdctrls,Spin,extctrls,buttons,Consts,Graphics, Registry, MMSystem;

Type
  TResInfo = function : Word; stdcall;

function Days(Date: TDate):Word;
function WorkDays(Date: TDate; Feast:Boolean):Word;
function DateToLongStr(Date:TDate):String;
function DateTimeToLongStr(DateTime:TDateTime):String;

procedure SM(const Caption: Variant);
procedure SMError(const Caption: Variant);
procedure SMInfo(const Caption: Variant);
function MSConf(const Msg: Variant): Integer;
function InputPlus(const FormCaption, EditCaption: string;
                   var StringValue: string; Password, Number: Boolean; ResourcePic: String): Boolean;

procedure GaugeShow(FormCaption: String; Min, Max: LongInt; AutoClose: Boolean);
procedure GaugeClose;
procedure GaugeNext;

function RegWrite(Key, Name: String; Value: Variant):Boolean;
function RegRead(Key, Name: String; DefaultValue: Variant): Variant;

function GetFreeRes : Integer;

{Memo lines ...}
function MemoGetY(M:TCustomMemo):Word;
function MemoGetX(M:TCustomMemo):Word;
procedure MemoGetYX(M:TCustomMemo; var Y, X: Word);
procedure MemoSetY(M:TCustomMemo; Y: Word);
procedure MemoSetX(M:TCustomMemo; X: Word);
procedure MemoSetYX(M:TCustomMemo; Y, X: Word);
procedure MemoSelectWord(M:TCustomMemo; Rule: Boolean);

function GetWaveVolume: Integer;  {Min: 0 .. Max: 1000}
function SetWaveVolume(Volume: Integer): Boolean;

implementation
Uses Gauges;
{$R PUtils.RES}

Var PForm: TForm;
    PGauge: TGauge;
    PAutoClose: Boolean;

Const MsPassword = 'Password';
      MsPasswordCaption = 'Please enter the correct password:';

function GetWaveVolume: Integer;  {Min: 0 ; Max: 1000}
Var Left, Right, Vol: Integer;
begin
  waveOutGetVolume(0,@Vol);
  Left:=Vol and $FFFF;
  Right:=Vol shr 16;
  If Left<>Right then begin
    If Left>Right then Vol:=Left
    else Vol:=Right;
  end
  else Vol:=Left;
  Result := Round(Vol / (MaxWord/1000));
end;

function SetWaveVolume(Volume: Integer): Boolean;
Var Vol: Integer;
begin
  Result:=False;
  If Volume<=1000 then begin
    Vol:=Round(Volume * (MaxWord /1000));
    Vol:=Vol+Vol Shl 16;    {Vol:=Left+Right Shl 16;}
    Result:=waveOutSetVolume(0,Vol)=MMSYSERR_NOERROR;
  end;
end;

{Memo lines support}
function MemoGetY(M:TCustomMemo):Word;
begin
  With M do Result := SendMessage(Handle, EM_LINEFROMCHAR, SelStart, 0);
end;

function MemoGetX(M:TCustomMemo):Word;
begin
  With M do Result := SelStart - SendMessage(Handle, EM_LINEINDEX, SendMessage(Handle, EM_LINEFROMCHAR, SelStart, 0), 0);
end;

procedure MemoGetYX(M:TCustomMemo; var Y, X: Word);
begin
  With M do begin
    Y := SendMessage(Handle, EM_LINEFROMCHAR, SelStart, 0);
    X := SelStart - SendMessage(Handle, EM_LINEINDEX, Y, 0);
  end;
end;

procedure MemoSetY(M:TCustomMemo; Y: Word);
begin
  With M do SelStart :=SendMessage(Handle, EM_LINEINDEX, Y-1, 0) + MemoGetX(M);
end;

procedure MemoSetX(M:TCustomMemo; X: Word);
begin
  With M do SelStart :=SendMessage(Handle, EM_LINEINDEX, MemoGetY(M)-1, 0) + X;
end;

procedure MemoSetYX(M:TCustomMemo; Y, X: Word);
begin
  With M do SelStart :=SendMessage(Handle, EM_LINEINDEX, Y-1, 0) + X;
end;

procedure MemoSelectWord(M:TCustomMemo; Rule: Boolean);
Var Buffer: String;
    Kezdet, Veg: LongInt ;
    BeOK: Boolean;
begin
  With M do begin
    Buffer:=Text;
    Kezdet:=SelStart; Veg:=SelStart+1;
    while (Buffer[Kezdet]<>' ') and (Buffer[Kezdet]<>#0) and (Buffer[Kezdet]<>#10) do begin
      Dec(Kezdet);
    end;
    BeOK:=True;
    While (BeOK) and (Kezdet<Length(Buffer)) do begin
      while (Buffer[Veg]<>' ') and (Buffer[Veg]<>#0) and (Buffer[Veg]<>#10) do begin
        If (Buffer[Veg]='-') and (Rule)and
           ((Buffer[Veg+1]=#10) or (Buffer[Veg+1]=#13)) then begin
          if Buffer[Veg+1]=#13 then Inc(Veg,2)
          else Inc(Veg);
        end;
        Inc(Veg);
      end;
      If (Kezdet=Veg-1) then begin
        Inc(Kezdet);
        Inc(Veg);
      end
      else BeOK:=False;
    end;
    SelStart:=Kezdet;
    SelLength:=Veg-Kezdet-1;
  end;
end;

{Res monitoring}
function GetFreeRes : Integer;
Var HLib: THandle;
    FPoint: TFarProc;
    ResInfo: TResInfo;
    Ver: TOsVersionInfo;
begin
  Result:=-1;
  Ver.dwOSVersionInfoSize := SizeOf(Ver);
  GetVersionEx(Ver);
  If Ver.dwPlatformId<>VER_PLATFORM_WIN32_NT then begin
    Try
      HLib := LoadLibrary('ResMon.DLL');
      If HLib>0 then begin
        Try
          FPoint:=GetProcAddress(HLib,'ResInfo');
          If FPoint <> nil then begin
            ResInfo := TResInfo(FPoint);
            Result:=ResInfo;
          end;
        Finally
          FreeLibrary(HLib);
        end;
      end;
    Except
    End;
  end
  else Result:=100;
end;

function RegWrite(Key,Name: String; Value: Variant):Boolean;
Var Reg:TRegistry;
begin
  Reg:=TRegistry.Create;
  Result:=Reg.KeyExists(Key);
  Reg.OpenKey(Key,True);
  Case VarType(Value) of
    varSmallint, varInteger  : Reg.WriteInteger(Name,Value);
    varSingle,varDouble      : Reg.WriteFloat(Name,Value);
    varCurrency              : Reg.WriteCurrency(Name,Value);
    varDate                  : Reg.WriteDateTime(Name,Value);
    varBoolean               : Reg.WriteBool(Name,Value);
    varString                : Reg.WriteString(Name,Value);
    else begin
      IF Result=False then Reg.DeleteKey(Key);
    end;
  end;
  Reg.CloseKey;
  Reg.Free;
end;

function RegRead(Key, Name: String; DefaultValue: Variant): Variant;
Var Reg:TRegistry;
begin
  Reg:=TRegistry.Create;
  IF Reg.KeyExists(Key) then begin
    Reg.OpenKey(Key,False);
    Try
      Case VarType(DefaultValue) of
        varSmallint, varInteger  : Result := Reg.ReadInteger(Name);
        varSingle,varDouble      : Result := Reg.ReadFloat(Name);
        varCurrency              : Result := Reg.ReadCurrency(Name);
        varDate                  : Result := Reg.ReadDateTime(Name);
        varBoolean               : Result := Reg.ReadBool(Name);
        varString                : Result := Reg.ReadString(Name);
        else begin
          Result:=DefaultValue;
        end;
      end;
    Except
      Result:=DefaultValue;
    End;
    Reg.CloseKey;
  end
  else Result:=DefaultValue;
  Reg.Free;
end;

procedure GaugeShow(FormCaption: String; Min, Max: LongInt; AutoClose: Boolean);
begin
  IF PForm<>nil then Exit;
  PForm:=TForm.Create(Application);
  PGauge:=TGauge.Create(PForm);
  PGauge.Parent:=PForm;
  PAutoClose:=AutoClose;

  With PForm do begin
    Left := 247;
    Top := 290;
    BorderStyle := bsSingle;
    BorderIcons:=[];
    Caption := FormCaption;
    ClientHeight := 45;
    ClientWidth := 509;
    FormStyle := fsStayOnTop;
    Position := poScreenCenter;

  end;
  With PGauge do begin
    Left := 7;
    Top := 7;
    Width := 491;
    Height := 29;
    Font.Charset := EASTEUROPE_CHARSET;
    Font.Color := clWindowText;
    Font.Name := 'Ariel';
    Font.Size := 12;
    Font.Style := [fsBold];
    ForeColor := clRed;
    ParentFont := False;
    MinValue:=Min;
    MaxValue:=Max;
    Progress := 0;
  end;
  PForm.Show;
  PForm.Repaint;
end;

procedure GaugeNext;
begin
  IF PForm=nil then Exit;
  PGauge.Progress:=PGauge.Progress+1;
  IF (PAutoClose) and (PGauge.Progress>=PGauge.MaxValue) then GaugeClose;
end;

procedure GaugeClose;
begin
  IF PForm=nil then Exit;
  PForm.Free;
  PForm:=nil;
end;

procedure SM(const Caption: Variant);
begin
  MessageBeep(MB_ICONEXCLAMATION);
  MessageDlgPosHelp(Caption, mtWarning,[mbOK],0, -1, -1, '');
end;

procedure SMInfo(const Caption: Variant);
begin
  MessageBeep(MB_ICONASTERISK);
  MessageDlgPosHelp(Caption, mtInformation,[mbOK],0, -1, -1, '');
end;

procedure SMError(const Caption: Variant);
begin
  MessageBeep(MB_ICONHAND);
  MessageDlgPosHelp(Caption, mtError,[mbOK],0, -1, -1, '');
end;

function MSConf(const Msg: Variant): Integer;
begin
  MessageBeep(MB_ICONQUESTION);
  Result:=MessageDlgPosHelp(Msg,mtConfirmation,[mbYes,mbNo],0, -1, -1, '');
end;

{$WARNINGS OFF}
function InputPlus(const FormCaption, EditCaption: string;
                   var StringValue: string; Password, Number: Boolean; ResourcePic: String): Boolean;
var
  Form: TForm;
  Cimke: TLabel;
  Edit: TEdit;
  SEdit: TSpinEdit;
  IW: Byte;
  ETop ,EWidth ,EHeight, ELeft: Word;

begin
  Result := False;
  Form := TForm.Create(Application);
  with Form do
    try
      Canvas.Font := Font;
      Form.Color:=$0082E9FF;
      BorderStyle := bsDialog;
      If (FormCaption='') and (Password) then Caption:=msPassword
      else Caption := FormCaption;
      Cimke := TLabel.Create(Form);
      If (ResourcePic='') and (Password) then ResourcePic:='BIPLUS';
      If ResourcePic<>'' then begin
        with TImage.Create(Form) do
        begin
          IW:=45;
          Name := 'Image';
          Parent := Form;
          Picture.Bitmap.LoadFromResourceName(HInstance,ResourcePic);
          Transparent:=True;
          SetBounds(8,8,IW,40);
        end;
      end
      else begin
        IW:=0;
      end;
      with Cimke do
      begin
        Parent := Form;
        AutoSize := True;
        Left := IW+12;
        Top :=10 ;
        If (EditCaption='') and (Password) then Caption:=MsPasswordCaption
        else Caption := EditCaption;
      end;
      If (Cimke.Width>160) then ClientWidth :=Cimke.Width+25+IW
      else ClientWidth:=185+IW;
      ClientHeight := 100;
      Position := poScreenCenter;
      If Number then begin
        SEdit := TSpinEdit.Create(Form);
        with SEdit do begin
          Parent := Form;
          Left := Cimke.Left;
          Top:=Cimke.Top+Cimke.Height+4;
          If Cimke.Width>160 then SEdit.Width :=Cimke.Width
          else SEdit.Width:=160;
          MaxLength := 9;
          If StringValue <> '' then Value := StrToInt(StringValue)
          else Value := 0;
          SelectAll;
        end;
        ELeft:=SEdit.Left;
        ETop:=SEdit.Top;
        EHeight:=SEdit.Height;
        EWidth:=SEdit.Width;
      end
      else begin
        Edit := TEdit.Create(Form);
        with Edit do begin
          Parent := Form;
          Left := Cimke.Left;
          Top:=Cimke.Top+Cimke.Height+4;
          If Cimke.Width>160 then Edit.Width :=Cimke.Width
          else Edit.Width:=160;
          MaxLength := 100;
          If Password then PasswordChar:=#164;
          Edit.Text:=StringValue;
          SelectAll;
        end;
        ELeft:=Edit.Left;
        ETop:=Edit.Top;
        EHeight:=Edit.Height;
        EWidth:=Edit.Width;
      end;
      with TBitBtn.Create(Form) do
      begin
        Parent := Form;
        Kind := bkOk;
        Caption := SMsgDlgOK;
        SetBounds((ELeft+EWidth)-160, ETop+EHeight+13,75,25);
      end;
      with TBitBtn.Create(Form) do
      begin
        Parent := Form;
        Kind := bkCancel;
        Caption := SMsgDlgCancel;
        SetBounds((ELeft+EWidth)-75, ETop+EHeight+13,75,25);
      end;
      MessageBeep(MB_ICONQUESTION);
      if ShowModal = mrOk then
      begin
        If Number then begin
          If SEdit.Text<>'' then StringValue := IntToStr(SEdit.Value);
        end
        else StringValue := Edit.Text;
        Result := True;
      end;
    finally
      Form.Free;
    end;
end;
{$WARNINGS ON}

function DateToLongStr(Date:TDate):String;
Var Year, Month, Day: Word;
begin
  DecodeDate(Date,Year, Month, Day);
  Result:=IntToStr(Year)+'. '+LongMonthNames[Month]+' '+IntToStr(Day)+'.';
end;

function DateTimeToLongStr(DateTime:TDateTime):String;
begin
  Result:=DateToLongStr(DateTime)+'  '+TimeToStr(DateTime);
end;

function Days(Date: TDate):Word;
Var DayTable: PDayTable;
    Year, Month, Day:Word;
begin
  DecodeDate(Date,Year,Month,Day);
  DayTable := @MonthDays[IsLeapYear(Year)];
  Result:=DayTable^[Month];
end;

function WorkDays(Date: TDate; Feast:Boolean):Word;
Var DayTable: PDayTable;
    Year, Month, Day, X, SDay:Word;
begin
  DecodeDate(Date,Year,Month,Day);
  DayTable := @MonthDays[IsLeapYear(Year)];
  Day:=DayTable^[Month];
  SDay:=0;
  For X:=1 to Day do begin
    Case (DateTimeToTimeStamp(EncodeDate(Year,Month,X)).Date mod 7) of
      6,0: Inc(SDay);
    end;
  end;
  IF Feast then begin
    Case Month of  { This is Hungaran feast days }
      01: Inc(SDay);
      03: Inc(SDay);
      05: Inc(SDay);
      08: Inc(SDay);
      10: Inc(SDay);
      12: Inc(SDay,2);
    end;
  end;
  Result:=Day-SDay;
end;


end.
