unit psvdreg;

interface

uses
  Windows,
  Classes,
  Controls,
  psvDialogs,
  {$IFNDEF VER140}
  DsgnIntf,
  {$ELSE}
  DesignIntf,
  DesignEditors,
  {$ENDIF}
  Dialogs,
  form_about,
  Forms;

type
  TAppletFileProperty = class(TStringProperty)
  public
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
  end;

  { The About Box Property Editor }
  TpsvAboutStringProperty = class(TStringProperty)
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
    function GetValue: string; override;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Dialogs',
  [TpsvOrganizeFavoritesDialog,
   TpsvFormatDialog,
   TpsvComputerNameDialog,
   TpsvBrowseFolderDialog,
   TpsvControlPanelDialog,
   TpsvAppletDialog,
   TpsvChangeIconDialog,
   TpsvShellAboutDialog,
   TpsvRunDialog,
   TpsvObjectPropertiesDialog,
   TpsvOpenDialog,
   TpsvSaveDialog,
   TpsvNewLinkDialog,
   TpsvAddHardwareDialog,
   TpsvOpenWidthDialog,
   TpsvOutOfMemoryDialog]);
   RegisterPropertyEditor(TypeInfo(String), TpsvAppletDialog, 'AppletName', TAppletFileProperty);
   RegisterPropertyEditor(TypeInfo(String), TpsvComponent, 'About', TpsvAboutStringProperty);
end;



{property editor for TpsvAppletDialog component}
procedure TAppletFileProperty.Edit;
var
  APFileOpen: TOpenDialog;
begin
  APFileOpen := TOpenDialog.Create(Application);
  APFileOpen.Filename := GetValue;
  APFileOpen.Filter := 'Applet File (*.cpl)|*.cpl';
  APFileOpen.Options := APFileOpen.Options + [ofPathMustExist,
    ofFileMustExist];
  try
    if APFileOpen.Execute then SetValue(APFileOpen.Filename);
  finally
    APFileOpen.Free;
  end;
end;

function TAppletFileProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paDialog];
end;


function TpsvAboutStringProperty.GetAttributes: TPropertyAttributes;
begin
  { The Property Editor should show a Dialog Box and the Property itself
    is Read Only }
  Result := [paDialog, paReadOnly]
end;

function TpsvAboutStringProperty.GetValue: string;
begin
  Result := 'About...';
end;

procedure TpsvAboutStringProperty.Edit;
begin
  with TfrmAbout.Create(nil) do
  begin
    try
      ShowModal;
    finally
      Free;
    end;
  end;
end;



end.
