//==============================================
//       rutils.pas
//
//         Delphi.
//      ,   .
//
//      Copyright 1998-2000 Polaris Software
//      http://members.xoom.com/PolarisSoft
//      mailto: PolarisLib@mail.ru
//==============================================
unit rUtils;

{$I POLARIS.INC}

interface

uses Classes, Windows, SysUtils, Graphics, Forms, Consts, Registry
     {$IFDEF GIF}, RxGIF{$ENDIF}{$IFDEF JPEG}, JPEG{$ENDIF};

type
  TCharSet = set of Char;

  TrDate = record
             D,M,Y: Word;
           end;

  TBitmapResKind =
    (rkNone, rkBitmap, rkIcon, rkCursor, rkEMF, rkWMF
     {$IFDEF GIF}, rkGIF{$ENDIF}{$IFDEF JPEG}, rkJPEG{$ENDIF});

const
  DefBRK = rkBitmap;
  ResKindNames: array[TBitmapResKind] of PChar =
    ('',RT_BITMAP,RT_GROUP_ICON,RT_CURSOR,'EMF','WMF'
     {$IFDEF GIF},RT_GIF{$ENDIF}{$IFDEF JPEG},'JPEG'{$ENDIF});

  DateSeparatorFix: Char = '.';
  TimeSeparatorFix: Char = ':';
  ShortDateFormatFix = 'dd/mm/yyyy';
  ShortTimeFormatFix = 'hh:nn:ss';
  DecimalSeparatorFix: Char  = '.';

var
  RHandles: TList;

//------ 
//        . 
function AdaptedDateStr(Date: TDateTime): string;

//------ 
//      
function Stuff(S: string; Index,Count: Integer; Source: string): string;
// Convert \n and \NNN constructions into chars
function ConvertCodes(Source: string): string;
//     S
function GetDelimCount(S: String; Delim: TCharSet): Integer;
//            
//  Windows
function StrToDateFix(const S: string): TDateTime;
function StrToTimeFix(const S: string): TDateTime;
function StrToDateTimeFix(const S: string): TDateTime;
function DateToStrFix(Date: TDateTime): string;
function TimeToStrFix(Time: TDateTime): string;
function DateTimeToStrFix(DateTime: TDateTime): string;
function StrToFloatFix(const S: string): Extended;
function FloatToStrFix(Value: Extended): string;
function FormatFloatFix(const Format: string; Value: Extended): string;

//------ 
//     
function IncCycle(var Value: Integer;const Offset, MinValue, MaxValue: Integer): Integer;

//------ 
//    
function rMsgBox(Text: string; Flags: Longint): Integer;
//     
procedure RestoreWindow(Form: TForm);
//  
procedure RefreshWindow(Form: TForm);

//------ 
//     RHandles
function FindResourceInModules(var Module: THandle; const ResName, ResType: PChar): HRSRC;
//   
procedure CorrectResName(var ResName: string);
//    
function RLoadPicture(RHandle: THandle; ResName: string; ResKind: TBitmapResKind): THANDLE;
//        
procedure LoadBitmapFromResource(Bitmap: TBitmap; RHandle: THandle;
                                 ResName: string; ResKind: TBitmapResKind);

//------ 
//  
function RegReadValue(Reg: TRegistry; Name: string; Default: string {$IFDEF POLARIS_D4}= ''{$ENDIF}): string;
{$IFDEF POLARIS_D4}overload;
function RegReadValue(Reg: TRegistry; Name: string; Default: Integer = 0): Integer; overload;
function RegReadValue(Reg: TRegistry; Name: string; Default: Extended = 0): Extended; overload;
function RegReadValue(Reg: TRegistry; Name: string; Default: TDateTime = 0): TDateTime; overload;
{$ENDIF}

//------  
//   Windows
function GetOSUser: string;

implementation

var
  oldSep1, oldSep2: Char;
  oldFormat1, oldFormat2: String;

function AdaptedDateStr(Date: TDateTime): string;
var
  DMY: TrDate;
  newFmt,strMon: string;
begin
  with DMY do begin
    {     }
    DecodeDate(Date,Y,M,D);
    strMon := AnsiLowerCase(LongMonthNames[M]);
    if strMon[Length(strMon)] in ['',''] then
      strMon := Stuff(strMon,Length(strMon),1,'')
    else strMon := strMon+'';
    {   }
    newFmt := LongDateFormat;
    repeat
      D := Pos('MMMM',UpperCase(newFmt));
      if D = 0 then Break;
      newFmt := Stuff(newFmt,D,4,'"'+strMon+'"');
    until D=0;
  end;
  Result := FormatDateTime(newFmt,Date)
end;

function Stuff(S: string; Index,Count: Integer; Source: string): string;
begin
  Result := S;
  Delete(Result,Index,Count);
  Insert(Source,Result,Index);
end;

function ConvertCodes(Source: string): string;
var
  i,j,l: Integer;
begin
  i := 0;
  l := Length(Source);
  Result := '';
  while i < l do begin
    j := Pos('\',Copy(Source,i+1,l))+i;
    if j=i then begin
      Result := Result+Copy(Source,i+1,l);
      break;
    end else begin
      Result := Result+Copy(Source,i+1,j-i-1);
      case Source[j+1] of
        '\': begin
               Result := Result+'\';
               i := j+1;
             end;
        'n': begin
               Result := Result+#13#10;
               i := j+1;
             end;
        'r': begin
               Result := Result+#13;
               i := j+1;
             end;
        '0'..'9': begin
                    i := j;
                    while (j < l) and (Source[j+1] in ['0'..'9']) do Inc(j);
                    Result := Result+Chr(StrToInt(Copy(Source,i+1,j-i)));
                    i := j;
                  end
        else begin
          Result := Result+'\';
          i := j;
        end;
      end;
    end;
  end;
end;

function GetDelimCount(S: String; Delim: TCharSet): Integer;
var
  I: Integer;
begin
  Result := 0;
  if Length(S) > 0 then
    for I := 1 to Length(S) do
      if S[I] in Delim then Inc(Result);
end;

function StrToDateFix(const S: string): TDateTime;
begin
  oldSep1 := DateSeparator;
  oldFormat1 := ShortDateFormat;
  DateSeparator := DateSeparatorFix;
  ShortDateFormat := ShortDateFormatFix;
  Result := StrToDate(S);
  DateSeparator := oldSep1;
  ShortDateFormat := oldFormat1;
end;

function StrToTimeFix(const S: string): TDateTime;
begin
  oldSep1 := TimeSeparator;
  oldFormat1 := ShortTimeFormat;
  TimeSeparator := TimeSeparatorFix;
  ShortTimeFormat := ShortTimeFormatFix;
  Result := StrToTime(S);
  TimeSeparator := oldSep1;
  ShortTimeFormat := oldFormat1;
end;

function StrToDateTimeFix(const S: string): TDateTime;
begin
  oldSep1 := DateSeparator;
  oldFormat1 := ShortDateFormat;
  oldSep2 := TimeSeparator;
  oldFormat2 := ShortTimeFormat;
  DateSeparator := DateSeparatorFix;
  ShortDateFormat := ShortDateFormatFix;
  TimeSeparator := TimeSeparatorFix;
  ShortTimeFormat := ShortTimeFormatFix;
  Result := StrToDateTime(S);
  DateSeparator := oldSep1;
  ShortDateFormat := oldFormat1;
  TimeSeparator := oldSep2;
  ShortTimeFormat := oldFormat2;
end;

function DateToStrFix(Date: TDateTime): string;
begin
  oldSep1 := DateSeparator;
  oldFormat1 := ShortDateFormat;
  DateSeparator := DateSeparatorFix;
  ShortDateFormat := ShortDateFormatFix;
  Result := DateToStr(Date);
  DateSeparator := oldSep1;
  ShortDateFormat := oldFormat1;
end;

function TimeToStrFix(Time: TDateTime): string;
begin
  oldSep1 := TimeSeparator;
  oldFormat1 := ShortTimeFormat;
  TimeSeparator := TimeSeparatorFix;
  ShortTimeFormat := ShortTimeFormatFix;
  Result := TimeToStr(Time);
  TimeSeparator := oldSep1;
  ShortTimeFormat := oldFormat1;
end;

function DateTimeToStrFix(DateTime: TDateTime): string;
begin
  oldSep1 := DateSeparator;
  oldFormat1 := ShortDateFormat;
  oldSep2 := TimeSeparator;
  oldFormat2 := ShortTimeFormat;
  DateSeparator := DateSeparatorFix;
  ShortDateFormat := ShortDateFormatFix;
  TimeSeparator := TimeSeparatorFix;
  ShortTimeFormat := ShortTimeFormatFix;
  Result := DateTimeToStr(DateTime);
  DateSeparator := oldSep1;
  ShortDateFormat := oldFormat1;
  TimeSeparator := oldSep2;
  ShortTimeFormat := oldFormat2;
end;

function StrToFloatFix(const S: string): Extended;
begin
  oldSep1 := DecimalSeparator;
  DecimalSeparator  := DecimalSeparatorFix;
  Result := StrToFloat(S);
  DecimalSeparator  := oldSep1;
end;

function FloatToStrFix(Value: Extended): string;
begin
  oldSep1 := DecimalSeparator;
  DecimalSeparator  := DecimalSeparatorFix;
  Result := FloatToStr(Value);
  DecimalSeparator  := oldSep1;
end;

function FormatFloatFix(const Format: string; Value: Extended): string;
begin
  oldSep1 := DecimalSeparator;
  DecimalSeparator  := DecimalSeparatorFix;
  Result := FormatFloat(Format,Value);
  DecimalSeparator  := oldSep1;
end;

function IncCycle(var Value: Integer;const Offset, MinValue, MaxValue: Integer): Integer;
var
  Offs: Integer;
begin
  Result := 0;
  Offs := Offset;
  repeat
    Inc(Value,Offs);
    if Value > MaxValue then begin
      Inc(Result);
      Offs := Value-MaxValue;
      Value := MinValue-1;
    end else
      if Value < MinValue then begin
        Dec(Result);
        Offs := Value-MinValue;
        Value := MaxValue+1;
      end;
  until (Value>=MinValue) and (Value<=MaxValue);
end;

function rMsgBox(Text: string; Flags: Longint): Integer;
begin
  Result := Application.MessageBox(PChar(Text),PChar(Application.Title),Flags);
end;

procedure RestoreWindow(Form: TForm);
const
  WS: Array[TWindowState] of Integer = (SW_SHOW, SW_RESTORE, SW_MAXIMIZE);
begin
  if Assigned(Form)
  then begin
    ShowWindowAsync(Form.Handle,WS[Form.WindowState]);
    BringWindowToTop(Form.Handle);
  end;
end;

procedure RefreshWindow(Form: TForm);
begin
  if Assigned(Form)
  then RedrawWindow(Form.Handle, nil, 0,
          RDW_ERASENOW or RDW_UPDATENOW or RDW_FRAME or RDW_ALLCHILDREN or RDW_INVALIDATE);
end;

function FindResourceInModules(var Module: THandle; const ResName, ResType: PChar): HRSRC;
var
  i: Integer;
begin
  Result := FindResource(Module, ResName, ResType);
  if Result > 0 then exit;
  for i:=0 to RHandles.Count-1 do begin
    Result := FindResource(THandle(RHandles.Items[i]), ResName, ResType);
    if Result > 0 then begin
      Module := THandle(RHandles.Items[i]);
      exit;
    end;
  end;
end;

procedure CorrectResName(var ResName: string);
var
  ResID: Integer;
begin
  ResName := Trim(ResName);
  ResID := StrToIntDef(ResName,0);
  if ResID > 0 then ResName := '#'+ResName;
end;

function RLoadPicture(RHandle: THandle; ResName: string; ResKind: TBitmapResKind): THANDLE;
begin
  CorrectResName(ResName);
  if FindResourceInModules(RHandle,PChar(ResName),ResKindNames[ResKind]) = 0 then
    raise EResNotFound.CreateFmt(SResNotFound,[ResName]);
  if ResName[1] = '#' then
    ResName := String(MakeIntResource(Copy(ResName,2,Length(ResName))));
  case ResKind of
    rkBitmap: Result := LoadBitmap(RHandle,PChar(ResName));
    rkIcon:   Result := LoadIcon(RHandle,PChar(ResName));
    rkCursor: Result := LoadCursor(RHandle,PChar(ResName));
  else
    Result := 0;
  end;
end;

procedure LoadBitmapFromResource(Bitmap: TBitmap; RHandle: THandle;
                                 ResName: string; ResKind: TBitmapResKind);
type
  TCG = class of TGraphic;
var
  CG: TCG;
  Image: TGraphic;
  Stream: TResourceStream;
begin
  CorrectResName(ResName);
  if FindResourceInModules(RHandle,PChar(ResName),ResKindNames[ResKind]) = 0 then
    raise EResNotFound.CreateFmt(SResNotFound,[ResName]);
  case ResKind of
    rkBitmap: Bitmap.LoadFromResourceName(RHandle,ResName);
    {rkIcon,}rkEMF,rkWMF{$IFDEF GIF},rkGIF{$ENDIF}{$IFDEF JPEG},rkJPEG{$ENDIF}:
      begin
        Stream := TResourceStream.Create(RHandle,ResName,ResKindNames[ResKind]);
        try
          case ResKind of
//            rkIcon:      CG := TIcon;
            rkEMF,rkWMF: CG := TMetafile;
            {$IFDEF GIF}rkGIF: CG := TGIFImage;{$ENDIF}
            {$IFDEF JPEG}rkJPEG: CG := TJPEGImage;{$ENDIF}
          else
            CG := nil;
          end;
          Image := CG.Create;
          try
            Image.LoadFromStream(Stream);
            if ResKind = rkEMF then TMetafile(Image).Enhanced := True;
            with Image do begin
              Bitmap.Width := Width;
              Bitmap.Height := Height;
            end;
            Bitmap.Canvas.Draw(0,0,Image);
          finally
            Image.Free;
          end;
        finally
          Stream.Free;
        end;
      end;
   rkIcon:
      begin
        Image := TIcon.Create;
        with Image as TIcon do
          try
            Handle := RLoadPicture(RHandle,ResName,rkIcon);
            if not Empty then
              with Bitmap do begin
                Width  := 32;
                Height := 32;
                Canvas.Brush.Color := clFuchsia;
                Canvas.FillRect(Canvas.ClipRect);
                Canvas.Draw(0,0,Image);
              end;
          finally
            Free;
          end;
      end;
  end;
end;

function RegReadValue(Reg: TRegistry; Name: string; Default: string): string;
{$IFDEF POLARIS_D4}overload;{$ENDIF}
begin
  if Reg.ValueExists(Name) then Result := Reg.ReadString(Name)
  else Result := Default;
end;
{$IFDEF POLARIS_D4}
function RegReadValue(Reg: TRegistry; Name: string; Default: Integer): Integer; overload;
begin
  if Reg.ValueExists(Name) then Result := Reg.ReadInteger(Name)
  else Result := Default;
end;
function RegReadValue(Reg: TRegistry; Name: string; Default: Extended): Extended; overload;
begin
  if Reg.ValueExists(Name) then Result := Reg.ReadFloat(Name)
  else Result := Default;
end;
function RegReadValue(Reg: TRegistry; Name: string; Default: TDateTime): TDateTime; overload;
begin
  if Reg.ValueExists(Name) then Result := Reg.ReadDateTime(Name)
  else Result := Default;
end;
{$ENDIF}

function GetOSUser;
var
  sbuf: PAnsiChar;
  i: DWORD;
  n: Integer;
begin
  n := 80;
  i := n;
  GetMem(sbuf,n);
  GetUserName(sbuf,i);
  Result := sbuf;
  FreeMem(sbuf,n);
end;

initialization
  RHandles := TList.Create;
  RHandles.Add(Pointer(HInstance));
{$IFDEF POLARIS_D5}
  RHandles.Add(Pointer(GetModuleHandle('vcl50.bpl')));
{$ELSE}
{$IFDEF POLARIS_D4}
  RHandles.Add(Pointer(GetModuleHandle('vcl40.bpl')));
{$ELSE}
  RHandles.Add(Pointer(GetModuleHandle('vcl30.bpl')));
{$ENDIF}
{$ENDIF}
finalization
  RHandles.Free;
end.
