//==============================================
//       rsetupfields.pas
//
//         Delphi.
//         .
//
//      Copyright 1998-2000 Polaris Software
//      http://members.xoom.com/PolarisSoft
//      mailto: PolarisLib@mail.ru
//==============================================
unit rSetupFields;

{$I POLARIS.INC}

interface

uses Forms, Controls, Windows, Classes, Db, dbgrids, RXDBCtrl, SysUtils, Registry,
     Graphics, Dialogs, Spin, ExtCtrls, StdCtrls, RXCombos, Buttons,
     rButtons, Procs, RConst, rSpeedButton, rDBConst;

type

  TrSFDataLink = class;

  TrSetupFields = class(TComponent)
  private
    FRegKey, FGridKey : String;
    FDataLink: TrSFDataLink;
    FDBGrid : TDBGrid;
    FExcludeTag : Integer;
    FEnabled : Boolean;
    function  GetDataSource: TDataSource;
    procedure SetDataSource(Value: TDataSource);
    procedure SetDBGrid(Value: TDBGrid);
    procedure SetRegKey(Value: String);
    function CheckStoreDS : Boolean;
    procedure SetDataLinkDS(DS: TDataSource);
  protected
    procedure ActiveChanged;
    procedure Notification(AComponent: TComponent;
                           Operation: TOperation); override;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure Loaded; override;
    procedure Execute;
    procedure SetupColumns;
    property Enabled: Boolean read FEnabled;
    procedure SaveDBGridSettings(SDBGrid : TDBGrid);
  published
    property RegKey: String read FRegKey write SetRegKey;
    property DataSource: TDataSource read GetDataSource write SetDataSource stored CheckStoreDS;
    property DBGrid: TDBGrid read FDBGrid write SetDBGrid;
    property ExcludeTag: Integer read FExcludeTag write FExcludeTag default 1;
  end;

  TrSFDataLink = class(TDataLink)
  private
    FrSF: TrSetupFields;
  protected
    procedure ActiveChanged; override;
  public
    constructor Create(ArSF: TrSetupFields);
    destructor Destroy; override;
  end;

  TrDualListFldDlg = class(TForm)
    GroupBox1: TGroupBox;
    SrcLabel: TLabel;
    SrcList: TListBox;
    IncludeBtn: TrBitBtn;
    IncAllBtn: TrBitBtn;
    ExcludeBtn: TrBitBtn;
    ExAllBtn: TrBitBtn;
    DstLabel: TLabel;
    DstList: TListBox;
    OKBtn: TrBitBtn;
    UpBtn: TrBitBtn;
    DownBtn: TrBitBtn;
    FontDialog1: TFontDialog;
    CancelBtn: TrBitBtn;
    DefaultBtn: TrBitBtn;
    Props: TPanel;
    Label4: TLabel;
    Label2: TLabel;
    DisplayName: TEdit;
    Label1: TLabel;
    AlignBox: TComboBox;
    Label3: TLabel;
    ColorBox: TColorComboBox;
    Label5: TLabel;
    ColWidth: TSpinEdit;
    FontPanel: TPanel;
    FontBtn: TrBitBtn;
    Label6: TLabel;
    FixedSpin: TSpinEdit;
    BitBtn1: TBitBtn;
    RowSelect: TCheckBox;
    Label7: TLabel;
    Image1: TImage;
    procedure IncludeBtnClick(Sender: TObject);
    procedure ExcludeBtnClick(Sender: TObject);
    procedure IncAllBtnClick(Sender: TObject);
    procedure ExcAllBtnClick(Sender: TObject);
    procedure MoveSelected(List: TCustomListBox; Items: TStrings);
    procedure SetItem(List: TListBox; Index: Integer);
    function GetFirstSelection(List: TCustomListBox): Integer;
    procedure SetButtons;
    procedure DstListClick(Sender: TObject);
    procedure AlignBoxChange(Sender: TObject);
    procedure ColorBoxChange(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure UpBtnClick(Sender: TObject);
    procedure DownBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FixedSpinChange(Sender: TObject);
    procedure SrcListEnter(Sender: TObject);
    procedure DstListEnter(Sender: TObject);
    procedure ColWidthChange(Sender: TObject);
    procedure FontBtnClick(Sender: TObject);
    procedure DisplayNameChange(Sender: TObject);
    procedure DisplayNameEnter(Sender: TObject);
    procedure DefaultBtnClick(Sender: TObject);
    function FormHelp(Command: Word; Data: Integer;
      var CallHelp: Boolean): Boolean;
    procedure RowSelectClick(Sender: TObject);
    procedure AlignBoxEnter(Sender: TObject);
    procedure ColWidthEnter(Sender: TObject);
    procedure DstListDragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure DstListDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure SrcListDragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure SrcListDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure DstListMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
  private
    CanChange : Boolean;
    function GetFontSize(ColumnIndex : Integer) : Integer;
    { Private declarations }
  public
    FSrcGrid : TDBGrid;
    ClearFields : Boolean;
    { Public declarations }
  end;

var
  rDualListFldDlg: TrDualListFldDlg;

implementation

uses rDBGrid;

{$R *.DFM}

var
  Reg : TRegistry;

{ TrSFDataLink }

constructor TrSFDataLink.Create(ArSF: TrSetupFields);
begin
  inherited Create;
  FrSF := ArSF;
end;

destructor TrSFDataLink.Destroy;
begin
  FrSF := nil;
  inherited Destroy;
end;

procedure TrSFDataLink.ActiveChanged;
begin
  if FrSF <> nil then FrSF.ActiveChanged;
end;

{ TrSetupFields }


constructor TrSetupFields.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FDataLink := TrSFDataLink.Create(Self);
  FExcludeTag := 1;
  FEnabled := False;
end;

destructor TrSetupFields.Destroy;
begin
  FDBGrid := nil;
  FDataLink.Free;
  inherited Destroy;
end;

procedure TrSetupFields.Loaded;
begin
  inherited Loaded;
  if (FDBGrid <> nil ) then SetDataLinkDS(FDBGrid.DataSource);
end;

procedure TrSetupFields.Notification(AComponent: TComponent;Operation: TOperation);
begin
  inherited;
  if (Operation = opRemove) then
    if (FDataLink.DataSource <> nil) and (AComponent = FDataLink.DataSource) then
      FDataLink.DataSource := nil
    else if (FDBGrid <> nil) and (AComponent = FDBGrid) then
           FDBGrid := nil;
end;

procedure TrSetupFields.ActiveChanged;
begin
  if FDataLink.Active then begin
    if (FDBGrid <> nil) then FDBGrid.Columns.Clear;
    SetRegKey(FRegKey);
    SetupColumns;
  end;
end;

function TrSetupFields.GetDataSource: TDataSource;
begin
  Result := FDataLink.DataSource;
end;

procedure TrSetupFields.SetDataLinkDS(DS: TDataSource);
begin
  if not (FDataLink.DataSourceFixed and (csLoading in ComponentState)) then
    FDataLink.DataSource := DS;
end;

procedure TrSetupFields.SetDataSource(Value: TDataSource);
begin
  if (FDataLink.DataSource <> Value) then begin
    if (FDBGrid <> nil) and (Value <> nil) then FDBGrid:=nil;
    SetDataLinkDS(Value);
    if Value <> nil then begin
      Value.FreeNotification(Self);
      if Value.DataSet <> nil then
        if not (csDesigning in ComponentState) then SetupColumns;
    end;
  end;
end;

procedure TrSetupFields.SetRegKey(Value: String);
begin
  b := FRegKey <> Value;
  FRegKey := Value;
  if FRegKey <> '' then begin
    if FDBGrid <> nil then
      FGridKey := AddSlash(FRegKey)+FDBGrid.Name
    else FGridKey := '';
    if (DataSource <> nil) and (DataSource.DataSet <> nil) then
    begin
      if FDBGrid <> nil then
        FGridKey := FGridKey+';'+DataSource.DataSet.Name
      else FGridKey := AddSlash(FRegKey)+';'+DataSource.DataSet.Name;
    end;  
    if b then ActiveChanged;
  end;
  FEnabled := Reg.KeyExists(FGridKey);
end;

procedure TrSetupFields.SetDBGrid(Value: TDBGrid);
begin
//  if (FDBGrid <> Value) then begin
    if FDataLink.DataSource <> nil then SetDataLinkDS(nil);
    FDBGrid := Value;
    if Value <> nil then begin
      if not (csLoading in ComponentState) then SetDataLinkDS(FDBGrid.DataSource);
      Value.FreeNotification(Self);
      if not (csDesigning in ComponentState) then SetupColumns;
    end else
      SetDataLinkDS(nil);
//  end;
end;

procedure TrSetupFields.Execute;
var FIndex, i, j: Integer;
    FLabel, ColumnKey : String;
    FDataSet: TDataSet;
    ValueNames : TStringList;
    OldColumns : TDBGridColumns;
    OldFixedCols: Integer;
    DualListDlg: TrDualListFldDlg;
    Exists : Boolean;
begin
  FDataSet := nil;
  if (FDataLink.DataSource <> nil) and (FDataLink.DataSource.DataSet <> nil) then
     FDataSet := FDataLink.DataSource.DataSet
  else
  if (FDBGrid <> nil) and (FDBGrid.DataSource <> nil) and
     (FDBGrid.DataSource.DataSet <> nil) then
     FDataSet := FDBGrid.DataSource.DataSet;
  if (FDataSet <> nil) and (FDataSet.Active) then begin
    DualListDlg := TrDualListFldDlg.Create(Self);
    DualListDlg.FSrcGrid := FDBGrid;
    OldColumns := nil;
    OldFixedCols := 0;
    try
      if (FDBGrid <> nil) then begin  //  DBGrid
        OldColumns := TDBGridColumns.Create(FDBGrid,TColumn);
        OldColumns.Assign(FDBGrid.Columns);
        if (FDBGrid is TRxDBGrid) then
          OldFixedCols := (FDBGrid as TRxDBGrid).FixedCols;
        FDBGrid.Columns.Assign(OldColumns);
        if (FDBGrid is TRxDBGrid) then
          (FDBGrid as TRxDBGrid).FixedCols := OldFixedCols;
        for i:=0 to FDBGrid.Columns.Count-1 do begin
          FLabel :=  FDBGrid.Columns[i].Title.Caption;
          DualListDlg.DstList.Items.AddObject(FLabel,TObject(FDBGrid.Columns[i]));
        end;
      end
      else                          //  DataSource
      begin
        FIndex := 0;
//        OldFields := TFields.Create(FDataSet);

        {for i:=0 to FDataSet.Fields.Count-1 do begin
          OldFields.Add(FDataSet.Fields[i]);
        end;}

        for i:=0 to FDataSet.FieldCount-1 do
          if FDataSet.Fields[i].Visible then begin
            FLabel := FDataSet.Fields[i].DisplayLabel;
            DualListDlg.DstList.Items.AddObject(FLabel,TObject(FDataSet.Fields[i]));
            FDataSet.Fields[i].Index := FIndex;
            Inc(FIndex);
          end;
      end;
      for i:=0 to FDataSet.FieldCount-1 do begin
        if FDataSet.Fields[i].Tag <> FExcludeTag then begin
          Exists := False;
          For j := 0 to DualListDlg.DstList.Items.Count-1 do begin
            if (FDBGrid <> nil) then begin
              if (FDataSet.Fields[i].FieldName =
                      TColumn(DualListDlg.DstList.Items.Objects[j]).FieldName) then begin
                Exists := True;
                Break;
              end
            end
            else begin
              if (FDataSet.Fields[i].FieldName =
                      TField(DualListDlg.DstList.Items.Objects[j]).FieldName) then begin
                Exists := True;
                Break;
              end;
            end;
          end;
          if not Exists then
            DualListDlg.SrcList.Items.AddObject(FDataSet.Fields[i].DisplayLabel,
                                      TObject(FDataSet.Fields[i]));
        end;
      end;
      With DualListDlg,Reg do begin
        SetButtons;
        if (ShowModal = mrOK) and (FGridKey <> '') then begin
          OpenKey(FGridKey,True);
          ValueNames := TStringList.Create;
          try
            GetValueNames(ValueNames);
            for i := 0 to ValueNames.Count-1 do DeleteValue(ValueNames[i]);

            if FDBGrid <> nil then begin

              WriteString(srFixedColsKey,IntToStr(FixedSpin.Value));
              if (FDBGrid is TrDBGrid) then
                WriteString(srDefaultRowHeight,IntToStr(TrDBGrid(FDBGrid).DefaultRowHeight));
              if RowSelect.Checked then WriteString(srRowSelectKey,'1')
              else WriteString(srRowSelectKey,'0');
              for i := 0 to DstList.Items.Count-1 do begin
                With TColumn(DstList.Items.Objects[i]) do begin
                  ColumnKey := Title.Caption+#13;
                  Case Alignment of
                    taLeftJustify : ColumnKey := ColumnKey+'0';
                    taRightJustify : ColumnKey := ColumnKey+'1';
                    taCenter : ColumnKey := ColumnKey+'2';
                  end;
                  ColumnKey := ColumnKey+#13+IntToStr(Width)+
                                  #13+ColorToString(Color);
                  if Font.Style = [fsBold] then
                    ColumnKey := ColumnKey+#13'1'
                  else if Font.Style = [fsItalic] then
                    ColumnKey := ColumnKey+#13'2'
                  else if Font.Style = [fsBold,fsItalic] then
                    ColumnKey := ColumnKey+#13'3'
                  else if Font.Style = [] then
                    ColumnKey := ColumnKey+#13'0';
                  ColumnKey := ColumnKey+#13+IntToStr(Font.Size)+
                                  #13+ColorToString(Font.Color)+
                                  #13+Font.Name;
                  WriteString(FieldName,ColumnKey);
                  FEnabled := True;
                end;
              end;

            end
            else    //    DataSource
            begin

              for i := 0 to DstList.Items.Count-1 do begin
                With TField(DstList.Items.Objects[i]) do begin
                  ColumnKey := DisplayLabel+#13;
                  Case Alignment of
                    taLeftJustify : ColumnKey := ColumnKey+'0';
                    taRightJustify : ColumnKey := ColumnKey+'1';
                    taCenter : ColumnKey := ColumnKey+'2';
                  end;
                  ColumnKey := ColumnKey+#13+IntToStr(DisplayWidth);
                  WriteString(FieldName,ColumnKey);
                  FEnabled := True;
                end;
              end;
            end;
          finally
            CloseKey;
            ValueNames.Free;
          end;
        end
        else begin
          if ClearFields then
          With Reg do begin
            OpenKey(FGridKey,False);
            ValueNames := TStringList.Create;
            try
              GetValueNames(ValueNames);
              for i := 0 to ValueNames.Count-1 do DeleteValue(ValueNames[i]);
              if FDBGrid <> nil then FDBGrid.Columns.Clear;
            finally
              ValueNames.Free;
              CloseKey;
            end;
          end
          else if (FDBGrid <> nil) then begin
            FDBGrid.Columns.Clear;
            FDBGrid.Columns.Assign(OldColumns);
            if (FDBGrid is TRxDBGrid) then
              (FDBGrid as TRxDBGrid).FixedCols := OldFixedCols;
          end
          {else begin
            FDataSet.Close;
            FDataSet.Fields.Clear;
            for i := 0 to OldFields.Count-1 do
            FDataSet.Fields.Add(OldFields[i]);
            FDataSet.Open;
          end;}
        end;
      end;
    finally
//      OldFields.Free;
      if OldColumns <> nil then OldColumns.Free;
      DualListDlg.Free;
    end;
  end;
end;

function TrSetupFields.CheckStoreDS : Boolean;
begin
  Result := (FDBGrid = nil);
end;

procedure TrSetupFields.SetupColumns;
Var
  ValueNames : TStringList;
  NewColumn : TColumn;
  FAlignment,FFontStyle,Int,i,j : Integer;
  ColumnKey : String;
  FDataSet: TDataSet;
  l: Integer;
begin
if (FGridKey <> '') and Reg.KeyExists(FGridKey) then begin
  FDataSet := nil;
  if (FDataLink.DataSource <> nil) and (FDataLink.DataSource.DataSet <> nil) then
     FDataSet := FDataLink.DataSource.DataSet;
  if (FDataSet <> nil) {and (FDataSet.Active)} then begin
    ValueNames := TStringList.Create;
    Reg.OpenKey(FGridKey,False);
    try
      Reg.GetValueNames(ValueNames);

      if FDBgrid <> nil then begin  //  DBGrid

        with FDBGrid do
          if Reg.ReadString(srRowSelectKey)='1' then Options := Options+[dgRowSelect]
          else Options := Options-[dgRowSelect];
        FDBGrid.Columns.Clear;
        for i := 0 to ValueNames.Count-1 do
          if (FDBGrid.DataSource.DataSet.FindField(ValueNames[i]) <> nil) then begin
            NewColumn := FDBGrid.Columns.Add;
            NewColumn.FieldName := ValueNames[i];
            ColumnKey := Reg.ReadString(ValueNames[i]);
            l := Length(ColumnKey);

            // Title.Caption
            Int := Pos(#13,ColumnKey);
            NewColumn.Title.Caption := Copy(ColumnKey,1,Int-1);
            ColumnKey:= Copy(ColumnKey,Int+1,l);

            // Alignment
            Int := Pos(#13,ColumnKey);
            FAlignment := StrToIntDef(Copy(ColumnKey,1,Int-1),0);
            ColumnKey:= Copy(ColumnKey,Int+1,l);
            Case FAlignment of
              0 : NewColumn.Alignment := taLeftJustify;
              1 : NewColumn.Alignment := taRightJustify;
              2 : NewColumn.Alignment := taCenter;
            end;

            // Width
            Int := Pos(#13,ColumnKey);
            NewColumn.Width := StrToIntDef(Copy(ColumnKey,1,Int-1),80);
            ColumnKey:= Copy(ColumnKey,Int+1,l);

            // Color
            Int := Pos(#13,ColumnKey);
            if Int = 0 then
              NewColumn.Color := clWindow
            else
              NewColumn.Color := StringToColor(Copy(ColumnKey,1,Int-1));
            ColumnKey:= Copy(ColumnKey,Int+1,l);

            // Font.Style
            Int := Pos(#13,ColumnKey);
            FFontStyle := StrToIntDef(Copy(ColumnKey,1,Int-1),0);
            ColumnKey:= Copy(ColumnKey,Int+1,l);
            if FFontStyle = 1 then
              NewColumn.Font.Style := NewColumn.Font.Style+[fsBold]
            else if FFontStyle = 2 then
              NewColumn.Font.Style := NewColumn.Font.Style+[fsItalic]
            else if FFontStyle = 3 then
              NewColumn.Font.Style := NewColumn.Font.Style+[fsBold,fsItalic]
            else if FFontStyle = 0 then
              NewColumn.Font.Style := [];

            // Font.Size
            Int := Pos(#13,ColumnKey);
            NewColumn.Font.Size := StrToIntDef(Copy(ColumnKey,1,Int-1),8);
            ColumnKey:= Copy(ColumnKey,Int+1,l);

            // Font.Color
            Int := Pos(#13,ColumnKey);
            if Int = 0 then
              NewColumn.Font.Color := clWindowText
            else
              NewColumn.Font.Color := StringToColor(Copy(ColumnKey,1,Int-1));
            ColumnKey:= Copy(ColumnKey,Int+1,l);

            // Font.Name
            NewColumn.Font.Name := ColumnKey;
          end;
        if (FDBGrid is TRxDBGrid) then begin
          if Reg.ValueExists(srFixedColsKey) then
            (FDBGrid as TRxDBGrid).FixedCols := StrToInt(Reg.ReadString(srFixedColsKey));
        end;
        if (FDBGrid is TrDBGrid) then
          (FDBGrid as TrDBGrid).DefaultRowHeight := StrToIntDef(Reg.ReadString(srDefaultRowHeight),17);
      end
      else if (ValueNames.Count <> 0) then begin  //   DataSource
        for i := 0 to FDataSet.FieldCount-1 do begin
          j := ValueNames.IndexOf(FDataSet.Fields[i].FieldName);
          if j <> -1 then begin
            FDataSet.Fields[i].Visible := True;
            ColumnKey := Reg.ReadString(ValueNames[j]);
            l := Length(ColumnKey);

            Int := Pos(#13,ColumnKey);
            FDataSet.Fields[i].DisplayLabel := Copy(ColumnKey,1,Int-1);
            ColumnKey:= Copy(ColumnKey,Int+1,l);

            Int := Pos(#13,ColumnKey);
            FAlignment := StrToInt(Copy(ColumnKey,1,Int-1));
            ColumnKey:= Copy(ColumnKey,Int+1,l);
            Case FAlignment of
              0 : FDataSet.Fields[i].Alignment := taLeftJustify;
              1 : FDataSet.Fields[i].Alignment := taRightJustify;
              2 : FDataSet.Fields[i].Alignment := taCenter;
            end;

            FDataSet.Fields[i].DisplayWidth := StrToInt(ColumnKey);
          end
          else
            FDataSet.Fields[i].Visible := False;
        end;
      end;
    finally
      Reg.CloseKey;
      ValueNames.Free;
    end;
  end;
end;
end;

{ TrDualListFldDlg }

procedure TrDualListFldDlg.IncludeBtnClick(Sender: TObject);
var
  Index: Integer;
begin
  Index := GetFirstSelection(SrcList);
  MoveSelected(SrcList, DstList.Items);
  SetItem(SrcList, Index);
end;

procedure TrDualListFldDlg.ExcludeBtnClick(Sender: TObject);
var
  Index: Integer;
begin
  Index := GetFirstSelection(DstList);
  MoveSelected(DstList, SrcList.Items);
  SetItem(DstList, Index);
  DstListClick(DstList);
end;

procedure TrDualListFldDlg.IncAllBtnClick(Sender: TObject);
var
  i : Integer;
  NewColumn : TColumn;
begin
  for i:= 0 to SrcList.Items.Count - 1 do begin
    if FSrcGrid<>nil then begin
      NewColumn := FSrcGrid.Columns.Add;
      NewColumn.FieldName :=
                TField(SrcList.Items.Objects[i]).FieldName;
      SrcList.Items.Objects[i] := TObject(NewColumn);
    end
    else TField(SrcList.Items.Objects[i]).Visible := True;
    DstList.Items.AddObject(SrcList.Items[I],SrcList.Items.Objects[I]);
  end;
  SrcList.Items.Clear;
  SetItem(SrcList, 0);
  with FixedSpin do
    if Visible then begin
      MaxValue := DstList.Items.Count-1;
      Enabled := (FSrcGrid is TRxDBGrid) and (MaxValue>0);
    end;
end;

procedure TrDualListFldDlg.ExcAllBtnClick(Sender: TObject);
var
  I: Integer;
begin
  for I := 0 to DstList.Items.Count - 1 do begin
    if FSrcGrid <> nil then DstList.Items.Objects[I] :=
       TObject(TField(FSrcGrid.DataSource.DataSet.FieldByName(TColumn(DstList.Items.Objects[i]).FieldName)))
    else TField(DstList.Items.Objects[i]).Visible := False;
    SrcList.Items.AddObject(DstList.Items[I], DstList.Items.Objects[I]);
  end;
  DstList.Items.Clear;
  if FSrcGrid <> nil then FSrcGrid.Columns.Clear;
  SetItem(DstList, 0);
  with FixedSpin do
    if Visible then begin
      Value := 0;
      Enabled := False;
    end;
end;

procedure TrDualListFldDlg.MoveSelected(List: TCustomListBox; Items: TStrings);
var
  I: Integer;
  NewColumn : TColumn;
begin
  for I := List.Items.Count - 1 downto 0 do
    if List.Selected[I] then
    begin
      if FSrcGrid<>nil then begin
        if List = SrcList then begin
          NewColumn := FSrcGrid.Columns.Add;
          NewColumn.FieldName :=
                    TField(List.Items.Objects[i]).FieldName;
          NewColumn.Title.Caption := List.Items[i];
          List.Items.Objects[i] := TObject(NewColumn);
        end else begin
          List.Items.Objects[i] :=
               TObject(TField(FSrcGrid.DataSource.DataSet.FieldByName(TColumn(List.Items.Objects[i]).FieldName)));
{*****}   FSrcGrid.Columns.Items[i].Destroy;
        end;
      end else
        TField(List.Items.Objects[i]).Visible := List <> DstList;
      Items.AddObject(List.Items[I], List.Items.Objects[I]);
      List.Items.Delete(I);
      with FixedSpin do
        if Visible then begin
          MaxValue := DstList.Items.Count-1;
          Enabled := (FSrcGrid is TRxDBGrid) and (MaxValue>0);
        end;
    end;
end;

procedure TrDualListFldDlg.SetButtons;
var
  SrcEmpty, DstEmpty: Boolean;
begin
  SrcEmpty := SrcList.Items.Count = 0;
  DstEmpty := DstList.Items.Count = 0;
  IncludeBtn.Enabled := not SrcEmpty;
  IncAllBtn.Enabled := not SrcEmpty;
  ExcludeBtn.Enabled := not DstEmpty;
  ExAllBtn.Enabled := not DstEmpty;
end;

function TrDualListFldDlg.GetFirstSelection(List: TCustomListBox): Integer;
begin
  for Result := 0 to List.Items.Count - 1 do
    if List.Selected[Result] then Exit;
  Result := LB_ERR;
end;

procedure TrDualListFldDlg.SetItem(List: TListBox; Index: Integer);
var
  MaxIndex: Integer;
begin
  with List do begin
    SetFocus;
    MaxIndex := List.Items.Count - 1;
    if Index = LB_ERR then Index := 0
    else if Index > MaxIndex then Index := MaxIndex;
    Selected[Index] := True;
  end;
  SetButtons;
end;

procedure TrDualListFldDlg.DstListClick(Sender: TObject);
begin
  CanChange := True;
  with DstList do
    if (Items.Count<>0) then
      if (FSrcGrid<>nil) then begin
        Case TColumn(Items.Objects[ItemIndex]).Alignment of
          taLeftJustify :  AlignBox.ItemIndex:=0;
          taRightJustify :  AlignBox.ItemIndex:=1;
          taCenter :  AlignBox.ItemIndex:=2;
        end;
        DisplayName.Text := TColumn(Items.Objects[ItemIndex]).Title.Caption;
        ColorBox.ColorValue := TColumn(Items.Objects[ItemIndex]).Color;
        FontPanel.Font := TColumn(Items.Objects[ItemIndex]).Font;
        ColWidth.Value := Round(TColumn(Items.Objects[ItemIndex]).Width/
                          GetFontSize(ItemIndex));
        if (FSrcGrid is TRxDBGrid) then
          FixedSpin.Value := (FSrcGrid as TRxDBGrid).FixedCols;
        RowSelect.Checked := dgRowSelect in FSrcGrid.Options;
      end
      else
      begin
        Case TField(Items.Objects[ItemIndex]).Alignment of
          taLeftJustify :  AlignBox.ItemIndex:=0;
          taRightJustify :  AlignBox.ItemIndex:=1;
          taCenter :  AlignBox.ItemIndex:=2;
        end;
        DisplayName.Text := TField(Items.Objects[ItemIndex]).DisplayLabel;
        ColWidth.Value := TField(Items.Objects[ItemIndex]).DisplayWidth;
      end;
end;

procedure TrDualListFldDlg.AlignBoxChange(Sender: TObject);
begin
  if not CanChange then
    if FSrcGrid<>nil then
      with TColumn(DstList.Items.Objects[DstList.ItemIndex]) do
        Case AlignBox.ItemIndex of
          0 : Alignment := taLeftJustify;
          1 : Alignment := taRightJustify;
          2 : Alignment := taCenter;
        end
    else
      with TField(DstList.Items.Objects[DstList.ItemIndex]) do
        Case AlignBox.ItemIndex of
          0 : Alignment := taLeftJustify;
          1 : Alignment := taRightJustify;
          2 : Alignment := taCenter;
        end;
end;

procedure TrDualListFldDlg.ColorBoxChange(Sender: TObject);
begin
  if (not CanChange) and (FSrcGrid<>nil) then
    TColumn(DstList.Items.Objects[DstList.ItemIndex]).Color := ColorBox.ColorValue;
end;

procedure TrDualListFldDlg.FormActivate(Sender: TObject);
begin
  if FSrcGrid = nil then begin
    Label3.Visible := False;
    ColorBox.Visible := False;
    FontPanel.Visible := False;
    FontBtn.Visible := False;
    Label6.Visible := False;
    FixedSpin.Visible := False;
    Label7.Visible := False;
    RowSelect.Visible := False;
    //DefaultBtn.Enabled := False;
  end;
  With DstList do begin
    ItemIndex := 0;
    OnClick(DstList);
  end;
  with FixedSpin do
    if Visible then begin
      MaxValue := DstList.Items.Count-1;
      Enabled := (FSrcGrid is TRxDBGrid) and (MaxValue>0);
    end;
end;

procedure TrDualListFldDlg.UpBtnClick(Sender: TObject);
var
  Index_: Integer;
begin
  With DstList do begin
    if ItemIndex > 0 then begin
      if FSrcGrid<>nil then
        FSrcGrid.Columns[ItemIndex].Index := ItemIndex-1
      else
        TField(DstList.Items.Objects[ItemIndex]).Index := ItemIndex-1;
      Index_ := ItemIndex;
      Items.Move(ItemIndex,ItemIndex-1);
      ItemIndex := Index_-1;
    end else
      UpBtn.Enabled := False;
    DownBtn.Enabled := ItemIndex < Items.Count-1;
  end;
end;

procedure TrDualListFldDlg.DownBtnClick(Sender: TObject);
var
  Index_: Integer;
begin
  With DstList do begin
    if ItemIndex < Items.Count-1 then begin
      if FSrcGrid<>nil then
        FSrcGrid.Columns[ItemIndex].Index := ItemIndex+1
      else
        TField(Items.Objects[ItemIndex]).Index := ItemIndex+1;
      Index_ := ItemIndex;
      Items.Move(ItemIndex,ItemIndex+1);
      ItemIndex := Index_+1;
    end else
      DownBtn.Enabled := False;
    UpBtn.Enabled := ItemIndex > 0;
  end;
end;

procedure TrDualListFldDlg.FormCreate(Sender: TObject);
begin
  HelpFile  := srHelpFile;
  CanChange := False;
  ClearFields := False;
{$IFNDEF POLARIS_D4}
  DstList.MultiSelect := False;
{$ENDIF}
end;

procedure TrDualListFldDlg.FixedSpinChange(Sender: TObject);
begin
  if (FSrcGrid <> nil) and (FSrcGrid is TRxDBGrid) then
    (FSrcGrid as TRxDBGrid).FixedCols := (Sender as TSpinEdit).Value;
end;

procedure TrDualListFldDlg.SrcListEnter(Sender: TObject);
Var
 i : Integer;
begin
  With Props do
  for i := 0 to ControlCount-1 do
    if not (Controls[i] is TLabel) then
      TControl(Controls[i]).Enabled := False;
end;

procedure TrDualListFldDlg.DstListEnter(Sender: TObject);
Var
 i : Integer;
begin
  With Props do
  for i := 0 to ControlCount-1 do
    if not (Controls[i] is TLabel) then
      TControl(Controls[i]).Enabled := True;
end;

procedure TrDualListFldDlg.ColWidthChange(Sender: TObject);
var
  newWidth, oldWidth: Integer;
begin
  if not CanChange then
    with DstList do
      if FSrcGrid<>nil then begin
        newWidth := ColWidth.Value*GetFontSize(ItemIndex);
        oldWidth := TColumn(Items.Objects[ItemIndex]).Width;
        if Abs(newWidth - oldWidth) > GetFontSize(ItemIndex) then
          TColumn(Items.Objects[ItemIndex]).Width := newWidth;
      end else
        TField(Items.Objects[ItemIndex]).DisplayWidth := ColWidth.Value;
end;

procedure TrDualListFldDlg.FontBtnClick(Sender: TObject);
begin
  FontDialog1.Font := FontPanel.Font;
  if FontDialog1.Execute then begin
    TColumn(DstList.Items.Objects[DstList.ItemIndex]).Font := FontDialog1.Font;
    FontPanel.Font := FontDialog1.Font;
  end;
end;

procedure TrDualListFldDlg.DisplayNameChange(Sender: TObject);
begin
  if not CanChange then
    With DstList do begin
      Items[ItemIndex] := (Sender as TEdit).Text;
      if FSrcGrid<>nil then
        TColumn(Items.Objects[ItemIndex]).Title.Caption :=
                          (Sender as TEdit).Text
      else
        TField(Items.Objects[ItemIndex]).DisplayLabel :=
                          (Sender as TEdit).Text;
    end;
end;

procedure TrDualListFldDlg.DisplayNameEnter(Sender: TObject);
begin
  CanChange := False;
end;

procedure TrDualListFldDlg.DefaultBtnClick(Sender: TObject);
begin
  if FSrcGrid = nil then
    Application.MessageBox(PChar('        !'),
                PChar(Application.Title),MB_OK);
  ClearFields := True;
  if (FSrcGrid is TrDBGrid) then TrDBGrid(FSrcGrid).DefaultRowHeight := 17;
  Close;
end;

function TrDualListFldDlg.GetFontSize(ColumnIndex : Integer ) : Integer;
begin
  Image1.Canvas.Font := FSrcGrid.Columns[ColumnIndex].Font;
  Result := Image1.Canvas.TextWidth('a');
end;

function TrDualListFldDlg.FormHelp(Command: Word; Data: Integer;
  var CallHelp: Boolean): Boolean;
begin
  CallHelp := not ((Command = HELP_CONTEXTPOPUP) and (Data = HelpContext));
  Result := True;
end;

procedure TrDualListFldDlg.RowSelectClick(Sender: TObject);
begin
  with FSrcGrid do
    if RowSelect.Checked then Options := Options+[dgRowSelect]
    else Options := Options-[dgRowSelect];
end;

procedure TrDualListFldDlg.AlignBoxEnter(Sender: TObject);
begin
  CanChange := False;
end;

procedure TrDualListFldDlg.ColWidthEnter(Sender: TObject);
begin
  CanChange := False;
end;

procedure TrDualListFldDlg.DstListDragOver(Sender, Source: TObject; X,
  Y: Integer; State: TDragState; var Accept: Boolean);
begin
  Accept := (Source = SrcList);
end;

procedure TrDualListFldDlg.DstListDragDrop(Sender, Source: TObject; X,
  Y: Integer);
begin
  IncludeBtnClick(Sender);
end;

procedure TrDualListFldDlg.SrcListDragOver(Sender, Source: TObject; X,
  Y: Integer; State: TDragState; var Accept: Boolean);
begin
  Accept := (Source = DstList);
end;

procedure TrDualListFldDlg.SrcListDragDrop(Sender, Source: TObject; X,
  Y: Integer);
begin
  ExcludeBtnClick(Sender);
end;

procedure TrDualListFldDlg.DstListMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
  if not (SrcList.Dragging or DstList.Dragging) and
     (ssLeft in Shift) then
    TControl(Sender).BeginDrag(True);
end;

procedure TrSetupFields.SaveDBGridSettings(SDBGrid : TDBGrid);
var
  i : Integer;
  ColumnKey : String;
  ValueNames : TStringList;
begin
  with Reg do begin
    OpenKey(FGridKey, True);
    ValueNames := TStringList.Create;
    try
      GetValueNames(ValueNames);
      for i := 0 to ValueNames.Count-1 do DeleteValue(ValueNames[i]);
      if (SDBGrid is TRxDBGrid) then
        WriteString(srFixedColsKey, IntToStr(TRxDBGrid(SDBGrid).FixedCols));
      if (SDBGrid is TrDBGrid) then
        WriteString(srDefaultRowHeight,IntToStr(TrDBGrid(FDBGrid).DefaultRowHeight));
      WriteString(srRowSelectKey,IIF((dgRowLines in SDBGrid.Options),'1','0'));
      for i := 0 to SDBGrid.Columns.Count-1 do begin
        With SDBGrid.Columns[i] do begin
          ColumnKey := Title.Caption+#13;
          Case Alignment of
            taLeftJustify : ColumnKey := ColumnKey+'0';
            taRightJustify : ColumnKey := ColumnKey+'1';
            taCenter : ColumnKey := ColumnKey+'2';
          end;
          ColumnKey := ColumnKey+#13+IntToStr(Width)+
                          #13+ColorToString(Color);
          if Font.Style = [fsBold] then
            ColumnKey := ColumnKey+#13'1'
          else if Font.Style = [fsItalic] then
            ColumnKey := ColumnKey+#13'2'
          else if Font.Style = [fsBold,fsItalic] then
            ColumnKey := ColumnKey+#13'3'
          else if Font.Style = [] then
            ColumnKey := ColumnKey+#13'0';
          ColumnKey := ColumnKey+#13+IntToStr(Font.Size)+
                          #13+ColorToString(Font.Color)+
                          #13+Font.Name;
          WriteString(FieldName, ColumnKey);
        end;
      end;
    finally
      CloseKey;
      ValueNames.Free;
    end;
  end;
end;

initialization
  if not Assigned(Reg) then Reg := TRegistry.Create;
finalization
  if Assigned(Reg) then Reg.Free;
end.
