//==============================================
//       rmenubar.pas
//
//         Delphi.
//         Delphi 4.
//
//      Copyright (c) 1995,98 Inprise Corporation
//      Copyright 1998-2000 Polaris Software
//      http://members.xoom.com/PolarisSoft
//      mailto: PolarisLib@mail.ru
//==============================================
unit rMenuBar;

{$I POLARIS.INC}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ToolWin, ComCtrls, Menus;

type
  TrMenuBar = class(TToolBar)
  private
    FMenu: TMainMenu;
    procedure SetMenu(const Value: TMainMenu);
  protected
    procedure GetChildren(Proc: TGetChildProc; Root: TComponent); override;
    procedure Notification(AComponent: TComponent;
      Operation: TOperation); override;
    procedure ClearButtons;
  public
    constructor Create(AOwner: TComponent); override;
  published
    property EdgeBorders default [];
    property Menu: TMainMenu read FMenu write SetMenu;
  end;

implementation

{ TrMenuBar }

constructor TrMenuBar.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  Flat := True;
  ShowCaptions := True;
  EdgeBorders := [];
  ControlStyle := [csCaptureMouse, csClickEvents,
    csDoubleClicks, csMenuEvents, csSetCaption];
end;

procedure TrMenuBar.ClearButtons;
var
  i: Integer;
begin
  for i := ButtonCount - 1 downto 0 do Buttons[i].Free;
end;

procedure TrMenuBar.GetChildren(Proc: TGetChildProc; Root: TComponent);
begin
end;

procedure TrMenuBar.Notification(AComponent: TComponent; Operation: TOperation);
begin
  inherited Notification(AComponent, Operation);
  if (Operation = opRemove) and (AComponent = FMenu)
  then begin
    ClearButtons;
    FMenu := nil;
  end;
end;

procedure TrMenuBar.SetMenu(const Value: TMainMenu);
var
  i: Integer;
  Button: TToolButton;
begin
  if FMenu = Value then exit;
  if Assigned(FMenu) then ClearButtons;
  FMenu := Value;
  if not Assigned(FMenu) then exit;
  Value.FreeNotification(Self);
  for i := 0 to FMenu.Items.Count - 1 do
  begin
    Button := TToolButton.Create(Self);
    try
      Button.AutoSize := True;
      Button.Grouped := True;
      Button.Parent := Self;
    except
      Button.Free;
      raise;
    end;
  end;
  for i := 0 to ButtonCount - 1 do Buttons[i].MenuItem := FMenu.Items[i];
end;

end.
