//==============================================
//       rdbutils.pas
//
//         Delphi.
//      ,       .
//
//      Copyright 1998-2000 Polaris Software
//      http://members.xoom.com/PolarisSoft
//      mailto: PolarisLib@mail.ru
//==============================================
unit rDBUtils;

{$I POLARIS.INC}

interface

uses Windows, Classes, Forms, Menus, rDBConst, DB, DBConsts, DBCtrls, DBUtils,
     SysUtils, Registry, rUtils, StrUtils, ErrorMes;

type
  TrDBOption =
    (tboFirst,tboLast,tboEmpty,
     tboCanModify,tboInserting,tboModifying,tboEditing,
     tboAfterEditAssigned,tboNULL);
  TrDBOptionSet = set of TrDBOption;

  TrDBAction = (tbaCustom,tbaFirst,tbaPrior,tbaNext,tbaLast,tbaRefresh,
                tbaInsert,tbaDelete,tbaEdit,tbaView,tbaPost,tbaCancel,
                tbaConfirmDelete,tbaNULL);

  TOnActiveChanged =
    procedure (Sender: TObject; DataLink: TFieldDataLink; var SetEnabled: Boolean) of object;

const

  Negatives: array[TrDBAction] of TrDBOptionSet =
    ([],[tboFirst,tboEditing],[tboFirst,tboEditing],[tboLast,tboEditing],[tboLast,tboEditing],[tboEditing],
     [tboEditing],[tboEmpty,tboEditing],[tboEmpty,tboEditing],[tboEmpty,tboEditing],[],[],
     [tboEmpty,tboEditing],[tboNULL]);

  Positives: array[TrDBAction] of TrDBOptionSet =
    ([],[],[],[],[],[],
     [tboCanModify],[tboCanModify],[tboCanModify],[tboAfterEditAssigned],[tboEditing],[tboEditing],
     [tboCanModify],[tboEditing]);

  DBActionResources: array[TrDBAction] of string[20] =
    ('','RDBN_FIRST','RDBN_PRIOR','RDBN_NEXT','RDBN_LAST',
     'RDBN_REFRESH','RDBN_INSERT','RDBN_DELETE','RDBN_EDIT','RDBN_VIEW',
     'RDBN_POST','RDBN_CANCEL','RDBN_DELETE','NULL_BTN');

  // 666 - set in initialization section
  DBActionShortCuts: array[TrDBAction] of TShortCut =
    (0, 666, VK_UP, VK_DOWN, 666, 666,
     VK_INSERT, VK_DELETE, VK_F4, 666, 666, VK_ESCAPE,
     VK_DELETE, VK_DELETE);

  DBActionHints: Array[TrDBAction] of Pointer = (
    @RDBN_Custom,
    @RDBN_First,
    @RDBN_Prior,
    @RDBN_Next,
    @RDBN_Last,
    @RDBN_Refresh,
    @RDBN_Insert,
    @RDBN_Delete,
    @RDBN_Edit,
    @RDBN_View,
    @RDBN_Post,
    @RDBN_Cancel,
    @RDBN_Delete,
    @RDBN_NULL);

  { TrActions }
  RDBA_Caption: Array[TrDBAction] of Pointer = (
    @RDBA_CUSTOM, //tbaCustom,
    @RDBA_FIRST,  //tbaFirst,
    @RDBA_Prior,  //tbaPrior,
    @RDBA_Next,   //tbaNext,
    @RDBA_Last,   //tbaLast,
    @RDBA_Refresh,//tbaRefresh,
    @RDBA_Insert, //tbaInsert,
    @RDBA_Delete, //tbaDelete,
    @RDBA_Edit,   //tbaEdit,
    @RDBA_View,   //tbaView,
    @RDBA_Post,   //tbaPost,
    @RDBA_Cancel, //tbaCancel,
    @RDBA_Delete, //tbaConfirmDelete,
    @RDBA_NULL    //tbaNULL
  );

  DBImageIndexes: array[TrDBAction] of Integer = (-1,0,1,2,3,4,5,6,7,8,9,10,6,11);

//    ()
function DeleteMessage(Multi: Boolean): Boolean;
//    dataset  field
function TestOptions(DataSet: TDataSet; Field: TField; PositiveOptions,NegativeOptions: TrDBOptionSet): Boolean;
//    dataset  field
function DoAction(DataSet: TDataSet; Field: TField; Action: TrDBAction): Boolean;
//   
procedure ReCalcField(DataSet: TDataSet);
{       
        }
procedure FormatNameField(Field: TStringField);
//   
procedure FormatFIOField(Field: TStringField);
//    DataSet
procedure ChangeFilter(DataSet: TDataSet; NewFilter: string);
//     
procedure SetDBFilter(AModule: TComponent; Reg: TRegistry; ARegKey: String);

// DB errors handler
procedure DBErrorEHProc(E: Exception; Handler: TErrorHandler);

implementation

type
  TCrackDataSet=class(TDataSet);

function DeleteMessage(Multi: Boolean): Boolean;
var s: string;
begin
  MessageBeep(MB_ICONQUESTION);
  if Multi then s := SDeleteMultipleRecordsQuestion
  else s := SDeleteRecordQuestion;
  Result := Application.MessageBox(PChar(s),PChar(Application.Title),
                 MB_YESNO+MB_ICONQUESTION+MB_DEFBUTTON2) = IDYES;
end;

function TestOptions(DataSet: TDataSet; Field: TField; PositiveOptions,NegativeOptions: TrDBOptionSet): Boolean;
var
  I: TrDBOption;

  function TestOption(O: TrDBOption): Boolean;
  begin
    case O of
      tboFirst     : Result := DataSet.BOF;
      tboLast      : Result := DataSet.EOF;
      tboEmpty     : Result := DataSet.BOF and DataSet.EOF;
      tboCanModify : Result :=
        (not Assigned(Field) and DataSet.CanModify) or (Assigned(Field) and Field.CanModify);
      tboInserting : Result := DataSet.State=dsInsert;
      tboModifying : Result := DataSet.State=dsEdit;
      tboEditing   : Result := DataSet.State in [dsInsert,dsEdit];
      tboAfterEditAssigned : Result := Assigned(DataSet.AfterEdit);
      tboNULL      : Result := Assigned(Field) and Field.IsNull;
    else
      Result := False;
    end;
  end;

begin
  Result := Assigned(DataSet) and DataSet.Active;
  if (PositiveOptions=[]) and (NegativeOptions=[]) then exit;
  if Result and (PositiveOptions<>[]) then
    for I := Low(TrDBOption) to High(TrDBOption) do
      if I in PositiveOptions then begin
        Result := Result and TestOption(I);
        if not Result then Break;
      end;
  if Result and (NegativeOptions<>[]) then
    for I := Low(TrDBOption) to High(TrDBOption) do
      if I in NegativeOptions then begin
        Result := Result and not TestOption(I);
        if not Result then Break;
      end;
end;

function DoAction(DataSet: TDataSet; Field: TField; Action: TrDBAction): Boolean;
var
  i: Integer;
begin
  if not Assigned(DataSet) then begin
    Result := False;
    exit;
  end;
  Result := True;
  with DataSet do
    case Action of
      tbaFirst  : First;
      tbaPrior  : Prior;
      tbaNext   : Next;
      tbaLast   : Last;
      tbaRefresh: begin
                    if Assigned(Field) then Field.RefreshLookupList
                    else
                      for i:=0 to FieldCount-1 do
                        if Fields[i].LookupCache then Fields[i].RefreshLookupList;
                    try Refresh except RefreshQuery(DataSet) end;
                  end;
      tbaInsert : Insert;
      tbaDelete : Delete;
      tbaEdit   : Edit;
      tbaView   : if Assigned(AfterEdit) then AfterEdit(DataSet)
                  else Result := False;
      tbaPost   : Post;
      tbaCancel : Cancel;
      tbaConfirmDelete: if DeleteMessage(False) then Delete else Result := False;
      tbaNULL   : if Field <> nil then Field.Clear else Result := False;
    else
      Result := False;
    end;
end;

procedure ReCalcField(DataSet: TDataSet);
begin
  if DataSet <> nil then
  TCrackDataSet(DataSet).GetCalcFields(DataSet.ActiveBuffer);
end;

procedure FormatNameField;
begin
  with Field do begin
    if not(DataSet.State in [dsEdit,dsInsert]) then exit;
    if Length(Trim(AsString))=0 then begin
      AsVariant := Null;
      exit;
    end;
    AsString := Trim(AsString);
    AsString := Stuff(AsString,1,1,AnsiUpperCase(String(AsString[1])))
  end;
end;

procedure FormatFIOField;
begin
  with Field do begin
    if not(DataSet.State in [dsEdit,dsInsert]) then exit;
    if Length(Trim(AsString))=0 then begin
      AsVariant := Null;
      exit;
    end;
    FormatNameField(Field);
    AsString := AnsiProperCase(Trim(AsString),[' ','.',',','-']);
  end;
end;

procedure ChangeFilter;
begin
  with DataSet do
    if Filter <> NewFilter then begin
      Filter := NewFilter;
      Filtered := (Trim(Filter)<>'') or Assigned(OnFilterRecord);
    end;
end;

procedure SetDBFilter(AModule: TComponent; Reg: TRegistry; ARegKey: String);
Var
  i: Integer;
  RealKey: String;
begin
  For i:=0 to AModule.ComponentCount-1 do
    if (AModule.Components[i] is TDataSet) then begin
      RealKey:=ARegKey+srFilterKey+(AModule.Components[i] as TDataSet).Name;
      With Reg do
        if KeyExists(RealKey) then begin
          OpenKey(RealKey,False);
          (AModule.Components[i] as TDataSet).Filter:=ReadString(srFilterValue);
          CloseKey;
        end;
   end;
end;

procedure DBErrorEHProc(E: Exception; Handler: TErrorHandler);
begin
  with Handler do begin
    TitleMessage := srDBErrorTitle;
    Message := E.Message;
  end;
end;

initialization
  AddError('EDatabaseError',DBErrorEHProc);

  DBActionShortCuts[tbaFirst]   := ShortCut(VK_HOME,[ssCtrl]);
  DBActionShortCuts[tbaLast]    := ShortCut(VK_END,[ssCtrl]);
  DBActionShortCuts[tbaRefresh] := ShortCut(Word('R'),[ssCtrl]);
  DBActionShortCuts[tbaView]    := ShortCut(VK_F3,[ssCtrl]);
  DBActionShortCuts[tbaPost]    := ShortCut(VK_RETURN,[ssCtrl])
end.

