unit rDBGridCtls;

interface

uses
    Windows, Messages, Classes, Controls, Forms, Buttons, Db,
    DBCtrls, extdlgs, rButtons, StdCtrls, ExtCtrls, Dialogs, rDBConst, rConst;

type

   TrDBGridCtlsForm = class(TForm)
     OpenDialog: TOpenDialog;
     SaveDialog: TSaveDialog;
     BBOk: TrBitBtn;
     BBCancel: TrBitBtn;
     BBHelp: TrBitBtn;
     MainPanel: TPanel;
     ScrollBox1: TScrollBox;
     DBImage: TDBImage;
     Memo1: TMemo;
     Panel1: TPanel;
     BBLoad: TrBitBtn;
     BBSave: TrBitBtn;
     Bevel1: TBevel;
     BBClear: TrBitBtn;
     BBPaste: TrBitBtn;
     BBCopy: TrBitBtn;
     BBCut: TrBitBtn;
     procedure OkbtnClick(Sender: TObject);
     procedure FormActivate(Sender: TObject);
     procedure MenuClick(Sender: TObject);
     procedure FileOpen(Sender: TObject);
     procedure SaveBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    function FormHelp(Command: Word; Data: Integer;
      var CallHelp: Boolean): Boolean;
  private
     { Private declarations }
     FBlobCaption: string;
     FBlobField: TField;
     FDataSource: TDataSource;
  public
     { Public declarations }
     property BlobCaption: string read FBlobCaption write FBlobCaption;
     property BlobField: TField read FBlobField write FBlobField;
     property DataSource: TDataSource read FDataSource write FDataSource;
  end;

var
  rDBGridCtlsForm: TrDBGridCtlsForm;

implementation

{$R *.DFM}

procedure TrDBGridCtlsForm.OkbtnClick(Sender: TObject);
begin
  if Assigned(FDataSource) and (FDataSource.DataSet.State in [dsEdit,dsInsert]) then begin
    if Memo1.Visible then FBlobField.AsString := Memo1.Lines.Text
    else FDataSource.DataSet.FieldByName(DBImage.DataField).Assign(DBImage.Picture);
  end;
end;

procedure TrDBGridCtlsForm.FormActivate(Sender: TObject);
begin
  rDBGridCtlsForm.Caption := FBlobCaption;
  case FBlobField.DataType of
    ftMemo, ftFmtMemo: begin
        Memo1.Lines.Text := FBlobField.AsString;
        Memo1.Visible := True;
      end;
    ftGraphic, ftTypedBinary: begin
        try
          DBImage.DataSource := FDataSource;
          DBImage.DataField := FBlobField.FieldName;
          ScrollBox1.Visible := True;
          Panel1.Visible := True;
        except
          rDBGridCtlsForm.ModalResult := mrCancel;
        end;
      end;
  end;
end;

procedure TrDBGridCtlsForm.MenuClick(Sender: TObject);
begin
  case Integer(TBitBtn(Sender).Tag) of
    1 : DBImage.Perform(WM_CUT, 0, 0);
    2 : DBImage.Perform(WM_COPY, 0, 0);
    3 : DBImage.Perform(WM_PASTE, 0, 0);
    4 : DBImage.Picture.Graphic := nil;
  end;
end;

procedure TrDBGridCtlsForm.FileOpen(Sender: TObject);
begin
  with TOpenPictureDialog.Create(Self) do
    try
      Title := srChoiceImg;
      if Execute then DBImage.Picture.LoadFromFile(FileName);
    finally
      Free;
    end;
end;

procedure TrDBGridCtlsForm.SaveBtnClick(Sender: TObject);
begin
  with SaveDialog do if Execute then DBImage.Picture.SaveToFile(FileName);
end;

procedure TRDBGridCtlsForm.FormCreate(Sender: TObject);
begin
  HelpFile := srHelpFile;
end;

function TRDBGridCtlsForm.FormHelp(Command: Word; Data: Integer;
  var CallHelp: Boolean): Boolean;
begin
  CallHelp := not ((Command = HELP_CONTEXTPOPUP) and (Data = HelpContext));
  Result := True;
end;

end.

