//==============================================
//       rdbedit.pas
//
//         Delphi.
//       TDBEdit.
//
//      Copyright 1998-2000 Polaris Software
//      http://members.xoom.com/PolarisSoft
//      mailto: PolarisLib@mail.ru
//==============================================
unit rDBEdit;

{$I POLARIS.INC}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Mask, DBCtrls, StrUtils, DB;

type
  TUpperCase = (ucNone, ucOnlyFirst, ucInitials);

  TrDBEdit = class(TDBEdit)
  private
    { Private declarations }
    FUpperCase: TUpperCase;
    FTrimBlanks: Boolean;
    procedure CMExit(var Message: TCMExit); message CM_EXIT;
  protected
    { Protected declarations }
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
  published
    { Published declarations }
    property UpperCase: TUpperCase read FUpperCase write FUpperCase default ucOnlyFirst;
    property TrimBlanks: Boolean read FTrimBlanks write FTrimBlanks default True;
  end;

implementation

constructor TrDBEdit.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FUpperCase := ucOnlyFirst;
  FTrimBlanks := True;
end;

procedure TrDBEdit.CMExit(var Message: TCMExit);
begin
  if not Modified then exit;
  if FTrimBlanks then Text := Trim(Text);
  if Length(Text) <> 0 then
    if FUpperCase = ucOnlyFirst then
      Text := AnsiUpperCase(String(Text[1]))+Copy(Text,2,Length(Text))
    else
      if FUpperCase = ucInitials then
        Text := AnsiProperCase(Text,[' ','.',',','-']);
  inherited;
  if Length(Text)=0 then
    with DataSource do
      if State <> dsBrowse then DataSet[DataField] := NULL;
end;

end.
