//==============================================
//       rbuttons.pas
//
//         Delphi.
//      TrCustomComboEdit & TrBitBtn.
//
//      Copyright 1998-2000 Polaris Software
//      http://members.xoom.com/PolarisSoft
//      mailto: PolarisLib@mail.ru
//==============================================
unit rButtons;

{$I POLARIS.INC}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Buttons, rUtils, ToolEdit;

type
  TrCustomComboEdit = class(TCustomComboEdit)
  private
    FGlyphResKind: TBitmapResKind;
    FGlyphResource: string;
    FOnCloseUp: TNotifyEvent;
    function IsGlyph: Boolean;
    procedure UpdateGlyph;
    procedure SetGlyphResKind(Value: TBitmapResKind);
    procedure SetGlyphResource(Value: string);
  protected
    property GlyphResKind:  TBitmapResKind read FGlyphResKind write SetGlyphResKind
                                           default DefBRK;
    property GlyphResource: string read FGlyphResource write SetGlyphResource;
    property OnCloseUp: TNotifyEvent read FOnCloseUp write FOnCloseUp;
    procedure Loaded; override;
  public
    constructor Create(AOwner: TComponent); override;
    property Button;
  published
    property Alignment;
    property AutoSelect;
    property BorderStyle;
    property ButtonHint;
    property CharCase;
    property ClickKey;
    property Color;
    property Ctl3D;
    property DirectInput;
    property DragCursor;
    property DragMode;
    property EditMask;
    property Enabled;
    property Font;
    property GlyphKind;
    { Ensure GlyphKind is published before Glyph and ButtonWidth }
    property Glyph stored IsGlyph;
    property ButtonWidth;
    property HideSelection;
{$IFDEF POLARIS_D4}
    property Anchors;
    property BiDiMode;
    property Constraints;
    property DragKind;
    property ParentBiDiMode;
{$ENDIF}
    property ImeMode;
    property ImeName;
    property MaxLength;
    property NumGlyphs;
    property OEMConvert;
    property ParentColor;
    property ParentCtl3D;
    property ParentFont;
    property ParentShowHint;
    property PopupMenu;
    property ReadOnly;
    property ShowHint;
    property TabOrder;
    property TabStop;
    property Text;
    property Visible;
    property OnButtonClick;
    property OnChange;
    property OnClick;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDrag;
    property OnEnter;
    property OnExit;
    property OnKeyDown;
    property OnKeyPress;
    property OnKeyUp;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property OnStartDrag;
{$IFDEF POLARIS_D4}
    property OnEndDock;
    property OnStartDock;
{$ENDIF}
  end;

  TCustomRBitBtn = class(TBitBtn)
  private
    FGlyphResKind: TBitmapResKind;
    FGlyphResource: string;
    function IsGlyph: Boolean;
    procedure UpdateGlyph;
    procedure SetGlyphResKind(Value: TBitmapResKind);
    procedure SetGlyphResource(Value: string);
  protected
    property GlyphResKind:  TBitmapResKind read FGlyphResKind write SetGlyphResKind
                                           default DefBRK;
    property GlyphResource: string read FGlyphResource write SetGlyphResource;
    procedure Loaded; override;
  public
    constructor Create(AOwner: TComponent); override;
  published
    property Glyph stored IsGlyph;
  end;

  TrBitBtn = class(TCustomRBitBtn)
  published
    property Align;
    property GlyphResKind;
    property GlyphResource;
  end;

implementation

{ TrCustomComboEdit }

constructor TrCustomComboEdit.Create(AOwner: TComponent);
begin
  inherited;
  FGlyphResKind := DefBRK;
end;

function TrCustomComboEdit.IsGlyph;
begin
  Result := ((FGlyphResKind = rkNone) or (Trim(FGlyphResource) = '')) and (GlyphKind = gkCustom);
end;

procedure TrCustomComboEdit.UpdateGlyph;
begin
  if (FGlyphResKind = rkNone) or (Trim(FGlyphResource) = '') or (csReading in ComponentState) then exit;
  try
    LoadBitmapFromResource(Button.Glyph,hInstance,FGlyphResource,FGlyphResKind);
  except
    on EResNotFound do if not(csDesigning in ComponentState) then raise;
    else raise;
  end;
end;

procedure TrCustomComboEdit.SetGlyphResource;
begin
  if FGlyphResource <> Value then begin
    FGlyphResource := Value;
    if Trim(FGlyphResource) <> '' then UpdateGlyph;
  end;
end;

procedure TrCustomComboEdit.SetGlyphResKind;
begin
  if FGlyphResKind <> Value then begin
    FGlyphResKind := Value;
    if FGlyphResKind <> rkNone then UpdateGlyph;
  end;
end;

procedure TrCustomComboEdit.Loaded;
begin
  inherited;
  UpdateGlyph;
end;

{ TCustomRBitBtn }

constructor TCustomRBitBtn.Create(AOwner: TComponent);
begin
  inherited;
  FGlyphResKind := DefBRK;
end;

function TCustomRBitBtn.IsGlyph;
begin
  Result := ((FGlyphResKind = rkNone) or (Trim(FGlyphResource) = '')) and (Kind = bkCustom);
end;

procedure TCustomRBitBtn.UpdateGlyph;
begin
  if (FGlyphResKind = rkNone) or (Trim(FGlyphResource) = '') or (csReading in ComponentState) then exit;
  try
    LoadBitmapFromResource(Glyph,hInstance,FGlyphResource,FGlyphResKind);
  except
    on EResNotFound do if not(csDesigning in ComponentState) then raise;
    else raise;
  end;
end;

procedure TCustomRBitBtn.SetGlyphResource;
begin
  if FGlyphResource <> Value then begin
    FGlyphResource := Value;
    if Trim(FGlyphResource) = '' then
      FGlyphResKind := rkNone
    else
      UpdateGlyph;
  end;
end;

procedure TCustomRBitBtn.SetGlyphResKind;
begin
  if FGlyphResKind <> Value then begin
    FGlyphResKind := Value;
    UpdateGlyph;
  end;
end;

procedure TCustomRBitBtn.Loaded;
begin
  inherited;
  UpdateGlyph;
end;

end.
