//==============================================
//       rbdeutils.pas
//
//         Delphi.
//      , ,   
//           BDE.
//
//      Copyright 1998-2000 Polaris Software
//      http://members.xoom.com/PolarisSoft
//      mailto: PolarisLib@mail.ru
//==============================================
unit rBDEUtils;

{$I POLARIS.INC}

interface

uses rDBConst, BDE, DBTables, DB, SysUtils, rUtils, ErrorMes;

const
{$IFDEF POLARIS_D4}
  DBMasks: array[TTableType] of string[5] = ('', '*.DB', '*.DBF', '*.TXT', '*.DBF');
{$ELSE}
  DBMasks: array[TTableType] of string[5] = ('', '*.DB', '*.DBF', '*.TXT');
{$ENDIF}

//  SQL 
procedure ExecuteSQL(ADatabase: TDatabase; SQL: string);
//  /   
function DBSysDate(ADatabase: TDatabase; WithTime: Boolean): TDateTime;
//     
procedure AssignParam(Param: TParam; Value: Variant);
//     
procedure ExecStoredProc(StoredProc: TStoredProc; DB: TDatabase);
//  
function GetUser(DB: TDatabase): string;

// BDE errors handler
procedure BDEErrorEHProc(E: Exception; Handler: TErrorHandler);

implementation

procedure ExecuteSQL(ADatabase: TDatabase; SQL: string);
var
  FStmtHandle: hDBIStmt;
begin
  Check(DbiQAlloc(ADataBase.Handle, qrylangSQL, FStmtHandle));
  try
    Check(DbiQPrepare(FStmtHandle, PChar(SQL)));
  except
    DbiQFree(FStmtHandle);
    FStmtHandle := nil;
    raise;
  end;
  Check(DbiQExec(FStmtHandle, nil));
  Check(DbiQFree(FStmtHandle));
end;

function DBSysDate(ADatabase: TDatabase; WithTime: Boolean): TDateTime;
var
  driver: string;
begin
  if ADatabase.AliasName <> '' then
    driver := ADatabase.Session.GetAliasDriverName(ADatabase.AliasName)
  else
    driver := ADatabase.DriverName;
  if driver = 'INTRBASE' then
    with TQuery.Create(nil) do
      try
        DatabaseName := ADatabase.DatabaseName;
        SQL.Text := srSQLIBSysDate;
        Open;
        Result := Fields[0].AsDateTime;
        if not WithTime then
          Result := StrToDate(DateToStr(Result));
        Close;
      finally
        Free;
      end
  else
    if WithTime then Result := SysUtils.Now else Result := SysUtils.Date;
end;

procedure AssignParam(Param: TParam; Value: Variant);
begin
  if Value = NULL then Param.Clear else Param.Value := Value;
end;

procedure ExecStoredProc(StoredProc: TStoredProc; DB: TDatabase);
var
  b: Boolean;
begin
  with StoredProc, DB do begin
    b := InTransaction;
    if not b then StartTransaction;
    try
      Prepare;
      ExecProc;
      if not b then Commit;
    except
      if not b then Rollback;
      raise;
    end;
  end;
end;

function GetUser(DB: TDatabase): string;
begin
  if Assigned(DB) and DB.Connected then
    Result := DB.Params.Values[szUSERNAME]+' '+srDBUserName
  else
    Result := GetOSUser+' '+srOSUserName;
end;

procedure BDEErrorEHProc(E: Exception; Handler: TErrorHandler);
var
  i: Integer;
  mes: string;
begin
  with Handler do begin
    TitleMessage := srBDEErrorTitle;
    with E as EDBEngineError do begin
      for i:=0 to ErrorCount-1 do begin  { loop by errors }
        mes := Errors[i].Message;
        // delete last LF or CR in message
        if Length(mes) > 0 then
          if Copy(mes,Length(mes),1)[1] in [#10,#13] then System.Delete(mes,Length(mes),1);
        if mes = '' then Continue;
        if (Handler.Message = '') and Assigned(FIniFile) and
           ((i = ErrorCount-1) or (Errors[i].NativeError <> 0)) then
          Handler.Message := ConvertMessage(Errors[i].Message);
        with Errors[i] do
          if NativeError = 0 then
            Description.Add(Format(srBDEErrorDesc,
                                    [ErrorCode, Category, SubCode,mes]))
          else
            Description.Add(Format(srSQLErrorDesc, [NativeError, mes]));
      end;
      if Handler.Message = '' then begin
        Handler.Message := Errors[ErrorCount-1].Message;
        SaveLog := True;
      end;
    end;
  end;
end;

initialization
  AddError('EDBEngineError',BDEErrorEHProc);
end.

