//==============================================
//       Procs.pas
//
//         Delphi.
//         ().
//
//      Copyright 1998-2000 Polaris Software
//      http://members.xoom.com/PolarisSoft
//      mailto: PolarisLib@mail.ru
//==============================================
unit Procs;

{$I POLARIS.INC}

interface

uses
  Windows, SysUtils, Forms, Controls, StrUtils, Classes, Graphics,
  MaxMin, rUtils, Registry, rConst;

type
  //      (0-1; 1-2..4; 2-0,5..9)
  TCurrencyNames = array [0..2] of string;
  //  (, ., ., . )
  TGenders = (gNeuter,gMale,gFemale,gPlural);
  TGenderNames = array[TGenders] of string;

const
  NO = False;            YES = True;
  CRLF = #13#10;
  WIN_CAP_DELIM = ' - ';
  NewStrings: TGenderNames = (srNewN,srNewM,srNewF,srNewP);
  Rubles: TCurrencyNames = ('','','');
  Copecks: TCurrencyNames = ('','','');

var
//  
i,j,k,n: Integer;
s: string;
b: Boolean;
c: Char;
v: Variant;

{     }
function DaysOfMonth(Date: TDateTime): Integer;
{      }
function FormatFIO(S: string): string;
{      }
function ChangeEndStr(Dest,Delim,Source: string): string;
//      TCurrencyNames
function TestNum(Num: Integer): Integer;
//       
function NumInWords(Sum: Extended; Gender: TGenders {$IFDEF POLARIS_D4}= gMale{$ENDIF}): string;
//   
function MoneyInWords(Sum: Extended; MainCur, SecCur: TCurrencyNames; Gender: TGenders;
                      Decimals: Integer {$IFDEF POLARIS_D4}= 2{$ENDIF}): string;
//  \   
function AddSlash(Path: string): string;
//     
function StrTrunc(Source: string; Len: Integer; TermStr: string): string;
//     
function ExecuteForm(Form: TForm): TModalResult;
//  MDI    
function CheckMDIForm(Parent: TForm;ChildName: string): Boolean;
//    
function ConfirmCancel(Caption: string): Boolean;
//  
function Sign(Value: Extended): Integer;
//   
function RaisePower(Value,Power: Integer): Integer;
//    Extended
function fPower(Value, Power: Extended): Extended;
// 
function fRound(X: Extended; Precision: Integer): Extended;
// ,    0,    
function SoftRound(X: Extended; Precision: Integer): Extended;
//    
function IIF(Switch: Boolean; Var1,Var2: Variant): Variant;
{$IFDEF POLARIS_D4}overload;
function IIF(Switch: Boolean; Var1,Var2: String): String; overload;
{$ENDIF}
//    
procedure ActiveControls(Owner: TWinControl; Active: Boolean);
//   Hint
procedure AppHint(StrHint: string);
//  Bitmap'  ImageList  
function LoadToImage(Handle: THandle; ResName: PChar; ResKind: TBitmapResKind; Image: TImageList): Boolean;
//  Version Info
function GetVersionInfo(VerList: TStrings; FileName: String {$IFDEF POLARIS_D4}= ''{$ENDIF}): Boolean;
//     
function MaxDate(const D: array of TDate): TDate;
//     
function MinDate(const D: array of TDate): TDate;
//      ImageList'a
procedure DrawImage(Canvas: TCanvas; Rect: TRect; Images: TImageList; Index: Integer);
//         
function GetRealIndex(Items: TStrings; FirstIndex: Integer; S: string): Integer;

implementation

uses
  Buttons;

function DaysOfMonth;
var dmy: TrDate;
begin
  with dmy do begin
    DecodeDate(Date,y,m,d);
    if m in [4,6,9,11] then Result := 30 else Result := 31;
    if m = 2 then
      if (y mod 4 = 0) and ((y mod 400 = 0) or (y mod 100 <> 0)) then
        Result := 29 else Result := 28;
  end;
end;

function FormatFIO;
begin
  if S = '' then exit;
  Result := ExtractWord(1,S,[' ']);
  if WordCount(S,[' ']) > 1 then
    Result := Result+' '+AnsiUpperCase(String(ExtractWord(2,S,[' '])[1]))+'.';
  if WordCount(S,[' ']) > 2 then
    Result := Result+' '+AnsiUpperCase(String(ExtractWord(3,S,[' '])[1]))+'.';
end;

function ChangeEndStr;
begin
  if Pos(Delim,Dest) = 0 then s := Dest
  else s := Copy(Dest,1,Pos(Delim,Dest)-1);
  if Source = '' then Result := s
                 else Result := s+Delim+Source;
end;

function TestNum(Num: Integer): Integer;
begin
  if (Num mod 10 = 1) and (Num mod 100 <> 11) then Result := 0
  else if (Num mod 10 in [2..4]) and not(Num mod 100 in [12..14]) then Result := 1
  else Result := 2;
end;

function NumInWords(Sum: Extended; Gender: TGenders{$IFDEF POLARIS_D4} = gMale{$ENDIF}): string;
const
  a1: array [1..19] of string =
    (sr1,sr2,sr3,sr4,sr5,sr6,sr7,sr8,sr9,
     sr10,sr11,sr12,sr13,sr14,sr15,sr16,sr17,sr18,sr19);
  a10: array [2..9] of string =
    (sr20,sr30,sr40,sr50,sr60,sr70,sr80,sr90);
  a100: array [1..9] of string =
    (sr100,sr200,sr300,sr400,sr500,sr600,sr700,sr800,sr900);
  aExp: array [1..5] of record
                          Num: Integer;
                          str: string;
                        end =
    ((num:12; str:sr10_12;),
     (num:9;  str:sr10_9; ),
     (num:6;  str:sr10_6; ),
     (num:3;  str:sr10_3; ),
     (num:0;  str:'';     ));
  strGender = 'NMFP';
var
  pNum, Divider: Extended;
  i, nGender, mNum: LongInt;
begin
  pNum := Abs(Trunc(Sum));
  Result := '';
  for i:=1 to 5 do begin
    Divider := Round(fPower(10,aExp[i].Num));
    mNum := Trunc(pNum/Divider);
    if mNum > 0 then begin
      if mNum > 99 then begin
        Result := Result+a100[mNum div 100]+' ';
        mNum := mNum mod 100;
      end;
      if mNum > 19 then begin
        Result := Result+a10[mNum div 10]+' ';
        mNum := mNum mod 10;
      end;
      if mNum > 0 then begin
        if i = 5 then
          nGender := Ord(Gender)+1
        else
          nGender := Pos(ExtractWord(1,aExp[i].str,[',']),strGender);
        if (nGender = 0) then nGender := 1;
        nGender := Min(nGender,WordCount(a1[mNum],[',']));
        Result := Result+ExtractWord(nGender,a1[mNum],[','])+' ';
      end;
      if (i <> 5) and (Trunc(pNum/Divider)<>0) then
        // name of numeral
        Result := Result+
                  ExtractWord( Min(TestNum(mNum)+2,WordCount(aExp[i].str,[','])),
                               aExp[i].str, [','])+ ' ';
    end;
    pNum := Round(Frac(pNum/Divider)*Divider);
  end;
  if Result = '' then Result := AnsiUpperCase(sr0)+' '
  else Result := Stuff(Result,1,1,AnsiUpperCase(Copy(Result,1,1)));
end;

function MoneyInWords(Sum: Extended; MainCur, SecCur: TCurrencyNames; Gender: TGenders;
                      Decimals: Integer {$IFDEF POLARIS_D4}= 2{$ENDIF}): string;
var
  n1: Integer;
begin
  n1 := Round(Frac(Sum)*RaisePower(10,Decimals));
  Result := NumInWords(Sum,Gender)+MainCur[TestNum(Trunc(Sum))]+' '+
            FormatFloat(StringOfChar('0',Decimals),n1)+' '+SecCur[TestNum(n1)];
end;

function AddSlash;
begin
  Result := Path;
  if (Path<>'') and (Pos(Copy(Path,Length(Path),1),':\')=0) then
    Result := Result+'\';
end;

function StrTrunc;
begin
  if Len > Length(Source) then Result := Source
  else
    Result := Copy(Source,1,Len-Length(TermStr))+TermStr;
end;

function ExecuteForm;
begin
  try
    Result := Form.ShowModal;
  finally
    Form.Free;
  end;
end;

function CheckMDIForm;
var i: Integer;
begin
  Result := False;
  for i:=0 to Parent.MDIChildCount-1 do
    if UpperCase(Parent.MDIChildren[i].Name) = UpperCase(ChildName) then begin
      Result := True;
      exit;
    end;
end;

function ConfirmCancel(Caption: string): Boolean;
begin
  Result := Application.MessageBox(PChar(ConvertCodes(srFormCancel)),
                PChar(Caption), MB_ICONQUESTION+MB_OKCANCEL) = IDOK
end;

function Sign;
begin
  if Value = 0 then Result := 0 else
    if Value < 0 then Result := -1 else Result := 1;
end;

function RaisePower(Value,Power: Integer): Integer;
var i: Integer;
begin
  Result := 1;
  for i := 1 to Power do Result := Result*Value;
end;

function fPower(Value, Power: Extended): Extended;
begin
  Result := exp(Power*ln(Value));
end;

function fRound(X: Extended; Precision: Integer): Extended;
begin
  Result := Int(X*fPower(10,Precision)+Sign(X)*0.500000001)*fPower(10,-Precision);
end;

function SoftRound(X: Extended; Precision: Integer): Extended;
begin
  Result := fRound(X, Precision);
  if Result = 0 then Result := X;
end;

function IIF(Switch: Boolean; Var1,Var2: Variant): Variant;
{$IFDEF POLARIS_D4}overload;{$ENDIF}
begin
  if Switch then Result := Var1 else Result := Var2;
end;
{$IFDEF POLARIS_D4}
function IIF(Switch: Boolean; Var1,Var2: String): String; overload;
begin
  if Switch then Result := Var1 else Result := Var2;
end;
{$ENDIF}
procedure ActiveControls;
var i: Integer;
begin
  with Owner do
    for i:=0 to ControlCount-1 do
      if (Controls[i] is TWinControl) or
         (Controls[i] is TSpeedButton) then begin
        Controls[i].Enabled := Active;
      end;
end;

procedure AppHint;
begin
  with Application do
    if Assigned(OnHint) then begin
      Hint := StrHint;
      OnHint(Application);
    end;
end;

function GetVersionInfo(VerList: TStrings; FileName: String {$IFDEF POLARIS_D4}= ''{$ENDIF}): Boolean;
const
  nItems = 11;
  ItemName: array[0..nItems] of String = (
    srVIComp, srVIFDesc, srVIFVer, srVIInt, srVICprt, srVITM,
    srVIFile, srVIProd, srVIProdV, srVIComm, srVIEmail, srVIHome);
var
  VersionBuffer, TempText: Pointer;
  VersionSize, Dummy: DWord;
  PSize, I: Integer;
begin
  Result := False;
  if not Assigned(VerList) then Exit;
  if FileName = '' then FileName := Application.ExeName;
  VerList.Clear;
  VersionSize := GetFileVersionInfoSize(PChar(FileName),Dummy);
  if VersionSize <> 0 then begin
    PSize := VersionSize;
    GetMem(VersionBuffer,PSize);
    try
      if GetFileVersionInfo(PChar(FileName),Dummy,VersionSize,VersionBuffer) and
         VerQueryValue(VersionBuffer,'\VarFileInfo\Translation',TempText,VersionSize)
      then begin
        s := '\StringfileInfo\'+IntToHex(PWord(TempText)^,4)+IntToHex(PWord(Integer(TempText)+2)^,4)+'\';
        for I := 0 to nItems do
          if VerQueryValue(VersionBuffer,
                           PChar(s+ItemName[I]),
                           TempText,VersionSize)
          then VerList.Values[ItemName[I]] := PChar(TempText);
      end;
    finally
      FreeMem(VersionBuffer,PSize);
    end;
  end;
end;

function LoadToImage(Handle: THandle; ResName: PChar; ResKind: TBitmapResKind; Image: TImageList): Boolean;
var
  Bmp: TBitmap;
begin
  Result := False;
  if Assigned(Image)
  then begin
    Bmp := TBitmap.Create;
    try
      LoadBitmapFromResource(Bmp,Handle,ResName,ResKind);
      Image.AddMasked(Bmp,Bmp.TransparentColor);
      Result := True;
    finally
      Bmp.Free;
    end
  end
end;

function MaxDate(const D: array of TDate): TDate;
begin
  n := High(D);
  if n-Low(D) > 0 then begin
    Result := D[Low(D)];
    I := Low(D);
    repeat
      if D[I] > Result
      then Result := D[I];
      Inc(I);
    until I > n;
  end else Result := 0;
end;

function MinDate(const D: array of TDate): TDate;
begin
  n := High(D);
  if n-Low(D) > 0 then begin
    Result := D[Low(D)];
    I := Low(D);
    repeat
      if D[I] < Result
      then Result := D[I];
      Inc(I);
    until I > n;
  end else Result := 0;
end;

procedure DrawImage(Canvas: TCanvas; Rect: TRect; Images: TImageList; Index: Integer);
begin
  Canvas.FillRect(Rect);
  if Index < 0
  then Exit;
  if ((Rect.Right-Rect.Left+2)>=Images.Width)
  then
    Images.Draw(Canvas,(Rect.Right+Rect.Left-Images.Width-2) shr 1,
                       (Rect.Top+Rect.Bottom-Images.Height) shr 1, Index);
end;

function GetRealIndex(Items: TStrings; FirstIndex: Integer; S: string): Integer;
var i: Integer;
begin
  Result := FirstIndex;
  if Items[FirstIndex] <> S then
    for i:=Max(FirstIndex,0) to Items.Count-1 do
      if Items[i] = S then begin
        Result := i;
        exit;
      end;
end;

end.
