//==============================================
//       polarisreg.pas
//
//         Delphi.
//      DesignTime ()    .
//
//      Copyright 1998-2000 Polaris Software
//      http://members.xoom.com/PolarisSoft
//      mailto: PolarisLib@mail.ru
//==============================================
unit PolarisReg;

{$I POLARIS.INC}

interface

procedure Register;

implementation

{$R *.DCR}

uses Classes, DsgnIntf, {$IFDEF POLARIS_D5}DBReg,{$ENDIF}
     DBrSpeedButton,DBrBitBtn,DBSpinEdit,DBStaticText,rDBEdit,rLocateDlg,
     rButtons, rSpeedButton, ErrorMes, Launch, rBkgnd, rPgSetup,
     rPeriod, rLabel, rSetupFields, rDLLloader
     {$IFDEF POLARIS_D4}, rAction, ActnList, rMenuBar{$ENDIF}
     {$IFDEF BDE}, CrossTable, DBMore, rDBConnect{$ENDIF}, rDBGrid;

type
{$IFNDEF POLARIS_D5}
  TDBStringProperty = class(TStringProperty)
  public
    function GetAttributes: TPropertyAttributes; override;
    procedure GetValueList(List: TStrings); virtual;
    procedure GetValues(Proc: TGetStrProc); override;
  end;
{$ENDIF}

{ TrCrossTable }
  { TSourceFieldProperty }
  TSourceFieldProperty = class(TDBStringProperty)
    function GetDictionaryPropName: string; virtual;
    procedure GetValueList(List: TStrings); override;
  end;

{$IFDEF BDE}
  { TDriversProperty }
  TDriversProperty = class(TDBStringProperty)
  public
    procedure GetValueList(List: TStrings); override;
  end;

  { TLookupFieldProperty }
  TLookupFieldProperty = class(TSourceFieldProperty)
    procedure GetValueList(List: TStrings); override;
  end;
{$ENDIF}
{ TDBrSpeedButton }
  { TSBControlFieldProperty }
  TSBControlFieldProperty = class(TSourceFieldProperty)
    procedure GetValueList(List: TStrings); override;
  end;

{ TDBrBitBtn }
  { TBBControlFieldProperty }
  TBBControlFieldProperty = class(TSourceFieldProperty)
    procedure GetValueList(List: TStrings); override;
  end;

{$IFDEF POLARIS_D4}
{ TrDBActions }
  { TrAControlFieldProperty }
  TrAControlFieldProperty = class(TSourceFieldProperty)
    procedure GetValueList(List: TStrings); override;
  end;
{$ENDIF}

procedure Register;
begin
  RegisterComponents('Polaris DB',
    [TrDBEdit, TDBrSpeedButton, TDBNULLSpeedButton,
     TDBrBitBtn, TDBNULLButton, TDBSwitchButton,
     TDBSpinEdit, TDBStaticText, TrLocateDlg,
     TrSetupFields{$IFDEF BDE}, TrCloneTable, TrCrossTable, TrDBConnect{$ENDIF},
     TrDBGrid]);
  RegisterComponents('Polaris',
    [TrSpeedButton, TrSeparator, TrLabel, TrBitBtn, TErrorHandler, TLauncher,
     TrPeriodComboEdit, TrPageSetupDialog, {$IFDEF POLARIS_D4}TrMenuBar,{$ENDIF}
     TrBackground, TrDLLloader]);
{$IFDEF POLARIS_D4}
  RegisterActions('Polaris DB',[TrDBActions], nil);
{$ENDIF}
{$IFDEF BDE}
{ TrDBConnect }
  RegisterPropertyEditor(TypeInfo(String), TrDBConnect, 'Drivers',
                         TDriversProperty);
{ TrCrossTable }
  RegisterPropertyEditor(TypeInfo(String), TrCrossTable, 'RowFieldName',
                         TSourceFieldProperty);

  RegisterPropertyEditor(TypeInfo(String), TrCrossTable, 'ColFieldName',
                         TSourceFieldProperty);

  RegisterPropertyEditor(TypeInfo(String), TrCrossTable, 'DataFieldName',
                         TSourceFieldProperty);

  RegisterPropertyEditor(TypeInfo(String), TrCrossTable, 'ColLookupFieldName',
                         TLookupFieldProperty);

  RegisterPropertyEditor(TypeInfo(String), TrCrossTable, 'ColResultFieldName',
                         TLookupFieldProperty);
{$ENDIF}
{ TDBrSpeedButton }
  RegisterPropertyEditor(TypeInfo(String), TDBrSpeedButton, 'ControlDataField',
                         TSBControlFieldProperty);

{ TDBrBitBtn }
  RegisterPropertyEditor(TypeInfo(String), TDBrBitBtn, 'ControlDataField',
                         TBBControlFieldProperty);

{$IFDEF POLARIS_D4}
{ TrActions }
  RegisterPropertyEditor(TypeInfo(String), TrDBActions, 'ControlDataField',
                         TrAControlFieldProperty);
{$ENDIF}
end;

{$IFNDEF POLARIS_D5}
{ TDBStringProperty }
function TDBStringProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paValueList, paSortList, paMultiSelect];
end;

procedure TDBStringProperty.GetValueList(List: TStrings);
begin
end;

procedure TDBStringProperty.GetValues(Proc: TGetStrProc);
var
  I: Integer;
  Values: TStringList;
begin
  Values := TStringList.Create;
  try
    GetValueList(Values);
    for I := 0 to Values.Count - 1 do Proc(Values[I]);
  finally
    Values.Free;
  end;
end;
{$ENDIF}

{ TSourceFieldProperty }
function TSourceFieldProperty.GetDictionaryPropName: string;
begin
  Result := 'DictionaryItem';
end;

procedure TSourceFieldProperty.GetValueList(List: TStrings);
{$IFDEF BDE}
var
  CrossTable: TrCrossTable;
{$ENDIF}
begin
{$IFDEF BDE}
  CrossTable := TrCrossTable(GetComponent(0));
  if (CrossTable <> nil) and (CrossTable.SourceDataSet <> nil) then
   CrossTable.SourceDataSet.GetFieldNames(List);
{$ENDIF}
end;

{$IFDEF BDE}
procedure TDriversProperty.GetValueList(List: TStrings);
begin
  (GetComponent(0) as TrDBConnect).Database.Session.GetDriverNames(List);
end;

procedure TLookupFieldProperty.GetValueList(List: TStrings);
var
  CrossTable: TrCrossTable;
begin
  CrossTable := TrCrossTable(GetComponent(0));
  if (CrossTable <> nil) and (CrossTable.ColLookUpDataSet <> nil) then
    CrossTable.ColLookUpDataSet.GetFieldNames(List);
end;
{$ENDIF}

{ TDBrSpeedButton }
procedure TSBControlFieldProperty.GetValueList(List: TStrings);
var
  SB: TDBrSpeedButton;
begin
  SB := TDBrSpeedButton(GetComponent(0));
  if (SB <> nil) and (SB.ControlDataSource <> nil) and
     (SB.ControlDataSource.DataSet <> nil) then
    SB.ControlDataSource.DataSet.GetFieldNames(List);
end;

{ TDBrBitBtn }
procedure TBBControlFieldProperty.GetValueList(List: TStrings);
var
  BB: TDBrBitBtn;
begin
  BB := TDBrBitBtn(GetComponent(0));
  if (BB <> nil) and (BB.ControlDataSource <> nil) and
     (BB.ControlDataSource.DataSet <> nil) then
    BB.ControlDataSource.DataSet.GetFieldNames(List);
end;

{$IFDEF POLARIS_D4}
{ TrDBActions }
procedure TrAControlFieldProperty.GetValueList(List: TStrings);
var
  rA: TrDBActions;
begin
  rA := TrDBActions(GetComponent(0));
  if (rA <> nil) and (rA.ControlDataSource <> nil) and
     (rA.ControlDataSource.DataSet <> nil) then
    rA.ControlDataSource.DataSet.GetFieldNames(List);
end;
{$ENDIF}
end.