//==============================================
//       dbtreereg.pas
//
//         Delphi.
//      DesignTime  TrDBxxxxTree-.
//
//      Copyright 1998-2000 Polaris Software
//      http://members.xoom.com/PolarisSoft
//      mailto: PolarisLib@mail.ru
//==============================================
unit DBTreeReg;

{$I POLARIS.INC}

interface

uses Classes, TypInfo, DsgnIntf, SysUtils, DB, rDBTreeView;

procedure Register;

implementation

type
  TrDBStringProperty = class(TStringProperty)
  public
    function GetAttributes: TPropertyAttributes; override;
    procedure GetValueList(List: TStrings); virtual;
    procedure GetValues(Proc: TGetStrProc); override;
  end;

  TrTreeDataFieldProperty = class(TrDBStringProperty)
  public
    procedure GetValueList(List: TStrings); override;
    function GetDataSourcePropName: string; virtual;
  end;

  TrTreeLookupFieldProperty = class(TrDBStringProperty)
  public
    procedure GetValueList(List: TStrings); override;
    function GetDataSourcePropName: string; virtual;
  end;

function TrDBStringProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paValueList, paSortList, paMultiSelect];
end;

procedure TrDBStringProperty.GetValues(Proc: TGetStrProc);
var
  I: Integer;
  Values: TStringList;
begin
  Values := TStringList.Create;
  try
    GetValueList(Values);
    for I := 0 to Values.Count - 1 do Proc(Values[I]);
  finally
    Values.Free;
  end;
end;

procedure TrDBStringProperty.GetValueList(List: TStrings);
begin
end;

function TrTreeDataFieldProperty.GetDataSourcePropName: string;
begin
//  Result := 'LookupSource';
  Result := 'DataSource';
end;

procedure TrTreeDataFieldProperty.GetValueList(List: TStrings);
var
  Instance: TComponent;
  PropInfo: PPropInfo;
  DataSource: TDataSource;
begin
  Instance := TComponent(GetComponent(0));
  PropInfo := TypInfo.GetPropInfo(Instance.ClassInfo, GetDataSourcePropName);
  if (PropInfo <> nil) and (PropInfo^.PropType^.Kind = tkClass) then
  begin
    DataSource := TObject(GetOrdProp(Instance, PropInfo)) as TDataSource;
    if (DataSource <> nil) and (DataSource.DataSet <> nil) then
      DataSource.DataSet.GetFieldNames(List);
  end;
end;

function TrTreeLookupFieldProperty.GetDataSourcePropName: string;
begin
  Result := 'LookupSource';
end;

procedure TrTreeLookupFieldProperty.GetValueList(List: TStrings);
var
  Instance: TComponent;
  PropInfo: PPropInfo;
  DataSource: TDataSource;
begin
  Instance := TComponent(GetComponent(0));
  PropInfo := TypInfo.GetPropInfo(Instance.ClassInfo, GetDataSourcePropName);
  if (PropInfo <> nil) and (PropInfo^.PropType^.Kind = tkClass) then
  begin
    DataSource := TObject(GetOrdProp(Instance, PropInfo)) as TDataSource;
    if (DataSource <> nil) and (DataSource.DataSet <> nil) then
      DataSource.DataSet.GetFieldNames(List);
  end;
end;

procedure Register;
begin
  RegisterComponents('Polaris DB', [TrDBTreeView, TrDBLookupTree, TrDBLookupComboTree]);

  RegisterPropertyEditor(TypeInfo(string), TrDBTreeView, 'KeyField',
    TrTreeDataFieldProperty);
  RegisterPropertyEditor(TypeInfo(string), TrDBTreeView, 'ChildrenField',
    TrTreeDataFieldProperty);
  RegisterPropertyEditor(TypeInfo(string), TrDBTreeView, 'ParentField',
    TrTreeDataFieldProperty);
  RegisterPropertyEditor(TypeInfo(string), TrDBTreeView, 'DisplayFields',
    TrTreeDataFieldProperty);

  RegisterPropertyEditor(TypeInfo(string), TrDBLookupTree, 'DataField',
    TrTreeDataFieldProperty);
  RegisterPropertyEditor(TypeInfo(string), TrDBLookupTree, 'LookupField',
    TrTreeLookupFieldProperty);
  RegisterPropertyEditor(TypeInfo(string), TrDBLookupTree, 'ChildrenField',
    TrTreeLookupFieldProperty);
  RegisterPropertyEditor(TypeInfo(string), TrDBLookupTree, 'ParentField',
    TrTreeLookupFieldProperty);
  RegisterPropertyEditor(TypeInfo(string), TrDBLookupTree, 'LookupDisplay',
    TrTreeLookupFieldProperty);

  RegisterPropertyEditor(TypeInfo(string), TrDBLookupComboTree, 'DataField',
    TrTreeDataFieldProperty);
  RegisterPropertyEditor(TypeInfo(string), TrDBLookupComboTree, 'LookupField',
    TrTreeLookupFieldProperty);
  RegisterPropertyEditor(TypeInfo(string), TrDBLookupComboTree, 'ChildrenField',
    TrTreeLookupFieldProperty);
  RegisterPropertyEditor(TypeInfo(string), TrDBLookupComboTree, 'ParentField',
    TrTreeLookupFieldProperty);
  RegisterPropertyEditor(TypeInfo(string), TrDBLookupComboTree, 'LookupDisplay',
    TrTreeLookupFieldProperty);
end;

end.
