//==============================================
//       dbstatictext.pas
//
//         Delphi.
//      DBAware - TrLabel.
//
//      Copyright 1998-2000 Polaris Software
//      http://members.xoom.com/PolarisSoft
//      mailto: PolarisLib@mail.ru
//==============================================
unit DBStaticText;

{$I POLARIS.INC}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, DB, DBCtrls, rLabel, ExtCtrls;

type
  TDBStaticText = class(TrCustomLabel)
  private
    FDataLink: TFieldDataLink;
    procedure DataChange(Sender: TObject);
    function GetDataField: string;
    function GetDataSource: TDataSource;
    function GetField: TField;
    function GetFieldText: string;
    procedure SetDataField(const Value: string);
    procedure SetDataSource(Value: TDataSource);
    procedure CMGetDataLink(var Message: TMessage); message CM_GETDATALINK;
  protected
    procedure Loaded; override;
    procedure Notification(AComponent: TComponent;
      Operation: TOperation); override;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    property Field: TField read GetField;
  published
    property DataField: string read GetDataField write SetDataField;
    property DataSource: TDataSource read GetDataSource write SetDataSource;
    property Blink;
    property BlinkSpeed;
    property BlinkColor;
    property BlinkTopColor;
    property BlinkBottomColor;
    property BlinkTransparent;
    property RaisedTopColor;
    property RaisedBottomColor;
    property RaisedTopDistance;
    property RaisedBottomDistance;

    property BorderWidth;
    property BevelWidth;
    property BorderTransparent;
    property BevelOuter default bvLowered;
    property BevelInner;
    property Text3D default False;
    property AutoSize;

    property Enabled;
    property Align;
    property Alignment;
    property Color;
    property DragCursor;
    property DragMode;
    property FocusControl;
    property Font;
{$IFDEF POLARIS_D4}
    property Anchors;
    property BiDiMode;
    property Constraints;
    property DragKind;
    property ParentBiDiMode;
{$ENDIF}
    property Layout;
    property ParentColor;
    property ParentFont;
    property ParentShowHint;
    property PopupMenu;
    property ShowAccelChar;
    property ShowHint;
    property Transparent;
    property Visible;
    property WordWrap;
    property OnClick;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDrag;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property OnStartDrag;
{$IFDEF POLARIS_D4}
    property OnEndDock;
    property OnStartDock;
{$ENDIF}
  end;

implementation

constructor TDBStaticText.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  ControlStyle := ControlStyle + [csReplicatable];
  ShowAccelChar := False;
  BevelOuter := bvLowered;
  Text3D := False;
  FDataLink := TFieldDataLink.Create;
  FDataLink.Control := Self;
  FDataLink.OnDataChange := DataChange;
end;

destructor TDBStaticText.Destroy;
begin
  FDataLink.Free;
  FDataLink := nil;
  inherited Destroy;
end;

procedure TDBStaticText.Loaded;
begin
  inherited Loaded;
  if (csDesigning in ComponentState) then DataChange(Self);
end;

procedure TDBStaticText.Notification(AComponent: TComponent;
  Operation: TOperation);
begin
  inherited Notification(AComponent, Operation);
  if (Operation = opRemove) and (FDataLink <> nil) and
    (AComponent = DataSource) then DataSource := nil;
end;

function TDBStaticText.GetDataSource: TDataSource;
begin
  Result := FDataLink.DataSource;
end;

procedure TDBStaticText.SetDataSource(Value: TDataSource);
begin
  if not (FDataLink.DataSourceFixed and (csLoading in ComponentState)) then
    FDataLink.DataSource := Value;
  if Value <> nil then Value.FreeNotification(Self);
end;

function TDBStaticText.GetDataField: string;
begin
  Result := FDataLink.FieldName;
end;

procedure TDBStaticText.SetDataField(const Value: string);
begin
  FDataLink.FieldName := Value;
end;

function TDBStaticText.GetField: TField;
begin
  Result := FDataLink.Field;
end;

function TDBStaticText.GetFieldText: string;
begin
  if FDataLink.Field <> nil then
    Result := FDataLink.Field.DisplayText
  else
    if csDesigning in ComponentState then Result := Name else Result := '';
end;

procedure TDBStaticText.DataChange(Sender: TObject);
begin
  Caption := GetFieldText;
end;

procedure TDBStaticText.CMGetDataLink(var Message: TMessage);
begin
  Message.Result := Integer(FDataLink);
end;

end.
