//==============================================
//       dbmore.pas
//
//         Delphi.
//        .
//
//      Copyright 1998-2000 Polaris Software
//      http://members.xoom.com/PolarisSoft
//      mailto: PolarisLib@mail.ru
//==============================================
unit DBMore;

{$I POLARIS.INC}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Db, DBTables, BDE, rDBConst;

type
  TrCloneTable = class(TTable)
  private
    FSourceTable: TTable;
    procedure SetSourceTable(Value: TTable);
  protected
    function CreateHandle: HDBICur; override;
    procedure OpenCursor {$IFDEF POLARIS_D3}(InfoQuery: Boolean){$ENDIF}; override;
    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  published
    property SourceTable: TTable read FSourceTable write SetSourceTable;
  end;

implementation

{ TrCloneTable }

constructor TrCloneTable.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FSourceTable := nil;
end;

destructor TrCloneTable.Destroy;
begin
  FSourceTable := nil;
  inherited Destroy;
end;

procedure TrCloneTable.Notification(AComponent: TComponent;
  Operation: TOperation);
begin
  inherited Notification(AComponent, Operation);
  if Operation = opRemove then
    if FSourceTable = AComponent then FSourceTable := nil;
end;

procedure TrCloneTable.OpenCursor;
begin
  if FSourceTable <> nil then begin
    DatabaseName := FSourceTable.DatabaseName;
    if FSourceTable.ReadOnly then ReadOnly := True;
    TableName  := FSourceTable.TableName;
    TableType  := FSourceTable.TableType;
    UpdateMode := FSourceTable.UpdateMode;
  end;
  inherited OpenCursor{$IFDEF POLARIS_D3}(InfoQuery){$ENDIF};
end;

function TrCloneTable.CreateHandle: HDBICur;
begin
  if FSourceTable <> nil then
    if FSourceTable.Active then
      Check(DbiCloneCursor(FSourceTable.Handle, ReadOnly, False, Result))
    else
      raise EDatabaseError.CreateFmt(srCloneError, [FSourceTable.TableName])
  else Result := inherited CreateHandle;
end;

procedure TrCloneTable.SetSourceTable(Value: TTable);
begin
  if Value <> FSourceTable then begin
    CheckInActive;
    FSourceTable := Value;
    if Value <> nil then Value.FreeNotification(Self);
  end;
end;

end.
