unit main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    BTN_Compare: TButton;
    ED_Pattern: TEdit;
    ED_String: TEdit;
    ED_Result: TEdit;
    Label1: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    RG_Case: TRadioGroup;
    RG_Style: TRadioGroup;
    RichEdit1: TRichEdit;
    BTN_CompareTimes: TButton;
    LB_Time: TLabel;
    procedure BTN_CompareClick(Sender: TObject);
    procedure BTN_CompareTimesClick(Sender: TObject);
  private
    { Private-Deklarationen}
  public
    { Public-Deklarationen}
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}
uses PMatch;


procedure TForm1.BTN_CompareClick(Sender: TObject);
var
  res : Integer;
  Pattern: string;
  str: string;
begin
  Pattern := ED_Pattern.Text;
  str := ED_String.Text;

  if RG_Case.ItemIndex = 1 then
  begin
   Pattern := Uppercase(Pattern);
   str := Uppercase(str);
  end;

  res := SMatch(pattern,str,(RG_Style.ItemIndex = 0) );
  case res of
    1 : ED_Result.Text := 'OK';
    0 : ED_Result.Text := 'FALSE';
    else
      ED_Result.Text := 'Error';
  end;
end;


procedure TForm1.BTN_CompareTimesClick(Sender: TObject);
var
  res : Integer;
  Pattern: string;
  str: string;
  start : DWord;
  i: integer;
begin
  Pattern := ED_Pattern.Text;
  str := ED_String.Text;

  if RG_Case.ItemIndex = 1 then
  begin
   Pattern := Uppercase(Pattern);
   str := Uppercase(str);
  end;

  start := GetTickCount;
  for i:= 0 to 100000 do
  begin
    res := SMatch(pattern,str,(RG_Style.ItemIndex = 0) );
  end;
  LB_Time.Caption :=  format('Time:%d ms',[GetTickCount-start]);
  case res of
    1 : ED_Result.Text := 'OK';
    0 : ED_Result.Text := 'FALSE';
    else
      ED_Result.Text := 'Error';
  end;
end;

end.


