(*******************************************************************************
Patternmatch Library to compare strings with a pattern in Dos or Unix Style.

Autor: Matthias Zartmann
Email: Matthias.Zartmann@gmx.de
Date: 19.08.1999
Version: 1.0
Copyright: Matthias Zartmann (1999)
Status: Freeware (if you find the Unit useful please send a mail)

History:
1.0   First Release

*******************************************************************************)
unit PMatch;


interface

function SMatch(const pattern, str: string; UnixStyle: Boolean):Integer;
function ZMatch( Pattern, Str: Pchar; UnixStyle: Boolean):Integer;

implementation

function SMatch(const pattern, str: string; UnixStyle: Boolean):Integer;
begin
  result := ZMatch( PChar(Pattern), PChar(Str), UnixStyle);
end;


{****************************************************************
Patternmatch (very fast) (Dos/Unix Style)
Wildcards: * ?
if Unixstyle then the Range is enabled
  Range    : [a-z] or [^a-z] or [!a-z] or [azert] or [a-ey-z] .......
In:
  Pattern  : Pattern see below
  Str      : String to compare
  Unixstyle: Range enabled/disabled
Result:
  0 = No Match
  1 = Match
  2 = Expr Error
*****************************************************************}
function ZMatch( Pattern, Str: Pchar; UnixStyle: Boolean):Integer;
var
  c: char;
  Reverse: Boolean;
  q: Pchar;
  e: Boolean;
  cc: char;
begin

  c := pattern^;
  inc(pattern);
  // If that was the end of the pattern, match if string empty too
  if (c = #0) then
  begin
    result :=  Integer(str[0] = #0);
    exit;
  end;

  // '?'  matches any character (but not an empty string) */

  if (c = '?') then
  begin
    if str^ <> #0 then
      result := ZMatch(pattern, str + 1, UnixStyle)
    else
      result := 0;
    exit;
  end;

  // '*' matches any number of characters, including zero
  if (c = '*') then
  begin
    if (pattern^ = #0) then  //Last char. in the Pattern then match
    begin
      result := 1;
      exit;
    end;

    while str^ <> #0 do
    begin
      result := ZMatch(pattern, str,UnixStyle);
      if (result <> 0) then
        exit;
      inc(str);
    end;
    result := 0;       // 2 means give up--match will return false
    exit;
  end;

  if (UnixStyle) and (c = '[') then
  begin
    if str^ = #0 then
    begin
       Result := 0;
       exit;
    end;
    if (pattern^ ='!') or (pattern^ = '^') then
    begin
      Reverse := TRUE;
      inc(pattern);
    end
    else
      Reverse := FALSE;

    q := pattern;
    e := FALSE;
    while e = FALSE do
    begin
      if e  then
        e := False
      else
      begin
        if q^ = '\' then
          e := TRUE
        else
        begin
          if q^ = ']' then
            break;
        end;
      end;
      inc(q);
    end;

    if (q^ <> ']') then            // nothing matches if bad syntax
    begin
      result := 2;
      exit;
    end;

    c := #0;
    e := ('-' = (Pattern^));

    while (pattern < q) do
    begin
      if (e = FALSE) and (pattern^ = '\') then             // set escape flag if \
         e := TRUE
      else
      begin
        if (e = FALSE) and (pattern^ = '-') then         // set start of range if -
          c := (pattern-1)^
        else
        begin
          cc := str^;
          if ((pattern+1)^ <> '-') then
          begin
             if c = #0 then
               c := pattern^;
             while c <= Pattern^ do
             begin
               if c = cc then
               begin
                 if Reverse then
                   result := 0
                 else
                   result := ZMatch(q + 1, str + 1,UnixStyle);
                 exit;
               end;
               inc(c);
             end;
             c := #0;  // clear range, escape flags
             e := FALSE;
          end;
        end;
      end;
      inc(pattern);
    end;
    if Reverse then
     result := ZMatch(q + 1, str + 1,UnixStyle)
    else
     result := 0;
    exit;
  end;

  if (c = '\') then
  begin
    if ((pattern^ = '*') or
        (pattern^ = '?') or
        (UnixStyle and ((pattern^ = '[')or (pattern^ = '\'))) ) then
    begin
      c := pattern^;
      inc(pattern);
    end;
  end;

  result :=  Integer(c = str^);
  if result = 1 then
  begin
    result := ZMatch(pattern, str + 1,UnixStyle);
  end;
end;


end.
