unit PgWhois;

interface

Uses Windows,Classes,SysUtils,WinSock;

Type

  TAfterNetworkOperation = Procedure(Sender : TObject;TheResult : Boolean;ErrorNumb : Integer) OF Object;

  TPgWhois = Class(TComponent)
  Private
    FHostIPAddress : String;
    FHostName      : String;
    FRequest       : String;
    FBeforeResolvingName     : TNotifyEvent;
    FAfterResolvingName      : TAfterNetworkOperation;
    FBeforeConnect           : TNotifyEvent;
    FAfterConnect            : TAfterNetworkOperation;
    FBeforeSendInformation   : TNotifyEvent;
    FAfterSendInformation    : TAfterNetworkOperation;
    FBeforeReciveInformation : TNotifyEvent;
    FAfterReciveInformation  : TAfterNetworkOperation;
    Procedure SetHostIPAddress(Value : String);
    Procedure SetHostName(Value : String);
    Function  GetInfo(IPAddress, WhoisInfo : String;Var S : String) : Integer;
  Public
    Function  ResolveName(Address:string;Var IP : String):Integer;
    Function  Whois : String;
    Function  ErrorMessage(ErrorNumb : Integer) : String;
  Published
    Property HostIPAddress : String Read FHostIPAddress Write SetHostIPAddress;
    Property HostName      : String Read FHostName      Write SetHostName;
    Property Request       : String Read FRequest       Write FRequest;
    Property BeforeResolvingName     : TNotifyEvent           Read FBeforeResolvingName     Write FBeforeResolvingName;
    Property AfterResolvingName      : TAfterNetworkOperation Read FAfterResolvingName      Write FAfterResolvingName;
    Property BeforeConnect           : TNotifyEvent           Read FBeforeConnect           Write FBeforeConnect;
    Property AfterConnect            : TAfterNetworkOperation Read FAfterConnect            Write FAfterConnect;
    Property BeforeSendInformation   : TNotifyEvent           Read FBeforeSendInformation   Write FBeforeSendInformation;
    Property AfterSendInformation    : TAfterNetworkOperation Read FAfterSendInformation    Write FAfterSendInformation;
    Property BeforeReciveInformation : TNotifyEvent           Read FBeforeReciveInformation Write FBeforeReciveInformation;
    Property AfterReciveInformation  : TAfterNetworkOperation Read FAfterReciveInformation  Write FAfterReciveInformation;
  End;

Procedure Register;

implementation

Procedure TPgWhois.SetHostIPAddress(Value : String);
Begin
  FHostIPAddress := Value;
  FHostName       := '';
End;

Procedure TPgWhois.SetHostName(Value : String);
Begin
  FHostName := Value;
  FHostIPAddress := '';
End;

Function TPgWhois.Whois : String;
Var
  S : String;
  I : Integer;
Begin
  IF FHostIPAddress <> '' Then
    S := FHostIPAddress
  Else
  Begin
    I := ResolveName(FHostName,S);
    IF S = '' Then
    Begin
      Result := ErrorMessage(I);
      Exit;
    End;
  End;
  I := GetInfo(S,FRequest,Result);
  IF Result = '' Then
    Result := ErrorMessage(I);
End;

Function TPgWhois.GetInfo(IPAddress, WhoisInfo : String;Var S : String) : Integer;
Var
  nListen_sd,nRc,nChars : Integer;
  wVersionRequested : Word;
  aWSADATA          : WSADATA;
  server_addr       : TSockAddrIn;
  RecvBuff          : Array [0 .. 499] OF Char;
  PIPAddress,
  PWhoisInfo        : Array [0..49] OF Char;
Begin
  //Initialize error property
  wVersionRequested := MAKEWORD(1,1);
  S := '';
  StrPCopy(PIPAddress,IPAddress);
  StrPCopy(PWhoisInfo,WhoisInfo);
  Result := WSAStartup( wVersionRequested, aWSADATA );
  IF Result <> 0  Then
    Result := WSAGetLastError() - WSABASEERR
  Else
  Begin
    //Open a socket and get a handle
    nListen_sd := socket(AF_INET, SOCK_STREAM, 0);
    IF nListen_sd < 0 Then
      Result := WSAGetLastError() - WSABASEERR
    Else
    Begin
      //Prepare the address structure
      server_addr.sin_family      := AF_INET;
      server_addr.sin_addr.s_addr := inet_addr(PIPAddress);
      server_addr.sin_port        := htons(IPPORT_WHOIS);

      //Connect to a remote address
      IF Assigned(FBeforeConnect) Then
        FBeforeConnect(Self);
      nRc := connect(nListen_sd, server_addr,
             sizeof(server_addr));
      IF Assigned(FAfterConnect) Then
        FAfterConnect(Self,nRC <> -1,nRc);
      IF nRc = -1 Then
        Result := WSAGetLastError() - WSABASEERR
      Else
      Begin
        //Prepare the name for submission and make a request for the
        //	address of the named host
        strcat(PWhoisInfo,#10+#13);
        IF Assigned(FBeforeSendInformation) Then
          FBeforeSendInformation(Self);
        Result := send(nListen_sd, PWhoisInfo, Length(WhoisInfo) + 1, 0);
        IF Assigned(FAfterSendInformation) Then
          FAfterSendInformation(Self,Result <> -1,Result);
        IF  Result  = -1 Then
          Result := WSAGetLastError() - WSABASEERR
        Else
        Begin
          IF Assigned(FBeforeReciveInformation) Then
            FBeforeReciveInformation(Self);
          Repeat
            FillChar(RecvBuff,sizeof(RecvBuff),#0);
            nChars := recv(nListen_sd,RecvBuff,sizeof(RecvBuff),0);
            Case nChars Of
             -1 : Result := WSAGetLastError() - WSABASEERR;
              0 : Break;
            Else
              S := S + RecvBuff;
            End;
          Until nChars <= 0;
          IF Assigned(FAfterReciveInformation) Then
            FAfterReciveInformation(Self,nChars <> -1,Result);
        End;
      End;
      shutdown(nListen_sd,0);
    End;
    CloseSocket(nListen_sd);
  End;
  WSACleanup();
End;

Function TPgWhois.ResolveName(Address:string;Var IP : String):Integer;
var
 i,
 j:Integer;
 theinfo:PHostEnt;
 s1:string;
 c:char;
 wVersionRequested : Word;
 aWSADATA          : WSADATA;
 Found             : Boolean;
Begin
  IF Assigned(FBeforeResolvingName) Then
    FBeforeResolvingName(Self);
  wVersionRequested := MAKEWORD(1,1);
  IP := '';
  Result := WSAStartup( wVersionRequested, aWSADATA );
  Found  := False;
  IF Result <> 0  Then
    Result := WSAGetLastError() - WSABASEERR
  Else
  Begin
    theinfo := Gethostbyname(PChar(Address));
    if theinfo = nil then
      Result := WSAGetLastError() - WSABASEERR
    Else
    Begin
      i:=theinfo.h_length;
      for j:=0 to i-1 do
      begin
        S1:=theinfo.h_addr^[j];
        C:=S1[1];
        IP:=IP+'.'+IntToStr(Ord(C));
      end;
      Delete(IP,1,1);
      Found := True;
    End;
  End;
  WSACleanup();
  IF Assigned(FAfterResolvingName) Then
    FAfterResolvingName(Self,Found,Result);
End;

Function  TPgWhois.ErrorMessage(ErrorNumb : Integer) : String;
Begin
  Case (ErrorNumb + WSABASEERR )OF
    WSAEINTR           : Result := 'Error WSAEINTR';
    WSAEBADF           : Result := 'Error WSAEBADF';
    WSAEACCES          : Result := 'Error WSAEACCES';
    WSAEFAULT          : Result := 'Error WSAEFAULT';
    WSAEINVAL          : Result := 'Error WSAEINVAL';
    WSAEMFILE          : Result := 'Error WSAEMFILE';
    WSAEWOULDBLOCK     : Result := 'Error WSAEWOULDBLOCK';
    WSAEINPROGRESS     : Result := 'Error WSAEINPROGRESS';
    WSAEALREADY        : Result := 'Error WSAEALREADY';
    WSAENOTSOCK        : Result := 'Error WSAENOTSOCK';
    WSAEDESTADDRREQ    : Result := 'Error WSAEDESTADDRREQ';
    WSAEMSGSIZE        : Result := 'Error WSAEMSGSIZE';
    WSAEPROTOTYPE      : Result := 'Error WSAEPROTOTYPE';
    WSAENOPROTOOPT     : Result := 'Error WSAENOPROTOOPT';
    WSAEPROTONOSUPPORT : Result := 'Error WSAEPROTONOSUPPORT';
    WSAESOCKTNOSUPPORT : Result := 'Error WSAESOCKTNOSUPPORT';
    WSAEOPNOTSUPP      : Result := 'Error WSAEOPNOTSUPP';
    WSAEPFNOSUPPORT    : Result := 'Error WSAEPFNOSUPPORT';
    WSAEAFNOSUPPORT    : Result := 'Error WSAEAFNOSUPPORT';
    WSAEADDRINUSE      : Result := 'Error WSAEADDRINUSE';
    WSAEADDRNOTAVAIL   : Result := 'Error WSAEADDRNOTAVAIL';
    WSAENETDOWN        : Result := 'Error WSAENETDOWN';
    WSAENETUNREACH     : Result := 'Error WSAENETUNREACH';
    WSAENETRESET       : Result := 'Error WSAENETRESET';
    WSAECONNABORTED    : Result := 'Error WSAECONNABORTED';
    WSAECONNRESET      : Result := 'Error WSAECONNRESET';
    WSAENOBUFS         : Result := 'Error WSAENOBUFS';
    WSAEISCONN         : Result := 'Error WSAEISCONN';
    WSAENOTCONN        : Result := 'Error WSAENOTCONN';
    WSAESHUTDOWN       : Result := 'Error WSAESHUTDOWN';
    WSAETOOMANYREFS    : Result := 'Error WSAETOOMANYREFS';
    WSAETIMEDOUT       : Result := 'Error WSAETIMEDOUT';
    WSAECONNREFUSED    : Result := 'Error WSAECONNREFUSED';
    WSAELOOP           : Result := 'Error WSAELOOP';
    WSAENAMETOOLONG    : Result := 'Error WSAENAMETOOLONG';
    WSAEHOSTDOWN       : Result := 'Error WSAEHOSTDOWN';
    WSAEHOSTUNREACH    : Result := 'Error WSAEHOSTUNREACH';
    WSAENOTEMPTY       : Result := 'Error WSAENOTEMPTY';
    WSAEPROCLIM        : Result := 'Error WSAEPROCLIM';
    WSAEUSERS          : Result := 'Error WSAEUSERS';
    WSAEDQUOT          : Result := 'Error WSAEDQUOT';
    WSAESTALE          : Result := 'Error WSAESTALE';
    WSAEREMOTE         : Result := 'Error WSAEREMOTE';
    WSAEDISCON         : Result := 'Error WSAEDISCON';
    WSASYSNOTREADY     : Result := 'Error WSASYSNOTREADY';
    WSAVERNOTSUPPORTED : Result := 'Error WSAVERNOTSUPPORTED';
    WSANOTINITIALISED  : Result := 'Error WSANOTINITIALISED';
    WSAHOST_NOT_FOUND  : Result := 'Error WSAHOST_NOT_FOUND';
    WSATRY_AGAIN       : Result := 'Error WSATRY_AGAIN';
    WSANO_RECOVERY     : Result := 'Error WSANO_RECOVERY';
    WSANO_DATA         : Result := 'Error WSANO_DATA';
  End;
End;

Procedure Register;
Begin
  RegisterComponents('Pragena',[TPgWhois]);
End;

end.
