{Ŀ
                           SP Software Development                          
 Ĵ
                     Copyright,(C) 1999 Petrus van Breda.                   
                        All Rights Reserved Worldwide                       
 Ĵ
               This source code is the exclusive property of:               
                            SP Software Development.                        
                             P.O.Box 9254, Edleen                           
                             1625, South Africa                             
 Ĵ
         Unauthorized distribution or disclosure of this source code        
                  or modification or removal of this notice                 
                constitutes a breach of the license agreement               
 }

unit SPPageControl;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls;

type
  TSPPageControl = class(TPageControl)
  private
    { Private declarations }
   function GetPageindex: integer;
   procedure SetPageindex(const Value: integer);
  protected
    { Protected declarations }
  public
    { Public declarations }
   constructor Create(AOwner: TComponent);override;
   destructor Destroy;override;
  published
    { Published declarations }
   property Pageindex: integer read GetPageindex write SetPageindex stored false;
  end;

procedure Register;

implementation

constructor TSPPageControl.Create(AOwner: TComponent);

begin
 inherited Create(AOwner);
 {Align := alClient;}
 HotTrack := True;
 Multiline := True;
 TabPosition := tpBottom;
 ShowHint := True;
end;

destructor TSPPageControl.Destroy;
begin
 inherited Destroy;
end;

function TSPPageControl.GetPageindex: integer;
var x: integer;
begin
  result:= -1;
  for x:= 0 to PageCount-1 do
    if Pages[x].Caption = ActivePage.Caption then
    begin
      result:= x;
      break;
    end;
end;

procedure TSPPageControl.SetPageindex(const Value: integer);
begin
  ActivePage:= Pages[Value];
end;

procedure Register;
begin
  RegisterComponents('SPSoft', [TSPPageControl]);
end;

end.
