// Borland C++ Builder
// Copyright (c) 1995, 1999 by Borland International
// All rights reserved

// (DO NOT EDIT: machine generated header) 'PerfMonitor.pas' rev: 4.00

#ifndef PerfMonitorHPP
#define PerfMonitorHPP

#pragma delphiheader begin
#pragma option push -w-
#include <PerfTitles.hpp>	// Pascal unit
#include <WinPerfUtils.hpp>	// Pascal unit
#include <WinPerf.hpp>	// Pascal unit
#include <PerfFilter.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <SysUtils.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <System.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Perfmonitor
{
//-- type declarations -------------------------------------------------------
class DELPHICLASS TPerfMonitorCounterValue;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TPerfMonitorCounterValue : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	unsigned _CounterType;
	bool _HasBase;
	bool _IsUsed;
	AnsiString _InstanceName;
	AnsiString _ObjectKeyValue;
	Classes::TNotifyEvent _OnDestroy;
	bool _PrevAvailable;
	int _RefreshCount;
	__int64 _FirstCounter;
	__int64 _FirstBase;
	__int64 _PrevCounter;
	__int64 _PrevBase;
	__int64 _Counter;
	__int64 _Base;
	__int64 _SysTime;
	__int64 _DeltaSysTime;
	__int64 _TotalSysTime;
	Extended __fastcall GetAsFloat(void);
	Extended __fastcall GetAvgAsFloat(void);
	__int64 __fastcall GetAsInteger(void);
	__int64 __fastcall GetAvgAsInteger(void);
	AnsiString __fastcall GetAsString();
	AnsiString __fastcall GetAvgAsString();
	
public:
	__property unsigned CounterType = {read=_CounterType, nodefault};
	__property int RefreshCount = {read=_RefreshCount, nodefault};
	__property __int64 FirstCounter = {read=_FirstCounter};
	__property __int64 FirstBase = {read=_FirstBase};
	__property __int64 PrevCounter = {read=_PrevCounter};
	__property __int64 PrevBase = {read=_PrevBase};
	__property __int64 Counter = {read=_Counter};
	__property __int64 Base = {read=_Base};
	__property bool HasBase = {read=_HasBase, nodefault};
	__property AnsiString ObjectKeyValue = {read=_ObjectKeyValue};
	__property AnsiString InstanceName = {read=_InstanceName};
	__property Classes::TNotifyEvent OnDestroy = {read=_OnDestroy, write=_OnDestroy};
	__property bool PrevAvailable = {read=_PrevAvailable, nodefault};
	__property Extended AsFloat = {read=GetAsFloat};
	__property Extended AvgAsFloat = {read=GetAvgAsFloat};
	__property __int64 AsInteger = {read=GetAsInteger};
	__property __int64 AvgAsInteger = {read=GetAvgAsInteger};
	__property AnsiString AsString = {read=GetAsString};
	__property AnsiString AvgAsString = {read=GetAvgAsString};
public:
	#pragma option push -w-inl
	/* TObject.Create */ inline __fastcall TPerfMonitorCounterValue(void) : System::TObject() { }
	#pragma option pop
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TPerfMonitorCounterValue(void) { }
	#pragma option pop
	
};

#pragma pack(pop)

class DELPHICLASS TPerfMonitorItem;
class DELPHICLASS TPerfMonitor;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TPerfMonitorItem : public Classes::TCollectionItem 
{
	typedef Classes::TCollectionItem inherited;
	
private:
	AnsiString _ObjectKey;
	Classes::TList* _KeyCounters;
	Classes::TList* _InstanceValues;
	TPerfMonitorCounterValue* _NoInstanceValue;
	void __fastcall CreateKeyCounters(void);
	void __fastcall FreeKeyCounters(void);
	AnsiString _CounterName;
	AnsiString _ObjectName;
	Perffilter::TPerfCounterItem* _Counter;
	Perffilter::TPerfCounterItem* __fastcall Counter(void);
	AnsiString __fastcall GetObjectName();
	void __fastcall SetObjectName(AnsiString Value);
	AnsiString __fastcall GetObjectKey();
	void __fastcall SetObjectKey(AnsiString Value);
	AnsiString __fastcall GetCounterName();
	void __fastcall SetCounterName(AnsiString Value);
	Perffilter::TPerfCounterType* __fastcall GetCounterType(void);
	void __fastcall SetCounterType(Perffilter::TPerfCounterType* Value);
	void __fastcall Collect(void);
	Winperf::PPERF_COUNTER_DEFINITION __fastcall GetCounterDefinition(void);
	int __fastcall GetInstanceCount(void);
	TPerfMonitorCounterValue* __fastcall GetInstanceValues(int Index);
	void __fastcall CollectValue(TPerfMonitorCounterValue* CV, int InstanceIdx, bool JustCreated);
	void __fastcall CollectNoInstanceValue(TPerfMonitorCounterValue* CV, bool JustCreated);
	AnsiString __fastcall GetSuffix();
	
public:
	__property Winperf::PPERF_COUNTER_DEFINITION CounterDefinition = {read=GetCounterDefinition};
	TPerfMonitor* __fastcall Monitor(void);
	virtual void __fastcall Assign(Classes::TPersistent* Value);
	__fastcall virtual TPerfMonitorItem(Classes::TCollection* Collection);
	__fastcall virtual ~TPerfMonitorItem(void);
	bool __fastcall HasInstances(void);
	__property int InstanceCount = {read=GetInstanceCount, nodefault};
	__property TPerfMonitorCounterValue* InstanceValues[int Index] = {read=GetInstanceValues};
	__property AnsiString Suffix = {read=GetSuffix};
	
__published:
	__property AnsiString ObjectName = {read=GetObjectName, write=SetObjectName};
	__property AnsiString CounterName = {read=GetCounterName, write=SetCounterName};
	__property Perffilter::TPerfCounterType* CounterType = {read=GetCounterType, write=SetCounterType, 
		stored=false};
	__property AnsiString ObjectKey = {read=GetObjectKey, write=SetObjectKey};
};

#pragma pack(pop)

class DELPHICLASS TPerfMonitorItems;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TPerfMonitorItems : public Classes::TCollection 
{
	typedef Classes::TCollection inherited;
	
private:
	TPerfMonitor* _Owner;
	
protected:
	DYNAMIC Classes::TPersistent* __fastcall GetOwner(void);
	TPerfMonitorItem* __fastcall GetMonitorItems(int index);
	
public:
	__property TPerfMonitor* Owner = {read=_Owner};
	__property TPerfMonitorItem* Items[int index] = {read=GetMonitorItems/*, default*/};
	HIDESBASE TPerfMonitorItem* __fastcall Add(void);
	__fastcall TPerfMonitorItems(TPerfMonitor* Owner, TMetaClass* ItemClass);
public:
	#pragma option push -w-inl
	/* TCollection.Destroy */ inline __fastcall virtual ~TPerfMonitorItems(void) { }
	#pragma option pop
	
};

#pragma pack(pop)

#pragma pack(push, 4)
class PASCALIMPLEMENTATION TPerfMonitor : public Classes::TComponent 
{
	typedef Classes::TComponent inherited;
	
private:
	bool _JustCreated;
	Perffilter::TPerfFilter* _Filter;
	TPerfMonitorItems* _Items;
	__int64 _SysTime;
	__int64 _FirstSysTime;
	__int64 _PrevSysTime;
	__int64 _DeltaSysTime;
	__int64 _TotalSysTime;
	void __fastcall SetItems(TPerfMonitorItems* Value);
	
protected:
	AnsiString __fastcall GetLocaleID();
	void __fastcall SetLocaleID(AnsiString Value);
	Perftitles::TPerfHelps* __fastcall GetHelps(void);
	void __fastcall SetHelps(Perftitles::TPerfHelps* Value);
	
public:
	__fastcall virtual TPerfMonitor(Classes::TComponent* AComponent);
	__fastcall virtual ~TPerfMonitor(void);
	void __fastcall Collect(void);
	
__published:
	__property AnsiString LocaleID = {read=GetLocaleID, write=SetLocaleID};
	__property TPerfMonitorItems* Items = {read=_Items, write=SetItems};
	__property Perftitles::TPerfHelps* Helps = {read=GetHelps, write=SetHelps};
};

#pragma pack(pop)

//-- var, const, procedure ---------------------------------------------------
extern PACKAGE void __fastcall ParseKey(AnsiString Key, Classes::TStrings* Keys);
extern PACKAGE void __fastcall DoRegister(void);

}	/* namespace Perfmonitor */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Perfmonitor;
#endif
#pragma option pop	// -w-

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// PerfMonitor
