{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

Author:       Alexey A. Dynnikov
EMail:        aldyn@chat.ru
WebSite:      http://www.chat.ru/~aldyn/index.html
Support:      Use the e-mail aldyn@chat.ru

Creation:     May 23, 1998
Version:      1.00

Legal issues: Copyright (C) 1997 by Alexey A. Dynnikov <aldyn@chat.ru>

              This software is provided 'as-is', without any express or
              implied warranty.  In no event will the author be held liable
              for any  damages arising from the use of this software.

              Permission is granted to anyone to use this software for any
              purpose, including commercial applications, and to alter it
              and redistribute it freely, subject to the following
              restrictions:

              1. The origin of this software must not be misrepresented,
                 you must not claim that you wrote the original software.
                 If you use this software in a product, an acknowledgment
                 in the product documentation would be appreciated but is
                 not required.

              2. Altered source versions must be plainly marked as such, and
                 must not be misrepresented as being the original software.

              3. This notice may not be removed or altered from any source
                 distribution.

 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

unit LocalePropertyEditor;

interface

uses
    Windows, Messages, SysUtils, Classes,
    Graphics, Controls, Forms, Dialogs, DsgnIntf,
    PerfTitles, PerfObjects, PerfCounters,
    PerfInstances, PerfFilter, PerfMonitor;

type
    TLocalePropertyEditor = class(TPropertyEditor)
    public
        function GetAttributes: TPropertyAttributes; override;
        function GetValue: string; override;
        procedure GetValues(Proc: TGetStrProc); override;
        procedure SetValue(const Value: string); override;
    end;

procedure DoRegister;

implementation

function TLocalePropertyEditor.GetAttributes: TPropertyAttributes;
begin
    result:=[paMultiSelect, paValueList, paSortList];
end;

function TLocalePropertyEditor.GetValue: string;
begin
    Result := GetStrValue;
end;

procedure TLocalePropertyEditor.SetValue(const Value: string);
begin
    SetStrValue(Value);
end;

procedure TLocalePropertyEditor.GetValues(Proc: TGetStrProc);
var i: Integer;
    LL: TStrings;
begin
    LL:=Locales;
    for i:=0 to LL.Count-1 do Proc(LL[i]);
end;

procedure DoRegister;
begin
    RegisterPropertyEditor(TypeInfo(String),TPerfInfo,'LocaleID',TLocalePropertyEditor);
    RegisterPropertyEditor(TypeInfo(String),TPerfObjects,'LocaleID',TLocalePropertyEditor);
    RegisterPropertyEditor(TypeInfo(String),TPerfCounters,'LocaleID',TLocalePropertyEditor);
    RegisterPropertyEditor(TypeInfo(String),TPerfInstances,'LocaleID',TLocalePropertyEditor);
    RegisterPropertyEditor(TypeInfo(String),TPerfFilter,'LocaleID',TLocalePropertyEditor);
    RegisterPropertyEditor(TypeInfo(String),TPerfMonitor,'LocaleID',TLocalePropertyEditor);
end;

end.
