{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

Author:       Alexey A. Dynnikov
EMail:        aldyn@chat.ru
WebSite:      http://www.chat.ru/~aldyn/index.html
Support:      Use the e-mail aldyn@chat.ru

Creation:     May 23, 1998
Version:      1.00

Legal issues: Copyright (C) 1997 by Alexey A. Dynnikov <aldyn@chat.ru>

              This software is provided 'as-is', without any express or
              implied warranty.  In no event will the author be held liable
              for any  damages arising from the use of this software.

              Permission is granted to anyone to use this software for any
              purpose, including commercial applications, and to alter it
              and redistribute it freely, subject to the following
              restrictions:

              1. The origin of this software must not be misrepresented,
                 you must not claim that you wrote the original software.
                 If you use this software in a product, an acknowledgment
                 in the product documentation would be appreciated but is
                 not required.

              2. Altered source versions must be plainly marked as such, and
                 must not be misrepresented as being the original software.

              3. This notice may not be removed or altered from any source
                 distribution.

 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

unit CounterPropertyEditor;

interface

uses
    Windows, Messages, SysUtils, Classes,
    Graphics, Controls, Forms, Dialogs, DsgnIntf,
    PerfTitles, PerfObjects, PerfCounters,
    PerfInstances, PerfFilter, PerfMonitor;

type
    TCounterPropertyEditor = class(TPropertyEditor)
    private
        _Counters: TPerfCounters;
    public
        function GetAttributes: TPropertyAttributes; override;
        function GetValue: string; override;
        procedure GetValues(Proc: TGetStrProc); override;
        procedure SetValue(const Value: string); override;
        destructor Destroy; override;
    end;

procedure DoRegister;

implementation

function TCounterPropertyEditor.GetAttributes: TPropertyAttributes;
begin
    result:=[paValueList, paSortList];
end;

function TCounterPropertyEditor.GetValue: string;
begin
    Result := GetStrValue;
end;

procedure TCounterPropertyEditor.SetValue(const Value: string);
begin
    SetStrValue(Value);
end;

procedure TCounterPropertyEditor.GetValues(Proc: TGetStrProc);
var i: Integer;
    LL: TStringList;
    C: TPersistent;
begin
    if _Counters = nil then _Counters:= TPerfCounters.Create(nil);

    C:=GetComponent(0);
    if C is TPerfCounterItem then
    begin
        _Counters.LocaleID:=(C as TPerfCounterItem).Filter.LocaleID;
        _Counters.ObjectName:=(C as TPerfCounterItem).ObjectName;
    end else
    if C is TPerfMonitorItem then
    begin
        _Counters.LocaleID:=(C as TPerfMonitorItem).Monitor.LocaleID;
        _Counters.ObjectName:=(C as TPerfMonitorItem).ObjectName;
    end else
        raise Exception.Create('Invalid property');

    LL:=TStringList.Create;
    _Counters.GetCounterTitles(LL);
    for i:=0 to LL.Count-1 do Proc(LL[i]);
    LL.Free;
end;

destructor TCounterPropertyEditor.Destroy;
begin
    _Counters.Free;
    inherited;
end;

procedure DoRegister;
begin
    RegisterPropertyEditor(TypeInfo(String),TPerfCounterItem,'CounterName',TCounterPropertyEditor);
    RegisterPropertyEditor(TypeInfo(String),TPerfMonitorItem,'CounterName',TCounterPropertyEditor);
end;

end.
