//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop
#include <math.h>

#include "fmAbout.h"
#include "fmTaskView.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "PerfFilter"
#pragma resource "*.dfm"
TTaskViewForm *TaskViewForm;
//---------------------------------------------------------------------------
__fastcall TTaskViewForm::TTaskViewForm(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TTaskViewForm::About1Click(TObject *Sender)
{
    TAboutBox *bx;
    bx = new TAboutBox(NULL);
    bx->SetProductInfo(ProductName,Version);
    bx->ShowModal();
}
//---------------------------------------------------------------------------
void __fastcall TTaskViewForm::FormCreate(TObject *Sender)
{
    int i,c;
    TListColumn *LC;

    c = PerfFilter->Items->Count;
    if( LV->Columns->Count > c+1 ) LV->Columns->Clear();
    while (LV->Columns->Count < c+1) LV->Columns->Add();

    // Fill ListView columns by names of counter items
    LV->Columns->Items[0]->Caption ="Task name";
    for (i=0; i < c; i++)
    {
        LC = LV->Columns->Items[i+1];
        LC->Caption = (PerfFilter->Items->Items[i])->CounterName;
        LC->Alignment = taRightJustify;
        LC->Width = 100;
    }

    // Update display information->
    Timer->OnTimer(NULL);

}

//---------------------------------------------------------------------------
void __fastcall TTaskViewForm::TimerTimer(TObject *Sender)
{
    int i,j,c;
    TPerfCounterItem *CI, *PCI;
    TInt64F PID;
    double ET;
    TListItem *LI;

    if (_IsBusy)  return;

    _IsBusy = TRUE;

    try
    {
        // Refresh performance information
        PerfFilter->Collect();


        LV->Items->BeginUpdate();

        // Adjust the number of ListView items->
        CI=PerfFilter->Items->Items[0];
        c=CI->InstanceCount;
        while (LV->Items->Count < c)  LV->Items->Add();
        while (LV->Items->Count > c)  LV->Items->Delete(c);

        for ( i=0; i < c; i++)
        {
            LI = LV->Items->Item[i];
            LI->Caption=CI->InstanceNames[i];

            // Get and display the counter values for each counter item->
            for( j=0; j < PerfFilter->Items->Count; j++)
            {
                if (LI->SubItems->Count <= j)  LI->SubItems->Add("");
                try
                {
                    PCI = PerfFilter->Items->Items[j];
                    PID = PCI->InsCtrAsInteger(i);
                    if (AnsiCompareText(PCI->CounterName,"Elapsed time") == 0)
                    {
                        ET=(double(PCI->ObjectTime()) - double(PID))/double(PCI->ObjectFreq()) /24/3600;
                        LI->SubItems->Strings[j] = FormatDateTime("hh:nn:ss",ET);
                    } else
                        LI->SubItems->Strings[j] = FloatToStr(PID);
                }
                catch(Exception &E)
                {
                    LI->SubItems->Strings[j] = E.Message;
                }
            }
        }
        LV->Items->EndUpdate();
    }
    catch(Exception &E)
    {
    }
    _IsBusy = FALSE;
}
//---------------------------------------------------------------------------
