//---------------------------------------------------------------------------
#ifndef fmPerfExplorerMainH
#define fmPerfExplorerMainH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include "PerfCounters.hpp"
#include "PerfObjects.hpp"
#include "PerfTitles.hpp"
#include <ComCtrls.hpp>
#include <ExtCtrls.hpp>
#include <Menus.hpp>
//---------------------------------------------------------------------------
class TPerfExplorerMainForm : public TForm
{
__published:	// IDE-managed Components
    TPanel *PnLeftPane;
    TTreeView *TV;
    TPanel *PnTV;
    TMainMenu *MainMenu;
    TMenuItem *Help1;
    TMenuItem *About1;
    TPerfCounters *PerfCounters;
    TPerfObjects *PerfObjects;
    TPerfHelps *PerfHelps;
    void __fastcall FormCreate(TObject *Sender);
    void __fastcall TVChange(TObject *Sender, TTreeNode *Node);
    void __fastcall PnTVClick(TObject *Sender);
    void __fastcall TVEnter(TObject *Sender);
    void __fastcall TVExit(TObject *Sender);
    void __fastcall About1Click(TObject *Sender);
private:	// User declarations
    TForm * _RightPane;
    void CreatePerformanceTree();
    void CreateObjectBranch(TTreeNode * Node, AnsiString ObjectName, Boolean HasInstances);
    void CreateCounterBranch(TTreeNode * Node, AnsiString CounterName, Boolean HasInstances);
    void SetRightPane(TForm * Form);
    __property TForm * RightPane = {read = _RightPane, write = SetRightPane};
public:		// User declarations
    __fastcall TPerfExplorerMainForm(TComponent* Owner);
};
//---------------------------------------------------------------------------
extern PACKAGE TPerfExplorerMainForm *PerfExplorerMainForm;
//---------------------------------------------------------------------------
void SetPanelState(TPanel * Panel, Boolean Active);
//---------------------------------------------------------------------------
#define ProductName "PerfExplorer"
#define Version "1.2"
#endif
