//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "fmObjectNoIns.h"
#include "fmPerfExplorerMain.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "PerfCounters"
#pragma link "PerfMonitor"
#pragma resource "*.dfm"
TObjectNoInsForm *ObjectNoInsForm;
//---------------------------------------------------------------------------
__fastcall TObjectNoInsForm::TObjectNoInsForm(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------
__fastcall TObjectNoInsForm::TObjectNoInsForm(TComponent * Owner, AnsiString ObjectName)
    : TForm(Owner)
{
    int i;
    TPerfMonitorItem * MI;
    TListItem * LI;

    PerfCounters->ObjectName = ObjectName;
    PnCaption->Caption = Format(PnCaption->Caption,ARRAYOFCONST((ObjectName)));
    for (i = 0; i < PerfCounters->CounterCount; i++)
    {
        if (PerfCounters->CounterTitle[i] == "") continue;
        MI = PerfMonitor->Items->Add();
        try
        {
            MI->ObjectName = ObjectName;
            MI->CounterName = PerfCounters->CounterTitle[i];
            LI = LV->Items->Add();
            LI->Caption = MI->CounterName;
            LI->SubItems->Add("");
            LI->SubItems->Add("");
        }
        catch(Exception &E)
        {
            MI->Free();
        }

    }
    Refresh();
}
//---------------------------------------------------------------------------
void TObjectNoInsForm::Refresh()
{
    int i;
    TPerfMonitorItem * MI;
    TPerfMonitorCounterValue * CV;
    TListItem * LI;

    if(_IsBusy) return;
    _IsBusy = TRUE;

    try
    {
        PerfMonitor->Collect();
        LV->Items->BeginUpdate();

        for( i = 0; i <  LV->Items->Count; i++)
        {
            LI = LV->Items->Item[i];
            MI = PerfMonitor->Items->Items[i];
            CV = MI->InstanceValues[0];

            LI->SubItems->Strings[0] = CV->AsString+" "+MI->Suffix;
            LI->SubItems->Strings[1] = CV->AvgAsString+" "+MI->Suffix;
        }
    }
    catch(Exception &E)
    {
    }

    LV->Items->EndUpdate();
    _IsBusy = FALSE;
}
//---------------------------------------------------------------------------



void __fastcall TObjectNoInsForm::TimerTimer(TObject *Sender)
{
    Refresh();
}
//---------------------------------------------------------------------------

void __fastcall TObjectNoInsForm::PnCaptionClick(TObject *Sender)
{
    ((TForm *)Parent)->ActiveControl = LV;
}
//---------------------------------------------------------------------------

void __fastcall TObjectNoInsForm::LVEnter(TObject *Sender)
{
    SetPanelState(PnCaption,TRUE);
}
//---------------------------------------------------------------------------

void __fastcall TObjectNoInsForm::LVExit(TObject *Sender)
{
    SetPanelState(PnCaption,FALSE);
}
//---------------------------------------------------------------------------

