{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

Author:       Alexey A. Dynnikov
EMail:        aldyn@chat.ru
WebSite:      http://www.chat.ru/~aldyn/index.html
Support:      Use the e-mail aldyn@chat.ru

Creation:     May 23, 1998
Version:      1.00

Legal issues: Copyright (C) 1998 by Alexey A. Dynnikov <aldyn@chat.ru>

              This software is provided 'as-is', without any express or
              implied warranty.  In no event will the author be held liable
              for any  damages arising from the use of this software.

              Permission is granted to anyone to use this software for any
              purpose, including commercial applications, and to alter it
              and redistribute it freely, subject to the following
              restrictions:

              1. The origin of this software must not be misrepresented,
                 you must not claim that you wrote the original software.
                 If you use this software in a product, an acknowledgment
                 in the product documentation would be appreciated but is
                 not required.

              2. Altered source versions must be plainly marked as such, and
                 must not be misrepresented as being the original software.

              3. This notice may not be removed or altered from any source
                 distribution.

 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

unit WinPerfUtils;

//CE_Desc_Begin(WinPerfUtils.pas)
{\
This unit contains a set of helper functions that are used \
to iterate through the performance data.
 
}
//CE_Desc_End


interface

{$ifndef ver90}
{$ifndef ver100}
{$ifndef ver110}
{$define UseInt64}
{$endif}
{$endif}
{$endif}

uses Windows, WinPerf, Classes, SysUtils;

function FirstObject( PerfData : PPERF_Data_Block ): PPERF_Object_Type;
function NextObject(PerfObj: PPERF_Object_Type): PPERF_Object_Type;

function FirstInstance(PerfObj: PPERF_Object_Type): PPERF_INSTANCE_DEFINITION;
function NextInstance(PerfInst: PPERF_INSTANCE_DEFINITION): PPERF_INSTANCE_DEFINITION;

function FirstCounter(PerfObj: PPERF_Object_Type): PPERF_Counter_DEFINITION;
function NextCounter( PerfCntr: PPERF_Counter_DEFINITION): PPERF_Counter_DEFINITION;

function ObjectBlock(PerfObj: PPERF_Object_Type): PPERF_COUNTER_BLOCK;

function InstanceBlock(PerfInst: PPERF_INSTANCE_DEFINITION): PPERF_COUNTER_BLOCK;
function NextBlockInstance(PerfBlock: PPERF_COUNTER_BLOCK): PPERF_INSTANCE_DEFINITION;

function PerfInstName(PerfInst: PPERF_INSTANCE_DEFINITION): String;

function Int64ToHex(Value: TInt64F; Digits: Integer): String;
function Int64ToStr(Value: TInt64F): String;

{$ifdef ver110}
function FInt64(Value: TInt64): TInt64F;
function Int64D(Value: DWORD): TInt64;
{$else}
type
    FInt64 = TInt64F;
    Int64D = TInt64;
{$endif}


//CE_Desc_Begin(GetNameStrings)
{\
This function is used to read performance titles and helps.
Parameters:
    Locale: String; // Three-digit locale identifier, the default value is 009 (English)
    GetHelp: Boolean; // If True then help strings will be retrieved else \
the title strings will be readed
    Names : TStrings; // It is a buffer for the information retrieved. \
Each string has form 'Index=Description'.
}
//CE_Desc_End
procedure GetNameStrings(Locale: String; GetHelp: Boolean; Names : TStrings);

//procedure GetIndex(Locale: String; szCounter :String; var szIndex: String );

const
    CounterSizeMask         = $00000300;
    CounterTypeMask         = $00000C00;
    CounterSubTypeMask      = $000F0000;
    CounterTimeBaseMask     = $00300000;
    CounterModifierMask     = $0FC00000;
    CounterDisplayMask      = $F0000000;


implementation

const
    szPerfKey: String = 'SOFTWARE\Microsoft\Windows NT\CurrentVersion\Perflib';

{$ifdef ver110}
function FInt64(Value: TInt64): TInt64F;
var V: TInt64;
begin
    if (Value.HighPart and $80000000) = 0 then // positive value
    begin
        result:=Value.HighPart;
        result:=result*$10000*$10000;
        result:=result+Value.LowPart;
    end else
    begin
        V.HighPart:=Value.HighPart xor $FFFFFFFF;
        V.LowPart:=Value.LowPart xor $FFFFFFFF;
        result:= -1 - FInt64(V);
    end;
end;

function Int64D(Value: DWORD): TInt64;
begin
    result.LowPart:=Value;
    result.HighPart := 0; // positive only
end;
{$endif}

{$ifdef UseInt64}
function Int64ToHex(Value: TInt64F; Digits: Integer): String;
begin
    result:=IntToHex(Value,Digits);
end;

function Int64ToStr(Value: TInt64F): String;
begin
    result:=IntToStr(Value);
end;

{$else}
function Int64ToHex(Value: TInt64F; Digits: Integer): String;
{$ifndef ver110}
var L: TLargeInteger;
    mx: Integer;
{$endif}
begin
    {$ifndef ver110}
    L.QuadPart:=Value;
    if Digits > 8 then mx:=Digits-8 else mx:=1;
    if L.HighPart <> 0 then
        result:=IntToHex(L.HighPart,mx) + IntToHex(L.LowPart,8)
    else
        result:=IntToHex(L.LowPart,Digits);
    {$else}
    result:=Int64ToStr(Value); //  ;-P
    {$endif}
end;

function Int64ToStr(Value: TInt64F): String;
begin
    result:=format('%.0f',[Value]);
end;
{$endif}


//CE_Desc_Begin(FirstObject)
{\
It is a helper function used to iterate though \
the TPERF_Object_Type structures. This function \
returns a pointer to the first TPERF_Object_Type \
structure in the performance data block. \
<%SEEALSO NextObject%>

}
//CE_Desc_End
function FirstObject( PerfData : PPERF_Data_Block ): PPERF_Object_Type;
begin
    result:=PPERF_Object_Type(DWORD(PerfData) + PerfData.HeaderLength);
end;

//CE_Desc_Begin(NextObject)
{\
It is a helper function used to iterate though \
the TPERF_Object_Type structures. This function \
returns a pointer to the next TPERF_Object_Type \
structure after PerfObj in the performance data block. \
<%SEEALSO FirstObject%>

}
//CE_Desc_End
function NextObject(PerfObj: PPERF_Object_Type): PPERF_Object_Type;
begin
    result:=PPERF_Object_Type(DWORD(PerfObj) + PerfObj.TotalByteLength);
end;

//CE_Desc_Begin(FirstInstance)
{\
It is a helper function used to iterate through the PPERF_INSTANCE_DEFINITION \
structures for the given performance object.
This function returns a pointer to the PERF_INSTANCE_DEFINITION for the \
performance object specified. If the performance object \
has no instances then the result is nil.

<%SEEALSO NextInstance%>
}
//CE_Desc_End
function FirstInstance(PerfObj: PPERF_Object_Type): PPERF_INSTANCE_DEFINITION;
begin
    if PerfObj.NumInstances = PERF_NO_Instances then
        result := nil
    else
        result:=PPERF_INSTANCE_DEFINITION(DWORD(PerfObj) + PerfObj.DefinitionLength);
end;

//CE_Desc_Begin(NextInstance)
{\
It is a helper function used to iterate through the PPERF_INSTANCE_DEFINITION \
structures for the given performance object.
This function returns the pointer to the next instance definition.

<%SEEALSO FirstInstance%>}
//CE_Desc_End
function NextInstance(PerfInst: PPERF_INSTANCE_DEFINITION): PPERF_INSTANCE_DEFINITION;
var PerfCntrBlk : PPERF_Counter_Block ;
begin
    PerfCntrBlk := PPERF_Counter_Block(DWORD(PerfInst) + PerfInst.ByteLength);
    result:=PPERF_INSTANCE_DEFINITION(DWORD(PerfCntrBlk) + PerfCntrBlk.ByteLength);
end;

//CE_Desc_Begin(FirstCounter)
{\
This is a helper function used to iterate through the \
PERF_Counter_DEFINITION structures for the given performance object. \
Call this function to obtain the pointer to the \
first PERF_Counter_DEFINITION structure for the PerfObj performance object.

<%SEEALSO NextCounter%>}
//CE_Desc_End
function FirstCounter(PerfObj: PPERF_Object_Type): PPERF_Counter_DEFINITION;
begin
    result:=PPERF_Counter_DEFINITION(DWORD(PerfObj) + PerfObj.HeaderLength);
end;

//CE_Desc_Begin(NextCounter)
{\
This is a helper function used to iterate through the \
PERF_Counter_DEFINITION structures for the given performance object. \
Call this function to obtain the pointer to the next PERF_Counter_DEFINITION \
structure after PerfCntr. <%SEEALSO FirstCounter%>
}
//CE_Desc_End
function NextCounter( PerfCntr: PPERF_Counter_DEFINITION) : PPERF_Counter_DEFINITION;
begin
    result:=PPERF_Counter_DEFINITION(DWORD(PerfCntr) + PerfCntr.ByteLength);
end;

//CE_Desc_Begin(ObjectBlock)
{}
//CE_Desc_End
function ObjectBlock(PerfObj: PPERF_Object_Type): PPERF_COUNTER_BLOCK;
begin
    if PerfObj.NumInstances = PERF_NO_Instances then
        result:=PPERF_COUNTER_BLOCK(DWORD(PerfObj) + PerfObj.DefinitionLength)
    else
        result:=nil;
end;

//CE_Desc_Begin(InstanceBlock)
{\
It is a helper function that return the pointer to the \
first PERF_COUNTER_BLOCK structure for the given instance definition. \

<%SEEALSO NextBlockInstance%>

}
//CE_Desc_End
function InstanceBlock(PerfInst: PPERF_INSTANCE_DEFINITION): PPERF_COUNTER_BLOCK;
begin
    result:=PPERF_COUNTER_BLOCK(PChar(PerfInst) + PerfInst.ByteLength );
end;

//CE_Desc_Begin(NextBlockInstance)
{\
It is a helper function that returns the pointer to the next instance \
definition for the given PERF_COUNTER_BLOCK.

<%SEEALSO InstanceBlock%>
}
//CE_Desc_End
function NextBlockInstance(PerfBlock: PPERF_COUNTER_BLOCK): PPERF_INSTANCE_DEFINITION;
begin
    result:=PPERF_INSTANCE_DEFINITION(PChar(PerfBlock) + PerfBlock.ByteLength);
end;

//CE_Desc_Begin(PerfInstName)
{\
It is a helper function. It returns the name of perfomance instance retried \
from the given instance definition.

}
//CE_Desc_End
function PerfInstName(PerfInst: PPERF_INSTANCE_DEFINITION): String;
begin
    if PerfInst.NameLength > 0 then
        result:=WideCharToString(PWideChar(DWORD(PerfInst) + PerfInst.NameOffset))
    else
        result:='';
end;

//------------------------------------------------------------------------------
{
procedure GetIndex(Locale: String; szCounter :String; var szIndex: String );
var
    pszBuffer: PChar;
    pszTemp: PChar;
    dwBytes: DWORD;
    hKeyIndex: THandle;
    pszCounter: PChar;
    i : Integer;
    j : Integer;
const
    szObject: array[0..255] of Char = '';
    pszIndex: array[0..255] of CHar = '';
begin
    i:=0;
    j:=0;
    pszCounter:=PChar(szCounter);


    // Open the key.
    if RegOpenKeyEx( HKEY_LOCAL_MACHINE, PChar(szPerfKey+'\'+Locale), 0, KEY_READ, hKeyIndex ) <> ERROR_SUCCESS then exit;

    // Get the size of the counter.
    RegQueryValueEx( hKeyIndex, 'Counters', nil, nil, nil, @dwBytes );

    // Allocate memory for the buffer.
    pszBuffer := AllocMem( dwBytes );

    // Get the titles and counters.
    RegQueryValueEx( hKeyIndex, 'Counters', nil, nil, PBYTE(pszBuffer), @dwBytes );

    // Find the index value for PROCESS.
    pszTemp := pszBuffer;

    while i <> dwBytes do
    begin
        while pszTemp[i] <> #0 do
        begin
            pszIndex[j] := pszTemp[i];
            INC(i); INC(j);
        end;
        pszIndex[j] := #0;
        INC(i); j := 0;
        while pszTemp[i] <> #0 do
        begin
            szObject[j] := pszTemp[i];
            INC(i); INC(j);
        end;
        szObject[j] := #0;
        INC(i);
        j := 0;
        if pszTemp[i] = #0 then INC(I);
        if StrComp(szObject, pszCounter) = 0 then break;
    end;

    // Deallocate the memory.
    FreeMem( pszBuffer );

    // Close the key.
    RegCloseKey( hKeyIndex );
    szIndex:=pszIndex;
end;
}

//------------------------------------------------------------------------------
procedure GetNameStrings(Locale: String; GetHelp: Boolean; Names : TStrings);
var
    hKeyPerflib: HKEY;      // handle to registry key
    dwMaxValueLen: DWORD;   // maximum size of key values
    dwBuffer: DWORD;        // bytes to allocate for buffers
    dwBufferSize: DWORD;    // size of dwBuffer
    lpCurrentString: LPSTR; // pointer for enumerating data strings
    dwCounter: DWORD;       // current counter index
    lpNameStrings: PChar;
begin
    // Get the number of Counter items.
    if RegOpenKeyEx( HKEY_LOCAL_MACHINE, PChar(szPerfKey), 0, KEY_READ, hKeyPerflib) <> ERROR_SUCCESS then Exit;
    dwBufferSize := sizeof(dwBuffer);
    RegQueryValueEx( hKeyPerflib, 'Last Counter', nil, nil, @dwBuffer, @dwBufferSize );
    RegCloseKey( hKeyPerflib );


    // Open key containing counter and object names.

    if RegOpenKeyEx( HKEY_LOCAL_MACHINE, PChar(szPerfKey+'\'+Locale), 0, KEY_READ, hKeyPerflib) <> ERROR_SUCCESS then Exit;

    // Get the size of the largest value in the key (Counter or Help).

    RegQueryInfoKey( hKeyPerflib, nil, nil, nil, nil, nil, nil, nil, nil, @dwMaxValueLen, nil, nil);

    // Allocate memory for the counter and object names.

    dwBuffer := dwMaxValueLen + 1;

    GetMem(lpNameStrings, dwBuffer * sizeof(CHAR));

    // Read Counter value.
    if GetHelp then
        RegQueryValueEx( hKeyPerflib, 'Help', nil, nil, PByte(lpNameStrings), @dwBuffer )
    else
        RegQueryValueEx( hKeyPerflib, 'Counter', nil, nil, PByte(lpNameStrings), @dwBuffer );

    // Load names into an array, by index.
    Names.Clear;
    lpCurrentString := lpNameStrings;
    while lpCurrentString^ <> #0 do
    begin
        dwCounter := StrToInt( lpCurrentString );
        INC( lpCurrentString, lstrlen(lpCurrentString)+1);
        Names.Add(IntToStr(dwCounter)+'='+lpCurrentString);
        INC(lpCurrentString,(lstrlen(lpCurrentString)+1) );
    end;

    FreeMem(lpNameStrings);
end;





end.
