{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

Author:       Alexey A. Dynnikov
EMail:        aldyn@chat.ru
WebSite:      http://www.chat.ru/~aldyn/index.html
Support:      Use the e-mail aldyn@chat.ru

Creation:     May 23, 1998
Version:      1.00

Legal issues: Copyright (C) 1997 by Alexey A. Dynnikov <aldyn@chat.ru>

              This software is provided 'as-is', without any express or
              implied warranty.  In no event will the author be held liable
              for any  damages arising from the use of this software.

              Permission is granted to anyone to use this software for any
              purpose, including commercial applications, and to alter it
              and redistribute it freely, subject to the following
              restrictions:

              1. The origin of this software must not be misrepresented,
                 you must not claim that you wrote the original software.
                 If you use this software in a product, an acknowledgment
                 in the product documentation would be appreciated but is
                 not required.

              2. Altered source versions must be plainly marked as such, and
                 must not be misrepresented as being the original software.

              3. This notice may not be removed or altered from any source
                 distribution.

 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

unit CounterTypePropertyEditor;

interface

uses
    Windows, Messages, SysUtils, Classes, WinPerf, WinPerfUtils,
    Graphics, Controls, Forms, Dialogs, DsgnIntf,
    PerfTitles, PerfObjects, PerfCounters, PerfMonitor,
    PerfInstances, PerfFilter, StdCtrls, Buttons, ExtCtrls;

type
  TCounterTypeForm = class(TForm)
    Label1: TLabel;
    LbSize: TLabel;
    Label2: TLabel;
    LbType: TLabel;
    Label3: TLabel;
    LbSubtype: TLabel;
    Label4: TLabel;
    LbTimebase: TLabel;
    Label5: TLabel;
    LbModifier: TLabel;
    Label6: TLabel;
    LbDispaly: TLabel;
    Bevel1: TBevel;
    BnOK: TButton;
  private
    { Private declarations }
    _Item: TObject;
    procedure SetItem(Value: TObject);
  public
    { Public declarations }
    property Item: TObject read _Item write SetItem;
  end;

type
    TCounterTypePropertyEditor = class(TPropertyEditor)
        procedure Edit; override;
        function GetAttributes: TPropertyAttributes; override;
        function GetValue: string; override;
        procedure SetValue(const AValue: string); override;
    end;


procedure DoRegister;

implementation

{$R *.DFM}

procedure TCounterTypePropertyEditor.Edit;
begin
    with TCounterTypeForm.Create(nil) do
    begin
        Item:=GetComponent(0);
        ShowModal;
        Release;
    end;
end;

function TCounterTypePropertyEditor.GetAttributes: TPropertyAttributes;
begin
    result:=[paDialog, paMultiSelect, paReadOnly];
end;

function TCounterTypePropertyEditor.GetValue: string;
begin
    result:='(Counter type)';
end;

procedure TCounterTypePropertyEditor.SetValue(const AValue: string);
begin
end;

procedure DoRegister;
begin
    RegisterPropertyEditor(TypeInfo(TPerfCounterType),TPerfCounterItem,'CounterType',TCounterTypePropertyEditor);
    RegisterPropertyEditor(TypeInfo(TPerfCounterType),TPerfMonitorItem,'CounterType',TCounterTypePropertyEditor);
end;

procedure TCounterTypeForm.SetItem(Value: TObject);
var PCD: PPerf_COUNTER_DEFINITION;
begin
    _Item:=Value;
    if Item is TPerfCounterItem then PCD:=(Item as TPerfCounterItem).CounterDefinition else
    if Item is TPerfMonitorItem then PCD:=(Item as TPerfMonitorItem).CounterDefinition else
    raise Exception.Create('Incompatible types');

    case PCD.CounterType and CounterSizeMask of
        Perf_SIZE_DWORD : LbSize.Caption:='DWord';

        Perf_SIZE_LARGE : LbSize.Caption:='Large';

        Perf_SIZE_ZERO  : LbSize.Caption:='Zero length';

        Perf_SIZE_VARIABLE_LEN : LbSize.Caption:='Variable length';

    else
        LbSize.Caption:='Internal error (CounterType = '+IntToHex(PCD.CounterType,8)+')';
    end;

    LbSize.Caption:=LbSize.Caption+' ( CounterSize = '+IntToStr(PCD.CounterSize)+')';


    case PCD.CounterType and CounterTypeMask of
        Perf_TYPE_NUMBER :
            begin
                LbType.Caption:='A number (not a counter)';

                case PCD.CounterType and CounterSubTypeMask of
                    Perf_NUMBER_HEX : LbSubType.Caption:='Display as HEX value';
                    Perf_NUMBER_DECIMAL : LbSubType.Caption:='Display as a decimal integer';
                    Perf_NUMBER_DEC_1000 : LbSubType.Caption:='Display as a decimal/1000';
                else
                    LbSubType.Caption:='Internal error (CounterType = '+IntToHex(PCD.CounterType,8)+')';
                end;
            end;

        Perf_TYPE_COUNTER :
            begin
                LbType.Caption:='An increasing numeric value';

                case PCD.CounterType and CounterSubTypeMask of
                    Perf_COUNTER_VALUE : LbSubType.Caption:='Display counter value';
                    Perf_COUNTER_RATE : LbSubType.Caption:='Divide counter / delta time';
                    Perf_COUNTER_FRACTION : LbSubType.Caption:='Divide counter / base';
                    Perf_COUNTER_BASE : LbSubType.Caption:='Base value used in fractions';
                    Perf_COUNTER_ELAPSED : LbSubType.Caption:='Subtract counter from current time';
                    Perf_COUNTER_QUEUELEN : LbSubType.Caption:='Use Queuelen processing func.';
                    Perf_COUNTER_HISTOGRAM : LbSubType.Caption:='Counter begins or ends a histogram';
                else
                    LbSubType.Caption:='Internal error (CounterType = '+IntToHex(PCD.CounterType,8)+')';
                end;
            end;

        Perf_TYPE_TEXT :
            begin
                LbType.Caption:='A text field';

                case PCD.CounterType and CounterSubTypeMask of
                    Perf_TEXT_UNICODE : LbSubType.Caption:='Unicode';
                    Perf_TEXT_ASCII : LbSubType.Caption:='ASCII';
                else
                    LbSubType.Caption:='Internal error (CounterType = '+IntToHex(PCD.CounterType,8)+')';
                end;
            end;

        Perf_TYPE_ZERO : LbType.Caption:='Displays a zero';

    else
        LbType.Caption:='Internal error (CounterType = '+IntToHex(PCD.CounterType,8)+')';
    end;

    case PCD.CounterType and CounterTimeBaseMask of
        Perf_TIMER_TICK : LbTimeBase.Caption:='Use system Performance freq for base';
        Perf_TIMER_100NS : LbTimeBase.Caption:='Use 100 NS timer time base units';
        Perf_OBJECT_TIMER : LbTimeBase.Caption:='Use the object timer freq';
    else
        LbTimeBase.Caption:='Internal error (CounterType = '+IntToHex(PCD.CounterType,8)+')';
    end;

    case PCD.CounterType and CounterModifierMask of
        Perf_DELTA_COUNTER : LbModifier.Caption:='Compute difference first';
        Perf_DELTA_BASE : LbModifier.Caption:='Compute base diff as well';
        Perf_INVERSE_COUNTER : LbModifier.Caption:='Show as 1.00-value';
        Perf_MULTI_COUNTER : LbModifier.Caption:='Sum of multiple instances';
    else
        LbModifier.Caption:='No information (CounterType = '+IntToHex(PCD.CounterType,8)+')';
    end;

    case PCD.CounterType and CounterDisplayMask of
        Perf_DISPLAY_NO_SUFFIX : LbDispaly.Caption:='Display without suffix';
        Perf_DISPLAY_PER_SEC : LbDispaly.Caption:='Display with suffix "/sec"';
        Perf_DISPLAY_PERCENT : LbDispaly.Caption:='Display with suffix "%"';
        Perf_DISPLAY_SECONDS : LbDispaly.Caption:='Display with suffix "secs"';
        Perf_DISPLAY_NOSHOW : LbDispaly.Caption:='Value is not displayed';
    else
        LbDispaly.Caption:='Internal error (CounterType = '+IntToHex(PCD.CounterType,8)+')';
    end;
end;

end.
