unit fmPerfInfoMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, PerfTitles, PerfObjects, WinPerf, Menus, fmAbout;

type
  TPerfInfoMainForm = class(TForm)
    PerfObjects: TPerfObjects;
    PerfHelps: TPerfHelps;
    MainMenu: TMainMenu;
    Help1: TMenuItem;
    About1: TMenuItem;
    Panel4: TPanel;
    Panel1: TPanel;
    LBxObjects: TListBox;
    PnObjects: TPanel;
    Splitter1: TSplitter;
    Panel2: TPanel;
    Splitter2: TSplitter;
    LBxObjectInfo: TListBox;
    Panel3: TPanel;
    BnMoreInfo: TButton;
    MObjectHelp: TMemo;
    PnObjectInfo: TPanel;
    PnObjectHelp: TPanel;
    procedure FormCreate(Sender: TObject);
    procedure LBxObjectsClick(Sender: TObject);
    procedure BnMoreInfoClick(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure PnObjectsClick(Sender: TObject);
    procedure LBxObjectsEnter(Sender: TObject);
    procedure LBxObjectsExit(Sender: TObject);
    procedure LBxObjectInfoEnter(Sender: TObject);
    procedure PnObjectInfoClick(Sender: TObject);
    procedure LBxObjectInfoExit(Sender: TObject);
    procedure PnObjectHelpClick(Sender: TObject);
    procedure MObjectHelpEnter(Sender: TObject);
    procedure MObjectHelpExit(Sender: TObject);
  private
    { Private declarations }
    _ObjIdx: Integer;
    procedure AddInfo(InfoDesc,Info: String);
    procedure Init;
  public
    { Public declarations }
  end;

var
  PerfInfoMainForm: TPerfInfoMainForm;

const
    ProductName = 'PerfInfo';
    Version = '1.2';

implementation

{$R *.DFM}

uses fmObjectInfo;

procedure TPerfInfoMainForm.FormCreate(Sender: TObject);
begin
    Init;
end;

procedure TPerfInfoMainForm.Init;
var i: Integer;
    ObjectTitle : String;
begin
    _ObjIdx:=-1;

    PerfHelps.Init;

    for i:=0 to PerfObjects.ObjectCount-1 do
    begin
        ObjectTitle := PerfObjects.ObjectTitle[i];
        if Trim(ObjectTitle) = '' then continue;
        LBxObjects.Items.Add(ObjectTitle);
    end;

    BnMoreInfo.Enabled:=False;
end;

procedure TPerfInfoMainForm.LBxObjectsClick(Sender: TObject);
var POT: PPerf_Object_Type;
    cr: Integer;
begin
    if _ObjIdx = LBxObjects.ItemIndex then exit;
    _ObjIdx := LBxObjects.ItemIndex;

    LBxObjectInfo.Clear;
    if _ObjIdx < 0 then
        LBxObjectInfo.Items.Add('No object selected');

    BnMoreInfo.Enabled:=_ObjIdx >= 0;

    POT:=PerfObjects.ObjectData[_ObjIdx];

    AddInfo('Total length',IntToStr(POT.TotalByteLength));
    AddInfo('Definition length',IntToStr(POT.DefinitionLength));
    AddInfo('Header length',IntToStr(POT.HeaderLength));
    AddInfo('Detail level',IntToStr(POT.DetailLevel));
    AddInfo('Number of counters',IntToStr(POT.NumCounters));
    AddInfo('Default counter',IntToStr(POT.DefaultCounter));
    AddInfo('Number of instances',IntToStr(POT.NumInstances));
    AddInfo('Code page',IntToStr(POT.CodePage));

    cr:=Screen.Cursor;
    Screen.Cursor:=crHourGlass;
    MObjectHelp.Text:=PerfObjects.ObjectHelp[_ObjIdx];
    Screen.Cursor:=cr;
end;

procedure TPerfInfoMainForm.AddInfo(InfoDesc,Info: String);
begin
    LBxObjectInfo.Items.Add(Format('%-21s = %-12s',[InfoDesc,Info]));
end;

procedure TPerfInfoMainForm.BnMoreInfoClick(Sender: TObject);
begin
    if _ObjIdx < 0 then
    begin
        Beep;
        exit;
    end;

    TObjectInfoForm.Create(PerfObjects.ObjectTitle[_ObjIdx]).Show;
end;

procedure TPerfInfoMainForm.About1Click(Sender: TObject);
begin
    with TAboutBox.Create(nil) do
    begin
        SetProductInfo(ProductName,Version);
        ShowModal;
    end;
end;

procedure TPerfInfoMainForm.PnObjectsClick(Sender: TObject);
begin
    ActiveControl:=LBxObjects;
end;

procedure TPerfInfoMainForm.LBxObjectsEnter(Sender: TObject);
begin
    SetPanelState(PnObjects,True);
end;

procedure TPerfInfoMainForm.LBxObjectsExit(Sender: TObject);
begin
    SetPanelState(PnObjects,False);
end;


procedure TPerfInfoMainForm.LBxObjectInfoEnter(Sender: TObject);
begin
    SetPanelState(PnObjectInfo,True);
end;

procedure TPerfInfoMainForm.LBxObjectInfoExit(Sender: TObject);
begin
    SetPanelState(PnObjectInfo,False);
end;

procedure TPerfInfoMainForm.PnObjectInfoClick(Sender: TObject);
begin
    ActiveControl:=LBxObjectInfo;
end;


procedure TPerfInfoMainForm.PnObjectHelpClick(Sender: TObject);
begin
    ActiveControl:=MObjectHelp;
end;

procedure TPerfInfoMainForm.MObjectHelpEnter(Sender: TObject);
begin
    SetPanelState(PnObjectHelp,True);
end;

procedure TPerfInfoMainForm.MObjectHelpExit(Sender: TObject);
begin
    SetPanelState(PnObjectHelp,False);
end;

end.
